<?php
// doopSites v1.9.7 - Última atualização 22/02/2023 16:20

class CallbackDoop
{
    public $code;

    public $message;

    public $template = [
        'danger',
        'success',
        'warning',
        'info'
    ];

    public $type;
    public $typeIn;

    public $html;

    public function __construct($code)
    {
        if ($code) {
            $this->view($code);
        }
    }

    public function view($code)
    {
        $this->template($code);

        if (isset($this->template[$this->type])) {
            $dataReturn = '<div class="alert alert-'.$this->template[$this->type].'"><button type="button" class="close" data-dismiss="alert"><i class="icon-remove"></i></button><strong>';

            switch ($this->template[$this->type])
            {
                case 'danger': $this->typeIn = 'error'; $dataReturn .= '<i class="icon-remove-sign"></i> '; break;
                case 'success': $this->typeIn = $this->template[$this->type]; $dataReturn .= '<i class="icon-ok-sign"></i> '; break;
                case 'warning': $this->typeIn = $this->template[$this->type]; $dataReturn .= '<i class="icon-warning-sign "></i> '; break;
                case 'info': $this->typeIn = $this->template[$this->type]; $dataReturn .= '<i class="icon-info-sign "></i> '; break;
            }

            $dataReturn .= config('app.LABEL_CALLBACK').'</strong> '.$this->message.'<br /></div>';

            $this->html = $dataReturn;
        }
    }

    public function template($code)
    {
        $this->code = $code;

        switch($code)
        {
            case 'permission_denied':
            case 'fatal_error': $this->type = 0; $this->message = 'Área Restrita! Você não tem permissão para continuar.'; break;
            case '100': $this->type = 0; $this->message = 'Dados inseridos estão inválidos. Sua conta pode ter sido desativada. Entre em contato com o administrador'; break;
            case '101': $this->type = 1; $this->message = 'Sua sessão de login foi finalizada com sucesso. Faça o login novamente!'; break;
            case '102': $this->type = 0; $this->message = 'Houve um erro no envio do e-mail. Tente novamente!'; break;
            case '103': $this->type = 0; $this->message = 'Nenhum e-mail foi encontrado. Tente novamente!'; break;
            case '104': $this->type = 1; $this->message = 'Uma confirmação foi enviada para seu email. Verifique e prossiga com as instruções!'; break;
            case '105': $this->type = 1; $this->message = 'Sua senha foi alterada com sucesso. Verifique seu e-mail e faça o login!'; break;
            case '106': $this->type = 0; $this->message = 'Dados de verificação estão errados. Redefina novamente sua senha!'; break;
            case '200': $this->type = 0; $this->message = ' Você não tem permissão para acessar o módulo!'; break;
            case '300': $this->type = 1; $this->message = ' Registro cadastrado com sucesso'; break;
            case '301': $this->type = 1; $this->message = ' Registro editado com sucesso'; break;
            case '302': $this->type = 1; $this->message = ' Registro excluído com sucesso'; break;
            case '303': $this->type = 2; $this->message = ' Nenhum registro encontrado'; break;
            case '304': $this->type = 1; $this->message = ' Fotos adicionadas com sucesso'; break;
            case '305': $this->type = 1; $this->message = ' Foto alterada com sucesso'; break;
            case '306': $this->type = 1; $this->message = ' Vídeo adicionado com sucesso'; break;
            case '307': $this->type = 1; $this->message = ' Vídeo alterado com sucesso'; break;
            case '308': $this->type = 1; $this->message = ' Anexos adicionados com sucesso'; break;
            case '309': $this->type = 1; $this->message = ' Anexo alterado com sucesso'; break;
            case '310': $this->type = 1; $this->message = ' Áudios adicionados com sucesso'; break;
            case '311': $this->type = 1; $this->message = ' Áudio alterado com sucesso'; break;
            case '312': $this->type = 1; $this->message = ' Metatags alteradas com sucesso'; break;
            case '313': $this->type = 1; $this->message = ' Imagem excluída com sucesso'; break;
            case '314': $this->type = 1; $this->message = ' Vídeo excluído com sucesso'; break;
            case '315': $this->type = 1; $this->message = ' Item excluído com sucesso'; break;
            case '316': $this->type = 1; $this->message = ' Anexo excluído com sucesso'; break;
            case '317': $this->type = 1; $this->message = ' Áudio excluído com sucesso'; break;
            case '318': $this->type = 1; $this->message = ' Imagens excluídas com sucesso'; break;
            case '319': $this->type = 1; $this->message = ' Vídeos excluídos com sucesso'; break;
            case '320': $this->type = 1; $this->message = ' Anexos excluídos com sucesso'; break;
            case '321': $this->type = 1; $this->message = ' Áudios excluídos com sucesso'; break;
            case '400': $this->type = 0; $this->message = ' E-mail já está cadastrado no sistema!'; break;
            case '401': $this->type = 0; $this->message = ' Título já está cadastrado no sistema!'; break;
            case '402': $this->type = 0; $this->message = ' Nome já está cadastrado no sistema!'; break;
            case '403': $this->type = 0; $this->message = ' Código já está cadastrado no sistema!'; break;
            case '404': $this->type = 0; $this->message = ' CPF já está cadastrado no sistema!'; break;
            case 'upload-size-allowed': $this->type = 0; $this->message = ' Tamanho do arquivo deve ser menor que 20MB!'; break;
            case 'upload-required': $this->type = 0; $this->message = ' O upload do arquivo é obrigatório!'; break;
            case 'upload-invalid-extension': $this->type = 0; $this->message = ' A extensão do arquivo não é pertimida!'; break;
            case 'upload-width-height-allowed': $this->type = 0; $this->message = ' A largura e altura dos arquivos estão fora dos padrões permitidos!'; break;
            case '504': $this->type = 0; $this->message = ' É obrigatório inserir um link do youtube ou vimeo!'; break;
            case '505': $this->type = 0; $this->message = ' Ops! Senha antiga digitada errada!'; break;
            case '506': $this->type = 1; $this->message = ' Dados alterados com sucesso!'; break;
            case '507': $this->type = 0; $this->message = ' É obrigatório selecionar pelo menos uma categoria!'; break;
            case '307': $this->type = 1; $this->message = ' Vídeo alterado com sucesso'; break;
            case 'status_active': $this->type = 1; $this->message = ' Status alterado para ativo'; break;
            case 'status_disabled': $this->type = 1; $this->message = ' Status alterado para desativado'; break;
            case 'status_trash': $this->type = 1; $this->message = ' Item enviado para lixeira'; break;
            case 'deleted': $this->type = 1; $this->message = ' Item deletado com sucesso'; break;
            case 'status_pendent': $this->type = 1; $this->message = ' Item marcado como pendência com sucesso'; break;
            case 'status_error': $this->type = 2; $this->message = ' Você deve selecionar pelo menos um item, para executar ações múltiplas'; break;
            case 'dev_0000': $this->type = 0; $this->message = ' Ops! Aconteceu um erro. Você não tem permissão para acessar essa área!'; break;
            case 'dev_000': $this->type = 0; $this->message = ' [ #dev_000 ] Você não tem permissão para acessar o módulo.'; break;
            case 'dev_001': $this->type = 0; $this->message = ' [ #dev_001 ] A tabela não está cadastrada no sistema.'; break;
            case 'dev_002': $this->type = 0; $this->message = ' [ #dev_002 ] O módulo não está ativado no sistema'; break;
            case 'dev_003': $this->type = 0; $this->message = ' [ #dev_003 ] Nenhuma chave de acesso definida pelo módulo.'; break;
            case 'dev_004': $this->type = 0; $this->message = ' [ #dev_004 ] Arquivo js para módulos não foi encontrado.'; break;
            case 'dev_005': $this->type = 1; $this->message = ' [ #dev_005 ] Banco de dados default carregado com sucesso.'; break;
            case 'support_001': $this->type = 1; $this->message = ' Mensagem enviada com sucesso! Aguarde que entraremos em contato.'; break;
            case '700': $this->type = 0; $this->message = ' O código cadastrado já existe. Tente novamente!'; break;
            case '701': $this->type = 0; $this->message = ' Chave de acesso já cadastrada no sistema. Tente novamente!'; break;
            case '702': $this->type = 1; $this->message = ' Resposta adicionada com sucesso!'; break;
            case 'js_not': $this->type = 0; $this->message = ' Arquivo javascript do módulo não encontrado!'; break;
            case 'module_notfound': $this->type = 0; $this->message = ' Arquivos do módulo não foram encontrados!'; break;
            case 'truncate_table': $this->type = 1; $this->message = ' Tabela zerada com sucesso!'; break;
            case 'backup_table': $this->type = 1; $this->message = ' Backup em formato excel realizado com sucesso!'; break;
            case 'backup_dump': $this->type = 1; $this->message = ' Backup do banco de dados realizado com sucesso!'; break;
            case 'sample_data': $this->type = 1; $this->message = ' Arquivo de dados padrão carregado com sucesso!'; break;
            case 'import_data': $this->type = 1; $this->message = ' Importação de dados carregada com sucesso!'; break;
            case 'import_data_notfound': $this->type = 0; $this->message = ' Nenhum arquivo de importação de dados encontrados!'; break;
            case 'reset_table': $this->type = 1; $this->message = ' Tabela resetada com sucesso!'; break;
            case 'reset_views_table': $this->type = 1; $this->message = ' As visualizações dos registros foram resetadas!'; break;
            case 'delete_ghosts_files': $this->type = 1; $this->message = ' Os arquivos fantamas foram excluídos!'; break;
            case 'convert_webp_success': $this->type = 1; $this->message = ' Os arquivos foram convertidos para webp!'; break;
            case 'restore_webp_success': $this->type = 1; $this->message = ' Os arquivos webp foram revertidos!'; break;
            case 'delete_webp_success': $this->type = 1; $this->message = ' Os arquivos webp foram removidos!'; break;
            case 'delete_foldertemp_success': $this->type = 1; $this->message = ' As pastas TEMP dos módulos foram excluídas!'; break;
            case 'featured_yes': $this->type = 1; $this->message = ' Item marcado como destaque'; break;
            case 'featured_no': $this->type = 1; $this->message = ' Destaque removido do item'; break;
            case 'error_in': $this->type = 0; $this->message = ' Aconteceu um problema tente novamente!'; break;
        }
    }
}
