<?php
// doopSites v1.9.7 - Última atualização 22/02/2023 16:20

require_once(config('app.ROOT_CMS_CORE').'/class.functions.php');
require_once(config('app.ROOT_CMS_CORE').'/class.modules.php');
require_once(config('app.ROOT_CMS_CORE').'/class.breadcrumb.php');

require_once(config('app.ROOT_CMS_HELPERS').'/tools-maintenance.php');
require_once(config('app.ROOT_CMS_HELPERS').'/tools-import.php');
require_once(config('app.ROOT_CMS_HELPERS').'/tools-template.php');
require_once(config('app.ROOT_CMS_HELPERS').'/tools-module.php');
require_once(config('app.ROOT_CMS_HELPERS').'/forms-html.php');

class ControllerDoop extends FunctionsDoop
{
    public $callback = null;
    public $modules = null;
    public $privilege = null;
    public $notComplet = true;
    public $forms = null;
    public $toolsMaintenance = null;

    public function __construct($key, $operation, $type = 'module', $increment = null)
    {
        parent::__construct($key);

        if ($key !== 'login') {
            if ($key !== 'developer') {
                $this->protection();
            }

            if ($type != 'sub') {
                $this->modules = new ModulesStructureDoop($key, $operation, $type, $increment);
                $this->forms = new FormsHtml($this);

                if (array_key_exists($this->modules->key, $this->modules->template)) {
                    $this->setTable($this->modules->template[$this->modules->key]['table']);
                }

                if (array_key_exists($this->modules->key, $this->modules->template)) {
                    $this->setSufix($this->modules->template[$this->modules->key]['sufix']);
                }
                else {
                    $this->setSufix($this->modules->key);
                }

                if (!$this->modules->extra && $this->get('uuid')) {
                    $keySelect = 'uuid';
                }
                else if (!$this->modules->extra && $this->get('id')) {
                    $keySelect = 'id';
                }
                else {
                    $keySelect = $this->modules->extra;
                }

                if ($this->modules->operation === 'update') {
                    $this->modules->dataUpdate = $this->modules->dataLoad($this->get($keySelect));

                    $this->setValue($this->value($keySelect));

                    if ($this->post('alterDeveloper_action_form')) {
                        if ($dataPostDeveloper = $this->modules->postParamsDeveloper()) {
                            $this->dataSave($dataPostDeveloper, 'update');
                        }

                        header('Location: '.parent::pathLang(null, $this->modules->page['update']['path'].'&callback=301&'.$keySelect.'='.$this->value($keySelect)).'#developer');
                        exit;
                    }

                    if ($this->post('delete_action_form')) {
                        $this->module_delete();
                    }

                    if ($this->get('action') == 'delete_cover') {
                        $query = "SELECT `".$this->sufix($this->get('label'))."` as label FROM `".$this->getTable()."` WHERE `".$this->sufix($keySelect)."` = '".$this->get($keySelect)."'";

                        $result = $this->dbFetchAssoc($query);

                        $this->deleteImages($result);

                        if ($this->get('typeimage') == 'default') {
                            $query = "UPDATE `".$this->getTable()."` SET `".$this->sufix($this->get('label'))."` = NULL WHERE `".$this->sufix($keySelect)."` = '".$this->get($keySelect)."'";
                        }
                        else {
                            $images = json_decode($result['label'], true);

                            if (array_key_exists($this->get('typeimage'), $images)) {
                                unset($images[$this->get('typeimage')]);

                                $query = "UPDATE `".$this->getTable()."` SET `".$this->sufix($this->get('label'))."` = '".json_encode($images)."' WHERE `".$this->sufix($keySelect)."` = '".$this->get($keySelect)."'";
                            }
                        }

                        $this->dbQuery($query);

                        header('Location: '.parent::pathLang(null, $this->modules->page['update']['path'].'&uuid='.$this->get($keySelect).'&callback=313'));
                        exit;
                    }

                    if ($this->get('action') == 'delete_video') {
                        $query = "UPDATE `".$this->getTable()."` SET `".$this->sufix($this->get('label'))."` = NULL WHERE `".$this->sufix($keySelect)."` = '".$this->get($keySelect)."'";

                        $this->dbQuery($query);

                        header('Location: '.parent::pathLang(null, $this->modules->page['update']['path'].'&uuid='.$this->get($keySelect).'&callback=314'));
                        exit;
                    }

                    if ($this->get('action') == 'delete_tuple') {
                        $query = "UPDATE `".$this->getTable()."` SET `".$this->sufix($this->get('tuple'))."` = NULL WHERE `id_".$this->getSufix()."` = '".$this->get($keySelect)."'";

                        $this->dbQuery($query);

                        header('Location: '.parent::pathLang(null, $this->modules->page['update']['path'].'&uuid='.$this->get($keySelect).'&callback=315'));
                        exit;
                    }
                }
                else if ($this->modules->operation === 'manage') {
                    if ($this->modules->type !== 'extra') {
                        $this->modules->setQuerySearch();
                        $this->modules->setQueryStatus();
                        $this->modules->setQueryFilter();

                        foreach ($this->modules->actionStatusContent as $key => $value) {
                            if ($this->get('action') === 'set_'.$key) {
                                $this->modules->dataStatus([$key, $this->get($keySelect)]);
                            }
                        }

                        if ($this->get('action') === 'set_deleted') {
                            $this->modules->deleteData(['deleted', $this->get($keySelect)]);
                        }

                        if ($this->get('action') === 'set_featured') {
                            $this->modules->alterFeatured(['featured', $this->get($keySelect)]);
                        }

                        $this->setOldUrl();
                    }
                }

                $this->toolsMaintenance = new ToolsMaintenanceDoop($this, true);

                if ($this->modules->operation === 'manage') {
                    $this->toolsMaintenance->monitor();
                }
            }
        }
    }

    protected function protection()
    {
        if (isset($_SESSION['administrator_id']) == '' && isset($_SESSION['administrator_ip']) == '') {
            header('Location:'.config('app.PATH_CMS_LOGIN').'/?callback=permission_denied');
            exit;
        }
    }

    public function value($label, $type = 'string')
    {
        if ($this->modules->operation === 'insert') {
            return $this->post($label, $type);
        }
        else {
            $check = explode('_', $label);

            if (count($check) == 1) {
                $newData = parent::sufix($label);
            }
            else {
                $newData = $label;
            }

            if (array_key_exists($newData, $this->modules->dataUpdate)) {
                return parent::processString($this->modules->dataUpdate[$newData], $type);
            }
            else {
                return parent::processString($this->modules->dataUpdate[$label], $type);
            }
        }
    }

    public function getSlug($parameter, $extension = false, $comparation = 'slug', $date = null)
    {
        $slug = parent::processString($parameter, 'slug');

        if ($this->modules->operation == 'insert') {
            $qntd = $this->modules->dbNumRows("SELECT `".parent::sufix('id')."` FROM `".parent::getTable()."` WHERE `".parent::sufix($comparation)."` LIKE '%".$slug."'");

            if ($qntd > 0) {
                if (is_null($date)) {
                    $date = date('d-m-Y');
                }

                return $this->getSlug($slug.'-'.$date);
            }

            return $slug;
        }
        else if ($this->modules->operation == 'update') {
            if ($this->value($comparation) == $slug) {
                return $this->value($comparation);
            }
            else {
                $qntd = $this->modules->dbNumRows("SELECT `".parent::sufix('id')."` FROM `".parent::getTable()."` WHERE `".parent::sufix($comparation)."` LIKE '%".$slug."'");

                if ($qntd > 0) {
                    if (is_null($date)) {
                        $date = date('d-m-Y');
                    }

                    return $this->getSlug($slug.'-'.$date);
                }

                return $slug;
            }
        }
    }

    public function generatorOrder($extra = null)
    {
        return parent::dbNumRows("SELECT `".parent::sufix('uuid')."` FROM `".parent::getTable()."` WHERE `".parent::sufix('status')."` = 'active' ".$extra) + 1;
    }

    public function linkSystem($path = null, $force = false)
    {
        if ($force) {
            $path = config('app.PATH_SYSTEM');
        }

        if ($this->modules->operation === 'update' || $this->modules->operation === 'view') {
            return parent::pathLang(null, $path.$this->modules->page[$this->modules->operation]['path'].'&uuid='.$this->modules->value('uuid'));
        }
        else {
            return parent::pathLang(null, $path.$this->modules->page[$this->modules->operation]['path']);
        }
    }

    public function linkSystemVars($var, $newValue)
    {
        $url = parse_url(parent::urlComplet());

        $pattern = '/&' . $var . '=/';

        if (preg_match($pattern, $url['query'])) {
            $arrayQuery = explode('&', $url['query']);

            foreach ($arrayQuery as $key => $value) {
                $patternVar = '/'.$var.'/';

                if (preg_match($patternVar, $value)) {
                    if ($newValue != 'remove_filter') {
                        $arrayQuery[$key] = $var.'='.$newValue;
                    }
                    else {
                        unset($arrayQuery[$key]);
                    }
                }
            }

            return config('app.PATH_CMS').'/system/?'.implode('&', $arrayQuery);
        }
        else {
            return parent::urlComplet().'&'.$var.'='.$newValue;
        }
    }

    public function pathModule()
    {
        if (isset($this->modules->template[$this->modules->key]['folder'])) {
            $folder = str_replace('-', '/', $this->modules->template[$this->modules->key]['folder']);

            return config('app.ROOT_CMS').'/'.$folder.'/';
        }
    }

    public function linkSystemPath()
    {
        if ($this->modules->operation === 'update') {
            return parent::pathLang(null, config('app.PATH_SYSTEM').str_replace('-', '/', $this->modules->template[$this->modules->key]['folder']).'/'.$this->modules->page[$this->modules->operation]['path'].'&uuid='.$this->modules->value('uuid'));
        }
        else {

            return parent::pathLang(null, config('app.PATH_SYSTEM').str_replace('-', '/', $this->modules->template[$this->modules->key]['folder']).'/'.$this->modules->page[$this->modules->operation]['path']);
        }
    }

    public function link($module, $operation = 'manage', $id = 1)
    {
        $folder = str_replace('-', '/', $this->modules->modulesSystem[$module]['folder'].'/'.$module);

        $path = config('app.PATH_SYSTEM').$folder.'&operation='.$operation;

        if ($this->modules->operation == 'update' || $this->modules->operation == 'view') {
            return $path.'&uuid='.$id;
        }

        return $path;
    }

    public function nameHelp()
    {
        return $this->modules->template[$this->modules->key]['label'];
    }

    public function insertAnnex($tuple, $table, $folder, $field = 'files')
    {
        $upload = new \CoreSlim\Upload();
        $upload->config($this->sufix($field), $folder, $this->linkSystem());
        $upload->setConfig('multiple', true);
        $upload->setConfig('type', 'annex');
        $upload->load();

        $this->setTable('sub_anexx');
        $this->setSufix('anexx');

        if ($output = $upload->output('array')) {
            foreach ($output as $key => $fileReturn) {
                $data = [
                    $this->sufix('table') => $table,
                    $this->sufix('tuple') => $tuple,
                    $this->sufix('file') => json_encode($fileReturn),
                    $this->sufix('order') => $this->generatorOrder("AND `".$this->sufix('table')."` = '".$table."' AND `".$this->sufix('tuple')."` = '".$tuple."'")
                ];

                $this->dataSave($data, 'insert');
            }

            parent::setTable($table);
            parent::setSufix($folder);

            return true;
        }
    }

    public function setOldUrl()
    {
        $url = config('app.BASE_URL').$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];

        $_SESSION['old-url'] = $url;
    }

    public function deleteImages($result)
    {
        $folderModule = $this->modules->key;

        $name = null;

        if (@json_decode($result['label'])) {
            $image = json_decode($result['label'], true);

            $name = explode('.', $image['name']);
        }

        if (is_array($name)) {
            $exts = [$name[1], 'webp'];
            $folders = ['default', 'temp', 'thumb', 'smaller', 'larger'];

            foreach ($folders as $folder) {
                $dir = config('app.ROOT_UPLOAD').'/'.$folderModule.'/images/'.$folder;

                foreach ($exts as $ext) {
                    $file = $dir.'/'.$name[0].'.'.$ext;

                    if (file_exists($file)) {
                        unlink($file);
                    }
                }
            }
        }
    }
}
