<?php
// doopSites v1.9.7 - Última atualização 22/02/2023 16:20

class ModelDoop extends CoreSlim\Database
{
    protected $functions = null;

    public $moduleActive = null;
    public $modulesBlockLang = ['sis_base', 'mod_administrator', 'mod_administrator-privilege'];

    public $dataTable = null;
    public $dataSufix = null;
    public $dataValue = null;
    public $dataLast = null;
    public $dataInnerJoin = null;
    public $tuplePrimary = 'uuid';
    public $generateUuid = true;

    public function __construct($functions, $lang = 'pt_BR', $connection = null)
    {
        $this->functions = $functions;

        parent::__construct($connection, $lang);
    }

    public function setTable($parameter)
    {
        $this->dataTable = $parameter;
    }

    public function getTable()
    {
        return $this->dataTable;
    }

    public function setSufix($parameter)
    {
        $this->dataSufix = $parameter;
    }

    public function getSufix()
    {
        return $this->dataSufix;
    }

    public function sufix($parameter)
    {
        return $parameter.'_'.$this->getSufix();
    }

    public function unsufix($parameter)
    {
        return str_replace('_'.$this->getSufix(), '', $parameter);
    }

    public function setValue($parameter)
    {
        $this->dataValue = $parameter;
    }

    public function getValue()
    {
        return $this->dataValue;
    }

    public function setLast($parameter)
    {
        $this->dataLast = $parameter;
    }

    public function getLast()
    {
        return $this->dataLast;
    }

    public function setInnerJoin($parameter)
    {
        $this->dataInnerJoin = $parameter;
    }

    public function getInnerJoin()
    {
        return $this->dataInnerJoin;
    }

    public function setTuplePrimary($parameter)
    {
        $this->tuplePrimary = $parameter;
    }

    public function getTuplePrimary()
    {
        return $this->tuplePrimary;
    }

    public function setGenerateUuid($value)
    {
        $this->generateUuid = $value;
    }

    public function getGenerateUuid()
    {
        return $this->generateUuid;
    }

    public function dataPost($key, $type = 'injection')
    {
        return $this->functions->post($this->sufix($key), $type);
    }

    public function dataSave($data, $type, $trigger = true, $status = 'active', $registry = true)
    {
        foreach ($data as $field => $value) {
            if (!$value && $value != 0) {
                $value = "NULL";
            }
            else {
                $value = "'".$value."'";
            }

            $sql_field[] = "`".$field."`";
            $sql_value[] = $value;
            $sql_rules[] = "`".$field."` = ".$value;
        }

        if ($type == 'insert') {
            $registry_field = null;
            $registry_value = null;

            if ($this->getGenerateUuid()) {
                $uuid = $this->generateUuid(uniqid());
                $registry_field .= ", `".$this->sufix('uuid')."`";
                $registry_value .= ", '".$uuid."'";
            }

            if ($registry == true) {
                if (!in_array('`status_'.$this->getSufix().'`', $sql_field)) {
                    $registry_field .= ", `user_".$this->getSufix()."`, `time_".$this->getSufix()."`, `status_".$this->getSufix()."`";
                    $registry_value .= ", '".ADMINISTRATOR."', '".date('Y-m-d H:i:s')."', '".$status."'";
                }
                else {
                    $registry_field .= ", `user_".$this->getSufix()."`, `time_".$this->getSufix()."`";
                    $registry_value .= ", '".ADMINISTRATOR."', '".date('Y-m-d H:i:s')."'";
                }
            }

            $query = "INSERT INTO `".$this->getTable()."` (".implode(', ', $sql_field).$registry_field.") VALUES (".implode(', ', $sql_value).$registry_value.")";

            if ($this->dbQuery($query)) {
                $dataLastInsert = $this->dataLast = $this->dbLast();

                if ($trigger == true) {
                    $this->setTriggerLog('insert', $dataLastInsert, $query);
                }

                return true;
            }
            else {
                return false;
            }
        }
        else if ($type == 'update') {
            $dataOld = $this->dbFetch("SELECT * FROM `".$this->getTable()."` WHERE `".$this->getTuplePrimary()."_".$this->getSufix()."` = '".$this->getValue()."'");

            $query = "UPDATE `".$this->getTable()."` SET ".implode(', ', $sql_rules)." WHERE `".$this->getTuplePrimary()."_".$this->getSufix()."` = '".$this->getValue()."'";

            if ($this->dbQuery($query)) {
                if ($trigger == true) {
                    $extra['old'] = $dataOld;
                    $extra['new'] = $data;

                    $this->setTriggerLog('update', $dataOld['id_'.$this->getSufix()], $query, $extra);
                }

                return true;
            }
            else {
                return false;
            }
        }
    }

    public function dataDelete($id)
    {
        $query = "DELETE FROM `".$this->getTable()."` WHERE `".$this->sufix($this->getTuplePrimary())."` = '".$id."'";

        if ($this->dbQuery($query)) {
            $this->setTriggerLog('delete', $id, $query);

            return true;
        }
    }

    public function dataDuplicated($field = array(), $value = array())
    {
        for ($i = 0; $i < count($field); $i++) {
            if ($i == 0) {
                $condition = "`".$field[$i]."_".$this->getSufix()."` = '".$value[$i]."'";
            }
            else {
                $condition .= " AND `".$field[$i]."_".$this->getSufix()."` = '".$value[$i]."'";
            }
        }

        $query = "SELECT `".$this->getTuplePrimary()."_".$this->getSufix()."` FROM `".$this->getTable()."` WHERE ".$condition;

        if ($this->dbNumRows($query) > 0) {
            return true;
        }
        else {
            return false;
        }
    }

    public function dataLoad($parameter)
    {
        $query = "SELECT * FROM `".$this->getTable()."` ".$this->getInnerJoin()." WHERE `".$this->getTuplePrimary()."_".$this->getSufix()."` = '".$parameter."'";


        $result = $this->dbFetch($query);

        if (!$result) {
            if ($this->getTuplePrimary() == 'uuid') {
                $this->setTuplePrimary('uuid');

                $query = "SELECT * FROM `".$this->getTable()."` ".$this->getInnerJoin()." WHERE `".$this->getTuplePrimary()."_".$this->getSufix()."` = '".$parameter."'";

                $result = $this->dbFetch($query);
            }
        }

        if ($result) {
            return $result;
        }
        else {
            header('Location: '.config('app.PATH_CMS_DASHBOARD').'/?callback=dev_0000&return='.$this->operation);
            exit;
        }
    }

    public function setTriggerLog($type, $tuple, $command, $extra = null, $info = null)
    {
        $table = $this->dataTable;

        if (!$table) {
            $table = $this->dataTable;
        }

        $query = "INSERT INTO `trigger_log` (`type_log`, `table_log`, `tuple_log`, `command_log`, `extra_log`, `ip_log`, `user_log`, `time_log`) VALUES ('".$type."', '".$table."', '".$tuple."', '".$this->processData($command, 'base64')."', '".$this->processData(json_encode($extra), 'base64')."', '".$_SERVER['REMOTE_ADDR']."', '".ADMINISTRATOR."', '".date("Y-m-d H:i:s")."')";

        $this->dbQuery($query);

        return true;
    }

    public function checkTriggerLog($type, $tuple, $command, $extra = null)
    {
        $table = $this->dataTable;

        if (!$table) {
            $table = $this->dataTable;
        }

        $query = "SELECT * FROM `trigger_log`
                  WHERE `type_log` = '".$type."' AND
                        `table_log` = '".$table."' AND
                        `tuple_log` = '".$tuple."' AND
                        `command_log` ='".$this->processData($command, 'base64')."' AND
                        `extra_log` = '".$extra."'";

        $result = $this->dbFetchAssoc($query);

        if ($result) {
            return true;
        }
    }

    public function importSql($file)
    {
        new Thamaraiselvam\MysqlImport\Import($file, $this->getConnection('user'), $this->getConnection('password'), $this->getConnection('database'), $this->getConnection('host').':'.$this->getConnection('port'));

        return true;
    }

    public function importSqlOld($args)
    {
        $this->connectionOpen();

        $querycount = 11;
        $queryerrors = '';
        $lines = (array) $args;

        if (is_string( $args)) {
            $lines =  array($args) ;
        }

        if (!$lines) {
            return '' . 'cannot execute ' . $args;
        }

        $scriptfile = false;

        foreach ($lines as $line) {
            $line = trim($line);

            if (substr($line, 0, 2) == '--') {
                $line = "\n" . $line;
            }

            if (substr($line, 0, 2) != '--') {
                $scriptfile .= ' ' . $line;
                continue;
            }
        }

        $queries = explode(';', $scriptfile);

        foreach($queries as $query) {
            $query = trim($query);

            ++$querycount;

            if ($query == '') {
                continue;
            }

            if (!$this->driver->query($query)) {
                $queryerrors .= '' . 'Line ' . $querycount . ' - ' . $this->driver->error . '<br>';
                continue;
            }
        }

        if ($queryerrors) {
            return '' . 'There was an error on File: ' . '<br>' . $queryerrors;
        }

        if ($this->driver && ! $this->driver->error) {
            $this->connectionClose();
        }

        return 'complete dumping database !';
    }

    public function getTupleModule($key, $select, $view = null, $where = 'id', $prefixTable = 'mod')
    {
        if (is_array($view)) {
            foreach ($view as $keyView => $valueView) {
                $newView[$keyView] = '`'.$valueView.'_'.$key.'`';
            }

            $view = implode(', ', $newView);

            $return = 'array';
        }
        else {
            $view = '`'.$view.'_'.$key.'`';

            $return = 'string';
        }

        $result = $this->dbFetch("SELECT ".$view." FROM `".$prefixTable."_".$key."` WHERE `".$where."_".$key."` = '".$select."'");

        if ($return == 'string' && isset($result[0])) {
            return $result[0];
        }
        else {
            return $result;
        }
    }

    public function setBaseData($key, $array = null, $type = 'json')
    {
        if (is_null($array)) {
            $result = $this->dbFetch("SELECT `value_base` FROM `sis_base` WHERE `key_base` = '".$key."'");

            $base = null;

            if (@unserialize($result[0])) {
                $base = unserialize($result[0]);
            }
            else if (@json_decode($result[0])) {
                $base = json_decode($result[0], true);
            }

            return $base;
        }
        else if (is_array($array)) {
            if ($type == 'serialize') {
                $base = serialize($array);
            }
            else if ($type == 'json') {
                $base = json_encode($array);
            }

            $check = $this->dbFetch("SELECT `value_base` FROM `sis_base` WHERE `key_base` = '".$key."'");

            if ($check) {
                $update = "UPDATE `sis_base` SET `value_base` = '".$base."' WHERE `key_base` = '".$key."'";

                $this->dbQuery($update);
            }
            else {
                $insert = "INSERT INTO `sis_base` (`id_base`, `uuid_base`, `key_base`, `value_base`) VALUES (NULL, '".$this->generateUuid(uniqid())."', '".$key."', '".$base."')";

                $this->dbQuery($insert);
            }
        }
    }

    public function getBaseData($key)
    {
        $result = $this->dbFetch("SELECT `value_base` FROM `sis_base` WHERE `key_base` = '".$key."'");

        $base = null;

        if (@unserialize($result[0])) {
            $base = unserialize($result[0]);
        }
        else if (@json_decode($result[0])) {
            $base = json_decode($result[0], true);
        }

        return $base;
    }

    public function createUUID($id)
    {
        $dataUUID[$this->sufix('uuid')] = $this->generateUuid($this->sufix('id').'-'.$id);

        $this->setValue($id);

        $this->setTuplePrimary('id');

        $this->dataSave($dataUUID, 'update', false, null, false);
    }
}
