<?php
// doopSites v1.9.7 - Última atualização 24/05/2023 16:26

class ModulesStructureDoop extends FunctionsDoop
{
    public $privilege = [
        'only' => null,
        'group' => null,
        'master' => null,
        'god' => null,
        'root' => null,
        'developer' => null
    ];
    public $error = null;
    public $type = null;
    public $key = null;
    public $operation = null;
    public $editextra = false;
    public $modulesSystem = [];
    public $template = [];
    public $page = [];
    public $dataUpdate = [];
    public $extra = null;
    public $noComplet = true;
    public $querySearch = null;
    public $queryStatus = null;
    public $queryFilter = null;
    public $buttonExtra = null;
    public $exportExcel = false;
    public $control = [
        'bt_insert' => true,
        'bt_update' => true,
        'bt_view' => false,
        'bt_frontend' => false,
        'bt_delete' => true,
        'controls_manage' => true,
        'controls_actions' => true,
        'controls_filter' => true,
        'controls_search' => true,
        'controls_developer' => true,
        'controls_modules' => false,
        'controls_relative' => true,
        'btnInsertReturn' => true
    ];

    public $navbars = [
        'photo' => false,
        'video' => false,
        'anexx' => false,
        'audio' => false,
        'pages' => false,
        'config' => false
    ];

    public $navbarsTitle = [
        'photo' => 'Imagens',
        'video' => 'Vídeos',
        'anexx' => 'Anexos',
        'audio' => 'Áudios',
        'pages' => 'Páginas',
        'config' => 'Configuração'
    ];

    public $navbarsModule = null;
    public $actionsMultipleModule = null;
    public $infoModules = null;

    public $filterStatusContent = [
        'active' => [
            'title' => 'Ativado',
            'label' => 'ativado',
            'key' => 'ativo',
            'class' => 'success'
        ],
        'disabled' => [
            'title' => 'Desativado',
            'label' => 'desativado',
            'key' => 'desativado',
            'class' => 'danger'
        ],
        'pendent' => [
            'title' => 'Pendente',
            'label' => 'pendente',
            'key' => 'pendente',
            'class' => 'warning'
        ],
        'trash' => [
            'title' => 'Lixeira',
            'label' => 'lixeira',
            'key' => 'lixeira',
            'class' => 'gray'
        ]
    ];

    public $actionStatusContent = [
        'active' => [
            'title' => 'Ativar',
            'color' => 'success'
        ],
        'disabled' => [
            'title' => 'Desativar',
            'color' => 'danger'
        ],
        'pendent' => [
            'title' => 'Marcar pendência',
            'color' => 'warning'
        ],
        'trash' => [
            'title' => 'Enviar para lixeira',
            'color' => 'gray'
        ]
    ];

    public $activeWebp = true;

    public $logDatabase = 'default';

    public $tabsActive = [
        'registry' => true,
        'developer' => true
    ];

    public function __construct($key, $operation, $type = 'module', $increment = null)
    {
        parent::__construct('system');

        $this->modulesSystem = Tools::jsonOpen(config('app.ROOT_CMS').'/system-modules.json', true);
        $extraModules = Tools::jsonOpen(config('app.ROOT_CMS').'/extra-modules.json', true);

        if (is_array($extraModules)) {
            foreach ($this->modulesSystem as $keyModules => $valueModules) {
                if (!$valueModules['active']) {
                    unset($this->modulesSystem[$keyModules]);
                }
            }

            $newModules = array_merge($this->modulesSystem, $extraModules);

            unset($this->modulesSystem);

            $this->modulesSystem = $newModules;
        }

        $this->type = $type;
        $this->key = $key;
        $this->operation = $operation;

        $this->infoModules = $this->getBaseData('modulesInfo-'.$this->key);

        $this->loadPrivilege();
        $this->setTemplateDefault();
        $this->setPageDefault();
        $this->moduleProtection();

        if (array_key_exists($this->key, $this->template)) {
            $this->setTable($this->template[$this->key]['table']);
        }

        if (array_key_exists($this->key, $this->template)) {
            $this->setSufix($this->template[$this->key]['sufix']);
        }
        else {
            $this->setSufix($this->key);
        }

        if (!is_null($increment)) {
            if (array_key_exists('filterStatusContent', $increment)) {
                $this->filterStatusContent = $increment['filterStatusContent'];
            }

            if (array_key_exists('actionStatusContent', $increment)) {
                $this->actionStatusContent = $increment['actionStatusContent'];
            }
        }
    }
    protected function loadPrivilege()
    {
        if ($this->key !== 'login') {
            $this->privilege['developer'] = intval($this->setPrivilege('developer'));
            $this->privilege['root'] = intval($this->setPrivilege('root'));
            $this->privilege['god'] = intval($this->setPrivilege('god'));
            $this->privilege['master'] = intval($this->setPrivilege('master'));
            $this->privilege['group'] = intval($this->setPrivilege('group'));
            $this->privilege['not'] = 1;
            $this->privilege['only'] = 2;
            $this->privilege['active'] = 'not';

            if ($this->privilege['developer'] === 1) {
                $this->privilege['active'] = 'developer';
                $this->privilege['not'] = 2;
            }
            else if ($this->privilege['root'] === 1) {
                $this->privilege['active'] = 'root';
                $this->privilege['not'] = 2;
            }
            else if ($this->privilege['god'] === 1) {
                $this->privilege['active'] = 'god';
                $this->privilege['not'] = 2;
            }
            else if ($this->privilege['master'] === 1) {
                $this->privilege['active'] = 'master';
                $this->privilege['not'] = 2;
            }
            else if ($this->privilege['group'] === 1) {
                $this->privilege['active'] = 'master';
                $this->privilege['not'] = 2;
            }
            else if ($this->privilege['not']) {
                $this->privilege['active'] = 'group';
                $this->privilege['not'] = 2;

                $dataReturn = $this->dbFetch("SELECT `privilege_nivel`, `only_nivel` FROM `mod_administrator-nivel` WHERE `administrator_nivel` = '".ADMINISTRATOR."' AND `module_nivel` = '".$this->key."' AND `privilege_nivel` = '1'");

                if (isset($dataReturn['privilege_nivel']) && $dataReturn['privilege_nivel'] == 1) {
                    $this->privilege['only'] = intval($dataReturn['only_nivel']);
                }
            }
        }
    }

    protected function setPrivilege($parameter)
    {
        $dataReturn = $this->dbFetch("SELECT `".$parameter."_privilege` FROM `mod_administrator-privilege` WHERE `administrator_privilege` = '".ADMINISTRATOR."'");

        return $dataReturn[0];
    }

    public function setTemplateDefault()
    {
        if (array_key_exists($this->key, $this->modulesSystem)) {
            $this->template[$this->key] = $this->modulesSystem[$this->key];
        }

        foreach ($this->modulesSystem as $key => $module) {
            if ($module['getter'] === $this->key) {
                $this->template[$key] = $this->modulesSystem[$key];
            }
        }
    }

    public function setPageDefault()
    {
        if ($this->type !== 'static' && $this->type !== 'extra' && array_key_exists($this->key, $this->template)) {
            $pageDefault = null;

            if (array_key_exists('insert', $this->template[$this->key]['privilege'])) {
                $pageDefault['insert'] = ['title' => 'Cadastrar', 'label' => 'cadastrar', 'privilege' => $this->template[$this->key]['privilege']['insert']];
                $pageDefault['insertReturn'] = ['title' => 'Cadastrar', 'label' => 'cadastrar e voltar', 'privilege' => $this->template[$this->key]['privilege']['insert']];
            }

            if (array_key_exists('update', $this->template[$this->key]['privilege'])) {
                $pageDefault['update'] = ['title' => 'Editar', 'label' => 'salvar', 'privilege' => $this->template[$this->key]['privilege']['update']];
                $pageDefault['updateReturn'] = ['title' => 'Editar', 'label' => 'salvar e voltar', 'privilege' => $this->template[$this->key]['privilege']['update']];
            }

            if (array_key_exists('delete', $this->template[$this->key]['privilege'])) {
                $pageDefault['delete'] = ['title' => 'Excluir', 'label' => 'excluir', 'privilege' => $this->template[$this->key]['privilege']['delete']];
            }

            if (array_key_exists('manage', $this->template[$this->key]['privilege'])) {
                $pageDefault['manage'] = ['title' => 'Painel de Controle', 'label' => 'Painel de Controle', 'privilege' => $this->template[$this->key]['privilege']['manage']];
            }

            if (array_key_exists('view', $this->template[$this->key]['privilege'])) {
                $pageDefault['view'] = ['title' => 'Visualizar', 'label' => 'Visualizar', 'privilege' => $this->template[$this->key]['privilege']['view']];
            }

            if (array_key_exists('configForm', $this->template[$this->key]['privilege'])) {
                $pageDefault['configForm'] = ['action' => 'configForm', 'title' => 'Configuração do formulário', 'label' => 'Configuração do formulário', 'path' => 'contact&operation=configForm', 'privilege' => $this->template[$this->key]['privilege']['configForm']];
            }

            if ($pageDefault) {
                foreach ($pageDefault as $default => $label) {
                    $this->page[$default]['action'] = $this->processString($default);
                    $this->page[$default]['title'] = $this->processString($label['title']);
                    $this->page[$default]['label'] = $this->processString($label['label']);
                    $this->page[$default]['path'] = parent::pathlang(null, config('app.PATH_SYSTEM').$this->template[$this->key]['folder'].'/'.str_replace('-', '/', $this->key).'&operation='.$this->processString($default));
                    $this->page[$default]['privilege'] = $this->processString($label['privilege']);
                }
            }
        }
    }

    public function setPage($key, $data)
    {
        $this->page[$key] =  $data;
    }

    public function menu($type = 'modules')
    {
        $dataReturn = $rest = null;

        $groupsName = Tools::jsonOpen(config('app.ROOT_CMS').'/group-modules.json', true);

        if ($type === 'modules') {
            $menuIcon = 'nav-icon';
        }
        else {
            $menuIcon = 'nav-icon';
        }

        if ($type === 'modules' || $type === 'rest'){
            foreach ($this->modulesSystem as $key => $data) {
                if ($data['type'] != 'static') {
                    if ($this->nivel($key) && $data['type'] != 'extra' && $data['type'] != 'relative' && $data['type'] != 'relative-multiple' && $data['type'] != 'complement' && $data['type'] != '2nivel' && $data['group'] != 200 && $data['active'] == 1 && $this->checkPrivilege($data['privilege'][$data['start']])) {
                        $keyActive = $data['folder'].'/'.$key;

                        if ($keyActive == parent::get('base') || $key == parent::get('module')) {
                            $selected = true;
                        }
                        else {
                            $selected = false;
                        }

                        $rest[$data['order']] = $data;

                        $rest[$data['order']] = [
                            'url' => parent::pathlang(null, config('app.PATH_SYSTEM').$data['folder'].'/'.str_replace('-', '/', $key).'&operation='.$data['start']),
                            'title' => $this->processString($data['title']),
                            'label' => $this->processString($data['label']),
                            'type' => $data['type'],
                            'icon' => $data['icon'],
                            'order' => intval($data['order']),
                            'group' => intval($data['group']),
                            'selected' => $selected
                        ];

                        if ($data['type'] == 'primary') {
                            $rest[$data['order']]['url_insert'] = parent::pathlang(null, config('app.PATH_SYSTEM').$data['folder'].'/'.str_replace('-', '/', $key).'&operation=insert');
                        }
                    }
                }
                else if ($data['type'] == 'static') {
                    if ($this->nivel($key) && $data['active'] == 1) {
                        $keyActive = $data['folder'].'/'.$key;

                        if ($this->checkPrivilege($data['privilege'][$data['start']])) {
                            $static = include(config('app.ROOT_CMS').'/'.$data['folder'].'/'.$key.'/automatic-forms-config.php');

                            foreach ($static as $keyStatic => $valueStatic) {
                                if ($valueStatic['active'] && $this->checkPrivilege($valueStatic['privilege'])) {
                                   if ($valueStatic['operation'] == parent::get('operation')) {
                                        $selected = true;
                                    } else {
                                        $selected = false;
                                    }

                                    $rest[$valueStatic['order']] = $valueStatic;

                                    $rest[$valueStatic['order']] = [
                                        'url' => parent::pathlang(null, config('app.PATH_SYSTEM').$data['folder'].'/'.$key.'&operation='.$valueStatic['operation']),
                                        'title' => $this->processString($valueStatic['title']),
                                        'label' => $this->processString($valueStatic['label']),
                                        'type' => 'static',
                                        'icon' => $valueStatic['icon'],
                                        'group' => intval($valueStatic['group']),
                                        'order' => intval($valueStatic['order']),
                                        'selected' => $selected
                                    ];
                                }
                            }
                        }
                    }
                }
            }

            $rest[8050] = [
                'url' => parent::pathlang(null, config('app.PATH_SYSTEM').'system/static&operation=about'),
                'title' => 'Sobre',
                'label' => 'Sobre',
                'type' => 'manual',
                'icon' => null,
                'group' => 80,
                'order' => 8050,
                'selected' => false
            ];

            $rest[8051] = [
                'url' => parent::pathlang(null, config('app.PATH_SYSTEM').'system/static&operation=feedback'),
                'title' => 'Feedback',
                'label' => 'Feedback',
                'type' => 'manual',
                'icon' => null,
                'group' => 80,
                'order' => 8051,
                'selected' => false
            ];

            $rest[8052] = [
                'url' => parent::pathlang(null, config('app.PATH_SYSTEM').'system/static&operation=support'),
                'title' => 'Suporte Técnico',
                'label' => 'Suporte Técnico',
                'type' => 'manual',
                'icon' => null,
                'group' => 80,
                'order' => 8052,
                'selected' => false
            ];
        }
        else if ($type === 'system') {
            return [];
        }

        if ($type != 'rest') {
            if ($type == 'modules') {
                if ($rest) {
                    ksort($rest);

                    $group = [];

                    $group['primary']['title'] = 'Site';
                    $group['primary']['icon'] = 'fas fa-globe';
                    $group['primary']['selected'] = false;

                    foreach ($rest as $key => $value) {
                        if ($value['group'] == 1) {
                            $group['primary']['sub'][$value['order']] = $value;

                            if ($this->checkGroupSelected($value)) {
                                $group['primary']['selected'] = true;
                            }
                        }

                        if ($value['group'] > 1 && $value['group'] != 200 && $value['group'] != 300) {
                            $group['group'][$value['group']]['sub'][$value['order']] = $value;
                            $group['group'][$value['group']]['title'] = $groupsName[$value['group']]['title'];
                            $group['group'][$value['group']]['icon'] = $groupsName[$value['group']]['icon'];

                            if (!array_key_exists('selected', $group['group'][$value['group']])) {
                                $group['group'][$value['group']]['selected'] = $this->checkGroupSelected($value);
                            }
                            else {
                                if (!$group['group'][$value['group']]['selected']) {
                                    $group['group'][$value['group']]['selected'] = $this->checkGroupSelected($value);
                                }
                            }
                        }
                    }

                    $dataReturn = $group;
                }
            }

            return $dataReturn;
        }
        else {

            return $rest;
        }
    }

    public function checkGroupSelected($values, $group = null)
    {
        if (is_array($values)) {
            foreach ($values as $key => $value) {
                if ($key == 'selected' && $value == true) {
                    return true;
                }
            }

            return false;
        }
    }

    public function setQueryStatus()
    {
        if (is_null($_SESSION['string_search'])) {
            if ($this->get('status') == null) {
                $this->queryStatus = "(`".$this->sufix('status')."` <> 'disabled')";
            }
            else if ($this->get('status')) {
                $this->queryStatus = "(`".$this->sufix('status')."` = '".$this->get('status')."')";
            }
            else {
                header('Location:'.config('app.PATH_CMS').'/index.php?callback=fatal_error&id=1');
                exit;
            }

            if ($this->get('featured')) {
                $this->queryStatus = "(`".$this->sufix('featured')."` = '".$this->get('featured')."')";
            }

            if ($this->privilege['only'] == 1) {
                $this->queryStatus = $this->queryStatus . " AND `".$this->sufix('user')."` = '".ADMINISTRATOR."'";
            }
        }
    }

    public function setQuerySearch()
    {
        if ($this->post('search_string') != '') {
            $_SESSION['string_search'] = $this->post('search_string');
        }

        if ($this->get('action') != 'search') {
            $_SESSION['string_search'] = null;
        }

        if ($_SESSION['string_search']) {
            $this->querySearch = null;

            $queryPrimary = "SELECT * FROM `".$this->template[$this->key]['table']."`";

            if ($fieldPrimary = $this->dbFields($queryPrimary)) {
                if (count($this->template) > 1) {
                    foreach ($this->template as $keyTemplate => $template) {
                        if ($this->key === $keyTemplate && $template['type'] !== 'primary') {
                            $queryRelative = "SELECT * FROM `".$template['table']."`";

                            if ($fieldRelative = $this->dbFields($queryRelative)) {
                                for ($i = 0; $i < count($fieldRelative); $i++) {
                                    if (isset($fieldRelative[$i]['native_type']) && $fieldRelative[$i]['native_type'] == 'DATE') {
                                        $date = $this->processDate($_SESSION['string_search'], 'mysql');

                                        if ($date) {
                                            $this->querySearch[] = "(`".$fieldRelative[$i]['name']."` = '".$this->processDate($_SESSION['string_search'], 'mysql')."')";
                                        }
                                    }
                                    else if (isset($fieldRelative[$i]['native_type']) && $fieldRelative[$i]['native_type'] == 'VAR_STRING') {
                                        $this->querySearch[] = "(`".$fieldRelative[$i]['name']."` LIKE '%".$this->processString($_SESSION['string_search'])."%')";
                                    }
                                    else if (isset($fieldRelative[$i])) {
                                        $this->querySearch[] = "(`".$fieldRelative[$i]['name']."` LIKE '%".$this->processString($_SESSION['string_search'], 'text')."%')";
                                    }
                                }
                            }
                        }
                    }
                }

                for ($i = 0; $i < count($fieldPrimary) - 5; $i++) {
                    if (isset($fieldPrimary[$i]['native_type']) && $fieldPrimary[$i]['native_type'] == 'DATE') {
                        $date = $this->processDate($_SESSION['string_search'], 'mysql');

                        if ($date) {
                            $this->querySearch[] = "(`".$fieldPrimary[$i]['name']."` = '".$date."')";
                        }
                    }
                    else if (isset($fieldPrimary[$i]['native_type']) && $fieldPrimary[$i]['native_type'] == 'VAR_STRING') {
                        $this->querySearch[] = "(`".$fieldPrimary[$i]['name']."` LIKE '%".$this->processString($_SESSION['string_search'])."%')";
                    }
                    else {
                        $this->querySearch[] = "(`".$fieldPrimary[$i]['name']."` LIKE '%".$this->processString($_SESSION['string_search'], 'text')."%')";
                    }
                }
            }
        }

        if (isset($this->querySearch)) {
            $this->querySearch = implode(' OR ', $this->querySearch);
        }
    }

    public function setQueryFilter()
    {
        if (count($this->template) > 1) {
            foreach ($this->template as $keyTemplate => $template) {
                if ($template['type'] === 'complement' OR $template['type'] === 'relative') {
                    if ($keyTemplate != $this->key) {
                        $filter = null;
                        $type = explode('-', $keyTemplate);

                        if ($this->get('filter_'.$type[1])) {
                            $filter = "AND `id_".$keyTemplate."` = '".$this->get('filter_'.$type[1])."'";
                        }

                        if ($template['type'] === 'complement') {
                            $this->queryFilter .= "LEFT JOIN ";
                        }
                        else if ($template['type'] === 'relative') {
                            $this->queryFilter .= "INNER JOIN ";
                        }

                        $this->queryFilter .= "`".$template['table']."` ON (`id_".$keyTemplate."` = `".$this->sufix($type[1])."` AND `status_".$keyTemplate."` = 'active' ".$filter.") ";
                    }
                }
            }
        }
    }

    public function getViewsTemplate($view = null)
    {
        if (is_null($view)) {
            $view = intval($this->value('view'));
        }

        if ($view && $view >= 1) {
            $dataReturn = '
                <div class="alert alert-info alert-view mb-4">
                    <b>
                        <i class="fa fa-eye"></i> Visualizações: '.$view.'
                    </b>
                </div>
            ';

            return $dataReturn;
        }
    }

    public function getTrigger($alert = true)
    {
        if (isset($this->template[$this->key]['table'])) {
            $dataReturn = '
            <div class="table-responsive">
                <table class="table table-striped table-bordered mb-0">
                    <thead>
                        <tr>
                            <th width="1%" class="text-center"><i class="fas fa-bolt mr-2"></i>ação</th>
                            <th width="1%"><i class="fas fa-user mr-2"></i>usuário</th>
                            <th><i class="far fa-clock mr-2"></i>horário</th>
                        </tr>
                    </thead>
                    <tbody>';

            $querySql = "SELECT * FROM `trigger_log`
                         WHERE `table_log` = '".$this->template[$this->key]['table']."' AND `tuple_log` = '".$this->value('id')."'
                         ORDER BY `time_log` DESC";

            if ($query = $this->dbFetchAll($querySql)) {
                foreach ($query as $key => $result) {
                    if ($result['type_log'] == 'update') {
                        $dataReturn .= '
                        <tr>
                            <td class="text-center"><span class="badge badge-info">editado</span></td>
                            <td>'.$this->getTupleModule('administrator', $result['user_log'], 'name').'</td>
                            <td>'.$this->processDate($result['time_log'], 'timestamp_brazil').'</td>
                        </tr>';
                    }
                    else if ($result['type_log'] == 'status') {
                        $dataReturn .= '
                        <tr>
                            <td class="text-center">'.$this->getTagTrigger($result['extra_log']).'</td>
                            <td>'.$this->getTupleModule('administrator', $result['user_log'], 'name').'</td>
                            <td>'.$this->processDate($result['time_log'], 'timestamp_brazil').'</td>
                        </tr>';
                    }
                }

                $dataReturn .= '
                <tr>
                    <td class="text-center"><span class="badge badge-primary">cadastro</span></td>
                    <td class="text-nowrap">'.$this->getTupleModule('administrator', $this->value('user'), 'name').'</td>
                    <td>'.$this->processDate($this->value('time'), 'timestamp_brazil').'</td>
                </tr>';

                $dataReturn .= '
                        </tbody>
                    </table>
                </div>';

                return $dataReturn;
            }
            else if ($alert) {
                return '<div class="alert alert-info" style="margin-bottom: 0">Nenhum registro encontrado!</div>';
            }
        }
    }

    public function getPhotoPage($parameter, $label = 'cover', $name = 'imagem', $folder = null, $delete = true, $archive = false, $height = 100, $typeimage = 'default', $onlyLinks = false)
    {
        if (is_null($folder)) {
            $folder = $this->key;
        }

        $dataReturn = null;

        if (@json_decode($parameter)) {
            $jsonData = json_decode($parameter, true);

            if (array_key_exists('name', $jsonData)) {
                $vars = explode('.', $jsonData['name']);

                $hashImage = $vars[0];
                $extensionImageReal = $vars[1];

                if ($this->activeWebp) {
                    $extensionWebp = 'webp';

                    $extensionExecute = $extensionWebp;
                }
                else {
                    $extensionExecute = $extensionImageReal;
                }

                $parameter = $hashImage.'.'.$extensionExecute;

                $links = $this->generateLinksImage($folder, $parameter, $extensionImageReal);

                $jsonData['root'] = $links['download'];
                $jsonData['larger'] = $links['larger'];
                $jsonData['smaller'] = $links['smaller'];
                $jsonData['download'] = config('app.PATH_API').'/getDownload.php?parameter='.base64_encode(json_encode($jsonData));

                if (isset($this->page['update']['path'])) {
                    $jsonData['remove'] = parent::pathlang(null, $this->page['update']['path'].'&uuid='.$this->get('uuid').'&action=delete_cover&label='.$label.'&typeimage='.$typeimage);
                }

                if ($onlyLinks) {
                    return $jsonData;
                }

                $dataReturn = $this->getPhotoPageViewImage($jsonData, $delete, $archive);

                if (!$jsonData['root']) {
                    $dataReturn = null;
                }
            }
        }

        return $dataReturn;
    }

    public function getPhotoPageViewImage($jsonData, $delete = true, $archive = false)
    {
        if (!$archive) {
            $dataReturn = '
            <a href="'.$jsonData['larger'].'" data-toggle="lightbox">
                <img src="'.$jsonData['smaller'].'" class="img-fluid" alt="" title="Visualizar" />
            </a>';

            $dataReturn .= '<div class="btn-group mt-2">';

            if ($delete) {
                $dataReturn .= '<a class="btn btn-sm btn-danger" href="'.$jsonData['remove'].'" title="Excluir"><i class="fa fa-trash mr-2"></i>Excluir</a>';
            }

            $dataReturn .= '<a class="btn btn-sm btn-primary" href="'.$jsonData['download'].'" title="Download"><i class="fa fa-download mr-2"></i>Download</a>';
            $dataReturn .= '</div>';

        }
        else {
            $dataReturn = '<img src="'.$jsonData['smaller'].'" class="img-fluid" alt="" title="Visualizar"/>';
        }

        return $dataReturn;
    }

    public function getPhotoPageOnlyLinks($parameter, $label = 'cover')
    {
        $links = self::getPhotoPage($parameter, $label, 'imagem', null, true, false, 100, 'default', true);

        return $links;
    }

    public function getPhotoPageIcon($parameter, $label = 'cover', $name = 'imagem', $folder = null)
    {
        if (is_null($folder)) {
            $folder = $this->key;
        }

        $dataReturn = null;

        if (@json_decode($parameter)) {
            $jsonData = json_decode($parameter, true);

            if (array_key_exists('name', $jsonData)) {
                $vars = explode('.', $jsonData['name']);

                $hashImage = $vars[0];
                $extensionImageReal = $vars[1];

                if ($this->activeWebp) {
                    $extensionWebp = 'webp';

                    $extensionExecute = $extensionWebp;
                }
                else {
                    $extensionExecute = $extensionImageReal;
                }

                $parameter = $hashImage.'.'.$extensionExecute;

                $links = $this->generateLinksImage($folder, $parameter, $extensionImageReal);

                $jsonData['root'] = $links['download'];

                $dataReturn = '
                <a href="'.$links['larger'].'" data-toggle="lightbox" data-type="image" data-title="false">
                    <i class="fa fa-search mr-2" title="Visualizar"></i>
                </a>';

                if (!$jsonData['root']) {
                    $dataReturn = null;
                }
            }
        }

        return $dataReturn;
    }

    public function getMultiplePhotoPage($parameter, $label = 'cover', $photo = null, $name = null, $folder = null, $delete = true, $archive = false, $height = 100, $typeimage = 'default', $onlyLinks = false)
    {
        $dataReturn = null;

        if (@json_decode($parameter)) {
            $jsonData = json_decode($parameter, true);

            if (!isset($jsonData['name'])) {
                if (isset($jsonData[$photo])) {
                    $parameter = json_encode($jsonData[$photo]);

                    $dataReturn = $this->getPhotoPage($parameter, $label, $name, $folder, $delete, $archive, $height, $typeimage, $onlyLinks);

                }
            }
        }

        return $dataReturn;
    }

    public function getMultiplePhotoPageOnlyLinks($parameter, $label = 'cover', $photo = null, $name = null, $folder = null, $delete = true, $archive = false, $height = 100, $typeimage = 'default')
    {
        $links = self::getMultiplePhotoPage($parameter, $label, $photo, $name, $folder, $delete, $archive, $height, $typeimage, true);

        return $links;
    }

    public function generateLinksImage($folder, $parameter, $extensionImageReal)
    {
        $links = null;

        if ($this->activeWebp) {
            $parameterRoot = explode('.webp', $parameter);

            $parameterReal = $parameterRoot[0].'.'.$extensionImageReal;
        }
        else {
            $parameterReal = $parameter;
        }

        $path_upload_root = config('app.ROOT_UPLOAD').'/'.$folder.'/images';
        $path_upload_web = config('app.PATH_UPLOAD').'/'.$folder.'/images';

        $folders = ['default', 'thumb', 'smaller', 'larger'];

        $compare = null;

        foreach ($folders as $keyFolder) {
            $folder_root = $path_upload_root.'/temp';

            $folder_web_root = $path_upload_root;
            $folder_web = $path_upload_web;

            $folder_web_root = $path_upload_root.'/'.$keyFolder;
            $folder_web = $path_upload_web.'/'.$keyFolder;

            if (file_exists($folder_web_root.'/'.$parameter)) {
                if (file_exists($folder_root.'/'.$parameterReal)) {
                    $compare[$keyFolder]['root'] = $folder_root.'/'.$parameterReal;
                }
                else if (file_exists($folder_root.'/'.$parameter)) {
                    $compare[$keyFolder]['root'] = $folder_root.'/'.$parameter;
                }

                $compare[$keyFolder]['web_root'] = $folder_web_root.'/'.$parameter;
                $compare[$keyFolder]['web'] = $folder_web.'/'.$parameter;

                if (!array_key_exists('root', $compare[$keyFolder])) {
                    $compare[$keyFolder]['root'] = $compare[$keyFolder]['web_root'];
                }
            }

            if (!$compare) {
                if (file_exists($folder_web_root.'/'.$parameterReal)) {
                    if (file_exists($folder_root.'/'.$parameterReal)) {
                        $compare[$keyFolder]['root'] = $folder_root.'/'.$parameterReal;
                    }
                    else if (file_exists($folder_root.'/'.$parameterReal)) {
                        $compare[$keyFolder]['root'] = $folder_root.'/'.$parameterReal;
                    }

                    $compare[$keyFolder]['web_root'] = $folder_web_root.'/'.$parameterReal;
                    $compare[$keyFolder]['web'] = $folder_web.'/'.$parameterReal;

                    if (!array_key_exists('root', $compare[$keyFolder])) {
                        $compare[$keyFolder]['root'] = $compare[$keyFolder]['web_root'];
                    }
                }
            }
        }

        $links['download'] = null;
        $links['larger'] = null;
        $links['smaller'] = null;

        if ($compare) {
            if (array_key_exists('thumb', $compare) && array_key_exists('web_root', $compare['thumb'])) {
                if (file_exists($compare['thumb']['web_root'])) {
                    $links['download'] = $compare['thumb']['web_root'];
                    $links['smaller'] = $compare['thumb']['web'];
                }
            }

            if (array_key_exists('smaller', $compare) && array_key_exists('web_root', $compare['smaller'])) {
                if (file_exists($compare['smaller']['web_root'])) {
                    $links['download'] = $compare['smaller']['web_root'];
                    $links['smaller'] = $compare['smaller']['web'];
                }
            }

            if (array_key_exists('default', $compare) && array_key_exists('web_root', $compare['default'])) {
                if (file_exists($compare['default']['web_root'])) {
                    $links['download'] = $compare['default']['web_root'];
                    $links['smaller'] = $compare['default']['web'];
                }
            }

            if (is_null($links['download']) || is_null($links['smaller'])) {
                if (array_key_exists('temp', $compare) && array_key_exists('web_root', $compare['temp'])) {
                    if (file_exists($compare['temp']['web_root'])) {
                        $links['download'] = $compare['temp']['web_root'];
                        $links['smaller'] = $compare['temp']['web'];
                    }
                }
            }

            if (array_key_exists('default', $compare) && array_key_exists('web_root', $compare['default'])) {
                if (file_exists($compare['default']['web_root'])) {
                    $links['download'] = $compare['default']['root'];
                    $links['smaller'] = $compare['default']['web'];
                }
            }

            if (array_key_exists('default', $compare) && array_key_exists('web_root', $compare['default'])) {
                if (file_exists($compare['default']['web_root'])) {
                    $links['larger'] = $compare['default']['web'];
                }
            }

            if (array_key_exists('original', $compare) && array_key_exists('web_root', $compare['original'])) {
                if (file_exists($compare['original']['web_root'])) {
                    $links['larger'] = $compare['original']['web'];
                }
            }

            if (array_key_exists('larger', $compare) && array_key_exists('web_root', $compare['larger'])) {
                if (file_exists($compare['larger']['web_root'])) {
                    $links['larger'] = $compare['larger']['web'];
                }
            }

            if (is_null($links['larger'])) {
                if (array_key_exists('temp', $compare) && array_key_exists('web_root', $compare['temp'])) {
                    if (file_exists($compare['temp']['web_root'])) {
                        $links['larger'] = $compare['temp']['web'];
                    }
                }
            }
        }

        return $links;
    }

    public function getVideoTemplate($parameter, $label = 'video', $name = 'vídeo', $delete = true, $view = true)
    {
        if ($parameter) {
            $dataReturn = null;

            if (@json_decode($parameter)) {
                $jsonData = json_decode($parameter, true);

                $parameter = [];

                if (isset($jsonData['code'])) {
                    $parameter[0] = $jsonData['code'];
                    $parameter[1] = $jsonData['type'];
                }
            }

            if (isset($jsonData['code'])) {
                if ($parameter[1] == 'youtube') {
                    if (isset($jsonData['list'])) {
                        $dataReturn = '<iframe width="600" height="380" src="//www.youtube.com/embed/videoseries?list='.$jsonData['list'].'" frameborder="0" allowfullscreen></iframe>';

                        if (isset($tag['index'])) {
                            $dataReturn = '<iframe width="600" height="380" src="//www.youtube.com/embed/videoseries?list='.$jsonData['list'].'&index='.$jsonData['index'].'" frameborder="0" allowfullscreen></iframe>';
                        }
                    }
                    else {
                        $dataReturn = '<iframe width="600" height="380" src="//www.youtube.com/embed/'.$parameter[0].'" frameborder="0" allowfullscreen></iframe>';
                    }
                }
                else if ($parameter[1] == 'vimeo') {
                    $dataReturn = '<iframe src="//player.vimeo.com/video/'.$parameter[0].'?badge=0&amp;color=ffffff" width="600" height="380" frameborder="0" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>';
                }

                if ($delete && $view) {
                    $dataReturn .= '<div class="mt-2">';
                }

                if ($delete) {
                    $dataReturn .= '<a class="btn btn-sm btn-danger" href="'.parent::pathlang(null, $this->page['update']['path'].'&id='.$this->get('id').'&action=delete_video&label='.$label).'" title="Excluir '.$name.'"><i class="fas fa-trash mr-2"></i>Excluir '.$name.'</a>';
                }

                if ($view) {
                    if ($parameter[1] == 'youtube') {
                        if (isset($jsonData['list'])) {
                            $dataReturn .= '<a class="btn btn-sm btn-info ml-2" data-toggle="lightbox" href="//www.youtube.com/embed/videoseries?list='.$jsonData['list'].'" title="Ver"><i class="fas fa-eye mr-2"></i>Assistir</a>';

                            if (isset($tag['index'])) {
                                $dataReturn .= '<a class="btn btn-sm btn-info ml-2" data-toggle="lightbox" href="//www.youtube.com/embed/videoseries?list='.$jsonData['list'].'&index='.$jsonData['index'].'" title="Ver"><i class="fas fa-eye mr-2"></i>Assistir</a>';
                            }
                        }
                        else {
                            $dataReturn .= '<a class="btn btn-sm btn-info ml-2" data-toggle="lightbox" href="//www.youtube.com/embed/'.$parameter[0].'" title="Ver"><i class="fas fa-eye mr-2"></i>Assistir</a>';
                        }
                    }
                    else if ($parameter[1] == 'vimeo') {
                        $dataReturn .= '<a class="btn btn-sm btn-info ml-2" data-toggle="lightbox" href="//player.vimeo.com/video/'.$parameter[0].'" title="Ver"><i class="fas fa-eye mr-2"></i>Assistir</a>';
                    }
                }

                if ($delete && $view) {
                    $dataReturn .= '</div>';
                }
            }

            return $dataReturn;
        }
    }

    public function getVideoTemplateThumbnail($parameter, $label = 'video', $name = 'vídeo', $class = 'photo_main_archive', $delete = false, $view = false, $typeImage = 'hq')
    {
        if ($parameter) {
            $dataReturn = null;

            if (@json_decode($parameter)) {
                $jsonData = json_decode($parameter, true);

                $parameter = [];

                $parameter = $jsonData['code'];
                $type = $jsonData['type'];
            }

            if ($type === 'youtube') {
                switch ($typeImage) {
                    case 'hq':
                        if (isset($jsonData['list'])) {
                            $dataReturn = '
                            <a href="//www.youtube.com/embed/videoseries?list='.$jsonData['list'].'" data-toggle="lightbox">
                                <img src="https://img.youtube.com/vi/'.$parameter.'/hqdefault.jpg" class="'.$class.'" alt="" title="Visualizar" />
                            </a>';

                            if (isset($tag['index'])) {
                                $dataReturn = '
                                <a href="//www.youtube.com/embed/videoseries?list='.$jsonData['list'].'&index='.$jsonData['index'].'" data-toggle="lightbox">
                                    <img src="https://img.youtube.com/vi/'.$parameter.'/hqdefault.jpg" class="'.$class.'" alt="" title="Visualizar" />
                                </a>';
                            }
                        }
                        else {
                            $dataReturn = '
                            <a href="//www.youtube.com/embed/'.$parameter.'" data-toggle="lightbox">
                                <img src="https://img.youtube.com/vi/'.$parameter.'/hqdefault.jpg" class="'.$class.'" alt="" title="Visualizar" />
                            </a>';
                        }
                    break;

                    default:
                        if (isset($jsonData['list'])) {
                            $dataReturn = '
                            <a href="//www.youtube.com/embed/videoseries?list='.$jsonData['list'].'" data-toggle="lightbox">
                                <img src="https://img.youtube.com/vi/'.$parameter.'/default.jpg" class="'.$class.'" alt="" title="Visualizar" />
                            </a>';

                            if (isset($tag['index'])) {
                                $dataReturn = '
                                <a href="//www.youtube.com/embed/videoseries?list='.$jsonData['list'].'&index='.$jsonData['index'].'" data-toggle="lightbox">
                                    <img src="https://img.youtube.com/vi/'.$parameter.'/default.jpg" class="'.$class.'" alt="" title="Visualizar" />
                                </a>';
                            }
                        }
                        else {
                            $dataReturn = '
                            <a href="//www.youtube.com/embed/'.$parameter.'" data-toggle="lightbox">
                                <img src="https://img.youtube.com/vi/'.$parameter.'/default.jpg" class="'.$class.'" alt="" title="Visualizar" />
                            </a>';
                        }
                    break;
                }
            }
            else if ($type === 'vimeo') {
                $vimeo = unserialize(file_get_contents('https://vimeo.com/api/v2/video/'.$parameter.'.php'));

                $dataReturn = '
                <a href="//player.vimeo.com/video/'.$parameter.'" class="video-lightbox blue">
                    <img src="'.$vimeo[0]['thumbnail_large'].'" class="'.$class.'" alt="" title="Visualizar" />
                </a>';
            }

            if ($view) {
                $dataReturn .= '<div style="margin-top: 10px;">';

                if ($delete) {
                    $dataReturn .= '<a class="text-muted" href="'.parent::pathlang(null, $this->page['update']['path'].'&id='.$this->get('id').'&action=delete_video&label='.$label).'" title="Excluir '.$name.'"><i class="fa fa-trash"></i> Excluir '.$name.'</a>';
                }

                if ($type == 'youtube') {
                    $dataReturn .= '&nbsp;- <a class="text-muted" href="https://www.youtube.com/watch?v='.$parameter.'" title="Ver" target="_blank"><i class="fas fa-eye"></i> Ver</a>';
                }
                else if ($type == 'vimeo') {
                    $dataReturn .= '&nbsp;- <a class="text-muted" href="https://vimeo.com/'.$parameter.'" title="Ver" target="_blank"><i class="fas fa-eye"></i> Ver</a>';
                }
            }

            $dataReturn .= '</div>';

            return $dataReturn;
        }
    }

    public function getDownloadPage($parameter, $label = 'pdf', $deleteText = 'anexo', $download = true, $delete = false, $view = false)
    {
        if (@json_decode($parameter)) {
            $jsonData = json_decode($parameter, true);

            $parameter = $jsonData['name'];

            $jsonData['root'] = config('app.ROOT_UPLOAD').'/'.$this->key.'/files/'.$parameter;
            $jsonData['download'] = config('app.PATH_UPLOAD').'/'.$this->key.'/files'.'/'.$parameter;

            $dataReturn = null;

            if ($view) {
                $dataReturn .= '<a class="text-muted" href="'.$jsonData['download'].'" title="Visualizar '.$deleteText.'" target="_blank"><i class="fas fa-eye"></i>&nbsp;&nbsp;Visualizar '.$deleteText.'</a>&nbsp;&nbsp;&nbsp;';
            }

            if ($delete) {
                $dataReturn .= '<a class="text-muted" href="'.parent::pathlang(null, $this->page['update']['path'].'&id='.$this->get('id').'&action=delete_tuple&tuple='.$label).'" title="Excluir '.$deleteText.'"><i class="fa fa-trash"></i>&nbsp;&nbsp;Excluir '.$deleteText.'</a>&nbsp;&nbsp;&nbsp;';
            }

            if ($download) {
                $dataReturn .= '<a class="text-muted" href="'.config('app.PATH_API').'/getDownload.php?parameter='.base64_encode(json_encode($jsonData)).'" title="Download"><i class="fa fa-download"></i>&nbsp;&nbsp;Download</a>';
            }

            return $dataReturn;
        }
    }

    public function getDownload($file, $label = 'Download')
    {
        $dataReturn = null;

        if (@json_decode($file)) {
            $jsonData = json_decode($file, true);

            $file = $jsonData['name'];

            $jsonData['root'] = config('app.ROOT_UPLOAD').'/'.$this->key.'/files/'.$file;
            $jsonData['download'] = config('app.PATH_UPLOAD').'/'.$this->key.'/files'.'/'.$file;

            if ($label) {
                $dataReturn = '<a class="btn btn-sm btn-primary" href="'.config('app.PATH_API').'/getDownload.php?parameter='.base64_encode(json_encode($jsonData)).'" title="'.$label.'"><i class="fa fa-download mr-2"></i>'.$label.'</a>';
            }
            else {
                $dataReturn = '<a class="btn btn-sm btn-primary" href="'.config('app.PATH_API').'/getDownload.php?parameter='.base64_encode(json_encode($jsonData)).'" title="'.$label.'"><i class="fa fa-download"></i></a>';
            }

            return $dataReturn;
        }
    }

    public function value($label, $type = 'string')
    {
        if ($this->operation == 'insert') {
            return $this->processString($this->post($label),$type);
        }
        else {
            if (array_key_exists($this->sufix($label), $this->dataUpdate)) {
                return $this->processString($this->dataUpdate[$this->sufix($label)],$type);
            }
        }
    }

    public function htmlHeader()
    {
        $return = null;

        if (isset($this->template[$this->key]) && $this->template[$this->key]['type'] === 'extra') {
            $return = '<h3 class="mb-2">'.$this->template[$this->key]['label'].'</h3><hr class="mt-0">';
        }
        else if (isset($this->template[$this->key]) && ($this->template[$this->key]['type'] === 'primary' || $this->template[$this->key]['type'] === 'configuration')) {
            $return = '<h1>'.'<a href="'.parent::pathlang(null, config('app.PATH_SYSTEM').$this->template[$this->key]['folder'].'/'.str_replace('-', '/', $this->key).'&operation='.$this->template[$this->key]['start']).'" title="'.$this->template[$this->key]['title'].'">'.$this->template[$this->key]['title'].'</a></h1>';
        }
        else if (isset($this->template[$this->key]) && $this->template[$this->key]['type'] === 'system') {
            if ($this->operation == 'manage' || $this->operation == 'insert' || $this->operation == 'update') {
                $return = '<h1>'.'<a href="'.parent::pathlang(null, config('app.PATH_SYSTEM').$this->template[$this->key]['folder'].'/'.str_replace('-', '/', $this->key).'&operation='.$this->template[$this->key]['start']).'" title="'.$this->template[$this->key]['title'].'">'.$this->template[$this->key]['title'].'</a></h1>';
            }
            else {
                $return = '<h1>'.'<a href="'.parent::pathlang(null, config('app.PATH_SYSTEM').$this->template[$this->key]['folder'].'/'.str_replace('-', '/', $this->key).'&operation='.$this->operation).'" title="'.$this->page[$this->operation]['title'].'">'.$this->page[$this->operation]['title'].'</a></h1>';
            }
        }
        else if (isset($this->template[$this->key]) && $this->template[$this->key]['type'] === 'primary-system' && isset($this->page[$this->operation]['title'])) {
            $return = '<h1>'.'<a href="'.parent::pathlang(null, config('app.PATH_SYSTEM').$this->template[$this->key]['folder'].'/'.str_replace('-', '/', $this->key).'&operation='.$this->template[$this->key]['start']).'" title="'.$this->template[$this->key]['title'].'">'.$this->template[$this->key]['title'].'</a></h1>';
        }
        else if (isset($this->template[$this->key])) {
            $return = '<h1>'.'<a href="'.parent::pathlang(null, config('app.PATH_SYSTEM').$this->template[$this->key]['folder'].'/'.str_replace('-', '/', $this->key).'&operation='.$this->template[$this->key]['start']).'" title="'.$this->template[$this->key]['title'].'">'.$this->template[$this->key]['title'].'</a></h1>';
        }

        return $return;
    }

    public function htmlButton($nots = [])
    {
        $dataReturn = null;
        $dataReturnExtra = null;
        $dataReturnDeveloper = null;
        $button = 'off';

        if ($this->buttonExtra && $this->operation != 'insert' && $this->operation != 'update' && $this->operation != 'configForm' && $this->operation != 'mergeProfiles') {
            foreach ($this->buttonExtra as $key => $value) {
                $dataReturnExtra .= $value;
            }
        }

        if ($this->operation == 'manage') {
            if (!isset($nots['noactions'])) {
                if ($this->checkPrivilegePage('insert')) {
                    $dataReturn .= '<div class="btn-group">';

                    $dataReturn .= '
                    <a class="btn btn-primary" href="'.parent::pathLang(null, $this->page['insert']['path'].$this->extra).'" title="Cadastrar '.$this->template[$this->key]['label'].'">
                        <i class="fa fa-plus mr-2"></i> Cadastrar
                    </a>';

                    $dataReturn .= '</div>';

                    if (isset($nots['onlyInsert'])) {
                        return $dataReturn;
                    }
                }

                $dataReturnOptionsRelative = $buttoRelativeOptions = null;

                foreach ($this->template as $keyTemplate => $template) {
                    if ($keyTemplate != $this->key && isset($template['getter']) && $this->nivel($template['getter'], $template['privilege']['insert'])) {
                        $buttoRelativeOptions = 'off';

                        $dataReturnOptionsRelative .= '<a class="btn btn-secondary" href="'.parent::pathlang(null, config('app.PATH_SYSTEM').str_replace('-', '/', $this->template[$this->key]['folder']).'/'.str_replace('-', '/',$keyTemplate).'&operation=manage'.$this->extra).'" title="Gerenciar '.$this->processString($template['label']).'"><i class="fa fa-tag mr-2"></i> '.$this->processString($template['label']).'</a>';
                    }
                }

                if ($buttoRelativeOptions == 'ok') {
                    $dataReturn .= '<div class="btn-group">'.$dataReturnOptionsRelative.'</div>';
                }

                $buttoCheckOptions = null;

                $buttonsOptions = '<div class="btn-group">';
                $buttonsOptions .= '
                    <button data-toggle="dropdown" class="btn btn-default dropdown-toggle" title="Configurações do Módulo">
                        <i class="fas fa-cogs mr-2"></i><span>Configurações</span>
                    </button>

                    <div class="dropdown-menu" role="menu">';

                if ($this->checkPrivilegePage('insert')) {
                    $button = 'ok';
                    $buttoCheckOptions = 'ok';
                    $buttonsOptions .= '<a class="dropdown-item" href="'.parent::pathlang(null, $this->page['insert']['path'].$this->extra).'" title="'.$this->page['insert']['title'].' '.$this->template[$this->key]['label'].'"><i class="fa fa-plus mr-2"></i> '.$this->page['insert']['title'].' '.$this->template[$this->key]['label'].'</a>';
                }

                $i = 0;

                foreach ($this->template as $keyTemplate => $template) {
                    if ($keyTemplate != $this->key && isset($template['getter']) && $this->nivel($template['getter'], $template['privilege']['insert'])) {
                        if ($button == 'ok') {
                            $buttonsOptions .= '<div class="dropdown-divider"></div>';
                        }

                        $button = 'ok';
                        $buttoCheckOptions = 'ok';

                        $buttonsOptions .= '<a class="dropdown-item" href="'.parent::pathlang(null, config('app.PATH_SYSTEM').str_replace('-', '/', $this->template[$this->key]['folder']).'/'.str_replace('-', '/',$keyTemplate).'&operation=manage'.$this->extra).'" title="Gerenciar '.$this->processString($template['label']).'"><i class="fa fa-desktop mr-2"></i> Gerenciar '.$this->processString($template['label']).'</a>';
                        $i++;
                    }
                }

                if ($this->exportExcel) {
                    $button = 'ok';
                    $buttoCheckOptions = 'ok';
                    $buttonsOptions .= '<div class="dropdown-divider"></div>';
                    $buttonsOptions .= '<a href="'.parent::pathlang(null, $this->page['manage']['path'].$this->extra.'&action=backupTable').'"><i class="fas fa-file-excel mr-2"></i> Exportar para Planilha de Excel</a></li>';
                }

                if ($this->privilege['god'] == 1  && $this->control['controls_modules'] == true) {
                   if ($button == 'ok') {
                        $buttonsOptions .= '<div class="dropdown-divider"></div>';
                    }

                    $button = 'ok';
                    $buttoCheckOptions = 'ok';
                    $buttonsOptions .= '<a class="dropdown-item" href="'.parent::pathlang(null, config('app.PATH_SYSTEM').'helpers&operation=modulesInfo&module='.$this->key).'"><i class="fas fa-database mr-2"></i> Dados do Módulo</a>';
                }

                $buttonsOptions .= '</div></div>';

                if ($this->privilege['developer'] == 1  && $this->control['controls_developer'] == true && config('app.ENV') == 'development') {
                    $button = 'ok';
                    $dataReturnDeveloper = '<div class="btn-group">';
                    $dataReturnDeveloper .= '<button class="btn btn-default dropdown-toggle" data-toggle="dropdown" title="DEVELOPER ToolBox">
                        <i class="fa fa-toolbox mr-2"></i></button>';

                    $dataReturnDeveloper .= '
                     <div class="dropdown-menu" role="menu">';
                    $dataReturnDeveloper .= '<a href="'.parent::pathlang(null, $this->page['manage']['path'].$this->extra.'&action=exportData').'" class="dropdown-item action-exportData"><i class="fas fa-database mr-2"></i> Exportar Dados</a>';
                    $dataReturnDeveloper .= '<a href="'.parent::pathlang(null, $this->page['manage']['path'].$this->extra.'&action=importData').'" class="dropdown-item action-importData"><i class="fas fa-database mr-2"></i> Importar Dados</a>';
                    $dataReturnDeveloper .= '<div class="dropdown-divider"></div>';
                    $dataReturnDeveloper .= '<a href="'.parent::pathlang(null, $this->page['manage']['path'].$this->extra.'&action=truncateTable').'" class="dropdown-item action-truncateTable"><i class="fas fa-database mr-2"></i> Limpar Tabela</a>';
                    $dataReturnDeveloper .= '<a href="'.parent::pathlang(null, $this->page['manage']['path'].$this->extra.'&action=resetTable').'" class="dropdown-item action-resetTable"><i class="fas fa-database mr-2"></i> Resetar Tabela</a>';

                    if ($this->template[$this->key]['type'] == 'primary' || $this->template[$this->key]['type'] == 'relative'|| $this->template[$this->key]['type'] == 'relative-multiple') {
                        $dataReturnDeveloper .= '<div class="dropdown-divider"></div>';
                        $dataReturnDeveloper .= '<a href="'.parent::pathlang(null, $this->page['manage']['path'].$this->extra.'&action=resetViewsTable').'" class="dropdown-item alert-action-default"><i class="fas fa-database mr-2"></i> Resetar visualizações</a>';
                        $dataReturnDeveloper .= '<a href="'.parent::pathlang(null, $this->page['manage']['path'].$this->extra.'&action=deleteGhostFiles').'" class="dropdown-item alert-action-default"><i class="fa fa-trash mr-2"></i> Excluir arquivos fantasmas</a>';
                        $dataReturnDeveloper .= '<div class="dropdown-divider"></div>';
                        $dataReturnDeveloper .= '<a href="'.parent::pathlang(null, $this->page['manage']['path'].$this->extra.'&action=deleteWebp').'" class="dropdown-item alert-action-default"><i class="fa fa-trash mr-2"></i> Excluir imagens WEBP</a>';
                        $dataReturnDeveloper .= '<a href="'.parent::pathlang(null, $this->page['manage']['path'].$this->extra.'&action=convertWebp').'" class="dropdown-item alert-action-default"><i class="fa fa-image mr-2"></i> Converter imagens em WEBP</a>';
                        $dataReturnDeveloper .= '<a href="'.parent::pathlang(null, $this->page['manage']['path'].$this->extra.'&action=restoreWebp').'" class="dropdown-item alert-action-default"><i class="fa fa-image mr-2"></i> Restaurar imagens em WEBP</a>';
                    }

                    $dataReturnDeveloper .= '</div></div>';
                }

                if ($buttoCheckOptions == 'ok') {
                    $dataReturn .= $buttonsOptions;
                }

                if (isset($dataReturnDeveloper)) {
                    $dataReturn .= $dataReturnDeveloper;
                }
            }
        }
        else if ($this->operation == 'insert') {
            $button = 'on';

            $dataReturn .= '
                <button id="insert_action_form" name="insert_action_form" class="btn btn-primary" type="submit" value="'.$this->page['insert']['label'].'">
                    <i class="fa fa-plus mr-2"></i>'.$this->page['insert']['label'].'
                </button>';

            if ($this->control['btnInsertReturn']) {
                $dataReturn .= '
                    <button id="insert_action_form_return" name="insert_action_form" class="btn btn-info" type="submit" value="'.$this->page['insertReturn']['label'].'">
                        <i class="fa fa-undo mr-2"></i>'.$this->page['insertReturn']['label'].'
                    </button>';
            }
        }
        else if ($this->operation == 'update') {
            $button = 'on';

            $dataReturn .= '
                <button id="update_action_form" name="update_action_form" class="btn btn-primary" type="submit" value="'.$this->page['update']['label'].'">
                    <i class="fa fa-save mr-2"></i>'.$this->page['update']['label'].'
                </button>';
            $dataReturn .= '
                <button id="update_action_form_return" name="update_action_form" class="btn btn-info" type="submit" value="'.$this->page['updateReturn']['label'].'">
                    <i class="fa fa-undo mr-2"></i>'.$this->page['updateReturn']['label'].'
                </button>';
        }
        else if (!isset($nots['noactions'])) {
            $button = 'on';

            $dataReturn .= '
            <button id="'.$this->operation.'_action_form" name="'.$this->operation.'_action_form" class="btn btn-primary" type="submit" value="'.$this->page[$this->operation]['label'].'">
                <i class="'.$this->page[$this->operation]['icon'].' mr-2"></i>'.$this->page[$this->operation]['label'].'
            </button>';
        }

        if ($button == 'off') {
            $dataReturn = null;
        }

        if ($dataReturnExtra) {
            $dataReturn = $dataReturn . '<div class="btn-group">' . $dataReturnExtra . '</div><div class="clearfix"></div>';
        }

        return $dataReturn;
    }

    public function htmlControl($total, $injection = null, $final = false, $topHeader = false)
    {
        $dataReturn = null;
        $dataReturnCallback = null;

        $dataApi['total'] = $this->html_feedback_total($total);

        $filter_status = null;

        if (array_key_exists($this->get('status'), $this->filterStatusContent)) {
            $filter_status = ': '.$this->filterStatusContent[$this->get('status')]['title'];
        }

        if ((($this->control['controls_manage'] == true || $this->control['controls_actions'] == true || $this->control['controls_filter'] == true || $this->control['controls_search'] == true) && $this->extra == null)) {
            if ((($this->control['controls_actions'] == true || $this->control['controls_filter'] == true) && $this->extra == null)) {
                if (($this->control['controls_actions'] == true && $this->extra == null)) {
                    $dataReturnCallback .= '
                    <div class="btn-group">
                        <button data-toggle="dropdown" class="btn btn-primary dropdown-toggle" title="Ações Múltiplas">
                        <i class="fa fa-bolt mr-2"></i>Ações
                    </button>

                    <ul class="dropdown-menu dropdown-primary">';
                        foreach ($this->actionStatusContent as $key => $value) {
                            $dataReturnCallback .= '<a class="dropdown-item submit" href="#" data-form="'.$this->extra.'" data-link="'.parent::pathlang(null, $this->page['manage']['path'].'&action=set_'.$key.$this->extra).'"><i class="fa fa-circle mr-2 text-'.$value['color'].'"></i> '.$value['title'].'</a>';
                        }

                        if ($this->checkPrivilegePage('delete')) {
                            $dataReturnCallback .= '<a class="dropdown-item submit" href="#" data-form="'.$this->extra.'" data-link="'.parent::pathlang(null, $this->page['manage']['path'].'&action=set_deleted'.$this->extra).'"><i class="fa fa-circle mr-2"></i> Excluir</a>';
                        }

                    if ($this->actionsMultipleModule) {
                        foreach ($this->actionsMultipleModule as $modules) {
                            $dataReturnCallback .= '<div class="dropdown-divider"></div>';

                            foreach ($modules as $key => $value) {
                                $dataReturnCallback .= '<a class="dropdown-item submit" href="#" data-form="'.$this->extra.'" data-link="'.parent::pathlang(null, $this->page['manage']['path'].'&action=set_'.$value['type'].'&value='.$value['value'].$this->extra).'"><i class="fa '.$value['icon'].' '.$value['color'].' mr-2"></i> '.$value['label'].'</a>';
                            }
                        }
                    }

                    $dataReturnCallback .= '
                    </ul>
                    </div>';
                }

                if (($this->control['controls_filter'] == true && $this->extra == null)) {
                    $dataReturnCallback .= '
                    <div class="btn-group">
                        <button data-toggle="dropdown" class="btn btn-primary dropdown-toggle" title="Filtar por status">
                            <i class="fa fa-filter mr-2"></i>Status'.$filter_status.'
                        </button>

                        <ul class="dropdown-menu dropdown-primary">';
                            foreach ($this->filterStatusContent as $key => $value) {
                                $colorKey = $value['class'];

                                if (isset($value['manipuleClass'])) {
                                    $colorKey = $value['manipuleClass'];
                                }

                                $dataReturnCallback .= '<a class="dropdown-item" href="'.parent::pathPreservLink($this->page['manage']['path'], [['status' => $key]]).$this->extra.'"><i class="fa fa-circle text-'.$colorKey.' mr-2"></i> '.$value['title'].'</a>';
                            }

                            if ($this->actionsMultipleModule) {
                                foreach ($this->actionsMultipleModule as $modules) {
                                    $dataReturnCallback .= '<div class="dropdown-divider"></div>';

                                    foreach ($modules as $key => $value) {
                                        $dataReturnCallback .= '<a class="dropdown-item" href="'.parent::pathlang(null, $this->page['manage']['path'].'&'.$value['type'].'='.$value['value'].$this->extra).'"><i class="fa '.$value['icon'].' '.$value['color'].' text-'.$key.' mr-2"></i> '.$value['filter'].'</a>';
                                    }
                                }
                            }

                            $dataReturnCallback .= '
                        </ul>
                    </div>';
                }

                if ((count($this->template) > 1 && $this->control['controls_relative'] == true)) {
                    foreach ($this->template as $keyTemplate => $template) {
                        if ($keyTemplate != $this->key && $template['type'] != 'complement' && $template['type'] != 'extra') {
                            $label = 'title';

                            $type = explode('-', $keyTemplate);

                            $querySql = "SELECT * FROM `".$template['table']."`
                                         INNER JOIN `".$this->template[$this->key]['table']."` ON (`".$type[1]."_".$this->key."` = `id_".$keyTemplate."` AND `status_".$this->key."` = 'active')
                                         WHERE `status_".$keyTemplate."` = 'active'  GROUP BY `id_".$keyTemplate."` ORDER BY `".$label."_".$keyTemplate."`";

                            $query = $this->dbFetchAll($querySql);

                            if (is_array($query) && count($query) > 0) {
                                $dataReturn .= '
                                <div class="btn-group-select2">
                                <select id="filter_'.$type[1].'" name="filter_'.$type[1].'" class="hidden-xs filter-link form-control select2">
                                <option value="'.parent::pathPreservLink($this->page['manage']['path'], [['filter_'.$type[1] => 'none-select']]).'">Filtro: '.$this->processString($template['label']).'</option>';
                                foreach ($query as $keyQuery => $result) {
                                    $dataReturn .= '<option style="white-space:nowrap" value="'.parent::pathPreservLink($this->page['manage']['path'], [['filter_'.$type[1] => $result['id_'.$keyTemplate]]]).$this->extra.'"';

                                    if ($this->get('filter_'.$type[1]) == $result['id_'.$keyTemplate]) {
                                        $dataReturn .= ' selected';
                                    }

                                    $dataReturn .= '>'.$this->processString($result[$label.'_'.$keyTemplate]).'</option>';
                                }
                                $dataReturn .= '
                                </select>
                                </div>';
                            }
                        }
                    }
                }
            }
        }

        if ($injection) {
            $dataReturn .= $injection;
        }

        $dataApi['commands'] = $dataReturn;
        $dataApi['commandsCallback'] = $dataReturnCallback;

        return $dataApi;
    }

    public function htmlSearch($final = true, $width = '250px')
    {
        $dataReturn = null;

        if (array_key_exists('manage', $this->modulesSystem[$this->key]['privilege']) && $this->control['controls_search'] == true && $this->control['controls_manage'] == true) {
            $label = 'Pesquisar...';

            if (isset($_SESSION['string_search'])) {
                $label = 'Pesquisa: '.$_SESSION['string_search'];
            }

            $dataReturn .= '
            <div id="searchFormManage" style="width: '.$width.';">
                <form name="search_form" method="post" action="'.parent::pathlang(null, $this->page['manage']['path'].'&action=search'.$this->extra).'" class="searhForm">
                    <div class="input-group">
                        <input type="text" id="search_string" name="search_string" class="form-control float-right" placeholder="'.$label.'">

                        <div class="input-group-append">
                            <button type="submit" class="btn btn-default">
                                <i class="fas fa-search"></i>
                            </button>
                        </div>
                    </div>
                </form>
            </div>';
        }

        return $dataReturn;
    }

    public function htmlActionUnique($parameter, $extra = 'uuid', $sub = false, $externalPrefix = null, $manipule = [], $labels = false)
    {
        $dataReturn = null;

        if (isset($parameter[$this->sufix('uuid')])) {
            $parameterId = $parameter[$this->sufix('uuid')];
        }
        else if (isset($parameter[$this->sufix('id')])) {
            $parameterId = $parameter[$this->sufix('id')];
        }
        else if (isset($parameter['id'])) {
            $parameterId = $parameter['id'];
        }

        if (!$sub) {
            $dataReturn = '<div class="action-buttons-table">';
        }

        if ($this->checkPrivilegePage('view', false)) {
            $dataReturn .= '
                <a class="btn btn-sm btn-default" href="'.parent::pathlang($this->lang, $this->page['view']['path']).'&'.$extra.'='.$parameterId.$this->extra.'" title="'.$this->page['view']['title'].'">
                    <i class="fas fa-eye"></i>
                </a>';
        }

        if ($this->checkPrivilegePage('update')) {
            $label = 'Editar';

            if (!$labels) {
                $label = null;
            }

            $dataReturn .= '
                <a class="btn btn-sm btn-default" href="'.parent::pathlang($this->lang, $this->page['update']['path']).'&'.$extra.'='.$parameterId.$this->extra.'" title="'.$this->page['update']['title'].'">
                    <i class="fas fa-pencil-alt"></i>
                </a>';
        }

        if ($this->control['bt_frontend'] == true) {
            if ($this->key != 'page') {
                if (!array_key_exists($this->sufix('slug'), $parameter)) {
                    $slug = $parameter[$this->sufix('id')];
                }
                else {
                    $slug = $parameter[$this->sufix('slug')];
                }

                if (!$externalPrefix) {
                    if ($this->infoModules) {
                        $externalPrefix = $this->infoModules['scope']['key_view'];
                    }
                }

                if ($externalPrefix) {
                    $dataReturn .= '
                        <a class="btn btn-sm btn-default" href="'.config('app.BASE_PATH').'/'.$externalPrefix.'/'.$slug.'" title="Ver no site" target="_blank">
                            <i class="fas fa-link"></i>
                        </a>';
                }
            }
            else if ($parameter[$this->sufix('type')] != 0) {
                $dataReturn .= '
                    <a class="btn btn-sm btn-default" href="'.config('app.BASE_PATH').'/'.$parameter[$this->sufix('slug')].'" title="Ver no site" target="_blank">
                        <i class="fas fa-link"></i>
                    </a>';
            }
        }

        if ($this->checkPrivilegePage('delete')) {
            $action = 'set_deleted'; $title = 'Excluir';

            if (array_key_exists('deleteAction', $manipule)) {
                $action = $manipule['deleteAction'];
            }

            $dataReturn .= '
                <a class="btn btn-sm btn-default action-delete" href="'.parent::pathlang($this->lang, $this->page['manage']['path']).'&action='.$action.'&'.$extra.'='.$parameterId.$this->extra.'" title="'.$title.'">
                    <i class="fa fa-trash"></i>
                </a>';
        }

        if (!$sub) {
            $dataReturn .= '</div>';
        }

        return $dataReturn;
    }

    public function htmlParamsDeveloper()
    {
        $dataReturn = null;

        $dataReturn .= '
        <div class="row form-group">
            <label class="col-md-3 col-form-label" for="'.$this->sufix('id_developer').'">ID:</label>
            <div class="col-md-6">
                <div class="clearfix">
                    <input type="number" id="'.$this->sufix('id_developer').'" name="'.$this->sufix('id_developer').'" class="form-control" maxlength="100" value="'.$this->value('id').'" disabled />
                </div>
            </div>
        </div>';

        $dataReturn .= '
        <div class="row form-group">
            <label class="col-md-3 col-form-label" for="'.$this->sufix('uuid_developer').'">UUID:</label>
            <div class="col-md-6">
                <div class="clearfix">
                    <input type="text" id="'.$this->sufix('uuid_developer').'" name="'.$this->sufix('uuid_developer').'" class="form-control" maxlength="100" value="'.$this->value('uuid').'" disabled />
                </div>
            </div>
        </div>';

        if ($this->value('slug')) {
            $dataReturn .= '
            <div class="row form-group">
                <label class="col-md-3 col-form-label" for="'.$this->sufix('slug_developer').'">Slug:</label>
                <div class="col-md-6">
                    <div class="clearfix">
                        <input type="text" id="'.$this->sufix('slug_developer').'" name="'.$this->sufix('slug_developer').'" class="form-control" maxlength="255" value="'.$this->value('slug').'" required />
                    </div>
                </div>
                <span class="col-md-3 help-inline">
                    <small><span class="middle" id="'.$this->sufix('cont_slug_developer').'">[ Máx. 255 caracteres ]</span></small>
                </span>
            </div>';
        }

        if ($this->value('order')) {
            $dataReturn .= '
            <div class="row form-group">
                <label class="col-md-3 col-form-label" for="'.$this->sufix('order_developer').'">Ordem:</label>
                <div class="col-xs-12 col-sm-2">
                    <div class="clearfix">
                        <input type="number" id="'.$this->sufix('order_developer').'" name="'.$this->sufix('order_developer').'" class="form-control" maxlength="100" value="'.$this->value('order').'" required />
                    </div>
                </div>
            </div>';
        }

        if ($this->value('view')) {
            $dataReturn .= '
            <div class="row form-group">
                <label class="col-md-3 col-form-label" for="'.$this->sufix('view_developer').'">Visualizações:</label>
                <div class="col-md-6">
                    <div class="clearfix">
                        <input type="number" id="'.$this->sufix('view_developer').'" name="'.$this->sufix('view_developer').'" class="form-control" maxlength="100" value="'.$this->value('view').'" required />
                    </div>
                </div>
            </div>';
        }

        $dataReturn .= '
        <div class="row form-group">
            <label class="col-md-3 col-form-label" for="'.$this->sufix('user_developer').'">Administrador:</label>
            <div class="col-md-6">
                <div class="clearfix">
                    <select id="'.$this->sufix('user_developer').'" name="'.$this->sufix('user_developer').'" class="form-control select2">';
                        $query = $this->dbFetchAll("SELECT `id_administrator`, `name_administrator` FROM `mod_administrator` WHERE `status_administrator` = 'active'");

                        foreach ($query as $key => $result) {
                            if ($result[0] === $this->value('user')) {
                                $selected = ' selected';
                            }
                            else {
                                $selected = null;
                            }

                            $dataReturn .= '<option value="'.$result[0].'"'.$selected.'>'.$this->processString($result[1]).'</option>';
                        }
        $dataReturn .= '
                    </select>
                </div>
            </div>
        </div>';

        $dataReturn .= '
        <div class="row form-group">
            <label class="col-md-3 col-form-label" for="'.$this->sufix('time_developer').'">Timestamp:</label>
            <div class="col-md-6">
                <div class="clearfix">
                    <input type="text" id="'.$this->sufix('time_developer').'" name="'.$this->sufix('time_developer').'" class="form-control input-mask-timestamp" maxlength="100" value="'.$this->value('time').'" required />
                </div>
            </div>
        </div>';

        $dataReturn .= '
        <div class="row form-group">
            <label class="col-md-3 col-form-label" for="'.$this->sufix('status_developer').'">Status:</label>
            <div class="col-md-6">
                <div class="clearfix">
                    <select id="'.$this->sufix('status_developer').'" name="'.$this->sufix('status_developer').'" class="form-control select2">';
                        foreach ($this->filterStatusContent as $key => $label) {
                            if ($key === $this->value('status')) {
                                $selected = ' selected';
                            }
                            else {
                                $selected = null;
                            }

                            $dataReturn .= '<option value="'.$key.'"'.$selected.'>'.mb_strtoupper($this->processString($label['title'])).'</option>';
                        }
        $dataReturn .= '
                    </select>
                </div>
            </div>
        </div>';

        return $dataReturn;
    }

    public function html_feedback_total($total)
    {
        if ($total == 0) {
            switch($this->get('status'))
            {
                case 'disabled': return 'Nenhum registro desabilitado'; break;
                case 'active': return 'Nenhum registro ativado'; break;
                case 'pendent': return 'Nenhum registro pendente'; break;
                case 'trash': return 'Nenhum registro na lixeira'; break;
                case 'deleted': return 'Nenhum registro deletado'; break;
                case 'old': return 'Nenhum registro antigo'; break;
                default:
                    if ($this->extra == null) {
                        if ($this->querySearch) {
                            return 'Nenhum registro encontrado'; break;
                        }
                        else {
                            return 'Nenhum registro cadastrado'; break;
                        }
                    }
                break;
            }
        }
        else if ($total == 1)
        {
            switch($this->get('status'))
            {
                case 'disabled': return '1 registro desabilitado'; break;
                case 'active': return '1 registro ativado'; break;
                case 'pendent': return '1 registro pendente'; break;
                case 'trash': return '1 registro na lixeira'; break;
                case 'deleted': return '1 registro deletado'; break;
                case 'old': return '1 registro antigo'; break;
                default:
                    if ($this->extra == null) {
                        if ($this->querySearch) {
                            return '1 registro encontrado'; break;
                        }
                        else {
                            return '1 registro cadastrado'; break;
                        }
                    }
                break;
            }
        }
        else
        {
            switch($this->get('status'))
            {
                case 'disabled': return $total.' registros desabilitados'; break;
                case 'active': return $total.' registros ativados'; break;
                case 'pendent': return $total.' registros pendentes'; break;
                case 'trash': return $total.' registros na lixeira'; break;
                case 'deleted': return ' registros deletados'; break;
                case 'old': return ' registros antigos'; break;
                default:
                    if ($this->extra == null) {
                        if ($this->querySearch) {
                            return $total.' registros encontrados'; break;
                        }
                        else {
                            return $total.' registros cadastrados'; break;
                        }
                    }
                break;
            }
        }
    }

    public function dataStatus($parameter = [], $pageReturn = 'manage', $callback = true, $info = null, $check = true)
    {
        if ($this->extra != NULL) {
            $array = explode('/', $this->get('base'));
        }

        if ($parameter[0] <> 'deleted') {
            $redirect_status = '&status='.$parameter[0];
        }
        else {
            $redirect_status = NULL;
        }

        if (empty($parameter[1])) {
            if ($select_one = $this->post('select_one', 'array_explode')) {
                foreach ($select_one as $value) {
                    $query = "UPDATE `".parent::getTable()."` SET `status_".parent::getSufix()."` = '".$parameter[0]."' WHERE `".parent::sufix('uuid')."` = '".$value."'";

                    $this->dbQuery($query);

                    if ($check) {
                        if (!$this->checkTriggerLog('status', $value, $query, $parameter[0], $this->logDatabase)) {
                            $this->setTriggerLog('status', $value, $query, $parameter[0], $this->logDatabase);
                        }
                    }
                    else {
                        $this->setTriggerLog('status', $value, $query, $parameter[0], $this->logDatabase);
                    }
                }

                if ($callback) {
                    header('Location: '.parent::pathlang(null, $this->page[$pageReturn]['path'].$redirect_status.'&callback=status_'.$parameter[0].$this->extra));
                    exit;
                }
            }
            else {
                if ($callback) {
                    header('Location: '.parent::pathlang(null, $this->page[$pageReturn]['path'].'&callback=status_error'.$this->extra));
                    exit;
                }
            }
        }
        else {
            $query = "UPDATE `".parent::getTable()."` SET `".parent::sufix('status')."` = '".$parameter[0]."' WHERE `".parent::sufix('uuid')."` = '".$parameter[1]."'";

            if ($check) {
                if (!$this->checkTriggerLog('status', $parameter[1], $query, $parameter[0], $this->logDatabase)) {
                    $this->alterStatus($parameter[0], $parameter[1], $query, $info);
                }
            }
            else {
                $this->alterStatus($parameter[0], $parameter[1], $query, $info);
            }

            if ($callback) {
                header('Location: '.parent::pathlang(null, $this->page[$pageReturn]['path'].$redirect_status.'&callback=status_'.$parameter[0].$this->extra));
                exit;
            }
        }
    }

    public function alterStatus($status, $id, $query, $info)
    {
        if ($this->logDatabase == 'default') {
            $this->dbQuery($query);

            $this->setTriggerLog('status', $id, $query, $status, $info);
        }
    }

    public function deleteData($parameter = [], $pageReturn = 'manage', $callback = true)
    {
        if ($this->extra != NULL) {
            $array = explode('/', $this->get('base'));
        }

        if ($parameter[0] <> 'deleted') {
            $redirect_status = '&status='.$parameter[0];
        }
        else {
            $redirect_status = NULL;
        }

        if (empty($parameter[1])) {
            if ($select_one = $this->post('select_one', 'array_explode')) {
                foreach ($select_one as $value) {
                    $query = "DELETE FROM `".parent::getTable()."` WHERE `".parent::sufix('uuid')."` = '".$value."'";

                    $this->dbQuery($query);

                    $this->setTriggerLog('delete', $value, $query, $parameter[0]);
                }

                if ($callback) {
                    header('Location: '.parent::pathlang(null, $this->page[$pageReturn]['path'].$redirect_status.'&callback='.$parameter[0].$this->extra));
                    exit;
                }
            }
            else {
                if ($callback) {
                    header('Location: '.parent::pathlang(null, $this->page[$pageReturn]['path'].'&callback=status_error'.$this->extra));
                    exit;
                }
            }
        }
        else {
            $query = "DELETE FROM `".parent::getTable()."` WHERE `".parent::sufix('uuid')."` = '".$parameter[1]."'";

            $this->dbQuery($query);

            $this->setTriggerLog('delete', $parameter[1], $query, $parameter[0]);

            if ($callback) {
                header('Location: '.parent::pathlang(null, $this->page[$pageReturn]['path'].$redirect_status.'&callback='.$parameter[0].$this->extra));
                exit;
            }
        }
    }

    public function alterFeatured($parameter = [], $pageReturn = 'manage')
    {
        if ($this->extra != NULL) {
            $array = explode('/', $this->get('base'));
        }

        if (empty($parameter[1])) {
            if ($select_one = $this->post('select_one', 'array_explode')) {
                foreach ($select_one as $value) {
                    $query = "UPDATE `".parent::getTable()."` SET `".parent::sufix($parameter[0])."` = '".parent::get('value')."'  WHERE `".parent::sufix('uuid')."` = '".$value."'";

                    $this->dbQuery($query);

                    $this->setTriggerLog($parameter[0], $value, $query, $parameter[0]);
                }

                $callback = 'featured_no';
                $redirect_status = NULL;

                if (parent::get('value') == 1) {
                    $callback = 'featured_yes';
                }

                $redirect_status = '&featured='.parent::get('value');

                header('Location: '.parent::pathlang(null, $this->page[$pageReturn]['path'].$redirect_status.'&callback='.$callback.$this->extra));
                exit;
            }
            else {
                header('Location: '.parent::pathlang(null, $this->page[$pageReturn]['path'].'&callback=status_error'.$this->extra));
                exit;
            }
        }
    }

    public function postParamsDeveloper()
    {
        $data = null;

        if ($this->privilege['developer'] == 1) {
            if ($this->post($this->sufix('slug_developer'))) {
                $data[$this->sufix('slug')] = $this->post($this->sufix('slug_developer'));
            }

            if ($this->post($this->sufix('order_developer'))) {
                $data[$this->sufix('order')] = intval($this->post($this->sufix('order_developer')));
            }

            if ($this->post($this->sufix('view_developer'))) {
                $data[$this->sufix('view')] = intval($this->post($this->sufix('view_developer')));
            }

            if ($this->post($this->sufix('user_developer'))) {
                $data[$this->sufix('user')] = intval($this->post($this->sufix('user_developer')));
            }

            if ($this->post($this->sufix('time_developer'))) {
                $data[$this->sufix('time')] = $this->post($this->sufix('time_developer'));
            }

            if ($this->post($this->sufix('status_developer'))) {
                $data[$this->sufix('status')] = $this->post($this->sufix('status_developer'));
            }
        }

        return $data;
    }

    public function inputSelectHtml($module, $output, $inputSelect = null, $extra = null, $nivelUser = null, $extraQuery = null, $extraInner = null, $allSelected = false, $tablePrefix = 'mod', $order = null)
    {
        $dataReturn = null;

        if ($module === 'ibge-city' || $module === 'ibge-state' || $module === 'ibge-country' || $module === 'ibge-district') {
            $tablePrefix = 'sis_';
        }
        else if ($tablePrefix == 'mod') {
            $tablePrefix = 'mod_';
        }
        else {
            $tablePrefix = $tablePrefix.'_';
        }

        if (is_null($order)) {
            $order = $output;
        }

        $query = $this->dbFetchAll("SELECT * FROM `".$tablePrefix.$module."` ".$extraInner." WHERE `status_".$module."` <> 'disabled' ".$extraQuery." GROUP BY `id_".$module."` ORDER BY `".$order."_".$module."`");

        if (is_array($query)) {
            foreach ($query as $key => $result) {
                if ($result[0] == $inputSelect || $allSelected) {
                    $selected = ' selected';
                }
                else {
                    $selected = null;
                }

                $extraInfoData = null;

                if (is_array($extra)) {
                    foreach ($extra as $key => $extraData) {
                        $extraInfoData[] = $extraData[1].$this->processString($result[$extraData[0].'_'.$module]).$extraData[2];
                    }

                    $extraInfoData = implode('', $extraInfoData);
                }

                $dataReturn .= '<option value="'.$result['id_'.$module].'"'.$selected.'>'.$this->processString($result[$output.'_'.$module]).' '.$extraInfoData.'</option>';
            }
        }

        if (!$dataReturn) {
            $dataReturn .= '<option value="">Nenhum resultado encontrado</option>';
        }

        return $dataReturn;
    }

    public function inputMultipleSelectHtml($module, $output, $inputSelect = null, $extra = null, $nivelUser = null, $extraQuery = null, $extraInner = null, $allSelected = false, $tablePrefix = 'mod', $order = null)
    {
        $dataReturn = null;

        if ($module === 'ibge-city' || $module === 'ibge-state' || $module === 'ibge-country' || $module === 'ibge-district') {
            $tablePrefix = 'sis_';
        }
        else if ($tablePrefix == 'mod') {
            $tablePrefix = 'mod_';
        }
        else {
            $tablePrefix = $tablePrefix.'_';
        }

        if (is_null($order)) {
            $order = $output;
        }

        $querySql = "SELECT * FROM `".$tablePrefix.$module."`
                     ".$extraInner."
                     WHERE `status_".$module."` <> 'disabled' ".$extraQuery."
                     GROUP BY `id_".$module."`
                     ORDER BY `".$order."_".$module."`";

        $query = $this->dbFetchAll($querySql);

        if (is_array($query)) {
            foreach ($query as $key => $result) {
                if ($this->inputMultipleSelectArrayItens($inputSelect, $result['id_'.$module]) || $allSelected) {
                    $selected = ' selected';
                }
                else {
                    $selected = null;
                }

                $extraInfoData = null;

                if (is_array($extra)) {
                    foreach ($extra as $key => $extraData) {
                        $extraInfoData[] = $extraData[1].$this->processString($result[$extraData[0]]).$extraData[2];
                    }

                    $extraInfoData = implode($extraInfoData);
                }

                $dataReturn .= '<option value="'.$result['id_'.$module].'"'.$selected.'>'.$this->processString($result[$output.'_'.$module]).' '.$extraInfoData.'</option>';
            }

            if (!$dataReturn) {
                $dataReturn .= '<option value="">Nenhum resultado encontrado</option>';
            }
        }

        return $dataReturn;
    }

    public function arraySelectedItens($key, $item)
    {
        $keyArray = explode('-', $key);
        $keyPrimary = $keyArray[0];
        $keyComplement = $keyArray[1];

        $result = $this->dbFetch("SELECT `".$keyComplement."_".$keyPrimary."` FROM `mod_".$keyPrimary."` WHERE `id_".$keyPrimary."` = '".$this->value('id')."' AND `status_".$keyPrimary."` = 'active'");

        if ($result[0]) {
            $array = json_decode($result[0]);

            foreach ($array as $selected) {
                if ($item == $selected) {
                    return true;
                }
            }
        }
    }

    public function inputMultipleSelectArrayHtml($key, $view = 'title', $inputSelect = null)
    {
        $dataReturn = null;

        $query = $this->dbQuery("SELECT `id_".$key."`, `".$view."_".$key."` FROM `mod_".$key."` WHERE `status_".$key."` = 'active'");

        while ($result = $query->fetch_array()) {
            if ($this->inputMultipleSelectArrayItens($inputSelect, $result['id_'.$key])) {
                $selected = ' selected';
            }
            else {
                $selected = null;
            }

            $dataReturn .= '<option value="'.$result[0].'"'.$selected.'>'.$this->processString($result[1]).'</option>';
        }

        if (!$dataReturn) {
            $dataReturn .= '<option value="">Nenhum resultado encontrado</option>';
        }

        return $dataReturn;
    }

    public function inputMultipleSelectArrayItens($inputSelect, $item)
    {
        if ($inputSelect) {
            if (@unserialize($inputSelect)) {
                $array = unserialize($inputSelect);
            }
            else if (@json_decode($inputSelect)) {
                $array = json_decode($inputSelect, true);
            }
            else if (is_array($inputSelect)) {
                $array = $inputSelect;
            }

            foreach ($array as $selected) {
                if ($item == $selected) {
                    return true;
                }
            }
        }
    }

    public function moduleCheck()
    {
        if ($this->template) {
            if (array_key_exists($this->key, $this->template)) {
                if ($this->template[$this->key]['table']) {
                    if ($this->dbPrepare("SELECT * FROM `".$this->template[$this->key]['table']."`")) {
                        return false;
                    }
                    else {
                        return true;
                    }
                }
            }
            else {
                return false;
            }
        }
        else {
            return false;
        }
    }

    public function buttonExtra($path, $title, $icon = null, $privilege = 'group')
    {
        if ($this->checkPrivilege($privilege)) {
            $this->buttonExtra[] = '<button class="btn btn-primary" data-link='.parent::pathlang(null, $path).' title="'.$title.'"><i class="'.$icon.'"></i> '.$title.'</button>';
        }
    }

    public function getImg($file)
    {
        if (file_exists(config('app.ROOT_UPLOAD').'/'.$this->key.'/'.$file)) {
            list($width, $height, $type, $html) = getimagesize(config('app.PATH_UPLOAD').'/'.$this->key.'/'.$file);

            return '<a href="'.config('app.PATH_UPLOAD').'/'.$this->key.'/'.$file.'" data-rel="colorbox"><img src="'.config('app.PATH_UPLOAD').'/'.$this->key.'/'.$file.'" '.$html.' alt="" title="Visualizar" class="img-fluid" /></a>';
        }
    }

    public function paramsModuleAdministrator($module)
    {
        $user = $this->dbFetch("SELECT `id_administrator`, `params_administrator` FROM `mod_administrator`
                                WHERE `id_administrator` = '".ADMINISTRATOR."'");

        if ($user[1]) {
            $params = unserialize($user[1]);

            foreach ($params as $key => $value) {
                if ($params['module'] === $module) {
                    return true;
                }
            }
        }
    }

    private function moduleProtection()
    {
        if ($this->type !== 'static' && $this->type !== 'extra' && array_key_exists($this->key, $this->template)) {
            if (array_key_exists($this->operation, $this->template[$this->key]['privilege'])) {
                $privilege = $this->template[$this->key]['privilege'][$this->operation];
                $module = $this->key;

                if (isset($this->template[$this->key]['getter']) && !is_null($this->template[$this->key]['getter'])) {
                    $module = $this->template[$this->key]['getter'];
                }

                if (!$this->nivel($module, $privilege)) {
                    header('Location: '.config('app.PATH_CMS').'/cms_system.php?callback=dev_000&return='.$this->operation);
                    exit;
                }
            }
        }
    }

    public function checkPrivilegePage($type, $extra = null)
    {
        if (isset($this->modulesSystem[$this->key]['privilege'][$type])) {
            $privilege = $this->modulesSystem[$this->key]['privilege'][$type];
            $module = $this->key;

            if (isset($this->template[$this->key]['getter']) && !is_null($this->template[$this->key]['getter'])) {
                $module = $this->template[$this->key]['getter'];
            }

            if ($this->nivel($module, $privilege)) {
                if ($this->control['bt_'.$type] == true) {
                    return true;
                }
            }
        }
    }

    public function nivel($module = null, $privilege = 'master')
    {
        $checkModule = $this->key;

        if ($module) {
            $checkModule = $module;
        }

        if ($this->checkPrivilege($privilege, $module)) {
            return true;
        }
    }

    public function checkPrivilege($checkPrivilege, $checkModule = null)
    {
        $rank = ['developer' => 500, 'root' => 400, 'god' => 300, 'master' => 200, 'group' => 100, 'not' => 000];

        if ($rank[$this->privilege['active']] >= $rank[$checkPrivilege]) {
            return true;
        }
        else if ($checkModule) {
            if ($rank[$this->privilege['active']] == 100) {
                $dataReturn = $this->dbFetch("SELECT `privilege_nivel`, `only_nivel` FROM `mod_administrator-nivel` WHERE `administrator_nivel` = '".ADMINISTRATOR."' AND `module_nivel` = '".$checkModule."' AND `privilege_nivel` = '1'");

                if (isset($dataReturn['privilege_nivel']) && $dataReturn['privilege_nivel'] == 1 && 200 >= $rank[$checkPrivilege]) {
                    $this->privilege['only'] = intval($dataReturn['only_nivel']);

                    return true;
                }
            }
        }
    }

    public function navBarsUpdateTop($keyActive = null, $keysOff = null, $typeActive = null, $typesOff = null)
    {
        $dataReturn = '
        <li class="nav-item">
            <a class="nav-link" id="data-content-tab" data-toggle="pill" href="#data-content"  title="Dados" role="tab" aria-controls="data-content" aria-selected="false">
                <i class="fas fa-file mr-2"></i>
            </a>
        </li>';

        if ($this->navbarsModule) {
            foreach ($this->navbarsModule as $keyModule => $valueModule) {
                if ($valueModule['active']) {
                    $label = null;

                    if (array_key_exists('view-name', $valueModule)) {
                        $label = ' '.$valueModule['title'];
                    }

                    $dataReturn .= '
                    <li class="nav-item">
                        <a class="nav-link" id="'.$valueModule['key'].'-tab" data-toggle="pill" href="#'.$valueModule['key'].'" role="tab" title="Dados" aria-controls="'.$valueModule['key'].'" aria-selected="false">
                           <i class="fa '.$valueModule['icon'].'"></i>
                        </a>
                    </li>';
                }
            }
        }

        if ($this->navbars['photo'] && $this->checkOffTab($keyActive, $keysOff) && $this->checkOffTab($typeActive, $typesOff)) {
            $dataReturn .= '
            <li class="nav-item">
                <a class="nav-link" id="photo-content-tab" data-toggle="pill" href="#photo-content" role="tab" title="Imagens" aria-controls="photo-content" aria-selected="false">
                   <i class="far fa-image mr-2"></i>
                </a>
            </li>';
        }

        if ($this->navbars['video'] && $this->checkOffTab($keyActive, $keysOff) && $this->checkOffTab($typeActive, $typesOff)) {
            $dataReturn .= '
            <li class="nav-item">
                <a class="nav-link" id="video-content-tab" data-toggle="pill" href="#video-content" role="tab" title="Vídeos" aria-controls="video-content" aria-selected="false">
                   <i class="fas fa-camera mr-2"></i>
                </a>
            </li>';
        }

        if ($this->navbars['anexx'] && $this->checkOffTab($keyActive, $keysOff) && $this->checkOffTab($typeActive, $typesOff)) {
            $dataReturn .= '
            <li class="nav-item">
                <a class="nav-link" id="anexx-content-tab" data-toggle="pill" href="#anexx-content" role="tab" title="Anexos" aria-controls="anexx-content" aria-selected="false">
                   <i class="fas fa-paperclip mr-2"></i>
                </a>
            </li>';
        }

        if ($this->navbars['audio'] && $this->checkOffTab($keyActive, $keysOff) && $this->checkOffTab($typeActive, $typesOff)) {
            $dataReturn .= '
            <li class="nav-item">
                <a class="nav-link" id="audio-content-tab" data-toggle="pill" href="#audio-content" role="tab" title="Áudios" aria-controls="audio-content" aria-selected="false">
                   <i class="fas fa-music mr-2"></i>
                </a>
            </li>';
        }

        if ($this->navbars['config'] && $this->checkOffTab($typeActive, $typesOff)) {
            $dataReturn .= '
            <li class="nav-item">
                <a class="nav-link" id="config-content-tab" data-toggle="pill" href="#config-content" role="tab" title="Configuração" aria-controls="config-content" aria-selected="false">
                   <i class="fas fa-cog"></i>
                </a>
            </li>';
        }

        if ($this->privilege['god'] == 1 && $this->tabsActive['registry']) {
            $dataReturn .= '
            <li class="nav-item">
                <a class="nav-link" id="registry-content-tab" data-toggle="pill" href="#registry-content" role="tab" title="Registro de atividades" aria-controls="registry-content" aria-selected="false">
                   <i class="fas fa-list-ol"></i>
                </a>
            </li>';
        }

        if ($this->privilege['developer'] == 1 && $this->tabsActive['developer']) {
            $dataReturn .= '
            <li class="nav-item">
                <a class="nav-link" id="developer-content-tab" data-toggle="pill" href="#developer-content" role="tab" title="Parâmetros de administrator" aria-controls="developer-content" aria-selected="false">
                   <i class="fas fa-code"></i>
                </a>
            </li>';
        }

        return $dataReturn;
    }

    public function navBarsUpdateBottom($keyActive = null, $keysOff = null, $typeActive = null, $typesOff = null)
    {
        $dataReturn = [];

        if ($this->navbarsModule) {
            foreach ($this->navbarsModule as $keyModule => $valueModule) {
                $dataReturn[$valueModule['key']] = $valueModule['path'];
            }
        }

        if ($this->navbars['config']) {
            $dataReturn['config'] = config('app.ROOT_CMS').'/system/extra/sub-config.php';
        }

        if ($this->navbars['photo'] && $this->checkOffTab($keyActive, $keysOff) && $this->checkOffTab($typeActive, $typesOff)) {
            $dataReturn['photo'] = config('app.ROOT_CMS').'/system/extra/sub-photo.php';
        }

        if ($this->navbars['video'] && $this->checkOffTab($keyActive, $keysOff) && $this->checkOffTab($typeActive, $typesOff)) {
            $dataReturn['video'] = config('app.ROOT_CMS').'/system/extra/sub-video.php';
        }

        if ($this->navbars['anexx'] && $this->checkOffTab($keyActive, $keysOff) && $this->checkOffTab($typeActive, $typesOff)) {
            $dataReturn['anexx'] = config('app.ROOT_CMS').'/system/extra/sub-anexx.php';
        }

        if ($this->navbars['audio'] && $this->checkOffTab($keyActive, $keysOff) && $this->checkOffTab($typeActive, $typesOff)) {
            $dataReturn['audio'] = config('app.ROOT_CMS').'/system/extra/sub-audio.php';
        }

        if ($this->privilege['god'] == 1 && $this->tabsActive['registry']) {
            $dataReturn['registry'] = config('app.ROOT_CMS').'/system/extra/params-registry.php';
        }

        if ($this->privilege['developer'] == 1 && $this->tabsActive['developer']) {
            $dataReturn['developer'] = config('app.ROOT_CMS').'/system/extra/params-developer.php';
        }

        return $dataReturn;
    }

    public function checkOffTab($keyActive, $keysOff)
    {
        if ($keyActive && is_array($keysOff)) {
            if (!in_array($keyActive, $keysOff)) {
                return true;
            }
        }
        else {
            return true;
        }
    }

    public function getPhotoMobileDesktop($data, $type = 'desktop')
    {
        if (@json_decode($data)) {
            $file = json_decode($data, true);

            $parameter = json_encode($file[$type]);

            return $this->getPhotoPage($parameter, 'file', null, null, false, true);
        }
    }

    public function getAvatar($parameter, $typeSteam = 'full', $noAvatar = 'no-avatar-team.jpg')
    {
        $dataReturn = $imgWeb = $imgDir = null;
        $type = 'no-avatar';

        if (@json_decode($parameter)) {
            $jsonData = json_decode($parameter, true);

            if (array_key_exists($typeSteam, $jsonData)) {
                $parameter = $jsonData[$typeSteam];

                $type = 'steam';
            }
            else {
                $parameter = $jsonData['name'];

                $type = 'doop';
            }
        }

        if ($type == 'doop') {
            $folderDir = config('app.ROOT_UPLOAD').'/'.$this->key.'/images';
            $folderWeb = config('app.PATH_UPLOAD').'/'.$this->key.'/images';

            $imgDir = $folderDir.'/thumb/'.$parameter;

            if (file_exists($imgDir)) {
                $imgWeb = $folderWeb.'/thumb'.'/'.$parameter;
            }
            else if (!file_exists($imgDir)) {
                $imgWeb = $folderWeb.'/original/'.$parameter;
                $imgDir = $folderDir.'/original'.'/'.$parameter;
            }
        }
        else if ($type == 'no-avatar') {
            $imgWeb = PATH_SITE.'/public'.'/img'.'/'.$noAvatar;
        }

        if ($imgWeb) {
            if ($this->operation == 'manage') {
                $height = 40;
            }
            else {
                $height= 200;
            }

            $dataReturn = '
                <img src="'.$imgWeb.'" class="avatar_main img-rounded" alt="Avatar" title="Avatar" height="'.$height.'" />';

        }

        return $dataReturn;
    }

    public function getViews($view)
    {
        if (!$view || $view == 0) {
            return 0;
        }
        else {
            return parent::processString($view, 'int');
        }
    }

    public function getFeaturedIcon($featured)
    {
        if ($featured == 2) {
            return '<i class="fa fa-star-o" title="Sem destaque"></i>';
        }
        else if ($featured == 1) {
            return '<i class="fa fa-star text-yellow" title="Destaque"></i>';
        }
    }

    public function getTagStatus($parameter, $status = 'badge text-uppercase p-1')
    {
        if (array_key_exists($parameter, $this->filterStatusContent)) {
            $parameterClass = $parameter;

            if (isset($this->filterStatusContent[$parameter]['class'])) {
                $parameterClass = $this->filterStatusContent[$parameter]['class'];
            }

            return '<span class="'.$status.' badge-'.$parameterClass.'">'.$this->filterStatusContent[$parameter]['label'].'</span>';
        }
    }

    public function getTagTrigger($parameter , $status = 'badge')
    {
        if (array_key_exists($parameter, $this->filterStatusContent)) {
            return '<span class="'.$status.' badge-'.$parameter.'">'.$this->filterStatusContent[$parameter]['label'].'</span>';
        }
    }

    public function getFooterUpdate()
    {
        $getFooterUpdate = '
        <h3 class="mb-2">Registro de atividades</h3>

        <hr class="mt-0">';

        $getFooterUpdate .= $this->getViewsTemplate();
        $getFooterUpdate .= $this->getTrigger();

        return $getFooterUpdate;
    }

    public function getInputSelectStatus($valueStatus = null)
    {
        $dataReturn = null;

        foreach ($this->filterStatusContent as $key => $label) {
            if ($key === $valueStatus) {
                $selected = ' selected';
            }
            else {
                $selected = null;
            }

            $dataReturn .= '<option value="'.$key.'"'.$selected.'>'.mb_strtoupper($this->processString($label['title'])).'</option>';
        }

        return $dataReturn;
    }
}
