<?php
// doopSites v1.9.7 - Última atualização 22/02/2023 16:20

class PhonesInput extends FunctionsDoop
{
    public $operatorActive = false;

    public $operatorDefault = [
        'vivo' => [
            'label' => 'Vivo'
        ],

        'oi' => [
            'label' => 'Oi'
        ],

        'tim' => [
            'label' => 'Tim'
        ],

        'claro' => [
            'label' => 'Claro'
        ],

        'fixo' => [
            'label' => 'Fixo'
        ],

        'whatsapp' => [
            'label' => 'Whatsapp'
        ]
    ];

    public function __construct()
    {
        parent::__construct('system');
    }

    public function preparePhones()
    {
        $data = [
            'number' => $this->post('phones_number', 'array_explode_shift'),
            'details' => $this->post('phones_details', 'array_explode_shift'),
            'operator' => $this->post('phones_operator', 'array_explode_shift')
        ];

        return $data;
    }

    public function showHtml($dataSelect = null)
    {
        $html = '
        <div class="row form-group">
          <label class="col-md-3 col-form-label">Telefones:</label>
          <div class="col-md-9">
            <div class="table-responsive">
              <table class="table table-striped table-bordered table-hover table-doop">
                <thead>
                  <tr>
                    <th colspan="4"><a class="blue" href="#phones" data-command="phones" onclick="$.addLine(this);"><i class="fa fa-plus"></i> Adicionar Telefone</a></th>
                  </tr>
                </thead>

                <thead>
                  <tr>
                    <th>Telefone</th>';
                    if ($this->operatorActive) { $html .= '<th>Tipo</th>'; }
        $html .= '
                    <th colspan="2">Detalhes</th>
                  </tr>
                </thead>

                <tbody id="phones">
                  <tr id="line_1" class="d-none">
                    <td width="25%">
                      <input type="text" name="phones_number[]" class="form-control" maxlength="20" />
                    </td>';

                    if ($this->operatorActive) {
        $html .= '
                    <td width="35%">
                      <select name="phones_operator[]" class="form-control">';
                      foreach ($this->operatorDefault as $keySocial => $data) {
                        $html .= '<option value="'.$keySocial.'">'.$this->processString($data['label'], 'text').'</option>';
                      }
        $html .= '
                      </select>
                    </td>';
                    }

                    if ($this->operatorActive) { $td = '35%'; } else { $td = '70%'; }
        $html .= '
                    <td width="'.$td.'">
                      <input type="text" name="phones_details[]" class="form-control" maxlength="50" />
                    </td>

                    <td width="5%">
                      <a class="blue" href="#phones" data-command="phones" title="Excluir Telefone" onclick="$.removeLine(this);">
                        <i class="fa fa-trash icon-only bigger-130"></i>
                      </a>
                    </td>
                  </tr>';
                    if (is_array($dataSelect)) {
                    $phones = $dataSelect['number'];
                    $phonesDetails = $dataSelect['details'];
                    $phonesOperator = $dataSelect['operator'];

                    if ($phones) {
                    foreach ($phones as $key => $value) {
                      $valuePhone = $phones[$key];
                      $line = $key+2;
        $html .= '
                <tr id="line_'.$line.'">
                  <td width="25%">
                    <input type="text" name="phones_number[]" class="form-control" value="'.$this->processString($valuePhone, 'text').'" maxlength="20" />
                  </td>';

                  if($this->operatorActive) {
        $html .= '
                  <td width="15%">
                    <select name="phones_operator[]" class="form-control">';
                    foreach($this->operatorDefault as $keySocial => $data) {
                      if($keySocial === $phonesOperator[$key]) { $selected = ' selected'; } else { $selected = null; }
                      $html .= '<option value="'.$keySocial.'"'.$selected.'>'.$this->processString($data['label'], 'text').'</option>';
                    }
        $html .= '
                    </select>
                  </td>';
                  }

                  if(array_key_exists($key, $phonesDetails)) { $valueDetails = $phonesDetails[$key]; } else { $valueDetails = null; }
        $html .= '
                  <td width="'.$td.'">
                    <input type="text" name="phones_details[]" class="form-control" maxlength="50" value="'.$this->processString($valueDetails, 'text').'" />
                  </td>

                  <td width="5%">
                    <a class="blue" href="#phones" data-command="phones" title="Excluir Telefone" onclick="$.removeLine(this);">
                      <i class="fa fa-trash icon-only bigger-130"></i>
                    </a>
                  </td>
                </tr>';
                  }
                } }
        $html .= '
                </tbody>
              </table>
            </div>
          </div>
        </div>';

        return $html;
    }
}
