<?php
// doopSites v1.9.7 - Última atualização 22/02/2023 16:20

class SocialInput extends FunctionsDoop
{
    public $socialDefault = [
        'facebook' => [
            'label' => 'Facebook',
            'icon' => 'fab fa-facebook'
        ],
        'instagram' => [
            'label' => 'Instagram',
            'icon' => 'fab fa-instagram'
        ],
        'linkedin' => [
            'label' => 'Linkedin',
            'icon' => 'fab fa-linkedin'
        ],
        'youtube' => [
            'label' => 'Youtube',
            'icon' => 'fab fa-youtube'
        ],
        'twitter' => [
            'label' => 'Twitter',
            'icon' => 'fab fa-twitter'
        ],
        'soundcloud' => [
            'label' => 'SoundCloud',
            'icon' => 'fab fa-soundcloud'
        ],
        'dropbox' => [
            'label' => 'Dropbox',
            'icon' => 'fab fa-dropbox'
        ],
        'vimeo' => [
            'label' => 'Vimeo',
            'icon' => 'fab fa-vimeo'
        ],
        'gplus' => [
            'label' => 'Google+',
            'icon' => 'fab fa-google-plus'
        ],
        'skype' => [
            'label' => 'Skype',
            'icon' => 'fab fa-skype'
        ],
        'flickr' => [
            'label' => 'Flickr',
            'icon' => 'fab fa-flickr'
        ],
        'pinterest' => [
            'label' => 'Pinterest',
            'icon' => 'fab fa-pinterest'
        ]
    ];

    public function __construct()
    {
        parent::__construct('system');
    }

    public function prepareSocial()
    {
        $data = [
            'url' => $this->post('social_url', 'array_explode_shift')
        ];

        $types = $this->post('social_type', 'array_explode_shift');

        if (is_array($types)) {
            $dataTypes = null;

            $id = 0;

            foreach ($types as $key) {
                $dataTypes[$id] = $this->socialDefault[$key];
                $dataTypes[$id]['key'] = $key;

                $id++;
            }

            $data['type'] = $dataTypes;
        }
        else{
            $data['type'] = null;
        }

        return $data;
    }

    public function showHtml($dataSelect = null)
    {
        $html = '
        <div class="row form-group">
        <label class="col-md-3 col-form-label">Redes Sociais:</label>
        <div class="col-md-9">
        <div class="table-responsive">
          <table class="table table-striped table-bordered table-hover table-doop">
            <thead>
              <tr>
                <th colspan="4"><a class="blue" href="#social" data-command="social" onclick="$.addLine(this);"><i class="fa fa-plus"></i> Adicionar Rede Social</a></th>
              </tr>
            </thead>

            <thead>
              <tr>
                <th>Tipo</th>
                <th colspan="2">Url</th>
              </tr>
            </thead>

            <tbody id="social">
              <tr id="line_1" class="d-none">
                <td width="30%">
                  <select name="social_type[]" class="form-control">
                    <option value="">Selecione uma rede</option>';
                  foreach($this->socialDefault as $keySocial => $data) {
                    $html .= '<option value="'.$keySocial.'">'.$this->processString($data['label'], 'text').'</option>';
                  }
        $html .= '
                  </select>
                </td>

                <td width="65%">
                  <input type="text" name="social_url[]" class="form-control" maxlength="500" />
                </td>

                <td width="5%">
                  <a class="blue" href="#social" data-command="social" title="Excluir Rede Social" onclick="$.removeLine(this);">
                    <i class="fa fa-trash icon-only bigger-130"></i>
                  </a>
                </td>
              </tr>';
              if (is_array($dataSelect)) {
                $type = $dataSelect['type'];
                $url = $dataSelect['url'];

                if ($type) {
                foreach ($type as $key => $value) {
                  $line = $key+2;
        $html .= '
            <tr id="line_'.$line.'">
              <td width="30%">
                <select name="social_type[]" class="form-control">
                  <option value="">Selecione uma rede</option>';
                foreach ($this->socialDefault as $keySocial => $data) {
                  if ($keySocial === $value['key']) { $selected = ' selected'; } else { $selected = null; }
                  $html .= '<option value="'.$keySocial.'"'.$selected.'>'.$this->processString($data['label'], 'text').'</option>';
                }
        $html .= '
                </select>
              </td>';

              if (array_key_exists($key, $url)) { $valueUrl = $url[$key]; } else { $valueUrl = null; }
        $html .= '
              <td>
                <input type="text" name="social_url[]" class="form-control" maxlength="500" value="'.$this->processString($valueUrl, 'text').'" />
              </td>

              <td width="5%">
                <a class="blue" href="#social" data-command="social" title="Excluir Rede Social" onclick="$.removeLine(this);">
                  <i class="fa fa-trash icon-only bigger-130"></i>
                </a>
              </td>
            </tr>';
              } }
            }
        $html .= '
            </tbody>
          </table>
        </div>
        </div>
        </div>';

        return $html;
    }
}
