<?php
// doopSites v1.9.7 - Última atualização 29/02/2024 11:15

class FormsClassAutomatic extends ControllerDoop
{
    public $breadcrumb = null;
    public $controller = null;
    public $operation = null;

    public $dataAutomatic = null;
    public $dataAutomaticFull = null;
    public $dataAutomaticInputs = null;

    public $dataModule = [];

    public function __construct($module, $operation, $type, $dataInputs = null)
    {
        $this->operation = $operation;

        parent::__construct($module, $operation, $type);

        $this->modules->control['bt_delete'] = false;
        $this->modules->control['controls_filter'] = false;

        if ($type == 'automaticForms') {
            if (array_key_exists($this->modules->key, $this->modules->template)) {
                $static = $this->modules->template[$this->modules->key];

                $this->dataModule['folder'] = $static['folder'];
                $this->dataModule['key'] = $this->modules->key;

                $this->dataModule['base'] = $this->dataModule['folder'].'/'.$this->dataModule['key'];
                $this->dataModule['path'] = $this->dataModule['folder'].'/'.$this->dataModule['key'];
            }

            //$this->automaticForms($operation, $dataInputs, $type);
        }
        else if ($type == 'automaticUniqueForms' && $this->get('module')) {
            $static = $this->modules->template[$module];

            $this->dataModule['folder'] = $static['folder'];
            $this->dataModule['key'] = $this->modules->key;

            $this->dataModule['base'] = 'helpers';
            $this->dataModule['path'] = $this->dataModule['folder'].'/'.$this->dataModule['key'];

            $this->automaticForms($operation, $dataInputs, $type);
        }
    }

    public function automaticForms($operation, $dataAutomaticInputs, $type)
    {
        if ($dataAutomaticInputs) {
            $this->dataAutomaticInputs = $dataAutomaticInputs;
        }

        $extraFile = config('app.ROOT_CMS').'/app/'.$this->dataModule['path'].'/automatic-forms-manipule.php';

        if (file_exists($extraFile)) {
            $extraFile = include($extraFile);

            $this->dataAutomaticInputs = array_merge($this->dataAutomaticInputs, $extraFile);
        }

        if ($type == 'automaticForms') {
            $automatics = include(config('app.ROOT_CMS').'/'.$this->dataModule['path'].'/automatic-forms-config.php');
        }
        else if ($type == 'automaticUniqueForms') {
            $automatics = include(config('app.ROOT_CMS_HELPERS').'/modulesInfo-config.php');
        }

        if (array_key_exists($operation, $automatics)) {
            $keyOperation = $keyOperationInit = $automatics[$operation]['operation'];

            if ($operation == $keyOperation) {
                $this->dataAutomaticFull = $this->getBaseData($keyOperation);

                if ($type == 'automaticUniqueForms') {
                    $keyOperation = $keyOperation.'-'.parent::get('module');
                }

                if ($type == 'automaticForms') {
                    $this->dataAutomatic = $this->getBaseData($keyOperation);
                }
                else if ($type == 'automaticUniqueForms' ) {
                    $this->dataAutomatic = $this->getBaseData($keyOperation);
                }

                if ($this->post('action_'.$keyOperationInit)) {
                    $this->module_automaticForms($keyOperationInit, $type);
                }

                if ($this->get('deleteImagemBaseData')) {
                    $this->deleteImagemBaseData($keyOperation);
                }
            }
        }
    }

    public function module_automaticForms($operation, $type)
    {
        $data = $this->dataAutomaticFull;

        if ($this->dataAutomaticInputs) {
            foreach ($this->dataAutomaticInputs as $key => $value) {
                if ($this->modules->checkPrivilege($value['privilege'])) {
                    if ($value['type'] == 'upload') {
                        $upload = new \CoreSlim\Upload();
                        $upload->config($value['key'].'_'.$value['value'].'_'.$operation, $this->dataModule['key'], $this->pathLang(null, config('app.PATH_SYSTEM').$this->dataModule['base'].'&operation='.$operation));
                        $upload->all();
                        $upload->dimensions([$value['width'], $value['height']]);
                        $upload->setConfig('type', $value['ext']);
                        $upload->load();

                        if ($output = $upload->output('array')) {
                            $new[$value['key']][$value['value']] = $output;
                        }
                        else if (isset($this->dataAutomaticFull[$value['key']][$value['value']])) {
                            $new[$value['key']][$value['value']] = $this->dataAutomaticFull[$value['key']][$value['value']];
                        }
                    }
                    elseif ($value['type'] == 'upload-crop') {
                        $upload = new \CoreSlim\Upload();
                        $upload->config($value['key'].'_'.$value['value'].'_'.$operation, $this->dataModule['key'], $this->pathLang(null, config('app.PATH_SYSTEM').$this->dataModule['base'].'&operation='.$operation));
                        $upload->all();
                        $upload->dimensions([$value['width'], $value['height']]);
                        $upload->setConfig('type', $value['ext']);
                        $upload->loadBlob($this->post($value['key'].'_'.$value['value'].'_'.$operation));

                        if ($output = $upload->output('array')) {
                            $new[$value['key']][$value['value']] = $output;
                        }
                        else if (isset($this->dataAutomaticFull[$value['key']][$value['value']])) {
                            $new[$value['key']][$value['value']] = $this->dataAutomaticFull[$value['key']][$value['value']];
                        }
                    }
                    else if ($value['type'] == 'upload-pdf') {
                        $upload = new \CoreSlim\Upload();
                        $upload->config($value['key'].'_'.$value['value'].'_'.$operation, $this->dataModule['key'], $this->pathLang(null, config('app.PATH_SYSTEM').$this->dataModule['base'].'&operation='.$operation));
                        $upload->setConfig('type', $value['ext']);
                        $upload->load();

                        if ($output = $upload->output('array')) {
                            $file = $output;

                            $new[$value['key']][$value['value']] = $file;
                        }
                        else {
                            $new[$value['key']][$value['value']] = $this->dataAutomaticFull[$value['key']][$value['value']];
                        }
                    }
                    else if ($value['type'] == 'input' || $value['type'] == 'select' || $value['type'] == 'radio') {
                        $new[$value['key']][$value['value']] = $this->post($value['key'].'_'.$value['value'].'_'.$operation, 'text');
                    }
                    else if ($value['type'] == 'html') {
                        $new[$value['key']][$value['value']] = base64_encode($this->post($value['key'].'_'.$value['value'].'_'.$operation, 'text') ?: '');
                    }
                    else if ($value['type'] == 'code') {
                        $new[$value['key']][$value['value']] = $this->post($value['key'].'_'.$value['value'].'_'.$operation, 'code');
                    }
                    else if ($value['type'] == 'itens') {
                        foreach ($value['itens'] as $keyParams => $valueParams) {
                            $item[$keyParams] = $this->post($value['key'].'_'.$value['value'].'_'.$operation.'_'.$keyParams, 'array_explode_shift');
                        }

                        $new[$value['key']][$value['value']] = $item;
                    }
                    else if ($value['type'] == 'video') {
                        $upload = new \CoreSlim\Upload();
                        $upload->config($value['key'].'_'.$value['value'].'_'.$operation, $this->dataModule['key'], $this->pathLang(null, config('app.PATH_SYSTEM').$this->dataModule['base'].'&operation='.$operation));
                        $upload->setConfig('type', $value['ext']);
                        $upload->load();

                        if ($output = $upload->output('array')) {
                            $file = $output;

                            $new[$value['key']][$value['value']] = $file;
                        }
                        else {
                            $new[$value['key']][$value['value']] = $this->dataAutomaticFull[$value['key']][$value['value']];
                        }
                    }
                }
            }
        }

        if ($type == 'automaticForms' && isset($new)) {
            $this->dataAutomatic = $this->dataAutomaticFull;

            foreach ($new as $keyData => $valueData) {
                foreach ($valueData as $key => $value) {
                    $this->dataAutomatic[$keyData][$key] = $value;
                }
            }

            $operationSave = $operation;
        }
        else if ($type == 'automaticUniqueForms' && isset($new)) {
            $this->dataAutomatic = $this->dataAutomaticFull;

            foreach ($new as $keyData => $valueData) {
                foreach ($valueData as $key => $value) {
                    $this->dataAutomatic[$keyData][$key] = $value;
                }
            }

            $operationSave = $operation.'-'.$this->get('module');
        }

        $this->setBaseData($operationSave, $this->dataAutomatic, 'json');

        if ($type == 'automaticForms') {
            header('Location: '.$this->pathLang(null, config('app.PATH_SYSTEM').$this->dataModule['base'].'&operation='.$operation.'&callback=301'));
            exit;
        }
        else {
            header('Location: '.$this->pathLang(null, config('app.PATH_SYSTEM').$this->dataModule['base'].'&operation='.$operation.'&module='.$this->get('module').'&callback=301'));
            exit;
        }
    }

    public function deleteImagemBaseData($operation)
    {
        list($key, $file) = explode('-', $this->get('deleteImagemBaseData'));


        $pathOriginal = config('app.ROOT_UPLOAD').'/'.$this->dataModule['key'].'/images/temp/'.$this->dataAutomatic[$key][$file]['name'];

        if (file_exists($pathOriginal)) {
            unlink($pathOriginal);
        }

        $vars = explode('.', $this->dataAutomatic[$key][$file]['name']);

        $hashImage = $vars[0];
        $extensionImageReal = $vars[1];

        $pathWebp = config('app.ROOT_UPLOAD').'/'.$this->dataModule['key'].'/images/'.$hashImage.'.webp';

        if (file_exists($pathWebp)) {
            unlink($pathWebp);
        }

        $this->dataAutomatic[$key][$file] = null;

        $this->setBaseData($operation, $this->dataAutomatic);

        header('Location: '.$this->pathLang(null, config('app.PATH_SYSTEM').$this->dataModule['base'].'&operation='.$operation.'&callback=301'));
        exit;
    }
}
