<?php
// doopSites v1.9.7 - Última atualização 23/05/2023 15:17

class FormsHtml
{
    public $controller = null;

    private $attrs = [];
    private $attr_class = [];

    public function __construct($controller)
    {
        $this->controller = $controller;
    }

    public function addAttrClass($value)
    {
        $this->attr_class[] = $value;
    }

    public function addAttrs($value)
    {
        $this->attrs[] = $value;
    }

    public function defaults($vars, $type, $value)
    {
        if (array_key_exists($type, $vars)) {
            $value = $vars[$type];
        }

        return $value;
    }

    public function setRequired($form, $vars)
    {
        if (!array_key_exists('required', $form)) {
            $form['required'] = $this->defaults($vars, 'required', true);
        }

        if ($form['required']) {
            $this->addAttrs('required');
        }

        return $form;
    }

    public function setMaxlength($form, $vars)
    {
        if (!array_key_exists('maxlength', $form)) {
            $form['maxlength'] = intval($this->defaults($vars, 'maxlength', 200));
        }

        if ($form['maxlength']) {
            $this->addAttrs('maxlength="'.$form['maxlength'].'"');
        }

        return $form;
    }

    public function setPlaceholder($form, $vars)
    {
        if (!array_key_exists('placeholder', $form)) {
            $form['placeholder'] = $this->defaults($vars, 'placeholder', false);
        }

        if ($form['placeholder']) {
            $this->addAttrs('placeholder="'.$form['placeholder'].'"');
        }

        return $form;
    }

    public function setReadonly($form, $vars)
    {
        if (!array_key_exists('readonly', $form)) {
            $form['readonly'] = $this->defaults($vars, 'readonly', false);
        }

        if ($form['readonly']) {
            $this->addAttrs('readonly');
        }

        return $form;
    }

    public function setDisabled($form, $vars)
    {
        if (!array_key_exists('disabled', $form)) {
            $form['disabled'] = $this->defaults($vars, 'disabled', false);
        }

        if ($form['disabled']) {
            $this->addAttrs('disabled');
        }

        return $form;
    }

    public function setAutocomplete($form, $vars)
    {
        if (!array_key_exists('autocomplete', $form)) {
            $form['autocomplete'] = $this->defaults($vars, 'autocomplete', false);
        }

        if ($form['autocomplete']) {
            $this->addAttrs('autocomplete="'.$form['autocomplete'].'"');
        }

        return $form;
    }

    public function setMask($form, $vars)
    {
        if (!array_key_exists('mask', $form)) {
            $form['mask'] = $this->defaults($vars, 'mask', false);
        }

        if ($form['mask']) {
            $this->addAttrClass($form['mask']);
        }

        return $form;
    }

    public function setContInput($form, $vars)
    {
        if (!array_key_exists('cont_input', $form)) {
            $form['cont_input'] = $this->defaults($vars, 'cont_input', true);
        }

        if ($form['cont_input']) {
            $this->addAttrClass('cont-input');
        }

        return $form;
    }

    public function setAttrClass($form, $vars)
    {
        $form['attr_class'] = null;

        if (!array_key_exists('class', $form)) {
            $form['class'] = $this->defaults($vars, 'input_class', 'form-control');
        }

        if ($form['class']) {
            $this->addAttrClass($form['class']);

            if (is_array($this->attr_class)) {
                $form['attr_class'] = implode(' ', $this->attr_class);
            }

            $this->attr_class = null;
        }

        return $form;
    }

    public function setInputGroup($form, $vars)
    {
        if (!array_key_exists('input_group_class', $form)) {
            $form['input_group_class'] = $this->defaults($vars, 'input_group_class', 'input-group');
        }

        if (!array_key_exists('input_group_label', $form)) {
            $form['input_group_label'] = $this->defaults($vars, 'input_group_label', false);
        }

        if (!array_key_exists('input_group_rtl', $form)) {
            $form['input_group_rtl'] = $this->defaults($vars, 'input_group_rtl', false);
        }

        $form['input_group_addon'] = $form['input_group_left'] = $form['input_group_right'] = null;

        if ($form['input_group_label']) {
            $form['input_group_addon'] = '<div class="input-group-text">'.$form['input_group_label'].'</div>';
        }

        if (!$form['input_group_rtl']) {
            $form['input_group_left'] = '<div class="input-group-prepend">'.$form['input_group_addon'].'</div>';
        }
        else {
            $form['input_group_right'] = '<div class="input-group-prepend">'.$form['input_group_addon'].'</div>';
        }

        if (!array_key_exists('input_group_label_left', $form)) {
            $form['input_group_label_left'] = $this->defaults($vars, 'input_group_label_left', false);
        }

        if (!array_key_exists('input_group_label_right', $form)) {
            $form['input_group_label_right'] = $this->defaults($vars, 'input_group_label_right', false);
        }

        if ($form['input_group_label_left']) {
            $form['input_group_label'] = true;
            $form['input_group_left'] = '<div class="input-group-prepend"><div class="input-group-text">'.$form['input_group_label_left'].'</div></div>';
        }

        if ($form['input_group_label_right']) {
            $form['input_group_label'] = true;
            $form['input_group_right'] = '<div class="input-group-append"><div class="input-group-text">'.$form['input_group_label_right'].'</div></div>';
        }

        return $form;
    }

    public function setContainerLabel($form, $vars)
    {
        $form['container_label'] = null;
        $form['label_required'] = null;
        $form['container_label_info'] = null;

        if (!array_key_exists('label_class', $form)) {
            $form['label_class'] = $this->defaults($vars, 'label_class', 'col-form-label');
        }

        if (!array_key_exists('label_col', $form)) {
            $form['label_col'] = $this->defaults($vars, 'label_col', 'col-md-3');
        }

        if (!array_key_exists('label_info', $form)) {
            $form['label_info'] = $this->defaults($vars, 'label_info', false);
        }

        if ($form['label_info']) {
            $form['container_label_info'] = '<br><small>'.$form['label_info'].'</small>';
        }

        if ($form['required']) {
            $form['label_required'] = '&nbsp;<sup class="text-danger" title="Obrigatório">(*)</sup>';
        }

        if ($form['label']) {
            $form['container_label'] = '<label class="'.$form['label_col'].' '.$form['label_class'].'" for="'.$form['id'].'">'.$form['label'].':'.$form['label_required'].$form['container_label_info'].'</label>';
        }

        return $form;
    }

    public function setContainerInput($form, $vars)
    {
        if (!array_key_exists('input_col', $form)) {
            $form['input_col'] = $this->defaults($vars, 'input_col', 'col-md-6');
        }

        if (!array_key_exists('action_group_disabled', $form)) {
            $form['action_group_disabled'] = $this->defaults($vars, 'action_group_disabled', false);
        }

        if (!array_key_exists('action_group_disabled_label', $form)) {
            $form['action_group_disabled_label'] = $this->defaults($vars, 'action_group_disabled_label', null);
        }

        if (!array_key_exists('action_group_disabled_checked', $form)) {
            $form['action_group_disabled_checked'] = $this->defaults($vars, 'action_group_disabled_checked', false);
        }

        if ($form['action_group_disabled_checked']) {
            $form['action_group_disabled_checked'] = ' checked';
        }

        return $form;
    }

    public function setContainerType($form, $vars)
    {
        if (!array_key_exists('form_inline', $form)) {
            $form['form_inline'] = $this->defaults($vars, 'form_inline', false);
        }

        if ($form['form_inline']) {
            $form['input_col'] = 'col-md-12';
            $form['label_col'] = 'col-md-12';
        }

        return $form;
    }

    public function setContainerDetails($form, $vars)
    {
        $form['attr_info'] = null;

        $form['container_details'] = null;
        $form['container_maxlength'] = null;
        $form['container_info'] = null;

        if (!array_key_exists('help_class', $form)) {
            $form['help_class'] = $this->defaults($vars, 'help_class', 'help-inline');
        }

        if (!array_key_exists('help_col', $form)) {
            $form['help_col'] = $this->defaults($vars, 'help_col', 'col-md-3');
        }

        if (!array_key_exists('info', $form)) {
            $form['info'] = $this->defaults($vars, 'info', null);
        }

        if ($form['info']) {
            $form['attr_info'] = $form['info'];
        }

        if ($form['cont_input'] && $form['maxlength']) {
            $form['container_maxlength'] = '
                <small><span class="middle" id="cont_'.$form['id'].'">[ Máx. '.$form['maxlength'].' caracteres ]</span></small>';
        }

        if ($form['attr_info']) {
            $form['container_info'] = '
                <small><em><span class="middle">'.$form['attr_info'].'</span></em></small>';

            if ($form['container_maxlength']) {
                $form['container_info'] = '<br>'.$form['container_info'];
            }
        }

        if ($form['container_maxlength'] || $form['container_info']) {
            $form['container_details'] = '
                <div class="'.$form['help_col'].' '.$form['help_class'].'">
                    '.$form['container_maxlength'].'
                    '.$form['container_info'].'
                </div>';
        }

        return $form;
    }

    public function preventDefaults($form, $vars)
    {
        if (array_key_exists('type', $vars) && ($vars['type'] == 'number')) {
            $form['input_col'] = 'col-md-4';

            $form['cont_input'] = false;
        }

        if ($form['disabled'] || $form['readonly']) {
            $form['required'] = false;
            $form['cont_input'] = false;
        }

        if (!$form['cont_input']) {
            $form['maxlength'] = null;
            $form['attr_maxlength'] = null;
            $form['container_maxlength'] = null;
        }

        return $form;
    }

    public function checkDefaults($form, $vars)
    {
        if (!array_key_exists('type', $form)) {
            $form['type'] = $this->defaults($vars, 'type', 'text');
        }

        if (!array_key_exists('clearfix', $form)) {
            $form['clearfix'] = $this->defaults($vars, 'clearfix', 'clearfix');
        }

        $form = $this->setRequired($form, $vars);
        $form = $this->setMaxlength($form, $vars);
        $form = $this->setPlaceholder($form, $vars);
        $form = $this->setReadonly($form, $vars);
        $form = $this->setDisabled($form, $vars);
        $form = $this->setAutocomplete($form, $vars);

        $form = $this->setMask($form, $vars);
        $form = $this->setContInput($form, $vars);
        $form = $this->setAttrClass($form, $vars);

        $form = $this->setInputGroup($form, $vars);

        $form = $this->preventDefaults($form, $vars);

        $form = $this->setContainerLabel($form, $vars);
        $form = $this->setContainerInput($form, $vars);

        $form = $this->setContainerType($form, $vars);
        $form = $this->setContainerDetails($form, $vars);

        $form['form_group'] = $this->defaults($vars, 'form_group', null);
        $form['formgroup_class'] = 'row form-group form-group-'.$form['id'].' '.$form['form_group'];

        $form['attrs'] = null;

        if (is_array($this->attrs)) {
            $form['attrs'] = implode(' ', $this->attrs);
        }

        $this->attr_class = null;

        return $form;
    }

    public function load($data, $output = 'component')
    {
        if ($output == 'html') {
            return $data;
        }
        else if ($output == 'force') {
            echo($data);
        }
        else if ($output == 'component') {
            return $data;
        }
    }

    public function cleanComponents($output = 'html')
    {
        if ($output == 'html') {
            $this->attrs = [];
            $this->attr_class = [];
        }
    }

    public function hidden($id, $value = null, $vars = [], $output = 'html')
    {
        $this->cleanComponents($output);

        $form['id'] = $this->defaults($vars, 'id', $id);
        $form['value'] = $this->defaults($vars, 'value', $value);

        $data = '<input type="hidden" id="'.$form['id'].'" name="'.$form['id'].'" value="'.$form['value'].'" />';

        return $this->load($data, $output);
    }

    public function input($id, $label = null, $value = null, $vars = [], $output = 'html')
    {
        $this->cleanComponents($output);

        $form['id'] = $this->defaults($vars, 'id', $id);
        $form['label'] = $this->defaults($vars, 'label', $label);
        $form['value'] = $this->defaults($vars, 'value', $value);

        $form = $this->checkDefaults($form, $vars);

        $data = '
            <div class="'.$form['formgroup_class'].'">
                '.$form['container_label'].'

                <div class="'.$form['input_col'].'"><div class="clearfix">';
                    if ($form['input_group_label']) {
                        $data .= '<div class="input-group">';
                            if (!$form['input_group_rtl'] || $form['input_group_label_left']) {
                                $data .= $form['input_group_left'];
                            }
                    }

                    $data .= '<input type="'.$form['type'].'" id="'.$form['id'].'" name="'.$form['id'].'" class="'.$form['attr_class'].'" value="'.$form['value'].'"'.$form['attrs'].' />';

                    if ($form['input_group_label']) {
                        if ($form['input_group_rtl'] || $form['input_group_label_right']) {
                            $data .= $form['input_group_right'];
                        }

                        $data .= '</div>';
                    }


                if ($form['action_group_disabled']) {
                    $data .= '
                    <label>
                        <input type="checkbox" name="'.$form['id'].'_action_disabled" id="'.$form['id'].'_action_disabled" class="ace action_input_disabled"'.$form['action_group_disabled_checked'].'>
                        <span class="lbl"> <small>'.$form['action_group_disabled_label'].'</small></span>
                    </label>';
                }

        $data .= '
                </div></div>

                '.$form['container_details'].'
            </div>';

        return $this->load($data, $output);
    }

    public function inputFile($id, $label = null, $value = null, $vars = [], $output = 'html')
    {
        $this->cleanComponents($output);

        $form['id'] = $this->defaults($vars, 'id', $id);
        $form['label'] = $this->defaults($vars, 'label', $label);
        $form['value'] = $this->defaults($vars, 'value', $value);

        $form = $this->checkDefaults($form, $vars);

        $data = '
            <div class="'.$form['formgroup_class'].'">
                '.$form['container_label'].'

                <div class="'.$form['input_col'].'">';
                    if ($form['input_group_label']) {
                        $data .= '<div class="input-group">';
                            if (!$form['input_group_rtl'] || $form['input_group_label_left']) {
                                $data .= $form['input_group_left'];
                            }
                    }
                    $data .= '<div class="custom-file">
                                <input type="'.$form['type'].'" id="'.$form['id'].'" name="'.$form['id'].'" class="custom-file-input" value="'.$form['value'].'"'.$form['attrs'].'>
                                <label class="custom-file-label" for="'.$form['id'].'" data-browse="SELECIONAR">Nenhum arquivo selecionado</label></div>';

                    if ($form['input_group_label']) {
                        if ($form['input_group_rtl'] || $form['input_group_label_right']) {
                            $data .= $form['input_group_right'];
                        }

                        $data .= '</div>';
                    }


                if ($form['action_group_disabled']) {
                    $data .= '
                    <label>
                        <input type="checkbox" name="'.$form['id'].'_action_disabled" id="'.$form['id'].'_action_disabled" class="ace action_input_disabled"'.$form['action_group_disabled_checked'].'>
                        <span class="lbl"> <small>'.$form['action_group_disabled_label'].'</small></span>
                    </label>';
                }

        $data .= '
                </div>

                '.$form['container_details'].'
            </div>';

        return $this->load($data, $output);
    }

    public function textarea($id, $label = null, $value = null, $vars = [], $output = 'html')
    {
        $this->cleanComponents($output);

        $form['id'] = $this->defaults($vars, 'id', $id);
        $form['label'] = $this->defaults($vars, 'label', $label);
        $form['value'] = $this->defaults($vars, 'value', $value);

        $form['class'] = $this->defaults($vars, 'class', 'summernote-full');
        $form['input_col'] = $this->defaults($vars, 'input_col', 'col-md-9');
        $form['cont_input'] = $this->defaults($vars, 'cont_input', false);

        $form = $this->checkDefaults($form, $vars);

        $data = '
            <div class="'.$form['formgroup_class'].'">
                '.$form['container_label'].'

                <div class="'.$form['input_col'].'">
                    <div class="'.$form['clearfix'].'">
                        <textarea id="'.$form['id'].'" name="'.$form['id'].'" class="'.$form['attr_class'].'"'.$form['attrs'].' cols="20">'.$form['value'].'</textarea>
                    </div>
                </div>

                '.$form['container_details'].'
            </div>';

        return $this->load($data, $output);
    }

    public function upload($id, $label = null, $value = null, $vars = [], $output = 'html')
    {
        $this->cleanComponents($output);

        $form['type'] = 'file';
        $form['only_view'] = $this->defaults($vars, 'only_view', false);
        $form['cont_input'] = $this->defaults($vars, 'cont_input', false);
        $form['required'] = $this->defaults($vars, 'required', true);
        $form['maxlength'] = $this->defaults($vars, 'maxlength', null);

        $form['clearfix'] = $this->defaults($vars, 'input_group_label', 'clearfix custom-file');

        $form['extension'] = $this->defaults($vars, 'extension', null);
        $form['imgx'] = $this->defaults($vars, 'imgx', null);
        $form['imgy'] = $this->defaults($vars, 'imgy', null);
        $form['width'] = $this->defaults($vars, 'width', null);
        $form['height'] = $this->defaults($vars, 'height', null);

        $form['info'] = $this->defaults($vars, 'info', null);

        $form['bg_content_image'] = $this->defaults($vars, 'bg_content_image', 'bg-light');

        if (isset($form['extension']) && isset($form['imgx']) && isset($form['imgy'])) {
            $form['info'] = '[ Extensão: '.$form['extension'].' ] - [ Formato: '.$form['imgx'].'x'.$form['imgy'].'px ]';
        }

        if (isset($form['extension']) && isset($form['width']) && isset($form['height'])) {
            $form['info'] = '[ Extensão: '.$form['extension'].' ] - [ Formato: '.$form['width'].'x'.$form['height'].'px ]';
        }

        $data = $this->inputFile($id, $label, null, $form, 'component');

        $view = null;

        if ($value) {
            $view = '
            <div class="form-row mb-4">
                <label class="col-form-label col-md-3">'.$label.':</label>
                <div class="col-md-4">
                    <div class="p-2 '.$form['bg_content_image'].' d-flex align-items-start justify-content-start flex-column">
                        '.$value.'
                    </div>
                </div>
            </div>';
        }

        if ($form['only_view']) {
            echo $view;
        }
        else {
            return $this->load($view.$data, $output);
        }
    }

    public function uploadCrop($id, $label = null, $value = null, $vars = [], $output = 'html')
    {
        $this->cleanComponents($output);

        $form['type'] = 'file';
        $form['only_view'] = $this->defaults($vars, 'only_view', false);
        $form['id'] = $this->defaults($vars, 'id', $id);
        $form['name'] = $this->defaults($vars, 'name', $id);
        $form['label'] = $this->defaults($vars, 'label', $label);
        $form['class'] = $this->defaults($vars, 'class', null);
        $form['required'] = $this->defaults($vars, 'required', false);
        $form['width'] = $this->defaults($vars, 'width', 400);
        $form['height'] = $this->defaults($vars, 'height', 400);
        $form['viewmode'] = $this->defaults($vars, 'viewmode', 1);
        $form['autocroparea'] = $this->defaults($vars, 'autocroparea', 1);
        $form['aspectratio'] = $this->defaults($vars, 'aspectratio', 1);
        $form['noimage'] = $this->defaults($vars, 'noimage', null);
        $form['rounded'] = $this->defaults($vars, 'rounded', false);
        $form['box'] = $this->defaults($vars, 'box', false);
        $form['modalDialog'] = $this->defaults($vars, 'modalDialog', 'modal-xl');
        $form['info'] = $this->defaults($vars, 'info', null);
        $form['areathumbnail'] = $this->defaults($vars, 'areathumbnail', false);
        $form['callbackExecute'] = $this->defaults($vars, 'callbackExecute', false);
        $form['callbackExecuteLabel'] = $this->defaults($vars, 'callbackExecuteLabel', null);

        $form['extension'] = $this->defaults($vars, 'extension', 'JPG/PNG');
        $form['limit'] = $this->defaults($vars, 'extension', '40MB');

        if (isset($form['extension']) && isset($form['width']) && isset($form['height'])) {
            $form['info'] = 'Clique na imagem para alterar<br>[ Extensão: '.$form['extension'].' ] - [ Formato: '.$form['width'].'x'.$form['height'].'px ]';
        }

        switch ($form['aspectratio']) {
            case '1':
                $form['aspectratioclass'] = 'cropper--area--1';
            break;

            case '4/3':
                $form['aspectratioclass'] = 'cropper--area--43';
            break;

            case '16/9':
                $form['aspectratioclass'] = 'cropper--area--169';
            break;
        }

        $form['roundedclass'] = '';

        if ($form['rounded']) {
            $form['roundedclass'] = 'cropper--area--rounded';
        }

        $form['areathumbnailclass'] = '';

        if ($form['areathumbnail']) {
            $form['areathumbnailclass'] = ' img-thumbnail';
        }

        $form['requiredclass'] = '';
        $form['labelView'] = $form['label'];

        if ($form['required']) {
            $form['requiredclass'] = ' required';
            $form['labelView'] = $form['label'].':<sup class="text-danger ml-2" title="Obrigatório">(*)</sup>';
        }

        $data = $this->inputFile($id, $label, null, $form, 'component');

        if (!isset($form['options']['image']['src']) && isset($value['smaller'])) {
            $form['options']['image']['src'] = $value['smaller'];
        }

        if (!isset($form['options']['image']['src']) && isset($value['larger'])) {
            $form['options']['image']['src'] = $value['larger'];
        }

        if (!isset($form['options']['image']['src']) && $form['noimage']) {
            $form['options']['image']['src'] = $form['noimage'];
        }

        if (!isset($form['options']['image']['src']) && !$form['noimage']) {
            //$form['options']['image']['src'] = 'https://via.placeholder.com/'.$form['width'].'x'.$form['height'];
            //$form['noimage'] = true;

            $form['options']['image']['src'] = assets_img('no-image.jpg', 'src');
            $form['noimage'] = true;
        }

        $data = '
        <div class="row form-group form-group-'.$form['id'].'">
            <label class="col-md-3 col-form-label" for="'.$form['id'].'">'.$form['labelView'].'</label>

            <div class="col-md-9">
                <div class="content-form-crop-box">
                    <div id="'.$form['id'].'--cropper--execute" class="content-form-crop-image" title="'.$form['label'].'" data-callbackexecute="" data-id="'.$form['id'].'" data-width="'.$form['width'].'" data-height="'.$form['height'].'" data-aspectratio="'.$form['aspectratio'].'" data-viewmode="'.$form['viewmode'].'" data-autocroparea="'.$form['autocroparea'].'">
                        <label for="'.$form['id'].'--cropper--input" class="'.$form['rounded'].'">
                            <div class="load-upload-crop">
                                <div class="content">
                                    <i class="fa fa-spinner fa-spin"></i>
                                    <p>Carregando...</p>
                                </div>
                            </div>

                            <span class="hover-icon"><i class="fas fa-edit" aria-hidden="true"></i></span>

                            <img id="'.$form['id'].'--cropper--active" class="'.$form['class'].$form['areathumbnailclass'].'" src="'.$form['options']['image']['src'].'" alt="'.$form['label'].'">
                        </label>

                        <input type="file" id="'.$form['id'].'--cropper--input" name="cropper--input" accept="image/*">
                        <input type="hidden" id="'.$form['id'].'" name="'.$form['id'].'"'.$form['requiredclass'].'>
                    </div>

                    <button id="'.$form['callbackExecute'].'" type="button" class="btn btn-sm btn-primary d-none">
                        <i class="fas fa-upload mr-1"></i>'.$form['callbackExecuteLabel'].'
                    </button>

                    <div id="'.$form['id'].'--cropper--label" class="content-form--label">
                        <p class="small font-italic text-muted mb-0">'.$form['info'].'</p>';
                        if (!isset($form['noimage'])) {
                            $data .= '
                            <div class="btn-group mt-4">
                                <a class="btn btn-sm btn-dark" href="'.$value['larger'].'" title="Visualizar" data-toggle="lightbox"><i class="fa fa-eye mr-2"></i>Visualizar</a>
                                <a class="btn btn-sm btn-dark" href="'.$value['download'].'" title="Download"><i class="fa fa-download mr-2"></i>Download</a>
                                <a class="btn btn-sm btn-dark" href="'.$value['remove'].'" title="Excluir"><i class="fa fa-trash mr-2"></i>Excluir</a>
                            </div>';
                        }
                    $data .= '
                    </div>
                </div>
            </div>
        </div>
        <div class="modal fade modal-crop" id="'.$form['id'].'--modal--cropper" tabindex="-1" role="dialog" aria-labelledby="'.$form['id'].'--modal--title" aria-hidden="true">
            <div class="modal-dialog '.$form['modalDialog'].'" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="'.$form['id'].'--modal--title">Recortar imagem</h5>

                        <button type="button" class="close" data-dismiss="modal" aria-label="Fechar">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>

                    <div class="modal-body">
                        <div class="img-container-crop">
                            <img id="'.$form['id'].'--cropper--zone" class="img-fluid">
                        </div>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger" data-dismiss="modal" title="Cancelar">
                            <i class="ml-0 mr-1 fa fa-times"></i><span>Cancelar</span>
                        </button>

                        <button type="button" class="btn btn-primary" id="'.$form['id'].'--execute--crop" title="Recortar">
                            <i class="ml-0 mr-1 fa fa-crop"></i><span>Recortar</span>
                        </button>
                    </div>
                </div>
            </div>
        </div>
        ';

        $view = null;

        if ($value) {
            $view = '';
        }

        if ($form['only_view']) {
            echo $view;
        }
        else {
            return $this->load($view.$data, $output);
        }
    }


    public function video($id, $label = null, $value = null, $vars = [], $output = 'html')
    {
        $this->cleanComponents($output);

        $form['id'] = $this->defaults($vars, 'id', $id);
        $form['label'] = $this->defaults($vars, 'label', $label);
        $form['value'] = null;

        $form['input_group_label'] = $this->defaults($vars, 'input_group_label', '<i class="fas fa-video"></i>');
        $form['cont_input'] = $this->defaults($vars, 'cont_input', false);

        $form = $this->checkDefaults($form, $vars);

        $form['info'] = $this->defaults($vars, 'info', '[ youtube/video]');

        $data = $this->input($id, $label, $value, $form, 'component');

        $view = null;

        if ($value) {
            $view .= '
            <div class="form-row mb-3">
                <label class="col-form-label col-md-3">'.$label.':</label>
                <div class="col-md-4">
                    <div class="'.$form['clearfix'].'">
                        '.$value.'
                    </div>
                </div>
            </div>';
        }

        return $this->load($view.$data, $output);
    }

    public function date($id, $label = null, $value = null, $vars = [], $output = 'html')
    {
        $this->cleanComponents($output);

        $vars['input_col'] = $this->defaults($vars, 'input_col', 'col-md-4');
        $vars['input_group_label'] = $this->defaults($vars, 'input_group_label', '<i class="fa fa-calendar"></i>');

        $vars['input_class'] = $this->defaults($vars, 'input_class', 'form-control input-mask-date');
        $vars['mask'] = $this->defaults($vars, 'mask', 'date-picker-unique');

        $vars['cont_input'] = $this->defaults($vars, 'cont_input', false);

        $data = $this->input($id, $label, $value, $vars, 'component');

        return $this->load($data, $output);
    }

    public function hour($id, $label = null, $value = null, $vars = [], $output = 'html')
    {
        $this->cleanComponents($output);

        $form['id'] = $this->defaults($vars, 'id', $id);
        $form['label'] = $this->defaults($vars, 'label', $label);
        $form['value'] = $this->defaults($vars, 'value', $value);

        $form['input_col'] = $this->defaults($vars, 'input_col', 'col-md-4');
        $form['input_group_label'] = $this->defaults($vars, 'input_group_label', '<i class="far fa-clock"></i>');
        $form['mask'] = $this->defaults($vars, 'mask', 'input-mask-hour');

        $form['cont_input'] = $this->defaults($vars, 'cont_input', false);

        $form = $this->checkDefaults($form, $vars);

        $data = $this->input($id, $label, $value, $form, 'component');

        return $this->load($data, $output);
    }

    public function money($id, $label = null, $value = null, $vars = [], $output = 'html')
    {
        $this->cleanComponents($output);

        $form['id'] = $this->defaults($vars, 'id', $id);
        $form['label'] = $this->defaults($vars, 'label', $label);
        $form['value'] = $this->defaults($vars, 'value', $value);

        $form['input_col'] = $this->defaults($vars, 'input_col', 'col-md-4');
        $form['input_group_label'] = $this->defaults($vars, 'input_group_label', 'R$');
        $form['mask'] = $this->defaults($vars, 'mask', 'input-mask-money');

        $form['cont_input'] = $this->defaults($vars, 'cont_input', false);

        $form = $this->checkDefaults($form, $vars);

        $data = $this->input($id, $label, $value, $form, 'component');

        return $this->load($data, $output);
    }

    public function phone($id, $label = null, $value = null, $vars = [], $output = 'html')
    {
        $this->cleanComponents($output);

        $vars['input_col'] = $this->defaults($vars, 'input_col', 'col-md-4');
        $vars['input_group_label'] = $this->defaults($vars, 'input_group_label', '<i class="fas fa-phone-alt"></i>');
        $vars['mask'] = $this->defaults($vars, 'mask', 'input-mask-phone');

        $vars['cont_input'] = $this->defaults($vars, 'cont_input', false);
        $vars['type'] = $this->defaults($vars, 'type', 'tel');

        $data = $this->input($id, $label, $value, $vars, 'component');

        return $this->load($data, $output);
    }

    public function password($id, $label = null, $value = null, $vars = [], $output = 'html')
    {
        $this->cleanComponents($output);

        $vars['input_group_rtl'] = $this->defaults($vars, 'input_group_rtl', true);
        $vars['input_group_label'] = $this->defaults($vars, 'input_group_label', '<a href="" type="button" class="show_password_view" title="Mostrar senha"><i class="fa fa-eye-slash" aria-hidden="true"></i></a>');
        $vars['cont_input'] = $this->defaults($vars, 'cont_input', false);
        $vars['type'] = $this->defaults($vars, 'type', 'password');

        $data = $this->input($id, $label, $value, $vars, 'component');

        return $this->load($data, $output);
    }

    public function email($id, $label = null, $value = null, $vars = [], $output = 'html')
    {
        $this->cleanComponents($output);

        $form['id'] = $this->defaults($vars, 'id', $id);
        $form['label'] = $this->defaults($vars, 'label', $label);
        $form['value'] = $this->defaults($vars, 'value', $value);

        $form['input_group_label'] = $this->defaults($vars, 'input_group_label', '<i class="far fa-envelope"></i>');
        $form['cont_input'] = $this->defaults($vars, 'cont_input', false);
        $form['input_col'] = $this->defaults($vars, 'input_col', 'col-md-4');
        $form['type'] = $this->defaults($vars, 'type', 'email');

        $form = $this->checkDefaults($form, $vars);

        $data = $this->input($id, $label, $value, $form, 'component');

        return $this->load($data, $output);
    }

    public function select($id, $label = null, $options = null, $vars = [], $output = 'html')
    {
        $this->cleanComponents($output);

        $form['id'] = $this->defaults($vars, 'id', $id);
        $form['label'] = $this->defaults($vars, 'label', $label);

        $form['class'] = $this->defaults($vars, 'input_class', 'form-control select2');

        $form['input_col'] = $this->defaults($vars, 'input_col', 'col-md-4');
        $form['primary_item'] = $this->defaults($vars, 'primary_item', false);
        $form['all_item'] = $this->defaults($vars, 'all_item', false);
        $form['cont_input'] = $this->defaults($vars, 'cont_input', false);
        $form['multiple'] = $this->defaults($vars, 'multiple', false);

        $attrClassMultiple = $attrClassMultipleAttr = $attrPlaceholderMultiple = null;

        if ($form['multiple']) {
            $attrClassMultiple = '[]';
            $attrClassMultipleAttr = ' multiple';

            $form['placeholder'] = $this->defaults($vars, 'placeholder', false);

            if ($form['placeholder']) {
                $attrPlaceholderMultiple = ' data-placeholder="'.$form['placeholder'].'"';
            }

            $form['input_col'] = 'col-md-6';
            $form['class'] = 'form-control select2-multiple';
        }

        $form = $this->checkDefaults($form, $vars);

        if (is_array($options)) {
            $newOptions = null;

            foreach ($options as $key => $value) {
                $selected = null;

                if ($value['selected']) {
                    $selected = ' selected';
                }

                $newOptions .= '<option value="'.$value['value'].'"'.$selected.'>'.$value['title'].'</option>';
            }

            $options = $newOptions;
        }

        $data = '
            <div class="'.$form['formgroup_class'].'">
                '.$form['container_label'].'

                <div class="'.$form['input_col'].'">
                    <div class="'.$form['clearfix'].'">
                        <select id="'.$form['id'].'" name="'.$form['id'].$attrClassMultiple.'" class="'.$form['attr_class'].'"'.$form['attrs'].$attrClassMultipleAttr.$attrPlaceholderMultiple.'>';
                        if ($form['primary_item']) {
                            $data .= '<option value="" selected disabled>'.$form['primary_item'].'</option>';
                        }

                        if ($form['all_item']) {
                            $data .= '<option value="" selected>'.$form['all_item'].'</option>';
                        }

                        $data .= $options.'
                        </select>
                    </div>
                </div>

                '.$form['container_details'].'
            </div>';

        return $this->load($data, $output);
    }

    public function checkbox($id, $label = null, $value = null, $options = null, $vars = [], $output = 'html')
    {
        $this->cleanComponents($output);

        $form['id'] = $this->defaults($vars, 'id', $id);
        $form['label'] = $this->defaults($vars, 'label', $label);

        $form['input_class'] = $this->defaults($vars, 'input_class', 'checkbox-inline');

        $form = $this->checkDefaults($form, $vars);

        $data = '
            <div class="'.$form['formgroup_class'].'">
                '.$form['container_label'].'

                <div class="'.$form['input_col'].'">
                    <div class="'.$form['clearfix'].'">';
                    foreach ($options as $keyOptions => $valueOptions) {
                        $checked = null;

                        if ($keyOptions == $value) {
                            $checked = ' checked';
                        }

                        $data .= '
                            <div class="'.$form['input_class'].'">
                                <label>
                                    <input id="'.$form['id'].'_'.$keyOptions.'" name="'.$form['id'].'" type="checkbox" class="ace" value="'.$keyOptions.'"'.$form['attrs'].$checked.' />
                                    <span class="lbl"> '.$valueOptions.'</span>
                                </label>
                            </div>';
                    }

        $data .= '
                    </div>
                </div>
            </div>';

        return $this->load($data, $output);
    }

    public function radio($id, $label = null, $value = null, $options = null, $vars = [], $output = 'html')
    {
        $this->cleanComponents($output);

        $form['id'] = $this->defaults($vars, 'id', $id);
        $form['label'] = $this->defaults($vars, 'label', $label);

        $form['input_class'] = $this->defaults($vars, 'input_class', 'icheck-primary icheck-inline');
        $form['only_text'] = $this->defaults($vars, 'only_text', false);

        $form = $this->checkDefaults($form, $vars);

        $data = '
            <div class="'.$form['formgroup_class'].'">
                '.$form['container_label'].'

                <div class="col-form-input '.$form['input_col'].'">
                    <div class="'.$form['clearfix'].'">';
                    foreach ($options as $keyOptions => $valueOptions) {
                        $checked = null;

                        if ($keyOptions == $value) {
                            $checked = ' checked';
                        }

                        $data .= '
                            <div class="'.$form['input_class'].'">
                                <input id="'.$form['id'].'_'.$keyOptions.'" name="'.$form['id'].'" type="radio" value="'.$keyOptions.'"'.$form['attrs'].$checked.' />
                                <label for="'.$form['id'].'_'.$keyOptions.'">'.$valueOptions.'</label>
                            </div>';
                    }

        $data .= '
                    </div>
                </div>
            </div>';

        if ($form['only_text']) {
            $data = '
                <div class="'.$form['formgroup_class'].'">
                    '.$form['container_label'].'

                    <div class="'.$form['input_col'].'">
                        <h4>'.$options[$value].'</h4>';
            $data .= '
                </div>
            </div>';

            echo $data;
        }
        else {
            return $this->load($data, $output);
        }
    }

    public function radioBoolean($id, $label = null, $value = null, $options = null, $vars = [], $output = 'html')
    {
        $this->cleanComponents($output);

        $form['id'] = $this->defaults($vars, 'id', $id);
        $form['label'] = $this->defaults($vars, 'label', $label);

        $form['input_class'] = $this->defaults($vars, 'input_class', 'radio-inline');
        $form['only_text'] = $this->defaults($vars, 'only_text', false);

        $form = $this->checkDefaults($form, $vars);

        $data = '
            <div class="'.$form['formgroup_class'].'">
                '.$form['container_label'].'

                <div class="'.$form['input_col'].'">
                    <div class="'.$form['clearfix'].'">';
                    $checked = null;

                    if ($value == 1) {
                        $checked = ' checked';
                    }

                    $data .= '<input type="checkbox" id="'.$form['id'].'" name="'.$form['id'].'" '.$checked.' data-bootstrap-switch data-off-color="danger" data-off-color="danger" data-on-text="'.$options[1].'" data-off-text="'.$options[2].'" data-on-color="success"'.$form['attrs'].$checked.'>';

        $data .= '
                    </div>
                </div>
            </div>';

        if ($form['only_text']) {
            $data = '
                <div class="'.$form['formgroup_class'].'">
                    '.$form['container_label'].'

                    <div class="'.$form['input_col'].'">
                        <h4>'.$options[$value].'</h4>';
            $data .= '
                </div>
            </div>';

            echo $data;
        }
        else {
            return $this->load($data, $output);
        }
    }


    public function table_multiple($id, $label = null, $value = [], $options = null, $vars = [], $output = 'html')
    {
        $this->cleanComponents($output);

        $form['id'] = $this->defaults($vars, 'id', $id);
        $form['label'] = $this->defaults($vars, 'label', $label);

        $form['input_col'] = $this->defaults($vars, 'input_col', 'col-md-6');
        $form['required'] = $this->defaults($vars, 'required', false);

        $form = $this->checkDefaults($form, $vars);

        if (!is_array($value)) {
            if (@unserialize($value)) {
                $value = unserialize($value);
            }
            else if (@json_decode($value)) {
                $value = json_decode($value, true);
            }
        }

        $data = '
            <div class="'.$form['formgroup_class'].'">
                '.$form['container_label'].'
                <div class="'.$form['input_col'].'">
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered table-hover table-doop">
                            <thead>
                                <tr>
                                    <th colspan="3">
                                        <a href="#'.$form['id'].'" data-command="'.$form['id'].'" onclick="$.addLine(this);">
                                            <i class="fa fa-plus"></i> '.$options['parameters']['add'].'
                                        </a>
                                    </th>
                                </tr>
                            </thead>

                            <thead>
                                <tr>';
                                foreach ($options['itens'] as $keyOptions => $valueOptions) {
                                    $data .= '<th width="'.$valueOptions['width'].'"><b>'.$valueOptions['label'].'</b></th>';
                                }

        $data .= '
                                    <th width="5%" class="text-center" title="ações">#</th>
                                </tr>
                            </thead>

                            <tbody id="'.$form['id'].'">
                                <tr id="line_1" class="d-none">';
                                    foreach ($options['itens'] as $keyOptions => $valueOptions) {
                                        if (!array_key_exists('class', $valueOptions)) {
                                            $valueOptions['class'] = 'form-control';
                                        }

                                        $data .= '
                                        <td>
                                            <div class="'.$form['clearfix'].'">
                                                <input type="'.$valueOptions['type'].'" name="'.$keyOptions.'[]" class="'.$valueOptions['class'].'" maxlength="'.$valueOptions['maxlength'].'" />
                                            </div>
                                        </td>';
                                    }

                                    $data .= '
                                    <td class="text-center">
                                        <a href="#'.$form['id'].'" data-command="'.$form['id'].'" title="'.$options['parameters']['delete'].'" onclick="$.removeLine(this);">
                                            <i class="fa fa-trash icon-only bigger-130"></i>
                                        </a>
                                    </td>
                                </tr>';

                            if (is_array($value)) {
                                $line = 2;

                                $optionsView = $newOptions = null;

                                foreach ($options['itens'] as $keyOptions => $valueOptions) {
                                    if (array_key_exists($keyOptions, $value) && $value[$keyOptions]) {
                                        $optionsView[$keyOptions] = $value[$keyOptions];
                                    }
                                }

                                if (is_array($optionsView)) {
                                    foreach ($optionsView as $keyOptions => $valueOptions) {
                                        foreach ($valueOptions as $keyOptionsValue => $valueValue) {
                                            $newOptions[$keyOptionsValue][$keyOptions] =$valueValue;
                                        }
                                    }

                                    foreach ($newOptions as $keyOptionsView => $valueOptionsView) {
                                        $data .= '<tr id="line_'.$line.'">';

                                        foreach ($options['itens'] as $keyOptions => $valueOptions) {
                                            $data .= '
                                                <td>
                                                    <div class="'.$form['clearfix'].'">
                                                        <input type="'.$valueOptions['type'].'" name="'.$keyOptions.'[]" class="form-control" maxlength="'.$valueOptions['maxlength'].'" value="'.$this->controller->processString($valueOptionsView[$keyOptions]).'" />
                                                    </div>
                                                </td>';
                                        }

                                        $data .= '
                                            <td class="text-center">
                                                <a href="#'.$form['id'].'" data-command="'.$form['id'].'" title="'.$options['parameters']['delete'].'" onclick="$.removeLine(this);">
                                                    <i class="fa fa-trash icon-only bigger-130"></i>
                                                </a>
                                            </td>
                                        </tr>';

                                        $line++;
                                    }
                                }
                            }
                            $data .= '
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>';

        return $this->load($data, $output);
    }

    public function separate($class = null, $output = 'html')
    {
        $this->cleanComponents($output);

        $data = '<hr class="'.$class.'">';

        return $this->load($data, $output);
    }

    public function info($title, $label = null, $output = 'html')
    {
        $this->cleanComponents($output);

        $data = '<div class="card card-body bg-light">';

        if ($label) {
            $data .= '
            <h3>'.$title.'</h3>
            <p class="mb-0">'.$label.'</p>';
        }
        else {
            $data .= '
            <p class="mb-0">'.$title.'</p>';
        }

        $data .= '</div>';

        return $this->load($data, $output);
    }
}
