<?php
// doopSites v1.9.7 - Última atualização 22/02/2023 16:20

require_once(config('app.ROOT_CMS_HELPERS').'/forms-class-automatic.php');

$listStatus = [
    1 => 'Ativado',
    2 => 'Desabilitado'
];

$inputs[] = ['privilege' => 'developer', 'type' => 'separator', 'value' => 'Configurações do Desenvolvedor', 'label' => 'Atenção ao editar essas informações, elas aplicam direto no código do desenvolvedor.'];
$inputs[] = ['privilege' => 'developer', 'type' => 'input', 'key' => 'scope', 'value' => 'key', 'title' => 'Chave de acesso - Arquivo:', 'maxlength' => 100];
$inputs[] = ['privilege' => 'developer', 'type' => 'divider'];
$inputs[] = ['privilege' => 'developer', 'type' => 'input', 'key' => 'scope', 'value' => 'key_view', 'title' => 'Chave de acesso - Visualização:', 'maxlength' => 100];
$inputs[] = ['privilege' => 'developer', 'type' => 'divider'];
$inputs[] = ['privilege' => 'developer', 'type' => 'input', 'key' => 'scope', 'value' => 'class', 'title' => 'Nome da Classe:', 'maxlength' => 100];
$inputs[] = ['privilege' => 'developer', 'type' => 'divider'];
$inputs[] = ['privilege' => 'developer', 'type' => 'radio', 'key' => 'scope', 'value' => 'status_infoIndex', 'title' => 'Exibir informação de Página Inicial:', 'list' => $listStatus];
$inputs[] = ['privilege' => 'developer', 'type' => 'radio', 'key' => 'scope', 'value' => 'status_infoArchive', 'title' => 'Exibir informação de Arquivo e Visualização:', 'list' => $listStatus];
$inputs[] = ['privilege' => 'god', 'type' => 'separator', 'value' => 'Metatags (SEO)', 'label' => 'Personalize as metatags da página. Esses campos influênciam diretamente na sua posição nas pesquisas do Google.'];
$inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'scope', 'value' => 'title_seo', 'title' => 'Metatag - Título:', 'maxlength' => 100, 'info' => 'Google exibe apenas 63 caracteres incluíndo espaços'];
$inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'scope', 'value' => 'description_seo', 'title' => 'Metatag - Descrição:', 'maxlength' => 250, 'info' => 'Google exibe apenas 160 caracteres incluíndo espaços'];
$inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'scope', 'value' => 'keywords_seo', 'title' => 'Metatag - Palavras-Chave:', 'maxlength' => 200, 'info' => 'Insira as palavras separadas por vírgula'];
$inputs[] = ['privilege' => 'god', 'type' => 'separator', 'value' => 'Arquivo e Visualização', 'label' => 'Informações referentes as páginas de arquivo e visualização do módulo'];
$inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'scope', 'value' => 'title', 'title' => 'Título:', 'maxlength' => 100];
$inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'scope', 'value' => 'noneitens', 'title' => 'Aviso - Nenhum item encontrado:', 'maxlength' => 100];
$inputs[] = ['privilege' => 'god', 'type' => 'separator', 'value' => 'Página Inicial', 'label' => 'Informações referentes a página principal'];
$inputs[] = ['privilege' => 'developer', 'type' => 'radio', 'key' => 'scope', 'value' => 'status_indexHat', 'title' => 'Exibir campo chapéu:', 'list' => $listStatus];
$inputs[] = ['privilege' => 'developer', 'type' => 'radio', 'key' => 'scope', 'value' => 'status_indexSubtitle', 'title' => 'Exibir campo subtítulo:', 'list' => $listStatus];
$inputs[] = ['privilege' => 'developer', 'type' => 'radio', 'key' => 'scope', 'value' => 'status_indexText', 'title' => 'Exibir campo descrição:', 'list' => $listStatus];
$inputs[] = ['privilege' => 'developer', 'type' => 'radio', 'key' => 'scope', 'value' => 'status_indexReadmore', 'title' => 'Exibir o botão leia mais:', 'list' => $listStatus];
$inputs[] = ['privilege' => 'developer', 'type' => 'divider'];
$inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'scope', 'value' => 'index_hat', 'title' => 'Chapéu:', 'maxlength' => 100];
$inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'scope', 'value' => 'index_title', 'title' => 'Título:', 'maxlength' => 100];
$inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'scope', 'value' => 'index_subtitle', 'title' => 'Subtítulo:', 'maxlength' => 300];
$inputs[] = ['privilege' => 'god', 'type' => 'html', 'key' => 'scope', 'value' => 'index_text', 'title' => 'Descrição:', 'class' => 'summernote-mini'];
$inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'scope', 'value' => 'index_readmore', 'title' => 'Botão - Leia mais:', 'maxlength' => 100];

$extraFile = config('app.ROOT_CMS').'/app/module/'.$controller->get('module').'/manipule.php';

if (file_exists($extraFile)) {
    $extraFile = include($extraFile);

    if (array_key_exists('remove', $extraFile) && is_array($extraFile['remove'])) {
        foreach ($extraFile['remove'] as $keyRemove => $valueRemove) {
            foreach ($inputs as $keyInputs => $valueInputs) {
                if (array_key_exists('key', $valueInputs)) {
                    if ($valueInputs['key'] == $valueRemove['key'] && $valueInputs['value'] == $valueRemove['value']) {
                        unset($inputs[$keyInputs]);
                    }
                }
            }
        }
    }

    if (array_key_exists('add', $extraFile) && is_array($extraFile['add'])) {
        foreach ($extraFile['add'] as $keyAdd => $valueAdd) {
            $inputs[] = $valueAdd;
        }
    }
}

$inputs[] = ['privilege' => 'developer', 'type' => 'separator', 'value' => 'Módulo Complementares'];

$inputs[] = ['privilege' => 'developer', 'type' => 'input', 'key' => 'additional', 'value' => 'gallery-photo', 'title' => 'Galeria de Fotos:', 'maxlength' => 25, 'valueDefault' => 'Fotos'];
$inputs[] = ['privilege' => 'developer', 'type' => 'input', 'key' => 'additional', 'value' => 'gallery-video', 'title' => 'Galeria de Vídeos:', 'maxlength' => 25, 'valueDefault' => 'Vídeos'];
$inputs[] = ['privilege' => 'developer', 'type' => 'input', 'key' => 'additional', 'value' => 'gallery-anexx', 'title' => 'Galeria de Anexos:', 'maxlength' => 25, 'valueDefault' => 'Anexos'];
$inputs[] = ['privilege' => 'developer', 'type' => 'input', 'key' => 'additional', 'value' => 'gallery-audio', 'title' => 'Galeria de Áudios:', 'maxlength' => 25, 'valueDefault' => 'Áudios'];

$module = new FormsClassAutomatic($_GET['module'], 'modulesInfo', 'automaticUniqueForms', $inputs);

$title = 'Dados do Módulo';
$noneitens = 'Nenhum dado do módulo encontrado.';
$table = 'modulesInfo-'.$_GET['module'];

$moduleInfo = $module->modules->modulesSystem[$_GET['module']];

$page['htmlHeader'] = '<h1><a href="" title="'.$title.'">'.$title.'</a></h1>';

if ($module->dataAutomatic) {
    foreach ($module->dataAutomatic as $key => $value) {
        if (array_key_exists('status_infoIndex', $value)) {
            if ($value['status_infoIndex'] == 2) {
                unset($module->dataAutomaticInputs[16]);
                unset($module->dataAutomaticInputs[17]);
                unset($module->dataAutomaticInputs[18]);
                unset($module->dataAutomaticInputs[19]);
                unset($module->dataAutomaticInputs[20]);
                unset($module->dataAutomaticInputs[21]);
                unset($module->dataAutomaticInputs[22]);
                unset($module->dataAutomaticInputs[23]);
                unset($module->dataAutomaticInputs[24]);
                unset($module->dataAutomaticInputs[25]);
                unset($module->dataAutomaticInputs[26]);
            }
        }

        if (array_key_exists('status_infoArchive', $value)) {
            if ($value['status_infoArchive'] == 2) {
                unset($module->dataAutomaticInputs[9]);
                unset($module->dataAutomaticInputs[10]);
                unset($module->dataAutomaticInputs[11]);
                unset($module->dataAutomaticInputs[12]);
                unset($module->dataAutomaticInputs[13]);
                unset($module->dataAutomaticInputs[14]);
                unset($module->dataAutomaticInputs[15]);

                unset($module->dataAutomaticInputs[27]);
                unset($module->dataAutomaticInputs[28]);
                unset($module->dataAutomaticInputs[29]);
                unset($module->dataAutomaticInputs[30]);
                unset($module->dataAutomaticInputs[31]);
            }
        }

        if (array_key_exists('status_indexHat', $value)) {
            if ($value['status_indexHat'] == 2) {
                unset($module->dataAutomaticInputs[22]);
            }
        }

        if (array_key_exists('status_indexSubtitle', $value)) {
            if ($value['status_indexSubtitle'] == 2) {
                unset($module->dataAutomaticInputs[24]);
            }
        }

        if (array_key_exists('status_indexText', $value)) {
            if ($value['status_indexText'] == 2) {
                unset($module->dataAutomaticInputs[25]);
            }
        }

        if (array_key_exists('status_indexReadmore', $value)) {
            if ($value['status_indexReadmore'] == 2) {
                unset($module->dataAutomaticInputs[26]);
            }
        }
    }
}

$formsAutomaticHtml = include(config('app.ROOT_CMS_HELPERS').'/forms-automatic.php');

$page['htmlPage'] = '<section class="content"><div class="container-fluid"><div class="card card-primary card-outline"><div class="card-body">'.$formsAutomaticHtml.'</div></div></div></section>';

return $page;
