<?php
// doopSites v1.9.7 - Última atualização 22/02/2023 16:20

class ToolsImagesDoop
{
    public $tools;

    public function __construct($tools)
    {
        $this->tools = $tools;

        unset($tools);
    }

    public function convertWebpFeature($key = null, $path = null)
    {
        $tools = $this->tools;
        $controller = $this->tools->controller();

        $types = ['png', 'jpg', 'jpeg', 'gif'];

        if (is_null($key)) {
            $key = $controller->getSufix();
        }

        if (is_null($path)) {
            if (is_dir(config('app.ROOT_UPLOAD').'/'.$key)) {
                $path = config('app.ROOT_UPLOAD').'/'.$key;
            }

            if (is_dir($path.'/images')) {
                $path = $path.'/images';
            }
        }

        $dirModule = $path;

        $folders = ['default', 'thumb', 'larger', 'smaller'];

        if (isset($dirModule) && file_exists($dirModule)) {
            foreach ($folders as $keyFolder) {
                $path = $dirModule.'/'.$keyFolder;

                if (file_exists($path)) {
                    $dir = new \DirectoryIterator($path);

                    foreach ($dir as $fileInfo) {
                        $ext = strtolower(pathinfo($fileInfo->getFilename(), PATHINFO_EXTENSION));

                        if (in_array($ext, $types)) {
                            $this->convertWebp($dirModule, $fileInfo->getPathName(), $fileInfo->getFilename(), false);
                        }
                    }
                }
            }
        }
    }

    public function convertWebp($dirModule, $originalPath, $originalFileName, $remove = false)
    {
        $ext = strtolower(pathinfo($originalFileName, PATHINFO_EXTENSION));

        $dirPaths = str_replace($originalFileName, '', $originalPath);
        $filename = str_replace('.'.$ext, '', $originalFileName);

        $imgWebp = $dirPaths.$filename.'.webp';

        if (file_exists($originalPath) && $ext != 'webp') {
            if (file_exists($imgWebp)) {
                unlink($imgWebp);
            }

            $options = [
                'png' => [
                    'encoding' => 'auto',
                    'near-lossless' => 60,
                    'quality' => 85,
                    'converters' => ['gd']
                ],
                'jpeg' => [
                    'encoding' => 'auto',
                    'quality' => 'auto',
                    'max-quality' => 80,
                    'default-quality' => 75,
                    'converters' => ['gd']
                ]
            ];

            switch ($ext) {
                case 'jpg':
                    if ($gdImageInstance = imagecreatefromjpeg($originalPath)) {
                        if (@imagewebp($gdImageInstance, $imgWebp, 75)) {
                            $conversionSuccess = imagewebp($gdImageInstance, $imgWebp, 75);
                        }

                    }
                break;

                case 'gif':
                    if ($gdImageInstance = imagecreatefromgif($originalPath)) {
                        if (@imagewebp($gdImageInstance, $imgWebp)) {
                            $conversionSuccess = @imagewebp($gdImageInstance, $imgWebp, 70);
                        }
                    }
                break;

                case 'png':
                    if ($gdImageInstance = imagecreatefrompng($originalPath)) {
                        if (@imagewebp($gdImageInstance, $imgWebp, 85)) {
                            $conversionSuccess = imagewebp($gdImageInstance, $imgWebp, 85);
                        }
                    }
                break;
            }

            if ($remove) {
                unlink($originalPath);
            }
        }
    }

    public function restoreWebpFeature($key = null, $table = null, $path = null, $queryExternal = null, $tupleCheck = ['file', 'cover', 'logotipo', 'image', 'images'])
    {
        $tools = $this->tools;
        $controller = $this->tools->controller();

        $types = ['webp'];
        $typesFix = ['jpg', 'png', 'gif'];

        if (is_null($key)) {
            $key = $controller->getSufix();
        }

        if (is_null($table)) {
            $table = $controller->getTable();
        }

        if (is_null($path)) {
            if (is_dir(config('app.ROOT_UPLOAD').'/'.$key)) {
                $path = config('app.ROOT_UPLOAD').'/'.$key;
            }

            if (is_dir($path.'/images')) {
                $path = $path.'/images';
            }
        }

        if ($path) {
            if (is_null($queryExternal)) {
                $queryExternal = $tools->prepareQueryExternal($key, $table, $tupleCheck);
            }

            $folders_module['default'] = $path.'/default';
            $folders_module['thumb'] = $path.'/thumb';

            $filesRoot = $this->selectAllFilesOnDatabase($path, $folders_module, $types, $queryExternal);

            $this->restoreWebpFilesProcess($path, $filesRoot, false, $typesFix);

            $folders_submodule['larger'] = $path.'/larger';
            $folders_submodule['smaller'] = $path.'/smaller';

            $queryExternal = null;

            $queryExternal[] = "SELECT `id_photo` as id, `file_photo` as parameter FROM `sub_photo` WHERE `file_photo` LIKE '%---fileNameSearch---%' AND `table_photo` = '".$table."'";

            $filesRoot = $this->selectAllFilesOnDatabase($path, $folders_submodule, $types, $queryExternal);

            $this->restoreWebpFilesProcess($path, $filesRoot, false, $typesFix);
        }
    }

    public function restoreWebp($dirModule, $originalPath, $folderPath, $originalFileName, $originalExtension)
    {
        $folderPath = $folderPath.'/';

        $fileTemp = $dirModule.'/'.$folderPath.$originalFileName.'.'.$originalExtension;

        if (!file_exists($fileTemp) && $originalExtension != 'webp') {
            $options = [];

            switch ($originalExtension) {
                case 'jpg':
                    $createJpg = imagecreatefromwebp($originalPath);

                    imagejpeg($createJpg, $fileTemp, 70);
                break;

                case 'gif':
                    $createGif = imagecreatefromwebp($originalPath);

                    imagegif($createGif, $fileTemp, 70);
                break;

                case 'png':
                    $createPng = imagecreatefromwebp($originalPath);

                    imagepng($createPng, $fileTemp, 70);
                break;
            }
        }
    }

    public function deleteWebpFeature($key = null, $table = null, $path = null)
    {
        $tools = $this->tools;
        $controller = $this->tools->controller();

        $types = ['webp'];

        if (is_null($key)) {
            $key = $controller->getSufix();
        }

        if (is_null($table)) {
            $table = $controller->getTable();
        }

        if (is_null($path)) {
            if (is_dir(config('app.ROOT_UPLOAD').'/'.$key)) {
                $path = config('app.ROOT_UPLOAD').'/'.$key;
            }

            if (is_dir($path.'/images')) {
                $path = $path.'/images';
            }
        }

        if ($path) {
            $folders_module['original'] = $path.'/default';
            $folders_module['thumb'] = $path.'/thumb';
            $folders_module['larger'] = $path.'/larger';
            $folders_module['smaller'] = $path.'/smaller';

            $this->deleteAllFilesOnFolders($path, $folders_module, $types);
        }
    }

    public function deleteAllFilesOnFolders($pathFolder, $folders, $typesAllowed)
    {
        $tools = $this->tools;
        $controller = $this->tools->controller();

        $filesRoot = null;

        if (is_null($folders)) {
            $folders[] = $pathFolder;
        }

        foreach ($folders as $keyPath => $path) {
            if (file_exists($path)) {
                $dir = new \DirectoryIterator($path);

                foreach ($dir as $fileInfo) {
                    $ext = strtolower(pathinfo($fileInfo->getFilename(), PATHINFO_EXTENSION));

                    if (in_array($ext, $typesAllowed)) {
                        $filename = $fileInfo->getFilename();

                        if (file_exists($path.'/'.$filename)) {
                            unlink($path.'/'.$filename);
                        }
                    }
                }
            }
        }
    }

    public function deleteFolderTemp($key)
    {
        $folder = config('app.ROOT_UPLOAD').'/'.$key.'/images/temp';

        if (is_dir($folder)) {
            $this->rrmdir($folder);
        }
    }

    function rrmdir($src)
    {
        $dir = opendir($src);

        while(false !== ($file = readdir($dir))) {
            if (($file != '.') && ($file != '..')) {
                $full = $src.'/'.$file;

                if (is_dir($full)) {
                    rrmdir($full);
                }
                else {
                    unlink($full);
                }
            }
        }

        closedir($dir);
        rmdir($src);
    }

    public function deleteFilesProcess($filesRoot, $status = true)
    {
        if ($filesRoot) {
            foreach ($filesRoot as $pathDelete => $verifyDelete) {
                if ($verifyDelete['status'] === $status) {
                    if (file_exists($pathDelete)) {
                        unlink($pathDelete);
                    }
                }
            }
        }
    }

    public function restoreWebpFilesProcess($path, $filesRoot, $status = false, $typesFix = null)
    {
        if ($filesRoot) {
            foreach ($filesRoot as $pathRestore => $verifyRestore) {
                if ($verifyRestore['status'] === $status) {
                    if (file_exists($pathRestore) && isset($verifyRestore['ext']) && in_array($verifyRestore['ext'], $typesFix)) {
                        $this->restoreWebp($path, $pathRestore, $verifyRestore['folder'], $verifyRestore['name'], $verifyRestore['ext']);
                    }
                }
            }
        }
    }

    public function selectAllFilesOnDatabase($pathFolder, $folders, $types, $queryExternal)
    {
        $tools = $this->tools;
        $controller = $this->tools->controller();

        $filesRoot = null;

        if (is_null($folders)) {
            $folders[] = $pathFolder;
        }

        foreach ($folders as $keyPath => $path) {
            if (file_exists($path)) {
                $dir = new \DirectoryIterator($path);

                foreach ($dir as $fileInfo) {
                    $verifyExistsDatabase = null;

                    $ext = strtolower(pathinfo($fileInfo->getFilename(), PATHINFO_EXTENSION));

                    if (in_array($ext, $types)) {
                        $fileName = $fileInfo->getFilename();
                        $fileNameSearch = explode('.'.$ext, $fileName)[0];

                        $pathFileName = $path.'/'.$fileName;

                        $filesRoot[$pathFileName]['name'] = $fileNameSearch;
                        $filesRoot[$pathFileName]['status'] = 'undefined';

                        if ($queryExternal) {
                            foreach ($queryExternal as $keyCheckInternal => $valueCheckInternal) {
                                $verifyExistsDatabase = str_replace('---fileNameSearch---', $fileNameSearch, $valueCheckInternal);

                                $resultExistsDatabase = $controller->dbFetchAssoc($verifyExistsDatabase);

                                if (!$resultExistsDatabase) {
                                    if ($filesRoot[$pathFileName]['status'] == 'undefined') {
                                        $filesRoot[$pathFileName]['status'] = true;
                                    }
                                }
                                else if ($resultExistsDatabase) {
                                    if (is_array($resultExistsDatabase)) {
                                        if (array_key_exists('parameter', $resultExistsDatabase) && @json_decode($resultExistsDatabase['parameter'])) {
                                            $parameter = json_decode($resultExistsDatabase['parameter'], true);

                                            if (array_key_exists('extension', $parameter)) {
                                                $filesRoot[$pathFileName]['ext'] =  $parameter['extension'];
                                                $filesRoot[$pathFileName]['folder'] =  $keyPath;
                                            }
                                            else if (array_key_exists('desktop', $parameter) || array_key_exists('mobile', $parameter)) {
                                                foreach ($parameter as $key => $value) {
                                                    if (array_key_exists('extension', $value)) {
                                                        if ($value['name'] == $fileNameSearch.'.'.$value['extension']) {
                                                            $filesRoot[$pathFileName]['ext'] =  $value['extension'];
                                                            $filesRoot[$pathFileName]['folder'] =  $keyPath;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        else if (array_key_exists('parameter', $resultExistsDatabase) && @unserialize($resultExistsDatabase['parameter'])) {
                                            $parameter = unserialize($resultExistsDatabase['parameter']);

                                            if (array_key_exists('assets', $parameter)) {
                                                foreach ($parameter['assets'] as $key => $value) {
                                                    if (array_key_exists('extension', $value)) {
                                                        if ($value['name'] == $fileNameSearch.'.'.$value['extension']) {
                                                            $filesRoot[$pathFileName]['ext'] =  $value['extension'];
                                                            $filesRoot[$pathFileName]['folder'] =  $keyPath;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }

                                    if ($filesRoot[$pathFileName]['status'] == 'undefined') {
                                        $filesRoot[$pathFileName]['status'] = false;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        return $filesRoot;
    }

    public function deleteImagesNotDatabase($key = null, $table = null, $path = null, $queryExternal = null, $tupleCheck = ['file', 'cover', 'logotipo', 'image', 'images'])
    {
        $tools = $this->tools;
        $controller = $this->tools->controller();

        $types = ['png', 'jpg', 'jpeg', 'gif', 'webp'];

        if (is_null($key)) {
            $key = $controller->getSufix();
        }

        if (is_null($table)) {
            $table = $controller->getTable();
        }

        if (is_null($path)) {
            if (is_dir(config('app.ROOT_UPLOAD').'/'.$key)) {
                $path = config('app.ROOT_UPLOAD').'/'.$key;
            }

            if (is_dir($path.'/images')) {
                $path = $path.'/images';
            }
        }

        if ($path) {
            if (is_null($queryExternal)) {
                $queryExternal = $tools->prepareQueryExternal($key, $table, $tupleCheck);
            }

            $folders_module['default'] = $path.'/default';
            $folders_module['thumb'] = $path.'/thumb';

            $filesRoot = $this->selectAllFilesOnDatabase($path, $folders_module, $types, $queryExternal);

            $this->deleteFilesProcess($filesRoot, true);

            $folders_submodule['larger'] = $path.'/larger';
            $folders_submodule['smaller'] = $path.'/smaller';

            $queryExternal = null;

            $queryExternal[] = "SELECT `id_photo` as id, `file_photo` as parameter FROM `sub_photo` WHERE `file_photo` LIKE '%---fileNameSearch---%' AND `table_photo` = '".$table."'";

            $filesRoot = $this->selectAllFilesOnDatabase($path, $folders_submodule, $types, $queryExternal);

            $this->deleteFilesProcess($filesRoot, true);
        }
    }

    public function deleteFilesNotDatabase($key = null, $table = null, $path = null, $queryExternal = null, $tupleCheck = ['file'])
    {
        $tools = $this->tools;
        $controller = $this->tools->controller();

        if (is_null($key)) {
            $key = $controller->getSufix();
        }

        if (is_null($table)) {
            $table = $controller->getTable();
        }

        $types = ['pdf', 'rar', 'zip', 'doc', 'docx', 'xsl', 'xslx', 'ppt', 'pptx', 'txt', 'jpg', 'gif', 'png'];

        if (is_null($path)) {
            if (is_dir(config('app.ROOT_UPLOAD').'/'.$key)) {
                $path = config('app.ROOT_UPLOAD').'/'.$key;
            }

            if (is_dir($path.'/files')) {
                $path = $path.'/files';
            }
        }

        if ($path) {
            if (is_null($queryExternal)) {
                $queryExternal = $tools->prepareQueryExternal($key, $table, $tupleCheck);
            }

            $queryExternal[] = "SELECT `id_anexx` as id, `file_anexx` as parameter FROM `sub_anexx` WHERE `file_anexx` LIKE '%---fileNameSearch---%' AND `table_anexx` = '".$table."'";

            $filesRoot = $this->selectAllFilesOnDatabase($path, null, $types, $queryExternal);

            $this->deleteFilesProcess($filesRoot, true);

            $types = ['mp3'];

            if (is_null($queryExternal)) {
                $queryExternal = $tools->prepareQueryExternal($key, $table, $tupleCheck);
            }

            $queryExternal[] = "SELECT `id_audio` as id, `file_audio` as parameter FROM `sub_audio` WHERE `file_audio` LIKE '%---fileNameSearch---%' AND `table_audio` = '".$table."'";

            $filesRoot = $this->selectAllFilesOnDatabase($path, null, $types, $queryExternal);

            $this->deleteFilesProcess($filesRoot, true);
        }
    }
}
