<?php

class ModuleDoop extends ModuleMaster
{
    public $form_type = [
        1 => 'Rotativo',
        2 => 'Lista ordernada'
    ];

    public function __construct($controller, $operation = 'manage', $key = null)
    {
        parent::__construct($controller, $operation, 'banners-local');
	}

    public function manage()
    {
        $controller = $this->controller();

        $query = "SELECT * FROM `".$controller->getTable()."`
                 ".$controller->modules->queryFilter."
                 WHERE ".$controller->modules->queryStatus." ".$controller->modules->querySearch."
                 GROUP BY `".$controller->sufix('id')."`
                 ORDER BY `".$controller->sufix('id')."`";

        $thead = '
        <th>local</th>
        <th>tipo</th>
        <th>quantidade</th>';

        $tbody = function ($result) use ($controller) {
            $dataTbody = '
            <td>
                <p>'.$controller->processString($result[$controller->sufix('title')]).'</p>
            </td>';

            $dataTbody .= '
            <td>
                <p>'.$this->form_type[$result[$controller->sufix('type')]].'</p>
            </td>';

            $dataTbody .= '
            <td>
                <p>'.$controller->processString($result[$controller->sufix('quantity')]).'</p>
            </td>';

            return $dataTbody;
        };

        return ToolsTemplate::manage($controller, $query, $thead, $tbody);
    }

    public function insert()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = $forms->input($controller->sufix('title'), 'Título', $controller->value('title'));
        $page .= $forms->separate();
        $page .= $forms->radio($controller->sufix('type'), 'Exibição', 1, $this->form_type);
        $page .= $forms->separate();
        $page .= $forms->select($controller->sufix('allowed'), 'Tipos permitidos', $modules->inputMultipleSelectHtml('banners-type', 'title', $controller->value('allowed')), ['multiple' => true]);
        $page .= $forms->separate();
        $page .= $forms->input($controller->sufix('quantity'), 'Quantidade visível', $controller->value('quantity'), ['type' => 'number']);

        return ToolsTemplate::insert($controller, $page);
    }

	public function module_insert()
	{
        $controller = $this->controller();
        $modules = $this->modules();

		$data = [
            $controller->sufix('title') => $controller->post($controller->sufix('title')),
            $controller->sufix('type') => intval($controller->post($controller->sufix('type'))),
            $controller->sufix('allowed') => $controller->post($controller->sufix('allowed'), 'json'),
            $controller->sufix('quantity') => intval($controller->post($controller->sufix('quantity')))
        ];

		$controller->dataSave($data, 'insert');

		return true;
	}

    public function update()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = $forms->input($controller->sufix('title'), 'Título', $controller->value('title'));
        $page .= $forms->separate();
        $page .= $forms->radio($controller->sufix('type'), 'Exibição', $controller->value('type'), $this->form_type);
        $page .= $forms->separate();
        $page .= $forms->select($controller->sufix('allowed'), 'Tipos permitidos', $modules->inputMultipleSelectHtml('banners-type', 'title', $controller->value('allowed')), ['multiple' => true]);
        $page .= $forms->separate();
        $page .= $forms->input($controller->sufix('quantity'), 'Quantidade visível', $controller->value('quantity'), ['type' => 'number']);

        return ToolsTemplate::update($controller, $page);
    }

	public function module_update()
	{
        $controller = $this->controller();
        $modules = $this->modules();

        $data = [
            $controller->sufix('title') => $controller->post($controller->sufix('title')),
            $controller->sufix('type') => intval($controller->post($controller->sufix('type'))),
            $controller->sufix('allowed') => $controller->post($controller->sufix('allowed'), 'json'),
            $controller->sufix('quantity') => intval($controller->post($controller->sufix('quantity')))
        ];

		$controller->dataSave($data, 'update');

		return true;
	}
}
