<?php

class ModuleDoop extends ModuleMaster
{
    public $configForm = null;

    private $configFormKey = 'configFormBudget';

    public function __construct($controller, $operation = 'manage', $key = null)
    {
        parent::__construct($controller, $operation, 'budget');

        $controller = $this->controller();
        $modules = $this->modules();

        $this->setControl('bt_insert', false);
        $this->setControl('bt_update', false);
        $this->setControl('bt_view', true);

        $this->setPage('configForm', ['action' => 'configForm', 'title' => 'Configuração do formulário', 'label' => 'Salvar', 'path' => 'module/budget&operation=configForm', 'icon' => 'far fa-edit', 'privilege' => 'god']);

        $this->buttonExtra($controller->pathlang(null, config('app.PATH_SYSTEM').$modules->page['configForm']['path']), $modules->page['configForm']['title'], 'far fa-edit');

        $this->configForm = $controller->getBaseData($this->configFormKey);

        if ($modules->operation == 'view') {
            $modules->dataUpdate = $modules->dataLoad($controller->get('uuid'));

            $controller->dbQuery("UPDATE `ex_budget` SET `read_budget` = '1' WHERE `uuid_budget` = '".$controller->get('uuid')."'");
        }

        if ($modules->operation == 'configForm') {
            $this->options['addCC'] = [
                'parameters' => [
                    'add' => 'adicionar c/c',
                    'delete' => 'excluir c/c'
                ],
                'itens' => [
                    'nameCC' => [
                        'label' => 'Nome',
                        'width' => '50%',
                        'type' => 'text',
                        'maxlength' => 200
                    ],
                    'emailCC' => [
                        'label' => 'E-mail',
                        'width' => '50%',
                        'type' => 'email',
                        'maxlength' => 200
                    ]
                ]
            ];
        }

        if ($this->post('configForm_action_form')) {
            $this->editConfigForm();
        }
    }

    public function manage()
    {
        $controller = $this->controller();
        $modules = $this->modules();

        $query = "SELECT * FROM `".$controller->getTable()."`
                 ".$modules->queryFilter."
                 WHERE ".$modules->queryStatus." ".$modules->querySearch."
                 GROUP BY `".$controller->sufix('id')."`
                 ORDER BY `".$controller->sufix('time')."` DESC";

        $thead = '
            <th>nome</th>
            <th width="1%" class="text-center">e-mail</th>
            <th width="1%" class="text-center">telefone</th>
            <th width="1%" class="text-center">data</th>
            <th width="1%" class="text-center">situação</th>';

        $tbody = function ($result) use ($controller, $modules) {
            $dataTbody = '<td>'.$controller->processString($result[$controller->sufix('name')]).'</td>';
            $dataTbody .= '<td class="text-center"><a href="mailto:'.$controller->processString($result[$controller->sufix('email')]).'">'.$controller->processString($result[$controller->sufix('email')]).'</a></td>';
            $dataTbody .= '<td class="text-center"><a href="tel:'.$controller->processString($result[$controller->sufix('phone')], 'callto').'">'.$controller->processString($result[$controller->sufix('phone')]).'</a></td>';
            $dataTbody .= '<td class="text-center">'.$controller->processDate($result[$controller->sufix('time')], 'timestamp_brazil').'</td>';

            if ($result[$controller->sufix('read')] == 0) {
                $dataTbody .= '<td class="text-center"><span class="badge badge-danger text-uppercase p-1 m-auto"><i class="fas fa-times mr-1"></i>Não lida</span></td>';
            }
            else {
                $dataTbody .= '<td class="text-center"><span class="badge badge-success text-uppercase p-1"><i class="fas fa-check mr-1"></i>Lida</span></td>';
            }

            return $dataTbody;
        };

        return ToolsTemplate::manage($controller, $query, $thead, $tbody);
    }

   public function view()
    {
        $controller = $this->controller();
        $modules = $this->modules();

        $labelForm = $controller->getBaseData('extraBudget')['label'];

        $page = '
        <h4>Orçamento recebido em <b>'.$controller->processDate($controller->value('time'), 'timestamp_brazil').'</b></h4>
        <hr>
        <div class="table-responsive">
            <table class="table table-striped table-bordered m-0">
                <tbody>
                    <tr>
                        <td width="25%" class="text-right"><b>'.$labelForm['name'].'</b></td>
                        <td>'.$controller->value('name').'</td>
                    </tr>
                    <tr>
                        <td width="25%" class="text-right"><b>'.$labelForm['email'].'</b></td>
                        <td><a href="mailto:'.$controller->value('email').'">'.$controller->value('email').'</a></td>
                    </tr>
                    <tr>
                        <td width="25%" class="text-right"><b>'.$labelForm['phone'].'</b></td>
                        <td><a href="tel:'.$controller->processString($controller->value('phone'), 'callto').'">'.$controller->value('phone').'</a></td>
                    </tr>
                    <tr>
                        <td width="25%" class="text-right"><b>'.$labelForm['message'].'</b></td>
                        <td>'.$controller->value('message').'</td>
                    </tr>
                    <tr>
                        <td width="25%" class="text-right"><b>IP</b></td>
                        <td>'.$controller->value('ip').'</td>
                    </tr>
                    <tr>
                        <td width="25%" class="text-right"><b>DISPOSITIVO</b></td>
                        <td>'.$controller->value('agent').'</td>
                    </tr>
                </tbody>
            </table>
        </div>
        ';

        return ToolsTemplate::page($controller, $page, []);
    }

    public function configForm()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = '<form name="insert_form" class="form-horizontal form-validate" method="post" action="'.$controller->linkSystem(config('app.PATH_SYSTEM')).'">';
        $page .= $forms->input('header_configForm', 'Cabeçalho do E-mail', $this->configForm['header'], ['maxlength' => 100]);
        $page .= $forms->separate();
        $page .= $forms->input('nameFrom_configForm', 'Remetente/Nome', $this->configForm['nameFrom'], ['maxlength' => 100, 'input_group_label' => '<i class="fa fa-fw fa-user"></i>']);
        $page .= $forms->input('emailFrom_configForm', 'Remetente/E-mail', $this->configForm['emailFrom'], ['type' => 'email', 'maxlength' => 100, 'cont_input' => false, 'input_group_label' => '<i class="fa fa-fw fa-envelope"></i>']);
        $page .= $forms->separate();
        $page .= $forms->input('nameTo_configForm', 'Destinatário/Nome', $this->configForm['nameTo'], ['maxlength' => 100, 'input_group_label' => '<i class="fa fa-fw fa-user"></i>']);
        $page .= $forms->input('emailTo_configForm', 'Destinatário/E-mail', $this->configForm['emailTo'], ['type' => 'email', 'maxlength' => 100,'cont_input' => false, 'input_group_label' => '<i class="fa fa-fw fa-envelope"></i>']);
        $page .= $forms->separate();
        $page .= $forms->table_multiple('addCC', 'Cópias', $this->configForm, $this->options['addCC'], []);
        $page .= $forms->separate();
        $page .= '<div class="text-center">'.$modules->htmlButton().'</div>';
        $page .= '</form>';

        return ToolsTemplate::page($controller, $page);
    }

    public function editConfigForm()
    {
        $controller = $this->controller();

        $data = [
            'header' => $controller->post('header_configForm', 'text'),
            'nameFrom' => $controller->post('nameFrom_configForm', 'text'),
            'emailFrom' => $controller->post('emailFrom_configForm', 'email'),
            'nameTo' => $controller->post('nameTo_configForm', 'text'),
            'emailTo' => $controller->post('emailTo_configForm', 'email'),
            'nameCC' => $controller->post('nameCC', 'array_explode_shift'),
            'emailCC' => $controller->post('emailCC', 'array_explode_shift')
        ];

        $controller->setBaseData($this->configFormKey, $data, 'json');

        $this->routeCallback('301');
    }
}
