<?php

class ModuleDoop extends ModuleMaster
{
    public $form_internals = [
        1 => 'URL Interna Livre',
        2 => 'URL Completa',
        3 => 'URL Interna Páginas'
    ];

    public $form_targets = [
        '_blank' => 'Nova Janela',
        '_parent' => 'Mesma Janela'
    ];

    public function __construct($controller, $operation = 'manage', $key = null)
    {
        $this->imgx = 400;
        $this->imgy = 360;

        $this->extension = 'jpg';

        parent::__construct($controller, $operation, 'clients');

        $this->setControl('controls_modules', true);
    }

    public function manage()
    {
        $controller = $this->controller();
        $modules = $this->modules();

        $query = "SELECT * FROM `".$controller->getTable()."`
                 ".$modules->queryFilter."
                 WHERE ".$modules->queryStatus." ".$modules->querySearch."
                 GROUP BY `".$controller->sufix('id')."`
                 ORDER BY `".$controller->sufix('order')."`, `".$controller->sufix('title')."`";

        $thead = '
            <th width="1%" class="text-center">imagem</th>
            <th>título</th>
            <th width="1%" class="text-center">url</th>';

        $tbody = function ($result) use ($controller, $modules) {
            $dataTbody = '<td class="text-center">'.$modules->getPhotoPage($result[$controller->sufix('file')], 'file', null, null, false, true).'</td>';
            $dataTbody .= '<td>'.$controller->processString($result[$controller->sufix('title')]).'</td>';
            $dataTbody .= '<td class="text-center text-nowrap">';

            if ($result[$controller->sufix('internal')] == 1) {
                if ($result[$controller->sufix('url')] && $result[$controller->sufix('url')] != '#') {
                    $link = config('app.BASE_PATH').'/'.$controller->processString($result[$controller->sufix('url')]);

                    $dataTbody .= '<a href="'.$link.'" target="_blank" title="'.$link.'" class="btn btn-sm btn-info"><i class="fas fa-paperclip mr-2"></i>Acessar</a>';
                }
                else {
                    $dataTbody .= '<b class="text-danger"># SEM AÇÃO</b>';
                }
            }
            else if ($result[$controller->sufix('internal')] == 2) {
                $link = $controller->processString($result[$controller->sufix('url')]);

                $dataTbody .= '<a href="'.$link.'" target="_blank" title="'.$link.'" class="btn btn-sm btn-info"><i class="fas fa-paperclip mr-2"></i>Acessar</a>';
            }
            else if ($result[$controller->sufix('internal')] == 3) {
                $link = config('app.BASE_PATH').'/'.$controller->getTupleModule('page', $result[$controller->sufix('url')], 'slug');

                $dataTbody .= '<a href="'.$link.'" target="_blank" title="'.$link.'" class="btn btn-sm btn-info"><i class="fas fa-paperclip mr-2"></i>Acessar</a>';
            }

            $dataTbody .= '</td>';

            return $dataTbody;
        };

        return ToolsTemplate::manage($controller, $query, $thead, $tbody);
    }

    public function insert()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = $forms->input($controller->sufix('title'), 'Título', $controller->value('title'), ['maxlength' => 100]);
        $page .= $forms->separate();
        $page .= $forms->radio($controller->sufix('internal'), 'Tipo de URL', 1, $this->form_internals);
        $page .= $forms->input($controller->sufix('url'), 'URL Interna Livre', $controller->value('url'), ['required' => false, 'cont_input' => false, 'input_group_label' => config('app.BASE_PATH').'/']);
        $page .= $forms->input($controller->sufix('urlfull'), 'URL Completa', $controller->value('urlfull'), ['required' => false, 'form_group' => 'd-none', 'cont_input' => false, 'input_group_label' => '<i class="fa fa-fw fa-paperclip"></i>']);
        $page .= $forms->select($controller->sufix('urlpage'), 'Url Interna Páginas', $modules->inputSelectHtml('page', 'title'), ['required' => false, 'form_group' => 'd-none', 'input_col' => 'col col-md-5']);
        $page .= $forms->radio($controller->sufix('target'), 'Abrir URL', '_parent', $this->form_targets);
        $page .= $forms->separate();
        $page .= $forms->upload($controller->sufix('file'), 'Imagem', null, ['required' => false, 'extension' => $this->extension, 'width' => $this->imgx, 'height' => $this->imgy]);
        $page .= $forms->separate();
        $page .= $forms->select($controller->sufix('status'), 'Status', $modules->getInputSelectStatus($controller->value('status')), ['input_col' => 'col-md-4']);

        return ToolsTemplate::insert($controller, $page);
    }

    public function module_insert()
    {
        $controller = $this->controller();
        $modules = $this->modules();

        $data = [
            $controller->sufix('title') => $controller->post($controller->sufix('title'), 'text'),
            $controller->sufix('internal') => $controller->post($controller->sufix('internal'), 'int'),
            $controller->sufix('target') => $controller->post($controller->sufix('target')),
            $controller->sufix('order') => $controller->generatorOrder(),
            $controller->sufix('status') => $controller->post($controller->sufix('status'))
        ];

        switch($data[$controller->sufix('internal')])
        {
            case 1:
                $data[$controller->sufix('url')] = $controller->post($controller->sufix('url'));
            break;

            case 2:
                $data[$controller->sufix('url')] = $controller->post($controller->sufix('urlfull'));
            break;

            case 3:
                $data[$controller->sufix('url')] = $controller->post($controller->sufix('urlpage'), 'int');
            break;
        }

        $file = new \CoreSlim\Upload();
        $file->config($controller->sufix('file'), $modules->key, $controller->linkSystem());
        $file->all('photo');
        $file->dimensions([$this->imgx, $this->imgy]);
        $file->load(true);

        if ($output = $file->output('json')) {
            $data[$controller->sufix('file')] = $output;
        }

        $controller->dataSave($data, 'insert');

        return true;
    }

    public function update()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        if ($controller->value('internal') == 1) {
            $url['url'] = $controller->value('url');
            $url['urlfull'] = null;
            $url['urlpage'] = null;

            $form_group['url'] = null;
            $form_group['urlfull'] = 'd-none';
            $form_group['urlpage'] = 'd-none';
        }
        else if ($controller->value('internal') == 2) {
            $url['url'] = null;
            $url['urlfull'] = $controller->value('url');
            $url['urlpage'] = null;

            $form_group['url'] = 'd-none';
            $form_group['urlfull'] = null;
            $form_group['urlpage'] = 'd-none';
        }
        else if ($controller->value('internal') == 3) {
            $url['url'] = null;
            $url['urlfull'] = null;
            $url['urlpage'] = $controller->value('url');

            $form_group['url'] = 'd-none';
            $form_group['urlfull'] = 'd-none';
            $form_group['urlpage'] = null;
        }

        $page = $forms->input($controller->sufix('title'), 'Título', $controller->value('title'), ['maxlength' => 100]);
        $page .= $forms->separate();
        $page .= $forms->radio($controller->sufix('internal'), 'Tipo de URL', $controller->value('internal'), $this->form_internals);
        $page .= $forms->input($controller->sufix('url'), 'URL Interna Livre', $url['url'], ['required' => false, 'form_group' => $form_group['url'], 'cont_input' => false, 'input_group_label' => config('app.BASE_PATH').'/']);
        $page .= $forms->input($controller->sufix('urlfull'), 'URL Completa', $url['urlfull'], ['required' => false, 'form_group' => $form_group['urlfull'], 'cont_input' => false, 'input_group_label' => '<i class="fa fa-fw fa-paperclip"></i>']);
        $page .= $forms->select($controller->sufix('urlpage'), 'Url Interna Páginas', $modules->inputSelectHtml('page', 'title',  $url['urlpage']), ['required' => false, 'form_group' => $form_group['urlpage'], 'input_col' => 'col col-md-5']);
        $page .= $forms->radio($controller->sufix('target'), 'Abrir URL', $controller->value('target'), $this->form_targets);
        $page .= $forms->separate();
        $page .= $forms->upload($controller->sufix('file'), 'Imagem', $modules->getPhotoPage($controller->value('file'), 'file'), ['required' => false, 'extension' => $this->extension, 'width' => $this->imgx, 'height' => $this->imgy]);
        $page .= $forms->separate();
        $page .= $forms->input($controller->sufix('order'), 'Ordem', $controller->value('order'), ['type' => 'number']);
        $page .= $forms->separate();
        $page .= $forms->select($controller->sufix('status'), 'Status', $modules->getInputSelectStatus($controller->value('status')), ['input_col' => 'col-md-4']);

        return ToolsTemplate::update($controller, $page);
    }

    public function module_update()
    {
        $controller = $this->controller();
        $modules = $this->modules();

        $data = [
            $controller->sufix('title') => $controller->post($controller->sufix('title'), 'text'),
            $controller->sufix('internal') => $controller->post($controller->sufix('internal'), 'int'),
            $controller->sufix('target') => $controller->post($controller->sufix('target')),
            $controller->sufix('order') => intval($controller->post($controller->sufix('order'))),
            $controller->sufix('status') => $controller->post($controller->sufix('status'))
        ];

        switch($data[$controller->sufix('internal')])
        {
            case 1:
                $data[$controller->sufix('url')] = $controller->post($controller->sufix('url'));
            break;

            case 2:
                $data[$controller->sufix('url')] = $controller->post($controller->sufix('urlfull'));
            break;

            case 3:
                $data[$controller->sufix('url')] = $controller->post($controller->sufix('urlpage'), 'int');
            break;
        }

        $file = new \CoreSlim\Upload();
        $file->config($controller->sufix('file'), $modules->key, $controller->linkSystem());
        $file->all('photo');
        $file->dimensions([$this->imgx, $this->imgy]);
        $file->load();

        if ($output = $file->output('json')) {
            $data[$controller->sufix('file')] = $output;
        }

        $controller->dataSave($data, 'update');

        return true;
    }

    public function importData()
    {
        \DeveloperSlim\Seeders\ClientsSeeder::seed();
    }
}
