<?php

class ModuleDoop extends ModuleMaster
{
    public function __construct($controller, $operation = 'manage', $key = null)
    {
        parent::__construct($controller, $operation, 'faq');

        $this->setControl('controls_modules', true);
        $this->setControl('bt_frontend', false);
    }

    public function manage()
    {
        $controller = $this->controller();
        $modules = $this->modules();

        $query = "SELECT * FROM `".$controller->getTable()."`
                 ".$modules->queryFilter."
                 WHERE ".$modules->queryStatus." ".$modules->querySearch."
                 GROUP BY `".$controller->sufix('id')."`
                 ORDER BY `".$controller->sufix('order')."`";

        $thead = '
        <th>faq</th>';

        $tbody = function ($result) use ($controller, $modules) {
            $dataTbody = '<td><h5>'.$controller->processString($result[$controller->sufix('title')]).'</h5>';

            if (isset($result[$controller->sufix('text')])) {
                $dataTbody .= $controller->processString($result[$controller->sufix('text')], 'text');
            }

            $dataTbody .= '</td>';

            return $dataTbody;
        };

        return ToolsTemplate::manage($controller, $query, $thead, $tbody);
    }

    public function insert()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = $forms->input($controller->sufix('title'), 'Título', $controller->value('title'));
        $page .= $forms->separate();
        $page .= $forms->textarea($controller->sufix('text'), 'Texto', $controller->value('text', 'text'), ['required' => false]);
        $page .= $forms->separate();
        $page .= $forms->select($controller->sufix('status'), 'Status', $modules->getInputSelectStatus($controller->value('status')), ['input_col' => 'col-md-4']);

        return ToolsTemplate::insert($controller, $page);
    }

    public function module_insert()
    {
        $controller = $this->controller();
        $modules = $this->modules();

        $data = [
            $controller->sufix('title') => $controller->post($controller->sufix('title')),
            $controller->sufix('slug') => $controller->getSlug($controller->post($controller->sufix('title'))),
            $controller->sufix('text') => $controller->post($controller->sufix('text'), 'text'),
            $controller->sufix('order') => $controller->generatorOrder(),
            $controller->sufix('status') => $controller->post($controller->sufix('status'))
        ];

        $controller->dataSave($data, 'insert');

        return true;
    }

    public function update()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = $forms->input($controller->sufix('title'), 'Título', $controller->value('title'));
        $page .= $forms->separate();
        $page .= $forms->textarea($controller->sufix('text'), 'Texto', $controller->value('text', 'text'), ['required' => false]);
        $page .= $forms->separate();
        $page .= $forms->input($controller->sufix('order'), 'Ordem', $controller->value('order'), ['type' => 'number']);
        $page .= $forms->separate();
        $page .= $forms->select($controller->sufix('status'), 'Status', $modules->getInputSelectStatus($controller->value('status')), ['input_col' => 'col-md-4']);

        return ToolsTemplate::update($controller, $page);
    }

    public function module_update()
    {
        $controller = $this->controller();
        $modules = $this->modules();

        $data = [
            $controller->sufix('title') => $controller->post($controller->sufix('title')),
            $controller->sufix('slug') => $controller->getSlug($controller->post($controller->sufix('title'))),
            $controller->sufix('text') => $controller->post($controller->sufix('text'), 'text'),
            $controller->sufix('order') => $controller->post($controller->sufix('order')),
            $controller->sufix('status') => $controller->post($controller->sufix('status'))
        ];

        $controller->dataSave($data, 'update');

        return true;
    }

    public function importData()
    {
        \DeveloperSlim\Seeders\FaqSeeder::seed();
    }
}
