<?php

class ModuleDoop extends ModuleMaster
{
    public function __construct($controller, $operation = 'manage', $key = null)
    {
        parent::__construct($controller, $operation, 'galleryvideo');

        $this->setControl('seo', true);
        $this->setControl('video', true);

        $this->setControl('controls_modules', true);
        $this->setControl('bt_frontend', true);
    }

    public function manage()
    {
        $controller = $this->controller();
        $modules = $this->modules();

        $query = "SELECT * FROM `".$controller->getTable()."`
                 ".$modules->queryFilter."
                 WHERE ".$modules->queryStatus." ".$modules->querySearch."
                 GROUP BY `".$controller->sufix('id')."`
                 ORDER BY `".$controller->sufix('time')."` DESC";

        $thead = '
        <th width="1%" class="text-center">vídeo</th>
        <th>título</th>';

        $tbody = function ($result) use ($controller, $modules) {
            $cover = $modules->getVideoTemplateThumbnail($result[$controller->sufix('video')]);

            $dataTbody = '<td class="text-center">'.$cover.'</td>';
            $dataTbody .= '<td><p><b>Data:</b> '.$controller->processDate($result[$controller->sufix('date')], 'brazil').'</p>';
            $dataTbody .= '<h4>'.$controller->processString($result[$controller->sufix('title')]).'</h4></td>';

            return $dataTbody;
        };

        return ToolsTemplate::manage($controller, $query, $thead, $tbody);
    }

    public function insert()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = $forms->date($controller->sufix('date'), 'Data', date('d/m/Y'));
        $page .= $forms->separate();
        $page .= $forms->input($controller->sufix('title'), 'Título', $controller->value('title'));
        $page .= $forms->input($controller->sufix('subtitle'), 'Chamada', $controller->value('subtitle'), ['required' => false, 'maxlength' => 300]);
        $page .= $forms->separate();
        $page .= $forms->textarea($controller->sufix('text'), 'Texto', $controller->value('text', 'text'), ['required' => false]);
        $page .= $forms->separate();
        $page .= $forms->video($controller->sufix('video'), 'URL Vídeo', null);
        $page .= $forms->separate();
        $page .= $forms->select($controller->sufix('status'), 'Status', $modules->getInputSelectStatus($controller->value('status')), ['input_col' => 'col-md-4']);

        return ToolsTemplate::insert($controller, $page);
    }

	public function module_insert()
	{
        $controller = $this->controller();
        $modules = $this->modules();

		$data = [
            $controller->sufix('date') => $controller->post($controller->sufix('date'), 'date'),
            $controller->sufix('title') => $controller->post($controller->sufix('title')),
            $controller->sufix('slug') => $controller->getSlug($controller->post($controller->sufix('title'))),
            $controller->sufix('subtitle') => $controller->post($controller->sufix('subtitle'), 'text'),
            $controller->sufix('text') => $controller->post($controller->sufix('text'), 'text'),
            $controller->sufix('video') => $controller->setVideoTemplate($controller->post($controller->sufix('video'))),
            $controller->sufix('status') => $controller->post($controller->sufix('status'))
        ];

		$controller->dataSave($data, 'insert');

		return true;
	}

    public function update()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = $forms->date($controller->sufix('date'), 'Data', date('d/m/Y'));
        $page .= $forms->separate();
        $page .= $forms->input($controller->sufix('title'), 'Título', $controller->value('title'));
        $page .= $forms->input($controller->sufix('subtitle'), 'Chamada', $controller->value('subtitle'), ['required' => false, 'maxlength' => 300]);
        $page .= $forms->separate();
        $page .= $forms->textarea($controller->sufix('text'), 'Texto', $controller->value('text', 'text'), ['required' => false]);
        $page .= $forms->separate();
        $page .= $forms->video($controller->sufix('video'), 'URL Vídeo', $modules->getVideoTemplate($controller->value('video'), 'video'), ['required' => false]);
        $page .= $forms->separate();
        $page .= $forms->input($controller->sufix('order'), 'Ordem', $controller->value('order'), ['type' => 'number']);
        $page .= $forms->separate();
        $page .= $forms->select($controller->sufix('status'), 'Status', $modules->getInputSelectStatus($controller->value('status')), ['input_col' => 'col-md-4']);

        return ToolsTemplate::insert($controller, $page);
    }

	public function module_update()
	{
        $controller = $this->controller();
        $modules = $this->modules();

        $data = [
            $controller->sufix('date') => $controller->post($controller->sufix('date'), 'date'),
            $controller->sufix('title') => $controller->post($controller->sufix('title')),
            $controller->sufix('slug') => $controller->getSlug($controller->post($controller->sufix('title'))),
            $controller->sufix('subtitle') => $controller->post($controller->sufix('subtitle'), 'text'),
            $controller->sufix('text') => $controller->post($controller->sufix('text'), 'text'),
            $controller->sufix('status') => $controller->post($controller->sufix('status'))
        ];

        if ($controller->post($controller->sufix('video'))) {
            $data[$controller->sufix('video')] = $controller->setVideoTemplate($controller->post($controller->sufix('video')));
        }

		$controller->dataSave($data, 'update');

		return true;
	}

    public function importData()
    {
        \DeveloperSlim\Seeders\GalleryVideo::import();
    }
}
