<?php

class ModuleDoop extends ModuleMaster
{
    public function __construct($controller, $operation = 'manage', $key = null)
    {
        parent::__construct($controller, $operation, 'page');

        $this->imgx = 800;
        $this->imgy = 600;
        $this->extension = 'jpg, png, gif';

        $this->imageActive = true;
        $this->keysOff = [];
        $this->typesOff = [3];

        $this->setNavBars('config', true);
        $this->setNavBars('photo', true);
        $this->setNavBars('video', true);
        $this->setNavBars('anexx', true);
        $this->setNavBars('audio', true);

        $this->setControl('bt_frontend', true);
    }

    public function manage()
    {
        $controller = $this->controller();
        $modules = $this->modules();

        $query = "SELECT * FROM `".$controller->getTable()."`
                 ".$modules->queryFilter."
                 WHERE ".$modules->queryStatus." ".$modules->querySearch."
                 GROUP BY `".$controller->sufix('id')."`
                 ORDER BY `order_page-type`, `".$controller->sufix('order')."`";

        $thead = '
        <th width="1%" class="text-center">tipo</th>
        <th>página</th>';

        $tbody = function ($result) use ($controller, $modules) {
            $dataTbody = '<td class="text-nowrap text-center"><p>'.$controller->processString($result['title_page-type']).'</p></td>';
            $dataTbody .= '<td><h5>'.$controller->processString($result[$controller->sufix('title')]).'</h5></td>';

            return $dataTbody;
        };

        return ToolsTemplate::manage($controller, $query, $thead, $tbody);
    }

    public function insert()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = $forms->select($controller->sufix('type'), 'Tipo', $modules->inputSelectHtml('page-type', 'title'));
        $page .= $forms->input($controller->sufix('title'), 'Título', $controller->value('title'));
        $page .= $forms->textarea($controller->sufix('text'), 'Texto', $controller->value('text', 'text'), ['required' => false]);

        if ($this->imageActive) {
            $page .= $forms->separate();
            $page .= $forms->uploadCrop($controller->sufix('cover'), 'Imagem', null, ['required' => false, 'extension' => $this->extension, 'width' => $this->imgx, 'height' => $this->imgy]);
        }

        $page .= $forms->separate();
        $page .= $forms->select($controller->sufix('status'), 'Status', $modules->getInputSelectStatus($controller->value('status')), ['input_col' => 'col-md-4']);

        return ToolsTemplate::insert($controller, $page);
    }

    public function module_insert()
    {
        $controller = $this->controller();
        $modules = $this->modules();

        $data = [
            $controller->sufix('type') => intval($controller->post($controller->sufix('type'))),
            $controller->sufix('title') => $controller->post($controller->sufix('title'), 'text'),
            $controller->sufix('slug') => $controller->getSlug($controller->post($controller->sufix('title')), false),
            $controller->sufix('text') => $controller->post($controller->sufix('text'), 'text'),
            $controller->sufix('order') => $controller->generatorOrder("AND `".$controller->sufix('type')."` = '".$controller->post($controller->sufix('type'))."'"),
            $controller->sufix('status') => $controller->post($controller->sufix('status'))
        ];

        if ($controller->dataDuplicated(['slug', 'type'], [$data[$controller->sufix('slug')], $data[$controller->sufix('type')]]) == true) {
            header('Location: '.$controller->linkSystem().'&callback=401');
            exit;
        }

        if ($this->imageActive) {
            $cover = new \CoreSlim\Upload();
            $cover->config($controller->sufix('cover'), $modules->key, $controller->linkSystem());
            $cover->dimensions([$this->imgx, $this->imgy]);
            $cover->loadBlob($controller->post($controller->sufix('cover')));

            if ($output = $cover->output('json')) {
                $data[$controller->sufix('cover')] = $output;
            }
        }

        $controller->dataSave($data, 'insert');

        return true;
    }

    public function update()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = $forms->select($controller->sufix('type'), 'Tipo', $modules->inputSelectHtml('page-type', 'title', $controller->value('type')));
        $page .= $forms->input($controller->sufix('title'), 'Título', $controller->value('title'));
        $page .= $forms->textarea($controller->sufix('text'), 'Texto', $controller->value('text', 'text'), ['required' => false]);

        if (!in_array($controller->value('slug'), $this->keysOff) && !in_array($controller->value('type'), $this->typesOff) && $this->imageActive) {
            $page .= $forms->separate();
            $page .= $forms->uploadCrop($controller->sufix('cover'), 'Foto', $modules->getPhotoPageOnlyLinks($controller->value('cover'), 'cover'), ['required' => false, 'extension' => $this->extension, 'width' => $this->imgx, 'height' => $this->imgy]);
        }

        $page .= $forms->separate();
        $page .= $forms->input($controller->sufix('order'), 'Ordem', $controller->value('order'), ['type' => 'number']);
        $page .= $forms->separate();
        $page .= $forms->select($controller->sufix('status'), 'Status', $modules->getInputSelectStatus($controller->value('status')), ['input_col' => 'col-md-4']);

        return ToolsTemplate::update($controller, $page);
    }

    public function module_update()
    {
        $controller = $this->controller();
        $modules = $this->modules();

        $data = [
            $controller->sufix('type') => intval($controller->post($controller->sufix('type'))),
            $controller->sufix('title') => $controller->post($controller->sufix('title')),
            $controller->sufix('slug') => $controller->getSlug($controller->post($controller->sufix('title'))),
            $controller->sufix('text') => $controller->post($controller->sufix('text'), 'text'),
            $controller->sufix('order') => intval($controller->post($controller->sufix('order'))),
            $controller->sufix('status') => $controller->post($controller->sufix('status'))
        ];

        $data[$controller->sufix('type')] = $controller->post($controller->sufix('type'));

        if ($data[$controller->sufix('slug')] != $controller->value('slug') || $data[$controller->sufix('type')] != $controller->value('type')) {
            if ($controller->dataDuplicated(['slug', 'type'], [$data[$controller->sufix('slug')], $data[$controller->sufix('type')]]) == true) {
                header('Location: '.$controller->linkSystem().'&callback=401');
                exit;
            }
        }

        if ($this->imageActive) {
            $cover = new \CoreSlim\Upload();
            $cover->config($controller->sufix('cover'), $modules->key, $controller->linkSystem());
            $cover->dimensions([$this->imgx, $this->imgy]);
            $cover->loadBlob($controller->post($controller->sufix('cover')));

            if ($output = $cover->output('json')) {
                $data[$controller->sufix('cover')] = $output;
            }
        }

        $controller->dataSave($data, 'update');

        return true;
    }
}
