CREATE TABLE `ex_protocol` (
  `id_protocol` int(10) NOT NULL,
  `uuid_protocol` binary(36) NOT NULL,
  `protocol_protocol` varchar(100) NOT NULL,
  `date_protocol` date NOT NULL,
  `name_protocol` varchar(100) NOT NULL,
  `address_protocol` varchar(100) NOT NULL,
  `phone_protocol` varchar(100) NOT NULL,
  `email_protocol` varchar(100) NOT NULL,
  `notification_protocol` text,
  `access_protocol` varchar(100) NOT NULL,
  `ip_protocol` varchar(100) NOT NULL,
  `agent_protocol` text,
  `user_protocol` int(10) NOT NULL DEFAULT '1',
  `time_protocol` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_protocol` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `status_protocol` varchar(50) NOT NULL DEFAULT 'disabled',
  `read_protocol` tinyint(1) DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

ALTER TABLE `ex_protocol`
  ADD PRIMARY KEY (`id_protocol`),
  ADD UNIQUE KEY `uuid_protocol` (`uuid_protocol`),
  ADD UNIQUE KEY `protocol_protocol` (`protocol_protocol`),
  ADD KEY `user_protocol` (`user_protocol`);

ALTER TABLE `ex_protocol`
  MODIFY `id_protocol` int(10) NOT NULL AUTO_INCREMENT;

CREATE TABLE `ex_protocol-reply` (
  `id_protocol-reply` int(10) NOT NULL,
  `uuid_protocol-reply` binary(36) NOT NULL,
  `protocol_protocol-reply` int(10) NOT NULL,
  `text_protocol-reply` text,
  `user_protocol-reply` int(10) NOT NULL DEFAULT '1',
  `time_protocol-reply` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_protocol-reply` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `status_protocol-reply` varchar(50) NOT NULL DEFAULT 'disabled'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

ALTER TABLE `ex_protocol-reply`
  ADD PRIMARY KEY (`id_protocol-reply`),
  ADD UNIQUE KEY `uuid_protocol-reply` (`uuid_protocol-reply`),
  ADD KEY `protocol_protocol-reply` (`protocol_protocol-reply`),
  ADD KEY `user_protocol-reply` (`user_protocol-reply`);

ALTER TABLE `ex_protocol-reply`
  MODIFY `id_protocol-reply` int(10) NOT NULL AUTO_INCREMENT;
