<?php

class ModuleDoop extends ModuleMaster
{
    public function __construct($controller, $operation = 'manage', $key = null)
    {
        parent::__construct($controller, $operation, 'services');

        $this->imgx = 800;
        $this->imgy = 800;
        $this->extension = 'jpg';

        $this->setNavBars('config', true);
        $this->setNavBars('photo', true);
        $this->setNavBars('video', true);

        $this->setControl('controls_modules', true);
        $this->setControl('bt_frontend', true);
    }

    public function manage()
    {
        $controller = $this->controller();
        $modules = $this->modules();

        $query = "SELECT * FROM `".$controller->getTable()."`
                 ".$modules->queryFilter."
                 WHERE ".$modules->queryStatus." ".$modules->querySearch."
                 GROUP BY `".$controller->sufix('id')."`
                 ORDER BY `".$controller->sufix('order')."`";

        $thead = '
        <th width="1%" class="text-center">imagem</th>
        <th>serviço</th>';

        $tbody = function ($result) use ($controller, $modules) {
            $dataTbody = '<td class="text-center">'.$modules->getPhotoPage($result[$controller->sufix('cover')], 'cover', null, null, false, true).'</td>';

            $dataTbody .= '<td><h5>'.$controller->processString($result[$controller->sufix('title')]).'</h5>';

            if (isset($result[$controller->sufix('subtitle')])) {
                $dataTbody .= '<p>'.$controller->processString($result[$controller->sufix('subtitle')], 'text').'</p>';
            }

            $dataTbody .= '</td>';

            return $dataTbody;
        };

        return ToolsTemplate::manage($controller, $query, $thead, $tbody);
    }

    public function insert()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = $forms->input($controller->sufix('title'), 'Título', $controller->value('title'));
        $page .= $forms->input($controller->sufix('subtitle'), 'Chamada', $controller->value('subtitle'), ['required' => false, 'maxlength' => 300]);
        $page .= $forms->separate();
        $page .= $forms->textarea($controller->sufix('text'), 'Texto', $controller->value('text', 'text'), ['required' => false]);
        $page .= $forms->separate();
        $page .= $forms->upload($controller->sufix('cover'), 'Imagem', null, ['required' => false, 'extension' => $this->extension, 'width' => $this->imgx, 'height' => $this->imgy]);
        $page .= $forms->separate();
        $page .= $forms->select($controller->sufix('status'), 'Status', $modules->getInputSelectStatus($controller->value('status')), ['input_col' => 'col-md-4']);

        return ToolsTemplate::insert($controller, $page);
    }

	public function module_insert()
	{
        $controller = $this->controller();
        $modules = $this->modules();

		$data = [
            $controller->sufix('title') => $controller->post($controller->sufix('title')),
            $controller->sufix('slug') => $controller->getSlug($controller->post($controller->sufix('title'))),
            $controller->sufix('subtitle') => $controller->post($controller->sufix('subtitle'), 'text'),
            $controller->sufix('text') => $controller->post($controller->sufix('text'), 'text'),
            $controller->sufix('order') => $controller->generatorOrder(),
            $controller->sufix('status') => $controller->post($controller->sufix('status'))
        ];

        $cover->config($controller->sufix('cover'), $modules->key, $controller->linkSystem());
        $cover->all('photo');
        $cover->dimensions([$this->imgx, $this->imgy]);
        $cover->load(true);

        if ($output = $cover->output('json')) {
            $data[$controller->sufix('cover')] = $output;
        }

		$controller->dataSave($data, 'insert');

		return true;
	}

    public function update()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = $forms->input($controller->sufix('title'), 'Título', $controller->value('title'));
        $page .= $forms->input($controller->sufix('subtitle'), 'Chamada', $controller->value('subtitle'), ['required' => false, 'maxlength' => 300]);
        $page .= $forms->separate();
        $page .= $forms->textarea($controller->sufix('text'), 'Texto', $controller->value('text', 'text'), ['required' => false]);
        $page .= $forms->separate();
        $page .= $forms->upload($controller->sufix('cover'), 'Imagem', $modules->getPhotoPage($controller->value('cover'), 'cover'), ['required' => false, 'extension' => $this->extension, 'width' => $this->imgx, 'height' => $this->imgy]);
        $page .= $forms->separate();
        $page .= $forms->input($controller->sufix('order'), 'Ordem', $controller->value('order'), ['type' => 'number']);
        $page .= $forms->separate();
        $page .= $forms->select($controller->sufix('status'), 'Status', $modules->getInputSelectStatus($controller->value('status')), ['input_col' => 'col-md-4']);

        return ToolsTemplate::update($controller, $page);
    }

	public function module_update()
	{
        $controller = $this->controller();
        $modules = $this->modules();

        $data = [
            $controller->sufix('title') => $controller->post($controller->sufix('title')),
            $controller->sufix('slug') => $controller->getSlug($controller->post($controller->sufix('title'))),
            $controller->sufix('subtitle') => $controller->post($controller->sufix('subtitle'), 'text'),
            $controller->sufix('text') => $controller->post($controller->sufix('text'), 'text'),
            $controller->sufix('order') => $controller->post($controller->sufix('order'), 'int'),
            $controller->sufix('status') => $controller->post($controller->sufix('status'))
        ];

        $cover = new \CoreSlim\Upload();
        $cover->config($controller->sufix('cover'), $modules->key, $controller->linkSystem());
        $cover->all('photo');
        $cover->dimensions([$this->imgx, $this->imgy]);
        $cover->load();

        if ($output = $cover->output('json')) {
            $data[$controller->sufix('cover')] = $output;
        }

		$controller->dataSave($data, 'update');

		return true;
	}

    public function importData()
    {
        \DeveloperSlim\Seeders\ServicesSeeder::seed();
    }
}
