<?php

class ModuleDoop extends ModuleMaster
{
    public $form_boolean = [
        1 => 'Sim',
        2 => 'Não'
    ];

    public $infoForm = [];

    public function __construct($controller, $operation = 'manage', $key = null)
    {
        parent::__construct($controller, $operation, 'administrator');

        $this->infoForm = [
            'god' => [
                'title' => 'Acesso total ao <b>'.config('app.LABEL_SYSTEM_NAME').'</b>, incluindo configurações avançadas.',
                'label' => '<b>ADMINISTRADOR MASTER</b>'
            ],
            'master' => [
                'title' => 'Acesso total ao <b>'.config('app.LABEL_SYSTEM_NAME').'</b>.',
                'label' => '<b>ADMINISTRADOR</b>'
            ],
            'group' => [
                'title' => 'Selecione os módulos que o usuário terá acesso no <b>'.config('app.LABEL_SYSTEM_NAME').'</b>.<br>',
                'label' => '<b>USUÁRIO</b>'
            ],
            'only' => [
                'title' => '<small><b>* REGISTROS INDIVIDUAIS:</b> Caso a opção for marcada, o usuário terá acesso apenas aos seus registros.</small>',
                'label' => '<small>REGISTROS INDIVIDUAIS</small>'
            ]
        ];

        $modules = $this->modules();

        if ($modules->operation === 'manage') {
            if ($controller->get('action') == 'setDeleteAdministrator') {
                $controller->dbQuery("DELETE FROM `mod_administrator-nivel` WHERE `administrator_nivel` = '".$controller->get('id')."'");
                $controller->dbQuery("DELETE FROM `mod_administrator-privilege` WHERE `administrator_privilege` = '".$controller->get('id')."'");
                $controller->dbQuery("DELETE FROM `trigger_login` WHERE `administrator_login` = '".$controller->get('id')."'");
                $controller->dbQuery("DELETE FROM `trigger_log` WHERE `user_log` = '".$controller->get('id')."'");

                $modules->deleteData(['deleted', $controller->get('id')], 'manage');
            }
        }

        $modules->setPage('account', [
            'action' => 'account',
            'title' => 'Minha Conta',
            'label' => 'Editar',
            'icon' => 'far fa-id-card',
            'path' => config('app.PATH_SYSTEM').'system/administrator&operation=account',
            'privilege' => 'group'
        ]);

        if ($modules->operation == 'update') {
            if ($controller->get('id') == 1 && $modules->privilege['developer'] == 2) {
                header('Location: '.$controller->link('administrator', 'manage').'&callback=permission_denied');
                exit;
            }

            if ($controller->get('id') == 2 && $modules->privilege['root'] == 2) {
                header('Location: '.$controller->link('administrator', 'manage').'&callback=permission_denied');
                exit;
            }
        }

        if ($modules->operation == 'account') {
            $modules->setTuplePrimary('id');

            $modules->dataUpdate = $modules->dataLoad(ADMINISTRATOR);

            if ($controller->post('account_action_form')) {
                $this->module_account();
            }
        }
    }

    public function manage()
    {
        $controller = $this->controller();
        $modules = $this->modules();

        $security = null;

        if (ADMINISTRATOR != 1) {
            $security = " AND `id_administrator` <> '1'";
        }

        if (ADMINISTRATOR != 1 && ADMINISTRATOR != 2) {
            $security = " AND `id_administrator` > '2'";
        }

        $query = "SELECT * FROM `".$controller->getTable()."`
                  INNER JOIN `mod_administrator-privilege` ON (`".$controller->sufix('id')."` = `administrator_privilege`)
                  ".$modules->queryFilter."
                  WHERE ".$modules->queryStatus." ".$modules->querySearch." ".$security."
                  GROUP BY `".$controller->sufix('id')."`
                  ORDER BY `developer_privilege`, `root_privilege`, `god_privilege`, `master_privilege`";

        $thead = '
        <th width="1%" class="text-center nowrap">grupo</th>
        <th>nome</th>
        <th>e-mail</th>';
        $tbody = function ($result) use ($controller) {
            if ($result['developer_privilege'] == 1) {
                $privilege = '<span class="text-danger">DEVELOPER</span>';
            }
            else if ($result['root_privilege'] == 1) {
                $privilege = '<span class="text-primary">EXPAND</span>';
            }
            else if ($result['god_privilege'] == 1) {
                $privilege = '<span class="text-warning">ADMINISTRADOR MASTER</span>';
            }
            else if ($result['master_privilege'] == 1) {
                $privilege = '<span class="text-success">ADMINISTRADOR</span>';
            }
            else {
                $privilege = '<span class="text-info">USUÁRIO</span>';
            }

            $dataTbody = '<td class="text-center"><b>'.$privilege.'</b></td>';
            $dataTbody .= '<td>'.$controller->processString($result[$controller->sufix('name')]).'</td>';
            $dataTbody .= $controller->tableEmail($result[$controller->sufix('email')]);

            return $dataTbody;
        };

        return ToolsTemplate::manage($controller, $query, $thead, $tbody);
    }

    public function insert()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = $forms->input($controller->sufix('name'), 'Nome', $controller->value('name'), ['input_group_label' => '<i class="fa fa-fw fa-user"></i>']);
        $page .= $forms->input($controller->sufix('email'), 'E-mail', $controller->value('email'), ['type' => 'email', 'input_group_label' => '<i class="fa fa-fw fa-envelope"></i>', 'cont_input' => false]);
        $page .= $forms->separate();
        $page .= $forms->input($controller->sufix('password'), 'Senha', null, ['type' => 'password', 'input_group_label' => '<i class="fa fa-fw fa-lock"></i>', 'cont_input' => false, 'input_col' => 'col col-md-4']);
        $page .= $forms->input('password_confirm', 'Confirmar Senha', null, ['type' => 'password', 'input_group_label' => '<i class="fa fa-fw fa-lock"></i>', 'cont_input' => false, 'input_col' => 'col col-md-4']);
        $page .= $forms->separate();
        $page .= $forms->input($controller->sufix('signature'), 'Assinatura', $controller->value('signature'), ['required' => false]);
        $page .= $forms->separate();
        $page .= $forms->select($controller->sufix('status'), 'Status', $modules->getInputSelectStatus($controller->value('status')), ['input_col' => 'col-md-4']);

        $page .= $forms->info($this->infoForm['god']['label'], $this->infoForm['god']['title']);
        $page .= $forms->radioBoolean('nivel_god',  $this->infoForm['god']['label'], 2, $this->form_boolean, ['required' => false]);

        $page .= '<div class="permissionsMaster">';
        $page .= $forms->info($this->infoForm['master']['label'], $this->infoForm['master']['title']);
        $page .= $forms->radioBoolean('nivel_master', $this->infoForm['master']['label'], 1, $this->form_boolean, ['required' => false]);
        $page .= '</div>';

        $page .= '<div class="permissionsModules d-none">';

        $page .= $forms->info($this->infoForm['group']['label'], $this->infoForm['group']['title'].$this->infoForm['only']['title']);

        $groupsName = Tools::jsonOpen(config('app.ROOT_CMS').'/group-modules.json', true);

        $nivel = null;

        $content = '<div class="table-responsive"><table class="table table-bordered table-doop"><tbody>';

        foreach ($modules->modulesSystem as $key => $modules) {
            if ($modules['type'] === 'primary' || $modules['type'] === 'primary-system') {
                $content .= '<tr>';
                $selected = 2;

                if ($nivel) {
                    if (array_key_exists($key, $nivel)) {
                        $selected = intval($nivel[$key]);

                        if ($selected == 0) {
                            $selected = 2;
                        }
                    }
                }

                $title = '<b>'.$groupsName[$modules['group']]['title'].' - '.$controller->processString($modules['title']).'</b>';

                $content .= '
                <td width="20%" class="text-right">
                    <p>'.$title.'</p>
                </td>';

                foreach ($this->form_boolean as $keyBool => $valueBool) {
                    $selectedRadio = 2;

                    if ($selected == $keyBool) {
                        $selectedRadio = 1;
                    }
                }

                $content .= '<td width="1%">'.$forms->radioBoolean($key,  null, 2, $this->form_boolean, ['required' => false]).'</td>';

                if ($modules['type'] === 'primary') {
                    $selectedOnly = null;

                    if (isset($only)) {
                        if (array_key_exists($key, $only)) {
                            $selectedOnly = intval($only[$key]);

                            if ($selectedOnly == 1) {
                                $selectedOnly = ' checked';
                            }
                        }
                    }

                    $content .= '
                    <td>
                        <div class="icheck-primary d-inline" title="'.strip_tags($this->infoForm['only']['title']).'">
                        <input type="checkbox" id="'.$key.'_only" name="'.$key.'_only" value="1" '.$selectedOnly.'>
                        <label for="'.$key.'_only">
                            '.$this->infoForm['only']['label'].'
                        </label>
                        </div>
                    </td>';
                }
                else {
                    $content .= '<td></td>';
                }

                $content .= '</tr>';
            }
        }

        $content .= '</tbody></table></div></div>';

        $page .= $content;

        return ToolsTemplate::insert($controller, $page);
    }

    public function module_insert()
    {
        $controller = $this->controller();
        $modules = $this->modules();

        $data = [
            $controller->sufix('name') => $controller->post($controller->sufix('name')),
            $controller->sufix('email') => $controller->post($controller->sufix('email')),
            $controller->sufix('password') => md5($controller->post($controller->sufix('password'))),
            $controller->sufix('signature') => $controller->post($controller->sufix('signature'), 'text')
        ];

        if ($controller->dataDuplicated(['email'], [$data[$controller->sufix('email')]]) == true) {
            header('Location: '.$controller->linkSystem().'&callback=400');
            exit;
        }

        $controller->dataSave($data, 'insert');

        $dataLastAdministrator = $controller->dataLast;

        $nivel = [
            'master' => $controller->getBoolean($controller->post('nivel_master')),
            'god' => $controller->getBoolean($controller->post('nivel_god'))
        ];

        if ($nivel['god'] == 1) {
            $nivel['master'] = 1;
        }

        $controller->dbQuery("INSERT INTO `mod_administrator-privilege` (`administrator_privilege`, `master_privilege`, `god_privilege`, `root_privilege`, `developer_privilege`)
                              VALUES ('".$dataLastAdministrator."', '".$nivel['master']."', '".$nivel['god']."', 2, 2)");

        if ($nivel['master'] == 2) {
            foreach ($modules->modulesSystem as $key => $module) {
                if ($module['type'] === 'primary' || $module['type'] === 'primary-system') {
                    $privilege = $controller->getBoolean($controller->post($key));
                    $only = $controller->getBoolean($controller->post($key.'_only'));

                    if (!isset($only) || $only == 2 || $only == 0 | $privilege == 2) {
                        $only = 2;
                    }

                    $controller->dbQuery("INSERT INTO `mod_administrator-nivel` (`administrator_nivel`, `module_nivel`, `privilege_nivel`, `only_nivel`)
                                          VALUES ('".$dataLastAdministrator."', '".$key."', '".$privilege."', '".$only."')");
                }
            }
        }

        return true;
    }

    public function update()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = $forms->input($controller->sufix('name'), 'Nome', $controller->value('name'), ['input_group_label' => '<i class="fa fa-fw fa-user"></i>']);
        $page .= $forms->input($controller->sufix('email'), 'E-mail', $controller->value('email'), ['type' => 'email', 'input_group_label' => '<i class="fa fa-fw fa-envelope"></i>', 'cont_input' => false]);
        $page .= $forms->separate();
        $page .= $forms->input('password_new', 'Senha', null, ['required' => false, 'type' => 'password', 'input_group_label' => '<i class="fa fa-fw fa-lock"></i>', 'cont_input' => false, 'input_col' => 'col col-md-4']);
        $page .= $forms->input('password_new_confim', 'Confirmar Senha', null, ['required' => false, 'type' => 'password', 'input_group_label' => '<i class="fa fa-fw fa-lock"></i>', 'cont_input' => false, 'input_col' => 'col col-md-4']);
        $page .= $forms->separate();
        $page .= $forms->input($controller->sufix('signature'), 'Assinatura', $controller->value('signature'), ['required' => false]);
        $page .= $forms->separate();
        $page .= $forms->select($controller->sufix('status'), 'Status', $modules->getInputSelectStatus($controller->value('status')), ['input_col' => 'col-md-4']);

        $privilege = $controller->dbFetch("SELECT * FROM `mod_administrator-privilege` WHERE `administrator_privilege` = '".$controller->value('id')."'");

        $page .= $forms->info($this->infoForm['god']['label'], $this->infoForm['god']['title']);
        $page .= $forms->radioBoolean('nivel_god',  $this->infoForm['god']['label'], $privilege['god_privilege'], $this->form_boolean, ['required' => false]);

        $godClass = 'permissionsMaster';

        if ($privilege['god_privilege'] == 1) {
            $godClass = 'permissionsMaster d-none';
        }

        $page .= '<div class="'.$godClass.'">';
        $page .= $forms->info($this->infoForm['master']['label'], $this->infoForm['master']['title']);
        $page .= $forms->radioBoolean('nivel_master', $this->infoForm['master']['label'], $privilege['master_privilege'], $this->form_boolean, ['required' => false]);
        $page .= '</div>';

        $masterClass = 'permissionsModules';

        if ($privilege['master_privilege'] != 2) {
            $masterClass = 'permissionsModules d-none';
        }

        $page .= '<div class="'.$masterClass.'">';
        $page .= $forms->info($this->infoForm['group']['label'], $this->infoForm['group']['title'].$this->infoForm['only']['title']);
        $groupsName = Tools::jsonOpen(config('app.ROOT_CMS').'/group-modules.json', true);
        $nivel = null;

        if ($queryNivel = $controller->dbFetchAll("SELECT * FROM `mod_administrator-nivel` WHERE `administrator_nivel` = '".$controller->value('id')."'")) {
            foreach ($queryNivel as $key => $resultNivel) {
                $nivel[$resultNivel['module_nivel']] = $resultNivel['privilege_nivel'];
                $only[$resultNivel['module_nivel']] = $resultNivel['only_nivel'];
            }
        }

        $content = '<div class="table-responsive"><table class="table table-bordered table-doop"><tbody>';

        foreach ($modules->modulesSystem as $key => $modules) {
            if ($modules['type'] === 'primary' || $modules['type'] === 'primary-system') {
                $content .= '<tr>';

                $content .= '
                <td width="20%" class="text-right">
                    <p><b>'.$groupsName[$modules['group']]['title'].' - '.$controller->processString($modules['title']).'</b></p>
                </td>';

                $selected = 2;

                if (isset($nivel[$key])) {
                    $selected = intval($nivel[$key]);

                    if ($selected == 0) {
                        $selected = 2;
                    }
                }

                $content .= '<td width="1%">'.$forms->radioBoolean($key,  null, $selected, $this->form_boolean, ['required' => false]).'</td>';

                if ($modules['type'] === 'primary') {
                    $selectedOnly = null;

                    if (isset($only[$key])) {
                        $selectedOnly = intval($only[$key]);

                        if ($selectedOnly == 1) {
                            $selectedOnly = ' checked';
                        }
                    }

                    $content .= '
                    <td>
                        <div class="icheck-primary d-inline" title="'.strip_tags($this->infoForm['only']['title']).'">
                        <input type="checkbox" id="'.$key.'_only" name="'.$key.'_only" value="1" '.$selectedOnly.'>
                        <label for="'.$key.'_only">'.$this->infoForm['only']['label'].'*</label>
                        </div>
                    </td>';
                }
                else {
                    $content .= '<td></td>';
                }

                $content .= '</tr>';
            }
        }

        $content .= '</tbody></table></div></div>';

        $page .= $content;

        return ToolsTemplate::update($this->controller, $page);
    }

    public function module_update()
    {
        $controller = $this->controller();
        $modules = $this->modules();

        $data = [
            $controller->sufix('name') => $controller->post($controller->sufix('name')),
            $controller->sufix('email') => $controller->post($controller->sufix('email')),
            $controller->sufix('signature') => $controller->post($controller->sufix('signature'), 'text')
        ];

        if ($data[$controller->sufix('email')] != $controller->value('email')) {
            if ($controller->dataDuplicated(['email'], [$data[$controller->sufix('email')]]) == true) {
                header('Location: '.$controller->linkSystem().'&callback=400');
                exit;
            }
        }

        if ($controller->post('password_new') != '') {
            $data[$controller->sufix('password')] = md5($controller->post('password_new'));
        }

        $controller->setValue($controller->value('uuid'));

        $controller->dataSave($data, 'update');

        $nivel = [
            'master' => $controller->getBoolean($controller->post('nivel_master')),
            'god' => $controller->getBoolean($controller->post('nivel_god'))
        ];

        if ($nivel['god'] == 1) {
            $nivel['master'] = 1;
        }

        $controller->dbQuery("UPDATE `mod_administrator-privilege` SET `master_privilege` = '".$nivel['master']."', `god_privilege` = '".$nivel['god']."' WHERE `administrator_privilege` = '".$controller->value('id')."'");

        if ($nivel['master'] == 2) {
            $controller->dbQuery("DELETE FROM `mod_administrator-nivel` WHERE `administrator_nivel` = '".$controller->value('id')."'");

            foreach ($modules->modulesSystem as $key => $module) {
                if ($module['type'] == 'primary' || $module['type'] == 'primary-system') {
                    $privilege = $controller->getBoolean($controller->post($key));
                    $only = $controller->getBoolean($controller->post($key.'_only'));

                    if (!isset($only) || $only == 2 || $only == 0 || $privilege == 2) {
                        $only = 2;
                    }

                    $controller->dbQuery("INSERT INTO `mod_administrator-nivel` (`administrator_nivel`, `module_nivel`, `privilege_nivel`, `only_nivel`)
                                          VALUES ('".$controller->value('id')."', '".$key."', '".$privilege."', '".$only."')");
                }
            }
        }

        return true;
    }

    public function account()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $modules->tabsActive['registry'] = false;
        $modules->tabsActive['developer'] = false;

        $page = $forms->input($controller->sufix('name'), 'Nome', $controller->value('name'), ['input_group_label' => '<i class="fa fa-fw fa-user"></i>']);
        $page .= $forms->input($controller->sufix('email'), 'E-mail', $controller->value('email'), ['type' => 'email', 'input_group_label' => '<i class="fa fa-fw fa-envelope"></i>', 'cont_input' => false]);
        $page .= $forms->separate();
        $page .= $forms->input($controller->sufix('signature'), 'Assinatura', $controller->value('signature'), ['required' => false]);
        $page .= $forms->separate();
        $page .= $forms->input($controller->sufix('password'), 'Senha', null, ['type' => 'password', 'input_group_label' => '<i class="fa fa-fw fa-lock"></i>', 'cont_input' => false, 'input_col' => 'col-md-4']);
        $page .= $forms->separate();
        $page .= $forms->input('password_new', 'Nova senha', null, ['required' => false, 'type' => 'password', 'input_group_label' => '<i class="fa fa-fw fa-lock"></i>', 'cont_input' => false, 'input_col' => 'col-md-4']);
        $page .= $forms->input('password_new_confim', 'Confirmar nova senha', null, ['required' => false, 'type' => 'password', 'input_group_label' => '<i class="fa fa-fw fa-lock"></i>', 'cont_input' => false, 'input_col' => 'col-md-4']);

        return ToolsTemplate::update($this->controller, $page);
    }

    public function module_account()
    {
        $controller = $this->controller();
        $modules = $this->modules();

        $oldPassword = md5($controller->post($controller->sufix('password')));

        if ($controller->dataDuplicated(['id', 'password'], [$controller->value('id'), $oldPassword]) === true) {
            $data = [
                $controller->sufix('name') => $controller->post($controller->sufix('name')),
                $controller->sufix('email') => $controller->post($controller->sufix('email')),
                $controller->sufix('signature') => $controller->post($controller->sufix('signature'), 'text')
            ];

            if ($data[$controller->sufix('email')] != $controller->value('email')) {
                if ($controller->dataDuplicated(['email'], [$data[$controller->sufix('email')]]) === true) {
                    header('Location: '.$controller->linkSystem().'&callback=400');
                    exit;
                }
            }

            if ($controller->post('password_new') != '') {
                $data[$controller->sufix('password')] = md5($controller->post('password_new'));
            }

            $controller->setValue(ADMINISTRATOR);
            $controller->setTuplePrimary('id');
            $controller->dataSave($data, 'update');

            header('Location: '.$controller->linkSystem().'&callback=506');
            exit;
        }

        header('Location: '.$controller->linkSystem().'&callback=505');
        exit;
    }
}
