<?php

class ModuleDoop extends ModuleMaster
{
    public function __construct($controller, $operation = 'manage', $key = null)
    {
		parent::__construct($controller, $operation, 'backups');

		$this->setControl('bt_delete', false);
		$this->setControl('controls_filter', false);
        $this->setControl('controls_actions', false);
		$this->setControl('controls_search', false);
		$this->setControl('controls_developer', true);

		$this->setPage('dump', [
            'action' => 'dump',
            'title' => 'Fazer backup',
            'label' => 'dumpar',
            'path' => 'system/backups&operation=dump',
            'privilege' => 'god'
        ]);

		$this->buttonExtraAuto('dump');
	}

    public function manage()
    {
        $controller = $this->controller();
        $modules = $this->modules();

        $query = "SELECT * FROM `".$controller->getTable()."`
                 ".$modules->queryFilter."
                 WHERE ".$modules->queryStatus." ".$modules->querySearch."
                 GROUP BY `".$controller->sufix('id')."`
                 ORDER BY `".$controller->sufix('time')."` DESC";

        $thead = '
        <th>Backup</th>
        <th width="1%" class="text-center">Download</th>';

        $tbody = function ($result) use ($controller, $modules) {
            $dataTbody = '<td><p>'.\Treatment::string($result[$controller->sufix('title')]).'</p>';

            $dataTbody .= '
            <td class="text-center">
                <a href="'.config('app.PATH_PUBLIC').'/backups/'.$result[$controller->sufix('file')].'" class="btn btn-xs btn-primary" title="Download" target="_blank">
                    <i class="fa fa-download mr-2"></i>Download
                </a>
            </td>';

            return $dataTbody;
        };

        $page['tableCheckLine'] = false;
        $page['tableStatus'] = false;
        $page['tableControls'] = false;

        return ToolsTemplate::manage($controller, $query, $thead, $tbody, $page);
    }

    public function dump()
    {
        $controller = $this->controller();
        $modules = $this->modules();

        $dumpSettings = [
            'compress' => \Ifsnop\Mysqldump\Mysqldump::NONE,
            'no-data' => false,
            'add-drop-table' => true,
            'single-transaction' => true,
            'lock-tables' => true,
            'add-locks' => true,
            'extended-insert' => false,
            'disable-keys' => true,
            'skip-triggers' => false,
            'add-drop-trigger' => true,
            'routines' => true,
            'databases' => false,
            'add-drop-database' => false,
            'hex-blob' => true,
            'no-create-info' => false,
            'where' => ''
        ];

        $default = config('database.default');
        $connections = config('database.connections');

        $connection = $connections[$controller->dataLang][$default];

        $dump = new \Ifsnop\Mysqldump\Mysqldump($connection['driver'].":host=".$connection['host'].";port=".$connection['port'].";dbname=".$connection['database'], $connection['username'], $connection['password'], $dumpSettings);

        $timestamp = date('Y-m-d H:i:s');
        $file = 'mysqldump-'.\Treatment::string($timestamp, 'slug').'.sql';

        $folder = config('app.ROOT_PUBLIC').'/backups';

        if (!file_exists($folder)) {
            mkdir($folder);
        }

        $dump->start($folder.'/'.$file);

        $data = [
            $controller->sufix('title') => \Treatment::string('Backup realizado em '.$controller->processDate($timestamp, 'timestamp_brazil')),
            $controller->sufix('file') => $file
        ];

        $controller->dataSave($data, 'insert');

        header('Location: '.$controller->pathLang(null, $modules->page['manage']['path'].'&callback=backup_dump'));
        exit;

    }
}
