<?php
if (!isset($_SESSION['administrator_id'])) { define('ADMINISTRATOR', 0); } else { define('ADMINISTRATOR', intval($_SESSION['administrator_id'])); }
require_once(config('app.ROOT_CMS_CORE').'/class.controller.php');
$system = new ControllerDoop('system', 'system', 'static');
?>
<!DOCTYPE html>
<html lang="pt-br">
    <head>
        <meta charset="utf-8" />
        <title><?php echo config('app.LABEL_SYSTEM_TITLE'); ?></title>
        <meta name="description" content="<?php echo config('app.LABEL_SYSTEM_DESCRIPTION'); ?>" />
        <meta name="keywords" content="<?php echo config('app.LABEL_SYSTEM_KEYWORDS'); ?>" />
        <meta name="author" content="<?php echo config('app.LABEL_SYSTEM_AUTHOR'); ?>" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <link rel="shortcut icon" href="<?php echo assets_img('favicon.png', 'painel'); ?>" />
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Source+Sans+Pro:wght@300;400;700&display=swap" rel="stylesheet">
        <script defer src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.1/js/all.min.js"></script>
        <link rel="stylesheet" href="<?php echo assets_css('core', 'painel'); ?>" />
    </head>

    <body class="hold-transition sidebar-mini layout-fixed control-sidebar-slide-open layout-navbar-fixed layout-footer-fixed">
        <div class="preloader flex-column justify-content-center align-items-center d-none">
            <img class="animation__shake" src="<?php echo assets_img('favicon.png', 'painel'); ?>" alt="<?php echo config('app.LABEL_SYSTEM_NAME'); ?>">
            <h4 class="mt-2 text-primary"><b><?php echo config('app.LABEL_SYSTEM_VERSION'); ?></b></h4>
        </div>

        <div class="wrapper">
            <?php ToolsTemplate::getBase($system); ?>
        </div>

        <script type="text/javascript">var path_cms = '<?php echo config('app.PATH_CMS'); ?>';</script>
        <script type="text/javascript">var path_upload = '<?php echo config('app.PATH_UPLOAD'); ?>';</script>
        <script type="text/javascript">var path_vendors = '<?php echo config('app.PATH_VENDORS'); ?>';</script>

        <script src="<?php echo assets_js('core', 'painel'); ?>"></script>

        <?php $system->getJavaScript(); ?>

        <?php if (isset($system->callback->typeIn)) { ?>
        <script>
            executeCallback('<?php echo $system->callback->message; ?>', '<?php echo $system->callback->typeIn; ?>');
        </script>
        <?php } ?>
    </body>
</html>
