<?php

require_once(config('app.ROOT_CMS_HELPERS').'/class.phonesInput.php');
require_once(config('app.ROOT_CMS_HELPERS').'/class.emailsInput.php');
require_once(config('app.ROOT_CMS_HELPERS').'/class.socialInput.php');

class ModuleDoop extends ModuleMaster
{
    public $form_boolean = [
        1 => 'Sim',
        2 => 'Não'
    ];

    public $form_types = [
        1 => 'Botão Maior',
        2 => 'Botão Menor'
    ];

    public $form_positions = [
        1 => 'Esquerda',
        2 => 'Direita'
    ];

    public $form_analytics = [
        1 => 'Versão UA',
        2 => 'Versão GA4',
        3 => 'Desabilitar'
    ];

    public $widthLogoHeader = 290;
    public $heightLogoHeader = 60;

    public $widthLogoFooter = 260;
    public $heightLogoFooter = 180;

    public $central = null;
    public $pageSite = null;
    public $pageInfo = null;
    public $pageSocial = null;
    public $pageAssets = null;
    public $pageAuths = null;
    public $pageScripts = null;
    public $pageConfigFormDefault = null;
    public $pageSmtp = null;
    public $pageLanguage = null;

    public $txtMultiple = null;
    public $uploadMultiple = null;

    public $dataExtraActive = false;
    public $dataCnpj = false;
    public $dataBusinessHour = false;
    public $dataAddress = true;
    public $dataPostal = false;

    public $phones = null;
    public $emails = null;
    public $socialNewtworks = null;
    public $options = null;
    public $methodAction = null;

    public function __construct($controller, $operation = 'manage', $key = null)
    {
        parent::__construct($controller, $operation, 'configuration');

        $controller = $this->controller();
        $modules = $this->modules();

        $modules->setPage('pageSite', [
            'action' => 'pageSite',
            'title' => 'Site',
            'label' => 'Salvar',
            'icon' => 'fa fa-save',
            'path' => 'configuration&operation=pageSite',
            'privilege' => 'god'
        ]);

        $modules->setPage('pageInfo', [
            'action' => 'pageInfo',
            'title' => 'Informações',
            'label' => 'Salvar',
            'icon' => 'fa fa-save',
            'path' => 'configuration&operation=pageInfo',
            'privilege' => 'god'
        ]);

        $modules->setPage('pageSocial', [
            'action' => 'pageSocial',
            'title' => 'Redes Sociais',
            'label' => 'Salvar',
            'icon' => 'fa fa-save',
            'path' => 'configuration&operation=pageSocial',
            'privilege' => 'god'
        ]);

        $modules->setPage('pageAssets', [
            'action' => 'pageAssets',
            'title' => 'Assets',
            'label' => 'Salvar',
            'icon' => 'fa fa-save',
            'path' => 'configuration&operation=pageAssets',
            'privilege' => 'god'
        ]);

        $modules->setPage('pageAuths', [
            'action' => 'pageAuths',
            'title' => 'Auths',
            'label' => 'Salvar',
            'icon' => 'fa fa-save',
            'path' => 'configuration&operation=pageAuths',
            'privilege' => 'god'
        ]);

        $modules->setPage('pageScripts', [
            'action' => 'pageScripts',
            'title' => 'Scripts',
            'label' => 'Salvar',
            'icon' => 'fa fa-save',
            'path' => 'configuration&operation=pageScripts',
            'privilege' => 'god'
        ]);

        $modules->setPage('pageConfigFormDefault', [
            'action' => 'pageConfigFormDefault',
            'title' => 'Formulário Padrão',
            'label' => 'Salvar',
            'icon' => 'fa fa-save',
            'path' => 'configuration&operation=pageConfigFormDefault',
            'privilege' => 'god'
        ]);

        $modules->setPage('pageSmtp', [
            'action' => 'pageSmtp',
            'title' => 'SMTP',
            'label' => 'Salvar',
            'icon' => 'fa fa-save',
            'path' => 'configuration&operation=pageSmtp',
            'privilege' => 'god'
        ]);

        $modules->setPage('pageLanguage', [
            'action' => 'pageLanguage',
            'title' => 'Linguagens',
            'label' => 'Salvar',
            'icon' => 'fa fa-save',
            'path' => 'configuration&operation=pageLanguage',
            'privilege' => 'developer'
        ]);

        $this->phones = new PhonesInput();
        $this->phones->operatorActive = false;

        $this->emails = new EmailsInput();
        $this->socialNewtworks = new SocialInput();

        $this->loadAssets();

        if ($modules->operation == 'pageConfigFormDefault') {
            $this->options['addCC'] = [
                'parameters' => [
                    'add' => 'adicionar c/c',
                    'delete' => 'excluir c/c'
                ],
                'itens' => [
                    'nameCC' => [
                        'label' => 'Nome',
                        'width' => '50%',
                        'type' => 'text',
                        'maxlength' => 200
                    ],
                    'emailCC' => [
                        'label' => 'E-mail',
                        'width' => '50%',
                        'type' => 'email',
                        'maxlength' => 200
                    ]
                ]
            ];
        }

        if ($modules->operation == 'pageInfo') {
            $this->options['businessHour'] = [
                'parameters' => [
                    'add' => 'adicionar horário comercial',
                    'delete' => 'excluir horário comercial'
                ],
                'itens' => [
                    'stringBusinessHour' => [
                        'label' => 'horário comercial',
                        'width' => '95%',
                        'type' => 'text',
                        'maxlength' => 200
                    ]
                ]
            ];

            $this->options['extraData'] = [
                'parameters' => [
                    'add' => 'adicionar dados extras',
                    'delete' => 'excluir dados extras'
                ],
                'itens' => [
                    'labelExtraData' => [
                        'label' => 'Label',
                        'width' => '30%',
                        'type' => 'text',
                        'maxlength' => 200
                    ],
                    'valueExtraData' => [
                        'label' => 'Valor',
                        'width' => '65%',
                        'type' => 'text',
                        'maxlength' => 200
                    ]
                ]
            ];
        }

        if ($controller->get('method')) {
            $this->methodAction = $controller->get('method');
        }

        foreach ($modules->page as $key => $value) {
            $this->{$key} = $controller->getBaseData($key);

            if ($controller->post($key.'_action_form')) {
                $labelFunction = 'edit_'.$key;
                $modules->operation = $key;

                $this->$labelFunction();
            }
        }

        if ($controller->get('deleteImagemBaseData')) {
            $this->deleteImagemBaseData();
        }
    }

    public function getData($parameter)
    {
        if (!is_null($this->{$this->modules()->operation})) {
            if (array_key_exists($parameter, $this->{$this->modules()->operation})) {
                return $this->{$this->modules()->operation}[$parameter];
            }
        }
    }

    public function loadAssets()
    {
        $uploadMultiple[] = [
            'key' => 'logoheader',
            'value' => 'file',
            'title' => 'Logotipo - Cabeçalho',
            'width' => $this->widthLogoHeader,
            'height' => $this->heightLogoHeader,
            'ext' => 'png'
        ];

        $uploadMultiple[] = [
            'key' => 'logofooter',
            'value' => 'file',
            'title' => 'Logotipo - Rodapé',
            'width' => $this->widthLogoFooter,
            'height' => $this->heightLogoFooter,
            'ext' => 'png'
        ];

        $uploadMultiple[] = [
            'key' => 'favicon',
            'value' => 'file',
            'title' => 'Favicon',
            'width' => 57,
            'height' => 57,
            'ext' => 'png'
        ];

        $uploadMultiple[] = [
            'key' => 'logoopengraph',
            'value' => 'file',
            'title' => 'Logotipo - OpenGraph - Facebook',
            'width' => 300,
            'height' => 300,
            'ext' => 'png'
        ];

        $uploadMultiple[] = [
            'key' => 'noimage',
            'value' => 'file',
            'title' => 'Nenhuma imagem',
            'width' => 800,
            'height' => 600,
            'ext' => 'jpg'
        ];

        $txtMultiple = null;

        $this->uploadMultiple = $uploadMultiple;
        $this->txtMultiple = $txtMultiple;
    }

    public function central($pageHtml, $pageTitle)
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $pageSiteActive = $pageInfoActive = $pageSocialActive = $pageAssetsActive = $pageAuthsActive = $pageScriptsActive = $pageConfigFormDefaultActive = $pageSmtpActive  = $pageLanguageActive =null;

        switch ($modules->operation) {
            case 'pageSite': $pageSiteActive = ' active'; break;
            case 'pageInfo': $pageInfoActive = ' active'; break;
            case 'pageSocial': $pageSocialActive = ' active'; break;
            case 'pageAssets': $pageAssetsActive = ' active'; break;
            case 'pageAuths': $pageAuthsActive = ' active'; break;
            case 'pageScripts': $pageScriptsActive = ' active'; break;
            case 'pageConfigFormDefault': $pageConfigFormDefaultActive = ' active'; break;
            case 'pageSmtp': $pageSmtpActive = ' active'; break;
            case 'pageLanguage': $pageLanguageActive = ' active'; break;
        }

        $page = '
        <div class="card card-primary card-outline card-outline-tabs">
            <div class="card-header p-0 border-bottom-0">
                <ul class="nav nav-tabs" id="tab_update_configuration">
                    <li class="nav-item">
                        <a class="nav-link'.$pageSiteActive.'" href="'.$controller->link('configuration', 'pageSite').'" title="Site">Site</a>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link'.$pageInfoActive.'" href="'.$controller->link('configuration', 'pageInfo').'" title="Informações">Informações</a>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link'.$pageSocialActive.'" href="'.$controller->link('configuration', 'pageSocial').'" title="Redes Sociais">Redes Sociais</a>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link'.$pageAssetsActive.'" href="'.$controller->link('configuration', 'pageAssets').'" title="Assets">Assets</a>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link'.$pageAuthsActive.'" href="'.$controller->link('configuration', 'pageAuths').'" title="Auths">Auths</a>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link'.$pageScriptsActive.'" href="'.$controller->link('configuration', 'pageScripts').'" title="Scripts">Scripts</a>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link'.$pageConfigFormDefaultActive.'" href="'.$controller->link('configuration', 'pageConfigFormDefault').'" title="Formulário Padrão">Formulário Padrão</a>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link'.$pageSmtpActive.'" href="'.$controller->link('configuration', 'pageSmtp').'" title="SMTP">SMTP</a>
                    </li>';

                    if ($modules->privilege['developer'] === 1) {
                        $page .= '
                        <li class="nav-item">
                            <a class="nav-link'.$pageLanguageActive.'" href="'.$controller->link('configuration', 'pageLanguage').'" title="Linguagens">Linguagens</a>
                        </li>';
                    }
                $page .= '
                </ul>
            </div>

            <div class="card-body">
                '.$pageHtml.'
            </div>
        </div>';

        $vars['htmlHeader'] = '<h1>'.$pageTitle.'</h1>';
        $vars['htmlNoneItens'] = 'Nenhum dado extra para esta configuração.';

        $this->breadcrumb->setLabel('pageSite', $pageTitle);

        return ToolsTemplate::clean($this->controller, $page, $vars);
    }

    public function pageSite()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = '
        <form name="update_form" class="form-horizontal form-validate" method="post" action="'.$controller->linkSystemPath().'">';
            $page .= $forms->input('title_pageSite', 'Título da Página', $this->getData('title'), ['maxlength' => 250]);
            $page .= $forms->separate();
            $page .= $forms->input('metatitle_pageSite', 'Metatag - Título', $this->getData('metatitle'), ['required' => false, 'maxlength' => 100, 'info' => 'Google exibe apenas 63 caracteres incluíndo espaços']);
            $page .= $forms->input('metadescription_pageSite', 'Metatag - Descrição', $this->getData('metadescription'), ['required' => false, 'maxlength' => 250, 'info' => 'Google exibe apenas 160 caracteres incluíndo espaços']);
            $page .= $forms->input('metakeywords_pageSite', 'Metatag - Palavras-Chave', $this->getData('metakeywords'), ['required' => false, 'maxlength' => 200]);
            $page .= $forms->separate();
            $page .= $forms->input('copyright_pageSite', 'Copyright', $this->getData('copyright'), ['maxlength' => 100]);
            $page .= $forms->separate();
            $page .= $forms->input('author_pageSite', 'Autor', config('app.AUTHOR.'), ['cont_input' => false, 'disabled' => true]);
            $page .= $forms->separate();
            $page .= '<div class="clearfix form-actions text-center">'.$modules->htmlButton().'</div>';
        $page .= '
        </form>';

        return $this->central($page, 'Configuração / Site');
    }

    public function edit_pageSite()
    {
        $data = [
            'title' => $this->post('title_pageSite', 'text'),
            'metatitle' => $this->post('metatitle_pageSite', 'text'),
            'metadescription' => $this->post('metadescription_pageSite', 'text'),
            'metakeywords' => $this->post('metakeywords_pageSite', 'text'),
            'copyright' => $this->post('copyright_pageSite', 'text')
        ];

        $this->controller()->setBaseData($this->modules()->operation, $data);

        header('Location: '.$this->controller()->linkSystemPath().'&callback=301');
        exit;
    }

    public function pageInfo()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = '
        <form name="update_form" class="form-horizontal form-validate" method="post" action="'.$controller->linkSystemPath().'" enctype="multipart/form-data">';
            $page .= $forms->input('company_pageInfo', 'Empresa', $this->getData('company'), ['required' => false, 'maxlength' => 100]);

            if ($this->dataCnpj) {
                $page .= $forms->separate();

                $page .= $forms->input('cnpj_pageInfo', 'CNPJ', $this->getData('cnpj'), ['required' => false, 'cont_input' => false, 'mask' => 'input-mask-cnpj']);
            }

            $page .= $forms->separate();

            $page .= $this->phones->showHtml($this->getData('phones'));

            $page .= $forms->separate();

            $page .= $this->emails->showHtml($this->getData('emails'));

            $page .= $forms->separate();

            if ($this->dataAddress) {
                $page .= $forms->input('address_pageInfo', 'Endereço', $this->getData('address'), ['required' => false]);
                $page .= $forms->input('district_pageInfo', 'Bairro', $this->getData('district'), ['required' => false]);

                $page .= $forms->select('state_pageInfo', 'Estado', $modules->inputSelectHtml('ibge-state', 'name', $this->getData('state')), ['required' => false, 'primary_item' => 'Selecione um estado...']);
                $page .= $forms->select('city_pageInfo', 'Cidade', $modules->inputSelectHtml('ibge-city', 'name', $this->getData('city'), null, null, " AND `state_ibge-city` = '".$this->getData('state')."'"), ['required' => false, 'primary_item' => 'Selecione uma cidade...', 'default_item' => 'Não exibir nenhum estado...']);

                $page .= $forms->input('cep_pageInfo', 'CEP', $this->getData('cep'), ['required' => false, 'mask' => 'input-mask-cep', 'cont_input' => false, 'input_col' => 'col col-md-3']);

                if ($this->dataPostal) {
                    $page .= $forms->input('postal_pageInfo', 'Caixa Postal', $this->getData('postal'), ['required' => false, 'cont_input' => false, 'input_col' => 'col col-md-3']);
                }
            }

            if ($this->dataBusinessHour) {
                $page .= $forms->separate();
                $page .= $forms->table_multiple('businessHour', 'Horário Comercial', $this->pageInfo, $this->options['businessHour'], []);
            }

            if ($this->dataExtraActive) {
                $page .= $forms->separate();
                $page .= $forms->table_multiple('extraData', 'Dados Extras', $this->pageInfo, $this->options['extraData'], []);
            }

            $page .= '
            <div class="clearfix form-actions text-center">
                '.$modules->htmlButton().'
            </div>
        </form>';

        return $this->central($page, 'Configuração / Informações');
    }

    public function edit_pageInfo()
    {
        $data = [
            'company' => $this->post('company_pageInfo', 'text'),
            'cnpj' => $this->post('cnpj_pageInfo', 'text'),
            'phones' => $this->phones->preparePhones(),
            'emails' => $this->emails->prepareEmails(),
            'address' => $this->post('address_pageInfo', 'text'),
            'district' => $this->post('district_pageInfo', 'text'),
            'cep' => $this->post('cep_pageInfo', 'text'),
            'postal' => $this->post('postal_pageInfo', 'text'),
            'state' => intval($this->post('state_pageInfo', 'text')),
            'city' => intval($this->post('city_pageInfo', 'text')),
            'stringBusinessHour' => $this->post('stringBusinessHour', 'array_explode_shift'),
            'labelExtraData' => $this->post('labelExtraData', 'array_explode_shift'),
            'valueExtraData' => $this->post('valueExtraData', 'array_explode_shift')
        ];

        $this->controller()->setBaseData($this->modules()->operation, $data);

        header('Location: '.$this->controller()->linkSystemPath().'&callback=301');
        exit;
    }

    public function pageSocial()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = '
        <form name="update_form" class="form-horizontal form-validate" method="post" action="'.$controller->linkSystemPath().'">';
            $page .= $this->socialNewtworks->showHtml($this->pageSocial);
            $page .= $forms->separate();
            $page .= '<div class="clearfix form-actions text-center">'.$modules->htmlButton().'</div>';
        $page .= '
        </form>';

        return $this->central($page, 'Configuração / Site');
    }

    public function edit_pageSocial()
    {
        $data = $this->socialNewtworks->prepareSocial();

        $this->controller()->setBaseData($this->modules()->operation, $data);

        header('Location: '.$this->controller()->linkSystemPath().'&callback=301');
        exit;
    }

    public function pageAssets()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $count = count($this->uploadMultiple);

        $page = '
        <form name="update_form" class="form-horizontal form-validate" method="post" action="'.$controller->linkSystemPath().'" enctype="multipart/form-data">';
            if ($this->uploadMultiple) {
                $i = 1;

                foreach ($this->uploadMultiple as $key => $value) {
                    $links = null;

                    if (isset($this->pageAssets[$value['key']][$value['value']])) {
                        $cover = $this->pageAssets[$value['key']][$value['value']];
                        $cover['remove'] = $controller->linkSystemPath().'&deleteImagemBaseData='.$value['key'].'-'.$value['value'];

                        $links = $modules->getPhotoPage(json_encode($cover), 'cover');
                    }

                    $page .= $forms->upload($value['key'].'_'.$value['value'].'_pageAssets', $value['title'], $links, ['required' => false, 'extension' => $value['ext'], 'width' => $value['width'], 'height' => $value['height']]);

                    if ($i < $count) {
                        $page .= $forms->separate();
                    }

                    $i++;
                }
            }
            $page .= $forms->separate();
            $page .= '<div class="clearfix form-actions text-center">'.$modules->htmlButton().'</div>';
        $page .= '
        </form>';

        return $this->central($page, 'Configuração / Assets');
    }

    public function edit_pageAssets()
    {
        $data = [];

        if ($this->uploadMultiple) {
            foreach ($this->uploadMultiple as $key => $value) {
                $upload = new \CoreSlim\Upload();
                $upload->config($value['key'].'_'.$value['value'].'_pageAssets', 'configuration', $this->controller()->linkSystemPath());
                $upload->dimensions([$value['width'], $value['height']]);
                $upload->getConfig('type', $value['ext']);
                $upload->load();

                if ($output = $upload->output('array')) {
                    $data[$value['key']][$value['value']] = $output;
                }
                else {
                    $data[$value['key']][$value['value']] = $this->pageAssets[$value['key']][$value['value']];
                }
            }
        }

        if ($this->txtMultiple) {
            foreach ($this->txtMultiple as $key => $value) {
                $data[$value['key']][$value['value']] = $this->post($value['key'].'_'.$value['value'].'_pageAssets', 'text');
            }
        }

        $this->controller()->setBaseData($this->modules()->operation, $data);

        header('Location: '.$this->controller()->linkSystemPath().'&callback=301');
        exit;
    }

    public function pageAuths()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = '
        <form name="update_form" class="form-horizontal form-validate" method="post" action="'.$controller->linkSystemPath().'">';
            $page .= $forms->radio('codetype_pageAuths', 'Google Analytics - Tipo', $this->getData('codetype'), $this->form_analytics, ['required' => false]);
            $page .= $forms->input('code_pageAuths', 'Google Analytics - Código', $this->getData('code'), ['required' => false, 'cont_input' => false]);
            $page .= $forms->separate();
            // $page .= $forms->input('apifacebook_pageAuths', 'Facebook - APPID', $this->getData('apifacebook'), ['required' => false, 'cont_input' => false]);
            // $page .= $forms->separate();
            // $page .= $forms->input('apimaps_pageAuths', 'Google Maps - TOKEN', $this->getData('apimaps'), ['required' => false, 'cont_input' => false]);
            // $page .= $forms->separate();
            $page .= $forms->radio('recaptchaactive_pageAuths', 'Recaptcha - Ativar', $this->getData('recaptchaactive'), $this->form_boolean, ['required' => false]);
            $page .= $forms->input('recaptchasecret_pageAuths', 'Recaptcha - SECRET KEY', $this->getData('recaptchasecret'), ['required' => false, 'cont_input' => false]);
            $page .= $forms->input('recaptchapublic_pageAuths', 'Recpatcha - PUBLIC KEY', $this->getData('recaptchapublic'), ['required' => false, 'cont_input' => false]);
            $page .= $forms->separate();
            $page .= $forms->radio('whatsappactive_pageAuths', 'WhatsApp - Ativar', $this->getData('whatsappactive'), $this->form_boolean, ['required' => false]);
            $page .= $forms->radio('whatsapptype_pageAuths', 'WhatsApp - Tipo ', $this->getData('whatsapptype'), $this->form_types, ['required' => false]);
            $page .= $forms->radio('whatsappposition_pageAuths', 'WhatsApp - Posição ', $this->getData('whatsappposition'), $this->form_positions, ['required' => false]);
            $page .= $forms->separate();
            $page .= $forms->input('whatsapplabel_pageAuths', 'WhatsApp - Label', $this->getData('whatsapplabel'), ['required' => false, 'maxlength' => 100]);
            $page .= $forms->phone('whatsappnumber_pageAuths', 'WhatsApp - Número', $this->getData('whatsappnumber'), ['required' => false]);
            $page .= $forms->input('whatsappmessage_pageAuths', 'WhatsApp - Mensagem', $this->getData('whatsappmessage'), ['required' => false, 'maxlength' => 300]);
            $page .= $forms->separate();
            $page .= '<div class="clearfix form-actions text-center">'.$modules->htmlButton().'</div>';
        $page .= '
        </form>';

        return $this->central($page, 'Configuração / Auths');
    }

    public function edit_pageAuths()
    {
        $data = [
            'codetype' => $this->post('codetype_pageAuths', 'int'),
            'code' => $this->post('code_pageAuths', 'text'),
            // 'apifacebook' => $this->post('apifacebook_pageAuths', 'text'),
            // 'apimaps' => $this->post('apimaps_pageAuths', 'text'),
            'recaptchaactive' => $this->post('recaptchaactive_pageAuths', 'int'),
            'recaptchasecret' => $this->post('recaptchasecret_pageAuths', 'text'),
            'recaptchapublic' => $this->post('recaptchapublic_pageAuths', 'text'),
            'whatsappactive' => $this->post('whatsappactive_pageAuths', 'int'),
            'whatsapptype' => $this->post('whatsapptype_pageAuths', 'int'),
            'whatsappposition' => $this->post('whatsappposition_pageAuths', 'int'),
            'whatsapplabel' => $this->post('whatsapplabel_pageAuths', 'text'),
            'whatsappnumber' => $this->post('whatsappnumber_pageAuths', 'text'),
            'whatsappmessage' => $this->post('whatsappmessage_pageAuths', 'text')
        ];

        $this->controller()->setBaseData($this->modules()->operation, $data);

        header('Location: '.$this->controller()->linkSystemPath().'&callback=301');
        exit;
    }

    public function pageScripts()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = '
        <form name="update_form" class="form-horizontal form-validate" method="post" action="'.$controller->linkSystemPath().'">
            <div class="row form-group">
                <label class="col-md-3 col-form-label" for="head_inicio_pageScripts">ÍNICIO TAG HEAD:</label>
                <div class="col-md-9">
                    <div class="clearfix">
                        <textarea id="head_inicio_pageScripts" name="head_inicio_pageScripts" class="form-control" rows="10">'.$controller->processString($this->getData('head_inicio'), 'code').'</textarea>
                    </div>
                </div>
            </div>

            <div class="row form-group">
                <label class="col-md-3 col-form-label" for="head_final_pageScripts">FINAL TAG HEAD:</label>
                <div class="col-md-9">
                    <div class="clearfix">
                        <textarea id="head_final_pageScripts" name="head_final_pageScripts" class="form-control" rows="10">'.$controller->processString($this->getData('head_final'), 'code').'</textarea>
                    </div>
                </div>
            </div>

            <div class="row form-group">
                <label class="col-md-3 col-form-label" for="body_inicio_pageScripts">ÍNICIO TAG BODY:</label>
                <div class="col-md-9">
                    <div class="clearfix">
                        <textarea id="body_inicio_pageScripts" name="body_inicio_pageScripts" class="form-control" rows="10">'.$controller->processString($this->getData('body_inicio'), 'code').'</textarea>
                    </div>
                </div>
            </div>

            <div class="row form-group">
                <label class="col-md-3 col-form-label" for="body_final_pageScripts">FINAL TAG BODY:</label>
                <div class="col-md-9">
                    <div class="clearfix">
                        <textarea id="body_final_pageScripts" name="body_final_pageScripts" class="form-control" rows="10">'.$controller->processString($this->getData('body_final'), 'code').'</textarea>
                    </div>
                </div>
            </div>';
            $page .= $forms->separate();
            $page .= '<div class="clearfix form-actions text-center">'.$modules->htmlButton().'</div>';
        $page .= '
        </form>';

        return $this->central($page, 'Configuração / Scripts');
    }

    public function edit_pageScripts()
    {
        $data = [
            'head_inicio' => $this->controller()->post('head_inicio_pageScripts', 'code'),
            'head_final' => $this->controller()->post('head_final_pageScripts', 'code'),
            'body_inicio' => $this->controller()->post('body_inicio_pageScripts', 'code'),
            'body_final' => $this->controller()->post('body_final_pageScripts', 'code')
        ];

        $this->controller()->setBaseData($this->modules()->operation, $data);

        header('Location: '.$this->controller()->linkSystemPath().'&callback=301');
        exit;
    }

    public function pageConfigFormDefault()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = '
        <form name="update_form" class="form-horizontal form-pageConfigFormDefault" method="post" action="'.$controller->linkSystemPath().'">';
            $page .= $forms->input('header_pageConfigFormDefault', 'Cabeçalho do E-mail', $this->getData('header'), ['maxlength' => 100]);
            $page .= $forms->separate();
            $page .= $forms->input('nameFrom_pageConfigFormDefault', 'Remetente/Nome', $this->getData('nameFrom'), ['maxlength' => 100]);
            $page .= $forms->input('emailFrom_pageConfigFormDefault', 'Remetente/E-mail', $this->getData('emailFrom'), ['cont_input' => false]);
            $page .= $forms->separate();
            $page .= $forms->input('nameTo_pageConfigFormDefault', 'Destinatário/Nome', $this->getData('nameTo'), ['maxlength' => 100]);
            $page .= $forms->input('emailTo_pageConfigFormDefault', 'Destinatário/E-mail', $this->getData('emailTo'), ['cont_input' => false]);
            $page .= $forms->separate();
            $page .= $forms->table_multiple('addCC', 'Cópias', $this->pageConfigFormDefault, $this->options['addCC'], []);
            $page .= $forms->separate();
            $page .= '<div class="clearfix form-actions text-center">'.$modules->htmlButton().'</div>';
        $page .= '
        </form>';

        return $this->central($page, 'Configuração / Formulário Padrão');
    }

    public function edit_pageConfigFormDefault()
    {
        $data = [
            'header' => $this->controller()->post('header_pageConfigFormDefault', 'text'),
            'nameFrom' => $this->controller()->post('nameFrom_pageConfigFormDefault', 'text'),
            'emailFrom' => $this->controller()->post('emailFrom_pageConfigFormDefault', 'email'),
            'nameTo' => $this->controller()->post('nameTo_pageConfigFormDefault', 'text'),
            'emailTo' => $this->controller()->post('emailTo_pageConfigFormDefault', 'email'),
            'nameCC' => $this->controller()->post('nameCC', 'array_explode_shift'),
            'emailCC' => $this->controller()->post('emailCC', 'array_explode_shift')
        ];

        $this->controller()->setBaseData($this->modules()->operation, $data);

        header('Location: '.$this->controller()->linkSystemPath().'&callback=301');
        exit;
    }

    public function pageSmtp()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = '
        <form name="update_form" class="form-horizontal form-pageSmtp" method="post" action="'.$controller->linkSystemPath().'">';
            $page .= $forms->input('host_pageSmtp', 'SMTP - HOST', $this->getData('host'), ['cont_input' => false]);
            $page .= $forms->input('port_pageSmtp', 'SMTP - PORTA', $this->getData('port'), ['cont_input' => false]);
            $page .= $forms->input('secure_pageSmtp', 'SMTP - SEGURANÇA', $this->getData('secure'), ['cont_input' => false]);
            $page .= $forms->input('user_pageSmtp', 'SMTP - USUÁRIO', $this->getData('user'), ['cont_input' => false]);
            $page .= $forms->password('password_pageSmtp', 'SMTP - SENHA', $this->getData('password'));
            $page .= $forms->separate();
            $page .= '<div class="clearfix form-actions text-center">'.$modules->htmlButton().'</div>';
        $page .= '
        </form>';

        return $this->central($page, 'Configuração / SMTP');
    }

    public function edit_pageSmtp()
    {
        $data = [
            'host' => $this->post('host_pageSmtp', 'text'),
            'port' => $this->post('port_pageSmtp', 'text'),
            'secure' => $this->post('secure_pageSmtp', 'text'),
            'user' => $this->post('user_pageSmtp', 'text'),
            'password' => $this->post('password_pageSmtp', 'text')
        ];

        $this->controller()->setBaseData($this->modules()->operation, $data);

        header('Location: '.$this->controller()->linkSystemPath().'&callback=301');
        exit;
    }

    public function pageLanguage()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = '
        <form name="update_form" class="form-horizontal form-validate" method="post" action="'.$controller->linkSystemPath().'">
            <div class="row form-group">
                <label class="col-md-3 col-form-label">Linguagens:</label>
                    <div class="col-md-9">
                        <div class="table-responsive">
                            <table class="table table-striped table-bordered table-hover">
                                <thead>
                                    <tr>
                                        <th colspan="8"><a class="blue" href="#language" data-command="language" onclick="$.addLine(this);"><i class="fa fa-plus"></i> Adicionar Linguagem</a></th>
                                    </tr>
                                </thead>

                                <thead>
                                    <tr>
                                        <th>Título</th>
                                        <th>Key url</th>
                                        <th>iso</th>
                                        <th>Bandeira</th>
                                        <th>Status</th>
                                        <th colspan="2">Excluir</th>
                                    </tr>
                                </thead>

                                <tbody id="language">
                                <tr id="line_1" class="d-none">
                                    <td width="30%">
                                        <input type="text" name="title_pageLanguage[]" class="form-control" placeholder="Título" maxlength="20" />
                                    </td>

                                    <td width="20%">
                                        <input type="text" name="key_pageLanguage[]" class="form-control" placeholder="Key" maxlength="20" />
                                    </td>

                                    <td width="20%">
                                        <input type="text" name="iso_pageLanguage[]" class="form-control" placeholder="Key" maxlength="20" />
                                    </td>

                                    <td width="20%">
                                        <input type="text" name="flag_pageLanguage[]" class="form-control" placeholder="Bandeira" maxlength="20" />
                                    </td>

                                    <td width="10%">
                                        <select id="status_1" name="status_pageLanguage[]" class="form-control">
                                            <option value="" selected>Status</option>
                                            <option value="1">Sim</option>
                                            <option value="2">Não</option>
                                        </select>
                                    </td>

                                    <td width="5%">
                                        <a class="blue" href="#language" data-command="language" title="Excluir Linguagem" onclick="$.removeLine(this);">
                                            <i class="fa fa-trash icon-only bigger-130"></i>
                                        </a>
                                    </td>
                                </tr>';

                                if ($this->pageLanguage) {
                                    $title = $this->getData('langtitle');
                                    $lang = $this->getData('langkey');
                                    $iso = $this->getData('isokey');
                                    $flag = $this->getData('flagkey');
                                    $status = $this->getData('statuskey');

                                    foreach ($title as $key => $value) {
                                        $selectIn1 = $selectIn2 = '';

                                        if ($status[$key] == 1) {
                                            $selectIn1 = ' selected';
                                        }

                                        if ($status[$key] == 2) {
                                            $selectIn2 = ' selected';
                                        }

                                        $keyIn = $key+2;

                                        $page .= '
                                        <tr id="line_'.$keyIn.'">
                                            <td width="30%">
                                                <input type="text" name="title_pageLanguage[]" class="form-control" placeholder="Título" maxlength="20" value="'.$controller->processString($title[$key], 'text').'" />
                                            </td>

                                            <td width="20%">
                                                <input type="text" name="key_pageLanguage[]" class="form-control" placeholder="Key" maxlength="20" value="'.$controller->processString($lang[$key], 'text').'" />
                                            </td>

                                            <td width="20%">
                                                <input type="text" name="iso_pageLanguage[]" class="form-control" placeholder="Código ISO" maxlength="20" value="'.$controller->processString($iso[$key], 'text').'" />
                                            </td>

                                            <td width="20%">
                                                <input type="text" name="flag_pageLanguage[]" class="form-control" placeholder="Bandeira" maxlength="20" value="'.$controller->processString($flag[$key], 'text').'" />
                                            </td>

                                            <td width="10%">
                                                <select name="status_pageLanguage[]" class="form-control">
                                                    <option value="1"'.$selectIn1.'>Sim</option>
                                                    <option value="2"'.$selectIn2.'>Não</option>
                                                </select>
                                            </td>

                                            <td width="5%">
                                                <a class="blue" href="#language" data-command="language" title="Excluir Linguagem" onclick="$.removeLine(this);">
                                                    <i class="fa fa-trash icon-only bigger-130"></i>
                                                </a>
                                            </td>
                                        </tr>';
                                    }
                                }
                            $page .= '
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>';

            $page .= $forms->separate();
            $page .= '<div class="clearfix form-actions text-center">'.$modules->htmlButton().'</div>';
        $page .= '
        </form>';

        return $this->central($page, 'Configuração / Linguages');
    }

    public function edit_pageLanguage()
    {
        $data = [
            'langtitle' => $this->controller()->post('title_pageLanguage', 'array_explode_shift'),
            'langkey' => $this->controller()->post('key_pageLanguage', 'array_explode_shift'),
            'isokey' => $this->controller()->post('iso_pageLanguage', 'array_explode_shift'),
            'flagkey' => $this->controller()->post('flag_pageLanguage', 'array_explode_shift'),
            'statuskey' => $this->controller()->post('status_pageLanguage', 'array_explode_shift')
        ];

        $this->controller()->setBaseData($this->modules()->operation, $data);

        header('Location: '.$this->controller()->linkSystemPath().'&callback=301');
        exit;
    }

    public function deleteImagemBaseData()
    {
        list($key, $file) = explode('-', $this->controller()->get('deleteImagemBaseData'));

        $this->modules()->operation = 'pageAssets';

        $file = config('app.ROOT_UPLOAD').'/configuration/images/default/'.$this->pageAssets[$key]['file']['name'];

        if (file_exists($file)) {
            unlink($file);
        }

        $vars = explode('.', $this->pageAssets[$key]['file']['name']);

        $hashImage = $vars[0];
        $extensionImageReal = $vars[1];

        $pathWebp = config('app.ROOT_UPLOAD').'/configuration/images/default/'.$hashImage.'.webp';

        if (file_exists($pathWebp)) {
            unlink($pathWebp);
        }

        $this->pageAssets[$key]['file'] = null;

        $this->controller()->setBaseData($this->modules()->operation, $this->pageAssets);

        header('Location: '.$this->controller()->linkSystemPath().'&callback=301');
        exit;
    }
}
