CREATE TABLE `sub_anexx` (
  `id_anexx` int NOT NULL,
  `uuid_anexx` binary(36) NOT NULL,
  `table_anexx` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `tuple_anexx` int NOT NULL,
  `file_anexx` json DEFAULT NULL,
  `legend_anexx` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order_anexx` int DEFAULT '1',
  `download_anexx` bigint DEFAULT '0',
  `user_anexx` int DEFAULT '1',
  `time_anexx` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_anexx` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `status_anexx` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'disabled'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `sub_audio` (
  `id_audio` int NOT NULL,
  `uuid_audio` binary(36) NOT NULL,
  `table_audio` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `tuple_audio` int NOT NULL,
  `file_audio` json DEFAULT NULL,
  `legend_audio` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order_audio` int DEFAULT '1',
  `download_audio` bigint DEFAULT '0',
  `user_audio` int DEFAULT '1',
  `time_audio` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_audio` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `status_audio` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'disabled'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `sub_config` (
  `id_config` int NOT NULL,
  `uuid_config` binary(36) NOT NULL,
  `table_config` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `tuple_config` int NOT NULL,
  `seo_config` json DEFAULT NULL,
  `auths_config` json DEFAULT NULL,
  `scripts_config` json DEFAULT NULL,
  `user_config` int DEFAULT '1',
  `time_config` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_config` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `status_config` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'disabled'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `sub_photo` (
  `id_photo` int NOT NULL,
  `uuid_photo` binary(36) NOT NULL,
  `table_photo` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `tuple_photo` int NOT NULL,
  `file_photo` json DEFAULT NULL,
  `legend_photo` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `credit_photo` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order_photo` int DEFAULT '1',
  `download_photo` bigint DEFAULT '0',
  `user_photo` int DEFAULT '1',
  `time_photo` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_photo` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `status_photo` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'disabled'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `sub_video` (
  `id_video` int NOT NULL,
  `uuid_video` binary(36) NOT NULL,
  `table_video` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `tuple_video` int NOT NULL,
  `tag_video` json DEFAULT NULL,
  `legend_video` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `credit_video` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order_video` int DEFAULT '1',
  `user_video` int DEFAULT '1',
  `time_video` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_video` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `status_video` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'disabled'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

ALTER TABLE `sub_anexx`
  ADD PRIMARY KEY (`id_anexx`),
  ADD UNIQUE KEY `uuid_anexx` (`uuid_anexx`),
  ADD KEY `table_anexx` (`table_anexx`),
  ADD KEY `tuple_anexx` (`tuple_anexx`),
  ADD KEY `user_anexx` (`user_anexx`);

ALTER TABLE `sub_audio`
  ADD PRIMARY KEY (`id_audio`),
  ADD UNIQUE KEY `uuid_audio` (`uuid_audio`),
  ADD KEY `table_audio` (`table_audio`),
  ADD KEY `tuple_audio` (`tuple_audio`),
  ADD KEY `user_audio` (`user_audio`);

ALTER TABLE `sub_config`
  ADD PRIMARY KEY (`id_config`),
  ADD UNIQUE KEY `uuid_config` (`uuid_config`),
  ADD KEY `table_config` (`table_config`),
  ADD KEY `tuple_config` (`tuple_config`),
  ADD KEY `user_config` (`user_config`);

ALTER TABLE `sub_photo`
  ADD PRIMARY KEY (`id_photo`),
  ADD UNIQUE KEY `uuid_photo` (`uuid_photo`),
  ADD KEY `tuple_photo` (`tuple_photo`),
  ADD KEY `user_photo` (`user_photo`);

ALTER TABLE `sub_video`
  ADD PRIMARY KEY (`id_video`),
  ADD UNIQUE KEY `uuid_video` (`uuid_video`),
  ADD KEY `table_video` (`table_video`),
  ADD KEY `tuple_video` (`tuple_video`),
  ADD KEY `user_video` (`user_video`);

ALTER TABLE `sub_anexx`
  MODIFY `id_anexx` int NOT NULL AUTO_INCREMENT;

ALTER TABLE `sub_audio`
  MODIFY `id_audio` int NOT NULL AUTO_INCREMENT;

ALTER TABLE `sub_config`
  MODIFY `id_config` int NOT NULL AUTO_INCREMENT;

ALTER TABLE `sub_photo`
  MODIFY `id_photo` int NOT NULL AUTO_INCREMENT;

ALTER TABLE `sub_video`
  MODIFY `id_video` int NOT NULL AUTO_INCREMENT;
COMMIT;
