CREATE TABLE `sis_base` (
  `id_base` int NOT NULL,
  `uuid_base` binary(36) NOT NULL,
  `key_base` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `value_base` json DEFAULT NULL,
  `time_base` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_base` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `trigger_log` (
  `id_log` bigint NOT NULL,
  `type_log` enum('insert','update','status') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `table_log` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tuple_log` int DEFAULT NULL,
  `command_log` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `extra_log` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `info_log` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `ip_log` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_log` int NOT NULL DEFAULT '1',
  `time_log` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `trigger_login` (
  `id_login` int NOT NULL,
  `administrator_login` int NOT NULL,
  `ip_login` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `entry_login` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `output_login` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

ALTER TABLE `sis_base`
  ADD PRIMARY KEY (`id_base`),
  ADD UNIQUE KEY `uuid_base` (`uuid_base`);

ALTER TABLE `trigger_log`
  ADD PRIMARY KEY (`id_log`),
  ADD KEY `tuple_log` (`tuple_log`),
  ADD KEY `user_log` (`user_log`);

ALTER TABLE `trigger_login`
  ADD PRIMARY KEY (`id_login`),
  ADD KEY `administrator_login` (`administrator_login`);

ALTER TABLE `sis_base`
  MODIFY `id_base` int NOT NULL AUTO_INCREMENT;

ALTER TABLE `trigger_log`
  MODIFY `id_log` bigint NOT NULL AUTO_INCREMENT;

ALTER TABLE `trigger_login`
  MODIFY `id_login` int NOT NULL AUTO_INCREMENT;
COMMIT;
