<?php
require_once(config('app.ROOT_CMS_CORE').'/class.submodule.php');

$params['table'] = $module->getTable();
$params['tuple'] = $module->value('id');
$params['folder'] =  $module->modules->key;

$anexx = new SubmoduleDoop('anexx', $module->linkSystem(), $params);

if ($anexx->post('insert_action_form_anexx')) { $anexx->sub_insert(); }
if ($anexx->post('update_action_form_anexx')) { $anexx->sub_update(); }

$dataTabAnexx = $anexx->modules->htmlHeader();

if (!$anexx->get($anexx->active)) {
    $dataTabAnexx .= '
    <form name="insert_anexx_form" class="form-horizontal form-validate-anexx" method="post" action="'.$anexx->newPath.'" enctype="multipart/form-data">
        <div class="row form-group">
            <label class="col-md-3 col-form-label" for="'.$anexx->modules->sufix('file').'">Anexos:  <sup class="text-danger" title="Obrigatório">(*)</sup></label>
            <div class="col-md-9">
                <div class="custom-file">
                    <input type="file" id="'.$anexx->modules->sufix('file').'" name="'.$anexx->modules->sufix('file').'[]" class="custom-file-input" value="" multiple="multiple" required>
                    <label class="custom-file-label" for="'.$anexx->modules->sufix('file').'" data-browse="SELECIONAR">Nenhum arquivo selecionado</label>
                </div>
                <small>[ pdf, zip, rar, imagens, word, excel, powerpoint ] [ Máximo: 80MB ]</small>
            </div>
        </div>
        <hr>
        <div class="text-center">
            <button id="insert_action_form_anexx" name="insert_action_form_anexx" class="btn btn-primary" type="submit" value="inserir anexos">
                <i class="fa fa-plus mr-2"></i> inserir anexos
            </button>
        </div>
    </form>';
}

$limit = 20;
$query = "SELECT * FROM `".$anexx->getTable()."`
          WHERE `".$anexx->modules->sufix('table')."` = '".$module->getTable()."' AND `".$anexx->modules->sufix('tuple')."` = '".$module->value('id')."' AND `".$anexx->modules->sufix('status')."` = 'active'
          GROUP BY `".$anexx->modules->sufix('id')."`
          ORDER BY `".$anexx->modules->sufix('order')."` DESC";

$paginationConfig = lang('site::default.pagination');
$paginationConfig[1] = 'paginaExtraAnexx';
$paginationConfig[7] = 'paginaExtraAnexx-1';

$pagination = new \CoreSlim\PaginationGet([
    'locale' => $paginationConfig,
    'item' => $limit,
    'query' => $query
]);

$queryData = $pagination->execute();

$paginationData = $anexx->dbFetchAll($queryData);

if (is_array($paginationData) && count($paginationData) > 0) {
    $dataTabAnexx .= '
    <hr>

    <form name="update_anexx_form" class="form-horizontal form-validate-anexx-update" method="post" action="'.$anexx->newPath.'" enctype="multipart/form-data">
        <div class="form-submodule-top mb-3">
            '.ToolsTemplate::navigation($pagination->total, $pagination->navigation(null, null, '#anexx')).'

            <div class="btn-group">
                <a href="'.$anexx->newPath.'&action=deleteAllItens&anexx=module#anexx" id="deleteAll_anexx" name="deleteAll_anexx" class="btn btn-danger alert-action-default" value="Excluir tudo">
                     <i class="fa fa-times mr-2"></i> excluir tudo
                </a>

                <button id="updateAll_anexx" name="updateAll_anexx" class="btn btn-success" type="submit" value="Salvar dados">
                    <i class="fa fa-save mr-2"></i> salvar dados
                </button>
            </div>
        </div>

        <div class="table-responsive">
            <table class="table table-striped table-bordered table-hover table-doop">
                <thead>
                    <tr>
                        <th width="1%" class="text-center">anexo</th>
                        <th>legenda</th>
                        <th width="10%" class="text-center">ordem</th>
                        <th width="2%" class="text-center">download</th>
                        <th width="1%" class="text-center"><i class="fa fa-cubes cursor-default" title="Controles"></i></th>
                    </tr>
                </thead>
                <tbody>';
                    foreach ($paginationData as $key => $result) {
                        $id = $result[$anexx->modules->sufix('id')];

                        $file = $result[$anexx->modules->sufix('file')];

                        if (@json_decode($file)) {
                            $dataAnexx = json_decode($file, true);
                        }

                        $dataTabAnexx .= '
                        <tr>
                            <td class="text-center">'.$anexx->getAnexxSub($result).'</td>
                            <td><input type="text" id="legend_anexx_'.$id.'" name="legend_anexx_'.$id.'" class="form-control" maxlength="100" value="'.$anexx->processString($result[$anexx->modules->sufix('legend')]).'" placeholder="ATENÇÃO: O nome exibido no site será '.$dataAnexx['realname'].', para alterá-lo, digite uma legenda..." /></td>
                            <td class="text-center"><input type="number" id="order_anexx_'.$id.'" name="order_anexx_'.$id.'" class="form-control text-center" maxlength="100" value="'.$anexx->processString($result[$anexx->modules->sufix('order')]).'" /></td>
                            <td class="text-center">'.$anexx->getDownloadNumber($result[$anexx->modules->sufix('download')]).'</td>
                            <td class="text-center">'.$anexx->modules->htmlActionUnique($result, $anexx->active).'</td>
                        </tr>';
                    }

                $dataTabAnexx .= '
                </tbody>
            </table>
        </div>
    </form>';
}

return $dataTabAnexx;
