<?php
require_once(config('app.ROOT_CMS_CORE').'/class.submodule.php');

$params['table'] = $module->getTable();
$params['tuple'] = $module->value('id');
$params['folder'] =  $module->modules->key;

$audio = new SubmoduleDoop('audio', $module->linkSystem(), $params);

if ($audio->post('insert_action_form_audio')) { $audio->sub_insert(); }
if ($audio->post('update_action_form_audio')) { $audio->sub_update(); }

$dataTabAudio = $audio->modules->htmlHeader();

if(!$audio->get($audio->active)) {
    $dataTabAudio .= '
    <form name="insert_audio_form" class="form-horizontal form-validate-audio" method="post" action="'.$audio->newPath.'" enctype="multipart/form-data">
        <div class="row form-group">
            <label class="col-md-3 col-form-label" for="'.$audio->modules->sufix('file').'">Áudios: <sup class="text-danger" title="Obrigatório">(*)</sup></label>
            <div class="col-md-9">
                <div class="custom-file">
                    <input type="file" id="'.$audio->modules->sufix('file').'" name="'.$audio->modules->sufix('file').'[]" class="custom-file-input" value="" multiple="multiple" required>
                    <label class="custom-file-label" for="'.$audio->modules->sufix('file').'" data-browse="SELECIONAR">Nenhum arquivo selecionado</label>
                </div>
                <small>[ mp3 ][ Máximo: 80MB ]</small>
            </div>
        </div>
        <hr>
        <div class="text-center">
            <button id="insert_action_form_audio" name="insert_action_form_audio" class="btn btn-primary" type="submit" value="inserir áudios">
                <i class="fa fa-plus mr-2"></i> inserir áudios
            </button>
        </div>
    </form>';
}

$limit = 20;
$query = "SELECT * FROM `".$audio->getTable()."`
          WHERE `".$audio->modules->sufix('table')."` = '".$module->getTable()."' AND `".$audio->modules->sufix('tuple')."` = '".$module->value('id')."' AND `".$audio->modules->sufix('status')."` = 'active'
          GROUP BY `".$audio->modules->sufix('id')."`
          ORDER BY `".$audio->modules->sufix('order')."` DESC";

$paginationConfig = lang('site::default.pagination');
$paginationConfig[1] = 'paginaExtraAudio';
$paginationConfig[7] = 'paginaExtraAudio-1';

$pagination = new \CoreSlim\PaginationGet([
    'locale' => $paginationConfig,
    'item' => $limit,
    'query' => $query
]);

$queryData = $pagination->execute();

$paginationData = $audio->dbFetchAll($queryData);

if (is_array($paginationData) && count($paginationData) > 0) {
    $dataTabAudio .= '
    <hr>

    <form name="update_audio_form" class="form-horizontal form-validate-audio-update" method="post" action="'.$audio->newPath.'" enctype="multipart/form-data">
        <div class="form-submodule-top mb-3">
            '.ToolsTemplate::navigation($pagination->total, $pagination->navigation(null, null, '#audio')).'

            <div class="btn-group">
                <a href="'.$audio->newPath.'&action=deleteAllItens&audio=module#audio" id="deleteAll_audio" name="deleteAll_audio" class="btn btn-danger alert-action-default" value="Excluir tudo">
                    <i class="fa fa-times mr-2"></i> excluir tudo
                </a>

                <button id="updateAll_audio" name="updateAll_audio" class="btn btn-success" type="submit" value="Salvar dados">
                    <i class="fa fa-save mr-2"></i> salvar dados
                </button>
            </div>
        </div>

        <div class="table-responsive">
            <table class="table table-striped table-bordered table-hover table-doop">
                <thead>
                    <tr>
                        <th width="1%" class="center">áudio</th>
                        <th>legenda</th>
                        <th width="10%" class="center">ordem</th>
                        <th width="1%" class="center"><i class="fa fa-cubes cursor-default" title="Controles"></i></th>
                    </tr>
                </thead>
                <tbody>';
                    foreach ($paginationData as $key => $result) {
                        $id = $result[$audio->modules->sufix('id')];

                        $dataTabAudio .= '
                        <tr>
                            <td class="center">'.$audio->getAudioSub($result[$audio->modules->sufix('file')]).'</td>
                            <td><input type="text" id="legend_audio_'.$id.'" name="legend_audio_'.$id.'" class="form-control" maxlength="100" value="'.$audio->processString($result[$audio->modules->sufix('legend')]).'" placeholder="Digite a legenda do aúdio..." /></td>
                            <td class="center"><input type="number" id="order_audio_'.$id.'" name="order_audio_'.$id.'" class="form-control text-center" maxlength="100" value="'.$audio->processString($result[$audio->modules->sufix('order')]).'" /></td>
                            <td class="center">'.$audio->modules->htmlActionUnique($result, $audio->active).'</td>
                        </tr>';
                    }
                $dataTabAudio .= '
                </tbody>
            </table>
        </div>
    </form>';
}

return $dataTabAudio;
