<?php
require_once(config('app.ROOT_CMS_CORE').'/class.submodule.php');

$config = new SubmoduleDoop('config', $module->linkSystem());
$config->dataSubmodule['table'] = $module->getTable();
$config->dataSubmodule['tuple'] = $module->value('id');
$config->dataSubmodule['folder'] = str_replace('-', '/', $module->modules->key);
$config->loadDataConfig();

if ($config->post('update_action_form_config')) {
    $config->sub_update();
}

$dataTabConfig = $config->modules->htmlHeader();

$dataTabConfig .= '
<form name="update_form_config" class="form-horizontal form-validate-config" method="post" action="'.$config->newPath.'">
    <div class="card card-body bg-light">
        <h5 class="mb-0">Metatags (SEO)</h5>
    </div>

    <div class="row form-group">
        <label class="col-md-3 col-form-label" for="'.$config->sufix('seo_title').'">Metatag - Título:</label>
        <div class="col-md-6">
            <div class="clearfix">
                <input type="text" id="'.$config->sufix('seo_title').'" name="'.$config->sufix('seo_title').'" class="form-control cont-input" maxlength="100" value="'.$config->config['seo']['title'].'" placeholder="Digite aqui o título..." />
            </div>
        </div>
        <span class="col-md-3 help-inline">
            <small><span class="middle" id="'.$config->sufix('cont_seo_title').'">[ máximo 100 caracteres ]</span><br><em>Google exibe apenas 63 caracteres incluíndo espaços</em></small>
        </span>
    </div>

    <div class="row form-group">
        <label class="col-md-3 col-form-label" for="'.$config->sufix('seo_description').'">Metatag - Descrição:</label>
        <div class="col-md-6">
            <div class="clearfix">
                <input type="text" id="'.$config->sufix('seo_description').'" name="'.$config->sufix('seo_description').'" class="form-control cont-input" maxlength="250" value="'.$config->config['seo']['description'].'" placeholder="Digite aqui a descrição..." />
            </div>
        </div>
        <span class="col-md-3 help-inline">
            <small><span class="middle" id="'.$config->sufix('cont_seo_description').'">[ máximo 250 caracteres ]</span><br><em>Google exibe apenas 160 caracteres incluíndo espaços</em></small>
        </span>
    </div>

    <div class="row form-group">
        <label class="col-md-3 col-form-label" for="'.$config->sufix('seo_keywords').'">Metatag - Palavras-Chave:</label>
        <div class="col-md-6">
            <div class="clearfix">
                <input type="text" id="'.$config->sufix('seo_keywords').'" name="'.$config->sufix('seo_keywords').'" class="form-control cont-input" maxlength="200" value="'.$config->config['seo']['keywords'].'"  placeholder="Digite aqui as palavras-chaves..." />
            </div>
        </div>
        <span class="col-md-3 help-inline">
            <small><span class="middle" id="'.$config->sufix('cont_seo_keywords').'">[ máximo 200 caracteres ]</span><br><em>Insira as palavras separadas por vírgula</em></small>
        </span>
    </div>

    <div class="card card-body bg-light">
        <h5 class="mb-0">Scripts Externos (Pixel)</h5>
    </div>

    <div class="row form-group">
        <label class="col-md-3 col-form-label" for="'.$config->sufix('scripts_head_inicio').'">ÍNICIO TAG HEAD:</label>
        <div class="col-md-9">
            <div class="clearfix">
                <textarea id="'.$config->sufix('scripts_head_inicio').'" name="'.$config->sufix('scripts_head_inicio').'" class="form-control" rows="10">'.$config->config['scripts']['head_inicio'].'</textarea>
            </div>
        </div>
    </div>

    <div class="row form-group">
        <label class="col-md-3 col-form-label" for="'.$config->sufix('scripts_head_final').'">FINAL TAG HEAD:</label>
        <div class="col-md-9">
            <div class="clearfix">
                <textarea id="'.$config->sufix('scripts_head_final').'" name="'.$config->sufix('scripts_head_final').'" class="form-control" rows="10">'.$config->config['scripts']['head_final'].'</textarea>
            </div>
        </div>
    </div>

    <div class="row form-group">
        <label class="col-md-3 col-form-label" for="'.$config->sufix('scripts_body_inicio').'">ÍNICIO TAG BODY:</label>
        <div class="col-md-9">
            <div class="clearfix">
                <textarea id="'.$config->sufix('scripts_body_inicio').'" name="'.$config->sufix('scripts_body_inicio').'" class="form-control" rows="10">'.$config->config['scripts']['body_inicio'].'</textarea>
            </div>
        </div>
    </div>

    <div class="row form-group">
        <label class="col-md-3 col-form-label" for="'.$config->sufix('scripts_body_final').'">FINAL TAG BODY:</label>
        <div class="col-md-9">
            <div class="clearfix">
                <textarea id="'.$config->sufix('scripts_body_final').'" name="'.$config->sufix('scripts_body_final').'" class="form-control" rows="10">'.$config->config['scripts']['body_final'].'</textarea>
            </div>
        </div>
    </div>

    <hr>

    <div class="text-center">
        <button id="update_action_form_config" name="update_action_form_config" class="btn btn-primary" type="submit" value="Salvar configuração">
            <i class="fa fa-save mr-2"></i> salvar configuração
        </button>
    </div>
</form>';

return $dataTabConfig;
