<?php
require_once(config('app.ROOT_CMS_CORE').'/class.submodule.php');

$params['table'] = $module->getTable();
$params['tuple'] = $module->value('id');
$params['folder'] =  $module->modules->key;

$video = new SubmoduleDoop('video', $module->linkSystem(), $params);

if ($video->post('insert_action_form_video')) { $video->sub_insert(); }
if ($video->post('update_action_form_video')) { $video->sub_update(); }

$dataTabVideo = $video->modules->htmlHeader();

if(!$video->get($video->active)) {
    $dataTabVideo .= '
    <form name="insert_video_form" class="form-horizontal form-validate-video" method="post" action="'.$video->newPath.'">
        <div class="row form-group">
            <label class="col-md-2 col-form-label">Vídeos: <sup class="text-danger" title="Obrigatório">(*)</sup><br><small>[ youtube/vimeo ]</small></label>
            <div class="col-md-10">
                <div class="table-responsive">
                    <table class="table table-striped table-bordered table-hover table-doop">
                        <thead>
                            <tr>
                                <th colspan="4"><a href="#tableVideo" data-command="tableVideo" onclick="$.addLine(this);"><i class="fa fa-plus"></i> Adicionar Vídeo</a></th>
                            </tr>
                        </thead>
                        <thead>
                            <tr>
                                <th>URL</th>
                                <th colspan="2">Legenda</th>
                            </tr>
                        </thead>

                        <tbody id="tableVideo">
                            <tr id="line_1">
                                <td width="45%">
                                    <input type="text" name="'.$video->modules->sufix('url').'[]" class="form-control" placeholder="Insira a url completa de um vídeo do youtube ou vimeo..." required />
                                </td>
                                <td width="45%">
                                    <input type="text" name="'.$video->modules->sufix('legend').'[]" class="form-control" placeholder="Digite a legenda do vídeo..." />
                                </td>
                                <td width="1%">
                                    <a class="btn btn-sm btn-default" href="#tableVideo" data-command="tableVideo" title="Excluir Vídeo" onclick="$.removeLine(this);">
                                        <i class="fa fa-trash"></i>
                                    </a>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <hr>
        <div class="text-center">
            <button id="insert_action_form_video" name="insert_action_form_video" class="btn btn-primary" type="submit" value="inserir vídeos">
                <i class="fa fa-plus mr-2"></i> inserir vídeos
            </button>
        </div>
    </form>';
}

$limit = 20;
$query = "SELECT * FROM `".$video->getTable()."`
          WHERE `".$video->modules->sufix('table')."` = '".$module->getTable()."' AND `".$video->modules->sufix('tuple')."` = '".$module->value('id')."' AND `".$video->modules->sufix('status')."` = 'active'
          GROUP BY `".$video->modules->sufix('id')."`
          ORDER BY `".$video->modules->sufix('order')."` DESC";

$paginationConfig = lang('site::default.pagination');
$paginationConfig[1] = 'paginaExtraVideo';
$paginationConfig[7] = 'paginaExtraVideo-1';

$pagination = new \CoreSlim\PaginationGet([
    'locale' => $paginationConfig,
    'item' => $limit,
    'query' => $query
]);

$queryData = $pagination->execute();

$paginationData = $video->dbFetchAll($queryData);

if (is_array($paginationData) && count($paginationData) > 0) {
    $dataTabVideo .= '
    <hr>
    <form name="update_video_form" class="form-horizontal form-validate-video-update" method="post" action="'.$video->newPath.'">
        <div class="form-submodule-top mb-3">
            '.ToolsTemplate::navigation($pagination->total, $pagination->navigation(null, null, '#video')).'

            <div class="btn-group">
                <a href="'.$video->newPath.'&action=deleteAllItens&video=module#video" id="deleteAll_video" name="deleteAll_video" class="btn btn-danger alert-action-default" value="Excluir tudo">
                    <i class="fa fa-times mr-2"></i> excluir tudo
                </a>

                <button id="updateAll_video" name="updateAll_video" class="btn btn-success" type="submit" value="Salvar dados">
                    <i class="fa fa-save mr-2"></i> salvar dados
                </button>
            </div>
        </div>

        <div class="table-responsive">
            <table class="table table-striped table-bordered table-hover table-doop">
                <thead>
                    <tr>
                        <th width="1%" class="text-center">vídeo</th>
                        <th>legenda</th>
                        <th>crédito</th>
                        <th width="10%" class="text-center">ordem</th>
                        <th width="1%" class="text-center"><i class="fa fa-cubes cursor-default" title="Controles"></i></th>
                    </tr>
                </thead>

                <tbody>';
                    foreach ($paginationData as $key => $result) {
                        $id = $result[$video->modules->sufix('id')];

                        $dataTabVideo .= '
                        <tr>
                            <td>'.$video->getVideoSub($result[$video->modules->sufix('tag')]).'</td>
                            <td><input type="text" id="legend_video_'.$id.'" name="legend_video_'.$id.'" class="form-control" maxlength="100" value="'.$video->processString($result[$video->modules->sufix('legend')]).'" placeholder="Digite a legenda do vídeo..." /></td>
                            <td><input type="text" id="credit_video_'.$id.'" name="credit_video_'.$id.'" class="form-control" maxlength="100" value="'.$video->processString($result[$video->modules->sufix('credit')]).'" placeholder="Digite o crédito do vídeo..." /></td>
                            <td class="text-center"><input type="number" id="order_video_'.$id.'" name="order_video_'.$id.'" class="form-control text-center" maxlength="100" value="'.intval($result[$video->modules->sufix('order')]).'" /></td>
                            <td class="text-center">'.$video->modules->htmlActionUnique($result, $video->active, null, true).'</td>
                        </tr>';
                    }

                    $dataTabVideo .= '
                </tbody>
            </table>
        </div>
    </form>';
}

return $dataTabVideo;
