<?php

require_once(config('app.ROOT_CMS_HELPERS').'/forms-class-automatic.php');

class ModuleDoop extends FormsClassAutomatic
{
    public $administrator = null;
    public $company = null;

    public $listAlerts = [
        'danger' => 'Mensagem de Erro',
        'success' => 'Mensagem de Sucesso',
        'warning' => 'Mensagem de Alerta',
        'info' => 'Mensagem de Informação'
    ];

    public $listStatus = [
        1 => 'Ativado',
        2 => 'Desabilitado'
    ];

    public function __construct($controller, $operation = 'manage')
    {
        $this->controller = $controller;
        $this->operation = $operation;

        parent::__construct('static', $operation, 'automaticForms');

        $this->controller->modules->control['bt_delete'] = false;
        $this->controller->modules->control['controls_filter'] = false;
    }

    public function extraLayout()
    {
        $controller = $this->controller;

        $inputs[] = ['privilege' => 'god', 'type' => 'separator', 'value' => 'INDEX - A EMPRESA'];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'about', 'value' => 'title', 'title' => 'Título:', 'maxlength' => 100];
        $inputs[] = ['privilege' => 'god', 'type' => 'html', 'key' => 'about', 'value' => 'text', 'title' => 'Texto:', 'class' => 'summernote-basic'];
        $inputs[] = ['privilege' => 'god', 'type' => 'upload', 'key' => 'assets', 'value' => 'about', 'title' => 'Imagem:', 'width' => 800, 'height' => 600, 'ext' => 'jpg'];

        $inputs[] = ['privilege' => 'god', 'type' => 'separator', 'value' => 'INDEX - PARALLAX'];

        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'parallax', 'value' => 'title', 'title' => 'Título:', 'maxlength' => 100];
        $inputs[] = ['privilege' => 'god', 'type' => 'upload', 'key' => 'assets', 'value' => 'parallax', 'title' => 'Imagem:', 'width' => 1920, 'height' => 500, 'ext' => 'jpg'];

        $module = $this;

        $vars['htmlHeader'] = '<h1>Dados Extras / Layout</h1>';
        $vars['htmlNoneItens'] = 'Nenhum dado extra para esta configuração.';
        $module->breadcrumb->setLabel($this->operation, 'Dados Extras / Layout');

        $this->automaticForms($this->operation, $inputs, 'automaticForms');

        $dataForm = include(config('app.ROOT_CMS_HELPERS').'/forms-automatic.php');

        return ToolsTemplate::page($this->controller, $dataForm, $vars);
    }

    public function extraContact()
    {
        $controller = $this->controller;

        $inputs[] = ['privilege' => 'god', 'type' => 'separator', 'value' => 'Configurações da página'];

        $inputs[] = ['privilege' => 'developer', 'type' => 'radio', 'key' => 'scope', 'value' => 'status', 'title' => 'Status:', 'list' => $this->listStatus];
        $inputs[] = ['privilege' => 'developer', 'type' => 'divider'];
        $inputs[] = ['privilege' => 'developer', 'type' => 'input', 'key' => 'scope', 'value' => 'class', 'title' => 'Nome da Classe:', 'maxlength' => 100];
        $inputs[] = ['privilege' => 'developer', 'type' => 'input', 'key' => 'scope', 'value' => 'key', 'title' => 'Chave de Acesso:', 'maxlength' => 50];
        $inputs[] = ['privilege' => 'developer', 'type' => 'divider'];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'scope', 'value' => 'title', 'title' => 'Título:', 'maxlength' => 100];
        $inputs[] = ['privilege' => 'god', 'type' => 'html', 'key' => 'scope', 'value' => 'text', 'title' => 'Texto:', 'class' => 'summernote-basic'];

        $inputs[] = ['privilege' => 'god', 'type' => 'separator', 'value' => 'Formulário', 'label' => 'As configurações abaixo são referentes a configuração do formulário.'];

        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'form', 'value' => 'buttonLabel', 'title' => 'Label - Botão Enviar:', 'maxlength' => 50];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'form', 'value' => 'buttonTitle', 'title' => 'Título - Botão Enviar:', 'maxlength' => 70];
        $inputs[] = ['privilege' => 'god', 'type' => 'divider'];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'form', 'value' => 'checkNewsletter', 'title' => 'Mensagem - Salvar nome e e-mail:', 'maxlength' => 100];
        $inputs[] = ['privilege' => 'god', 'type' => 'divider'];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'label', 'value' => 'name', 'title' => 'Label - Nome:', 'maxlength' => 50];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'label', 'value' => 'email', 'title' => 'Label - E-mail:', 'maxlength' => 50];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'label', 'value' => 'phone', 'title' => 'Label - Telefone:', 'maxlength' => 50];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'label', 'value' => 'city', 'title' => 'Label - Cidade:', 'maxlength' => 50];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'label', 'value' => 'state', 'title' => 'Label - Estado:', 'maxlength' => 50];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'label', 'value' => 'subject', 'title' => 'Label - Assunto:', 'maxlength' => 50];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'label', 'value' => 'message', 'title' => 'Label - Mensagem:', 'maxlength' => 50];

        $inputs[] = ['privilege' => 'god', 'type' => 'separator', 'value' => 'Callback do Formulário', 'label' => 'As configurações abaixo são referentes as mensagens de callback disparadas pelo formulário.'];

        $inputs[] = ['privilege' => 'developer', 'type' => 'input', 'key' => 'callback', 'value' => 'sendKey', 'title' => 'Chave - Formulário Enviado:', 'maxlength' => 30];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'callback', 'value' => 'sendMessage', 'title' => 'Mensagem - Formulário Enviado:', 'maxlength' => 150];
        $inputs[] = ['privilege' => 'developer', 'type' => 'select', 'key' => 'callback', 'value' => 'sendType', 'title' => 'Alerta - Formulário Enviado:', 'list' => $this->listAlerts];

        $module = $this;

        $vars['htmlHeader'] = '<h1>Dados Extras / Contato</h1>';
        $vars['htmlNoneItens'] = 'Nenhum dado extra para esta configuração.';
        $module->breadcrumb->setLabel($this->operation, 'Dados Extras / Contato');

        $this->automaticForms($this->operation, $inputs, 'automaticForms');

        $dataForm = include(config('app.ROOT_CMS_HELPERS').'/forms-automatic.php');

        return ToolsTemplate::page($this->controller, $dataForm, $vars);
    }

    public function extraWork()
    {
        $controller = $this->controller;

        $inputs[] = ['privilege' => 'god', 'type' => 'separator', 'value' => 'Configurações da página'];

        $inputs[] = ['privilege' => 'developer', 'type' => 'radio', 'key' => 'scope', 'value' => 'status', 'title' => 'Status:', 'list' => $this->listStatus];
        $inputs[] = ['privilege' => 'developer', 'type' => 'divider'];
        $inputs[] = ['privilege' => 'developer', 'type' => 'input', 'key' => 'scope', 'value' => 'class', 'title' => 'Nome da Classe:', 'maxlength' => 100];
        $inputs[] = ['privilege' => 'developer', 'type' => 'input', 'key' => 'scope', 'value' => 'key', 'title' => 'Chave de Acesso:', 'maxlength' => 50];
        $inputs[] = ['privilege' => 'developer', 'type' => 'divider'];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'scope', 'value' => 'title', 'title' => 'Título:', 'maxlength' => 100];
        $inputs[] = ['privilege' => 'god', 'type' => 'html', 'key' => 'scope', 'value' => 'text', 'title' => 'Texto:', 'class' => 'summernote-basic'];

        $inputs[] = ['privilege' => 'god', 'type' => 'separator', 'value' => 'Formulário', 'label' => 'As configurações abaixo são referentes a configuração do formulário.'];

        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'form', 'value' => 'buttonLabel', 'title' => 'Label - Botão Enviar:', 'maxlength' => 50];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'form', 'value' => 'buttonTitle', 'title' => 'Título - Botão Enviar:', 'maxlength' => 70];
        $inputs[] = ['privilege' => 'god', 'type' => 'divider'];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'form', 'value' => 'checkNewsletter', 'title' => 'Mensagem - Salvar nome e e-mail:', 'maxlength' => 100];
        $inputs[] = ['privilege' => 'god', 'type' => 'divider'];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'label', 'value' => 'name', 'title' => 'Label - Nome:', 'maxlength' => 50];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'label', 'value' => 'email', 'title' => 'Label - E-mail:', 'maxlength' => 50];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'label', 'value' => 'phone', 'title' => 'Label - Telefone:', 'maxlength' => 50];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'label', 'value' => 'file', 'title' => 'Label - Anexo:', 'maxlength' => 50];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'label', 'value' => 'message', 'title' => 'Label - Mensagem:', 'maxlength' => 50];
        $inputs[] = ['privilege' => 'god', 'type' => 'divider'];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'validate', 'value' => 'name', 'title' => 'Validação - Nome:', 'maxlength' => 100];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'validate', 'value' => 'email', 'title' => 'Validação - E-mail:', 'maxlength' => 100];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'validate', 'value' => 'phone', 'title' => 'Validação - Telefone:', 'maxlength' => 100];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'validate', 'value' => 'file', 'title' => 'Validação - Anexo:', 'maxlength' => 100];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'validate', 'value' => 'message', 'title' => 'Validação - Mensagem:', 'maxlength' => 100];

        $inputs[] = ['privilege' => 'god', 'type' => 'separator', 'value' => 'Callback do Formulário', 'label' => 'As configurações abaixo são referentes as mensagens de callback disparadas pelo formulário.'];

        $inputs[] = ['privilege' => 'developer', 'type' => 'input', 'key' => 'callback', 'value' => 'sendKey', 'title' => 'Chave - Formulário Enviado:', 'maxlength' => 30];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'callback', 'value' => 'sendMessage', 'title' => 'Mensagem - Formulário Enviado:', 'maxlength' => 150];
        $inputs[] = ['privilege' => 'developer', 'type' => 'select', 'key' => 'callback', 'value' => 'sendType', 'title' => 'Alerta - Formulário Enviado:', 'list' => $this->listAlerts];

        $module = $this;

        $vars['htmlHeader'] = '<h1>Dados Extras / Trabalhe conosco</h1>';
        $vars['htmlNoneItens'] = 'Nenhum dado extra para esta configuração.';
        $module->breadcrumb->setLabel($this->operation, 'Dados Extras / Trabalhe conosco');

        $this->automaticForms($this->operation, $inputs, 'automaticForms');

        $dataForm = include(config('app.ROOT_CMS_HELPERS').'/forms-automatic.php');

        return ToolsTemplate::page($this->controller, $dataForm, $vars);
    }

    public function extraBudget()
    {
        $controller = $this->controller;

        $inputs[] = ['privilege' => 'god', 'type' => 'separator', 'value' => 'Configurações da página'];

        $inputs[] = ['privilege' => 'developer', 'type' => 'radio', 'key' => 'scope', 'value' => 'status', 'title' => 'Status:', 'list' => $this->listStatus];
        $inputs[] = ['privilege' => 'developer', 'type' => 'divider'];
        $inputs[] = ['privilege' => 'developer', 'type' => 'input', 'key' => 'scope', 'value' => 'class', 'title' => 'Nome da Classe:', 'maxlength' => 100];
        $inputs[] = ['privilege' => 'developer', 'type' => 'input', 'key' => 'scope', 'value' => 'key', 'title' => 'Chave de Acesso:', 'maxlength' => 50];
        $inputs[] = ['privilege' => 'developer', 'type' => 'divider'];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'scope', 'value' => 'title', 'title' => 'Título:', 'maxlength' => 100];
        $inputs[] = ['privilege' => 'god', 'type' => 'html', 'key' => 'scope', 'value' => 'text', 'title' => 'Texto:', 'class' => 'summernote-basic'];

        $inputs[] = ['privilege' => 'god', 'type' => 'separator', 'value' => 'Formulário', 'label' => 'As configurações abaixo são referentes a configuração do formulário.'];

        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'form', 'value' => 'buttonLabel', 'title' => 'Label - Botão Enviar:', 'maxlength' => 50];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'form', 'value' => 'buttonTitle', 'title' => 'Título - Botão Enviar:', 'maxlength' => 70];
        $inputs[] = ['privilege' => 'god', 'type' => 'divider'];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'form', 'value' => 'checkNewsletter', 'title' => 'Mensagem - Salvar nome e e-mail:', 'maxlength' => 100];
        $inputs[] = ['privilege' => 'god', 'type' => 'divider'];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'label', 'value' => 'name', 'title' => 'Label - Nome:', 'maxlength' => 50];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'label', 'value' => 'email', 'title' => 'Label - E-mail:', 'maxlength' => 50];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'label', 'value' => 'phone', 'title' => 'Label - Telefone:', 'maxlength' => 50];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'label', 'value' => 'message', 'title' => 'Label - Mensagem:', 'maxlength' => 50];
        $inputs[] = ['privilege' => 'god', 'type' => 'divider'];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'validate', 'value' => 'name', 'title' => 'Validação - Nome:', 'maxlength' => 100];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'validate', 'value' => 'email', 'title' => 'Validação - E-mail:', 'maxlength' => 100];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'validate', 'value' => 'phone', 'title' => 'Validação - Telefone:', 'maxlength' => 100];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'validate', 'value' => 'message', 'title' => 'Validação - Mensagem:', 'maxlength' => 100];

        $inputs[] = ['privilege' => 'god', 'type' => 'separator', 'value' => 'Callback do Formulário', 'label' => 'As configurações abaixo são referentes as mensagens de callback disparadas pelo formulário.'];

        $inputs[] = ['privilege' => 'developer', 'type' => 'input', 'key' => 'callback', 'value' => 'sendKey', 'title' => 'Chave - Formulário Enviado:', 'maxlength' => 30];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'callback', 'value' => 'sendMessage', 'title' => 'Mensagem - Formulário Enviado:', 'maxlength' => 150];
        $inputs[] = ['privilege' => 'developer', 'type' => 'select', 'key' => 'callback', 'value' => 'sendType', 'title' => 'Alerta - Formulário Enviado:', 'list' => $this->listAlerts];

        $module = $this;

        $vars['htmlHeader'] = '<h1>Dados Extras / Orçamento</h1>';
        $vars['htmlNoneItens'] = 'Nenhum dado extra para esta configuração.';
        $module->breadcrumb->setLabel($this->operation, 'Dados Extras / Orçamento');

        $this->automaticForms($this->operation, $inputs, 'automaticForms');

        $dataForm = include(config('app.ROOT_CMS_HELPERS').'/forms-automatic.php');

        return ToolsTemplate::page($this->controller, $dataForm, $vars);
    }

    public function extraLocalization()
    {
        $controller = $this->controller;

        $inputs[] = ['privilege' => 'god', 'type' => 'separator', 'value' => 'Configurações da página'];

        $inputs[] = ['privilege' => 'developer', 'type' => 'radio', 'key' => 'scope', 'value' => 'status', 'title' => 'Status:', 'list' => $this->listStatus];
        $inputs[] = ['privilege' => 'developer', 'type' => 'divider'];
        $inputs[] = ['privilege' => 'developer', 'type' => 'input', 'key' => 'scope', 'value' => 'class', 'title' => 'Nome da Classe:', 'maxlength' => 100];
        $inputs[] = ['privilege' => 'developer', 'type' => 'input', 'key' => 'scope', 'value' => 'key', 'title' => 'Chave de Acesso:', 'maxlength' => 50];
        $inputs[] = ['privilege' => 'developer', 'type' => 'divider'];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'scope', 'value' => 'title', 'title' => 'Título:', 'maxlength' => 100];
        $inputs[] = ['privilege' => 'god', 'type' => 'html', 'key' => 'scope', 'value' => 'text', 'title' => 'Texto:', 'class' => 'summernote-basic'];

        $inputs[] = ['privilege' => 'god', 'type' => 'separator', 'value' => 'Configurações do Mapa', 'label' => 'As configurações abaixo são referentes ao Google Maps. Utilize o <b>ZOOM 17</b> para capturar as coordenadas.'];

        $inputs[] = ['privilege' => 'god', 'type' => 'code', 'key' => 'map', 'value' => 'embed', 'title' => 'EMBED:'];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'map', 'value' => 'url', 'title' => 'URL:', 'maxlength' => 800];

        $inputs[] = ['privilege' => 'god', 'type' => 'separator', 'value' => 'Textos Extras', 'label' => 'Os campos abaixo são utilizados no template.'];

        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'texts', 'value' => 'howtoget', 'title' => 'Como chegar:', 'maxlength' => 200];

        $module = $this;

        $vars['htmlHeader'] = '<h1>Dados Extras / Localização</h1>';
        $vars['htmlNoneItens'] = 'Nenhum dado extra para esta configuração.';
        $module->breadcrumb->setLabel($this->operation, 'Dados Extras / Localização');

        $this->automaticForms($this->operation, $inputs, 'automaticForms');

        $dataForm = include(config('app.ROOT_CMS_HELPERS').'/forms-automatic.php');

        return ToolsTemplate::page($this->controller, $dataForm, $vars);
    }

    public function extraNewsletter()
    {
        $controller = $this->controller;

        $inputs[] = ['privilege' => 'developer', 'type' => 'separator', 'value' => 'Configurações do Desenvolvedor', 'label' => 'Atenção ao editar essas informações, elas aplicam direto no código do desenvolvedor.'];

        $inputs[] = ['privilege' => 'developer', 'type' => 'select', 'key' => 'scope', 'value' => 'status', 'title' => 'Status:', 'list' => $this->listStatus];
        $inputs[] = ['privilege' => 'developer', 'type' => 'divider'];
        $inputs[] = ['privilege' => 'developer', 'type' => 'input', 'key' => 'scope', 'value' => 'key', 'title' => 'Chave de Acesso:', 'maxlength' => 25];
        $inputs[] = ['privilege' => 'developer', 'type' => 'divider'];
        $inputs[] = ['privilege' => 'developer', 'type' => 'input', 'key' => 'scope', 'value' => 'title', 'title' => 'Nome do Módulo:', 'maxlength' => 100];
        $inputs[] = ['privilege' => 'developer', 'type' => 'divider'];
        $inputs[] = ['privilege' => 'developer', 'type' => 'input', 'key' => 'scope', 'value' => 'class', 'title' => 'Nome da Classe:', 'maxlength' => 100];

        $inputs[] = ['privilege' => 'god', 'type' => 'separator', 'value' => 'Formulário', 'label' => 'As configurações abaixo são referentes a configuração do formulário.'];

        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'form', 'value' => 'buttonLabel', 'title' => 'Label - Botão Inserir:', 'maxlength' => 10];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'form', 'value' => 'buttonTitle', 'title' => 'Título - Botão Inserir:', 'maxlength' => 70];
        $inputs[] = ['privilege' => 'god', 'type' => 'divider'];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'form', 'value' => 'buttonRemoveLabel', 'title' => 'Label - Botão Remover:', 'maxlength' => 10];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'form', 'value' => 'buttonRemoveTitle', 'title' => 'Título - Botão Remover:', 'maxlength' => 70];
        $inputs[] = ['privilege' => 'god', 'type' => 'divider'];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'form', 'value' => 'placeholderName', 'title' => 'Placeholder - Nome:', 'maxlength' => 70];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'form', 'value' => 'placeholderEmail', 'title' => 'Placeholder - E-mail:', 'maxlength' => 70];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'form', 'value' => 'placeholderPhone', 'title' => 'Placeholder - Telefone:', 'maxlength' => 70];
        $inputs[] = ['privilege' => 'god', 'type' => 'divider'];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'validate', 'value' => 'name', 'title' => 'Validação - Nome:', 'maxlength' => 100];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'validate', 'value' => 'email', 'title' => 'Validação - E-mail:', 'maxlength' => 100];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'validate', 'value' => 'phone', 'title' => 'Validação - Telefone:', 'maxlength' => 100];

        $inputs[] = ['privilege' => 'god', 'type' => 'separator', 'value' => 'Textos Extras', 'label' => 'Os campos abaixo são utilizados no template.'];

        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'texts', 'value' => 'title', 'title' => 'Título - Inserir:', 'maxlength' => 30];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'texts', 'value' => 'textAdd', 'title' => 'Descrição - Inserir:', 'maxlength' => 150];
        $inputs[] = ['privilege' => 'god', 'type' => 'divider'];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'texts', 'value' => 'titleRemove', 'title' => 'Título - Remover:', 'maxlength' => 30];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'texts', 'value' => 'textRemove', 'title' => 'Descrição - Remover:', 'maxlength' => 150];

        $inputs[] = ['privilege' => 'god', 'type' => 'separator', 'value' => 'Callback do Formulário', 'label' => 'As configurações abaixo são referentes as mensagens de callback disparadas pelo formulário.'];

        $inputs[] = ['privilege' => 'developer', 'type' => 'input', 'key' => 'callback', 'value' => 'insertKey', 'title' => 'Chave - E-mail cadastrado:', 'maxlength' => 30];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'callback', 'value' => 'insertMessage', 'title' => 'Mensagem - E-mail cadastrado:', 'maxlength' => 150];
        $inputs[] = ['privilege' => 'developer', 'type' => 'select', 'key' => 'callback', 'value' => 'insertType', 'title' => 'Alerta - E-mail cadastrado:', 'list' => $this->listAlerts];
        $inputs[] = ['privilege' => 'god', 'type' => 'divider'];
        $inputs[] = ['privilege' => 'developer', 'type' => 'input', 'key' => 'callback', 'value' => 'removeKey', 'title' => 'Chave - E-mail excluído:', 'maxlength' => 30];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'callback', 'value' => 'removeMessage', 'title' => 'Mensagem - E-mail excluído:', 'maxlength' => 150];
        $inputs[] = ['privilege' => 'developer', 'type' => 'select', 'key' => 'callback', 'value' => 'removeType', 'title' => 'Alerta - E-mail excluído:', 'list' => $this->listAlerts];
        $inputs[] = ['privilege' => 'god', 'type' => 'divider'];
        $inputs[] = ['privilege' => 'developer', 'type' => 'input', 'key' => 'callback', 'value' => 'existsKey', 'title' => 'Chave - E-mail duplicado:', 'maxlength' => 30];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'callback', 'value' => 'existsMessage', 'title' => 'Mensagem - E-mail duplicado:', 'maxlength' => 150];
        $inputs[] = ['privilege' => 'developer', 'type' => 'select', 'key' => 'callback', 'value' => 'existsType', 'title' => 'Alerta - E-mail duplicado:', 'list' => $this->listAlerts];
        $inputs[] = ['privilege' => 'god', 'type' => 'divider'];
        $inputs[] = ['privilege' => 'developer', 'type' => 'input', 'key' => 'callback', 'value' => 'noexistsKey', 'title' => 'Chave - E-mail não encontrado:', 'maxlength' => 30];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'callback', 'value' => 'noexistsMessage', 'title' => 'Mensagem - E-mail não encontrado:', 'maxlength' => 150];
        $inputs[] = ['privilege' => 'developer', 'type' => 'select', 'key' => 'callback', 'value' => 'noexistsType', 'title' => 'Alerta - E-mail não encontrado:', 'list' => $this->listAlerts];

        $module = $this;

        $vars['htmlHeader'] = '<h1>Dados Extras / Newsletter</h1>';
        $vars['htmlNoneItens'] = 'Nenhum dado extra para esta configuração.';
        $module->breadcrumb->setLabel($this->operation, 'Dados Extras / Newsletter');

        $this->automaticForms($this->operation, $inputs, 'automaticForms');

        $dataForm = include(config('app.ROOT_CMS_HELPERS').'/forms-automatic.php');

        return ToolsTemplate::page($this->controller, $dataForm, $vars);
    }

    public function extraLGPD()
    {
        $controller = $this->controller;

        $inputs[] = ['privilege' => 'god', 'type' => 'separator', 'value' => 'Configurações da página'];

        $inputs[] = ['privilege' => 'developer', 'type' => 'radio', 'key' => 'scope', 'value' => 'status', 'title' => 'Status:', 'list' => $this->listStatus];
        $inputs[] = ['privilege' => 'developer', 'type' => 'divider'];
        $inputs[] = ['privilege' => 'developer', 'type' => 'input', 'key' => 'scope', 'value' => 'class', 'title' => 'Nome da Classe:', 'maxlength' => 100];
        $inputs[] = ['privilege' => 'developer', 'type' => 'input', 'key' => 'scope', 'value' => 'key', 'title' => 'Chave de Acesso:', 'maxlength' => 50];
        $inputs[] = ['privilege' => 'developer', 'type' => 'divider'];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'scope', 'value' => 'title', 'title' => 'Título:', 'maxlength' => 100];
        $inputs[] = ['privilege' => 'god', 'type' => 'html', 'key' => 'scope', 'value' => 'text', 'title' => 'Texto:', 'class' => 'summernote-basic'];

        $inputs[] = ['privilege' => 'god', 'type' => 'separator', 'value' => 'Popup de Confirmação - LGPD'];

        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'info', 'value' => 'lgpd', 'title' => 'Texto - Popup:', 'maxlength' => 300];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'info', 'value' => 'buttonPage', 'title' => 'Botão - Página:', 'maxlength' => 50];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'info', 'value' => 'buttonAccept', 'title' => 'Botão - Aceite:', 'maxlength' => 50];

        $module = $this;

        $vars['htmlHeader'] = '<h1>Dados Extras / LGPD</h1>';
        $vars['htmlNoneItens'] = 'Nenhum dado extra para esta configuração.';
        $module->breadcrumb->setLabel($this->operation, 'Dados Extras / LGPD');

        $this->automaticForms($this->operation, $inputs, 'automaticForms');

        $dataForm = include(config('app.ROOT_CMS_HELPERS').'/forms-automatic.php');

        return ToolsTemplate::page($this->controller, $dataForm, $vars);
    }

    public function extraGlobal()
    {
        $controller = $this->controller;

        $inputs[] = ['privilege' => 'root', 'type' => 'separator', 'value' => 'Labels'];

        $inputs[] = ['privilege' => 'root', 'type' => 'input', 'key' => 'info', 'value' => 'address', 'title' => 'Endereço:', 'maxlength' => 100];
        $inputs[] = ['privilege' => 'root', 'type' => 'input', 'key' => 'info', 'value' => 'phones', 'title' => 'Telefones:', 'maxlength' => 100];
        $inputs[] = ['privilege' => 'root', 'type' => 'input', 'key' => 'info', 'value' => 'emails', 'title' => 'E-mails:', 'maxlength' => 100];
        $inputs[] = ['privilege' => 'root', 'type' => 'input', 'key' => 'info', 'value' => 'businessHour', 'title' => 'Horário de Funcionamento:', 'maxlength' => 100];

        $inputs[] = ['privilege' => 'root', 'type' => 'separator', 'value' => 'Operadoras'];

        $inputs[] = ['privilege' => 'root', 'type' => 'input', 'key' => 'operator', 'value' => 'vivo', 'title' => 'Vivo:', 'maxlength' => 25];
        $inputs[] = ['privilege' => 'root', 'type' => 'input', 'key' => 'operator', 'value' => 'oi', 'title' => 'Oi:', 'maxlength' => 25];
        $inputs[] = ['privilege' => 'root', 'type' => 'input', 'key' => 'operator', 'value' => 'tim', 'title' => 'Tim:', 'maxlength' => 25];
        $inputs[] = ['privilege' => 'root', 'type' => 'input', 'key' => 'operator', 'value' => 'claro', 'title' => 'Claro:', 'maxlength' => 25];
        $inputs[] = ['privilege' => 'root', 'type' => 'input', 'key' => 'operator', 'value' => 'fixo', 'title' => 'Fixo:', 'maxlength' => 25];
        $inputs[] = ['privilege' => 'root', 'type' => 'input', 'key' => 'operator', 'value' => 'whatsapp', 'title' => 'Whatsapp:', 'maxlength' => 25];

        $inputs[] = ['privilege' => 'root', 'type' => 'separator', 'value' => 'Redes Sociais'];

        $inputs[] = ['privilege' => 'root', 'type' => 'input', 'key' => 'share', 'value' => 'title', 'title' => 'Label - Compartilhar:', 'maxlength' => 25];
        $inputs[] = ['privilege' => 'root', 'type' => 'input', 'key' => 'share', 'value' => 'facebook', 'title' => 'Facebook:', 'maxlength' => 25];
        $inputs[] = ['privilege' => 'root', 'type' => 'input', 'key' => 'share', 'value' => 'twitter', 'title' => 'Twitter:', 'maxlength' => 25];
        $inputs[] = ['privilege' => 'root', 'type' => 'input', 'key' => 'share', 'value' => 'linkedin', 'title' => 'Linkedin:', 'maxlength' => 25];
        $inputs[] = ['privilege' => 'root', 'type' => 'input', 'key' => 'share', 'value' => 'skype', 'title' => 'Skype:', 'maxlength' => 25];
        $inputs[] = ['privilege' => 'root', 'type' => 'input', 'key' => 'share', 'value' => 'whatsapp', 'title' => 'Whatsapp:', 'maxlength' => 25];

        $inputs[] = ['privilege' => 'root', 'type' => 'separator', 'value' => 'Submódulos'];

        $inputs[] = ['privilege' => 'root', 'type' => 'input', 'key' => 'additional', 'value' => 'gallery-photo', 'title' => 'Galeria de Fotos:', 'maxlength' => 50];
        $inputs[] = ['privilege' => 'root', 'type' => 'input', 'key' => 'additional', 'value' => 'gallery-video', 'title' => 'Galeria de Vídeos:', 'maxlength' => 50];
        $inputs[] = ['privilege' => 'root', 'type' => 'input', 'key' => 'additional', 'value' => 'gallery-anexx', 'title' => 'Galeria de Anexos:', 'maxlength' => 50];
        $inputs[] = ['privilege' => 'root', 'type' => 'input', 'key' => 'additional', 'value' => 'gallery-audio', 'title' => 'Galeria de Áudios:', 'maxlength' => 50];

        $module = $this;

        $vars['htmlHeader'] = '<h1>Dados Extras / Textos Gerais</h1>';
        $vars['htmlNoneItens'] = 'Nenhum dado extra para esta configuração.';
        $module->breadcrumb->setLabel($this->operation, 'Dados Extras / Textos Gerais');

        $this->automaticForms($this->operation, $inputs, 'automaticForms');

        $dataForm = include(config('app.ROOT_CMS_HELPERS').'/forms-automatic.php');

        return ToolsTemplate::page($this->controller, $dataForm, $vars);
    }

    public function extraPopup()
    {
        $controller = $this->controller;

        $inputs[] = ['privilege' => 'developer', 'type' => 'radio', 'key' => 'data', 'value' => 'status', 'title' => 'Exibir popup:', 'list' => $this->listStatus];
        $inputs[] = ['privilege' => 'god', 'type' => 'divider'];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'data', 'value' => 'title', 'title' => 'Título:', 'maxlength' => 100];
        $inputs[] = ['privilege' => 'god', 'type' => 'input', 'key' => 'data', 'value' => 'url', 'title' => 'Link:', 'maxlength' => 800];
        $inputs[] = ['privilege' => 'god', 'type' => 'upload', 'key' => 'assets', 'value' => 'popup', 'title' => 'Imagem:', 'width' => 800, 'height' => 800, 'ext' => 'jpg'];

        $module = $this;

        $vars['htmlHeader'] = '<h1>Dados Extras / Popup</h1>';
        $vars['htmlNoneItens'] = 'Nenhum dado extra para esta configuração.';
        $module->breadcrumb->setLabel($this->operation, 'Dados Extras / Popup');

        $this->automaticForms($this->operation, $inputs, 'automaticForms');

        $dataForm = include(config('app.ROOT_CMS_HELPERS').'/forms-automatic.php');

        return ToolsTemplate::page($this->controller, $dataForm, $vars);
    }

    public function support()
    {
        $administrator = parent::dbFetch("SELECT `name_administrator`, `email_administrator` FROM `mod_administrator` WHERE `id_administrator` = '".ADMINISTRATOR."'");

        $this->administrator = [
            'name' => parent::processString($administrator[0]),
            'email' => parent::processString($administrator[1])
        ];

        if (parent::post('send_action_support')) {
            $this->module_support();
        }

        $page = '<h5><b>E-mail:</b> <a class="blue" href="mailto:'.config('app.LABEL_EMAIL_SUPPORT').'" target="_blank">'.config('app.LABEL_EMAIL_SUPPORT').'</a> / <b>Registro:</b> '.date('d/m/Y H:i:s').'</h5>';
        $page .= '<hr>';

        $module = $this;

        $page .= '
        <form id="supportForm" name="supportForm" class="form-horizontal form-validate" method="post" action="'.$module->pathlang(null, config('app.PATH_SYSTEM').'system/static&operation=support').'">
            <div class="row form-group">
                <label class="col-md-3 col-form-label" for="name_support">Nome:</label>
                <div class="col-md-4">
                    <div class="clearfix">
                        <input type="text" id="name_support" name="name_support" class="form-control" disabled value="'.$module->administrator['name'].'" />
                    </div>
                </div>
            </div>

            <div class="row form-group">
                <label class="col-md-3 col-form-label" for="email_support">E-mail:</label>
                <div class="col-md-4">
                    <div class="clearfix">
                        <input type="email" id="email_support" name="email_support" class="form-control" disabled value="'.$module->administrator['email'].'" />
                    </div>
                </div>
            </div>

            <hr>

            <div class="row form-group">
                <label class="col-md-3 col-form-label" for="assunt_support">Assunto:</label>
                <div class="col-md-3">
                    <select id="assunt_support" name="assunt_support" class="form-control">';
                        $type = ['Avaliações', 'Sugestões', 'Suporte Técnico', 'Atualizações'];
                        foreach ($type as $label) {
                            $page .= '<option value="'.$label.'">'.$label.'</option>';
                        }

            $page .= '
                    </select>
                </div>
            </div>

            <hr>

            <div class="row form-group">
                <label class="col-md-3 col-form-label" for="message_support">Mensagem:</label>
                <div class="col-md-9">
                    <div class="clearfix">
                        <textarea id="message_support" name="message_support" class="form-control" required rows="10"></textarea>
                    </div>
                </div>
            </div>

            <hr>

            <div class="text-center">
                <button id="send_action_support" name="send_action_support" class="btn btn-primary" type="submit" value="send_action_support" title="Enviar">
                    <i class="fas fa-paper-plane mr-1"></i> Enviar
                </button>
            </div>
        </form>';

        $vars['htmlHeader'] = '<h1>Suporte Técnico / '.config('app.LABEL_SYSTEM_NAME').'</h1>';
        $vars['htmlNoneItens'] = 'Nenhum dado extra para esta configuração.';

        $this->breadcrumb->setLabel($this->operation, 'Suporte Técnico');

        return ToolsTemplate::page($this->controller, $page, $vars);
    }

    public function about()
    {
        $info = parent::getBaseData('pageInfo');

        if (isset($info['company'])) {
            $this->company = $info['company'];
        }
        else {
            $this->company = config('app.LABEL_SYSTEM_VERSION');
        }

        $page = '
        <img src="'.assets_img('img-logo.png', 'painel').'" alt="'.config('app.LABEL_SYSTEM_AUTHOR').'" style="max-width: '.config('app.ABOUT_LOGO_WIDTH').'; width: 100%;" />

        <h6 class="mt-4"><b>Identificação:</b> '.config('app.LABEL_SYSTEM_TITLE').'</h6>
        <h6><b>Versão:</b> '.config('app.VERSION').'</h6>
        <h6><b>Desenvolvido por:</b> '.config('app.LABEL_SYSTEM_AUTHOR').'</h6>
        <h6><b>Licenciado para:</b> '.$this->company.'</h6>
        <h6><b>O '.config('app.LABEL_SYSTEM_NAME').' foi desenvolvido em:</b></h6>
        <ul>
            <li>HTML5 (linguagem de marcação de conteúdo)</li>
            <li>CSS3 (definição de estilos)</li>
            <li>JAVASCRIPT (linguagem de manipulação de eventos)</li>
            <li>PHP 8.3.2 (linguagem de programação)</li>
            <li>MYSQL 8 (banco de dados)</li>
            <li>NPM (automatização de tarefas)</li>
            <li>Composer (gerenciamento de dependências PHP)</li>
            <li>WEBPACK (gerenciamento de assets)</li>
        </ul>
        <h6>A '.config('app.LABEL_SYSTEM_AUTHORMIN').' utiliza sistemas gratuitos e livres para desenvolvimento e manutenção do framework:</h6>
        <ul>
            <li>Sublime Text 4 (GNU/GPL)</li>
            <li>Google Chrome</li>
            <li>NodeJS 12.16.0</li>
            <li>Apache 2.4.38 (GNU/GPL)</li>
            <li>Sistema melhor vizualizado em 1920 x 1080 pixels e True Color (32 bits).</li>
        </ul>
        <h6>A '.config('app.LABEL_SYSTEM_AUTHORMIN').', retêm todos os direitos autorais sobre esta página e sistema.</h6>

        <h6 class="mt-4"><b>Informações adicionais:</b></h6>
        <h6>Todos os direitos e responsabilidade do conteúdo armazenado reservados para o cliente licenciado.</h6>
        <h6>Todos direitos do '.config('app.LABEL_SYSTEM_NAME').' reservados a <b>'.config('app.LABEL_SYSTEM_AUTHOR').'.</b></h6>
        <h6 class="mb-4">Proibida sua reprodução parcial ou total. Copyright '.config('app.DATEFOUNDATION').'-'.date('Y').' © '.config('app.LABEL_SYSTEM_AUTHOR').'</h6>
        <a href="'.config('app.SITE_AUTHOR').'" target="_blank" title="'.config('app.LABEL_SYSTEM_AUTHOR').'"><img src="'.assets_img('signature.png', 'painel').'" alt="'.config('app.LABEL_SYSTEM_AUTHOR').'" style="max-width: '.config('app.ABOUT_COMPANY_WIDTH').'; width: 100%;" /></a>';

        $vars['htmlHeader'] = '<h1>Sobre o sistema</h1>';
        $vars['htmlNoneItens'] = 'Nenhum dado extra para esta configuração.';

        $this->breadcrumb->setLabel($this->operation, 'Sobre o sistema');

        return ToolsTemplate::page($this->controller, $page, $vars);
    }

    public function feedback()
    {
        $page = null;

        $vars['htmlHeader'] = '<h1>Feedback do Sistema</h1>';
        $vars['htmlNoneItens'] = 'Nenhum dado extra para esta configuração.';

        $this->breadcrumb->setLabel($this->operation, 'Feedback do Sistema');

        $page = '
        <div class="table-responsive">
            <table class="table table-striped table-bordered table-hover">
                <thead class="thin-border-bottom">
                    <tr>
                        <th class="center">módulo</th>
                        <th width="10%" class="center">ativados</th>
                        <th width="10%" class="center">desativados</th>
                        <th width="10%" class="center">pendentes</th>
                        <th width="10%" class="center">total de registros</th>
                    </tr>
                </thead>
                <tbody>';

                foreach ($this->modules->modulesSystem as $key => $modules) {
                    if ($modules['type'] == 'primary' && $modules['active'] == 1) {
                        $page .= '
                        <tr class="thin-border-bottom">
                            <td class="center">'.$modules['title'].'</td>
                            <td class="center">'.$this->modules->getFeedback($key, 'active').'</td>
                            <td class="center">'.$this->modules->getFeedback($key, 'disabled').'</td>
                            <td class="center">'.$this->modules->getFeedback($key, 'pendent').'</td>
                            <td class="center">'.$this->modules->getFeedback($key, 'total').'</td>
                        </tr>';
                    }
                }
                $page .= '
                </tbody>
            </table>
        </div>';

        return ToolsTemplate::page($this->controller, $page, $vars);
    }

    public function module_support()
    {
        $data = [
            'system' => config('app.PATH_CMS'),
            'version' => config('app.LABEL_SYSTEM_VERSION'),
            'name' => $this->administrator['name'],
            'email' => $this->administrator['email'],
            'assunt' => parent::post('assunt_support'),
            'message' => parent::post('message_support', 'text'),
            'timestamp' => date('Y/m/d H:i:s')
        ];

        $site = parent::getBaseData('pageSite');
        $info = parent::getBaseData('pageInfo');

        $bodySupport = '
            <p><b>Sistema/Versão:</b> '.$data['version'].'</p>
            <p><b>URL:</b> <a href="'.$data['system'].'" target="_blank" title="'.$site['title'].'">'.$data['system'].'</a></p>
            <p><b>Cliente:</b> '.$info['company'].'</p>
            <p><b>Registro:</b> '.$data['timestamp'].'
            <hr>
            <p><b>Nome do administrador:</b> '.$data['name'].'</p>
            <p><b>E-mail do administrador:</b> <a href="mailto:'.$data['email'].'">'.$data['email'].'</a></p>
            <p><b>Assunto:</b> '.$data['assunt'].'</p>
            <hr>
            <p><b>Mensagem:</b></p>
            '.parent::processString($data['message'], 'text').'
        ';

        $email = new \CoreSlim\Email();

        $emailVars['body_title'] = $data['assunt'];
        $emailVars['button_link'] = config('app.PATH_CMS');
        $emailVars['button_label'] = 'Acesse o '.config('app.LABEL_SYSTEM_NAME');
        $emailVars['body_text'] = $bodySupport;
        $emailVars['signature_label'] = $email->signature('signature_label');
        $emailVars['signature_link'] = $email->signature('signature_link');

        $email->setConfig('callback', parent::pathLang(null, config('app.PATH_SYSTEM').'system/static&operation=support'));
        $email->setConfig('reply', [$data['email'], $data['name']]);
        $email->setConfig('to', [config('app.LABEL_EMAIL_SUPPORT'), config('app.LABEL_SYSTEM_NAME')]);
        $email->setConfig('body', $bodySupport);
        $email->setConfig('form', 'pageConfigFormDefault');
        $email->setConfig('title', config('app.LABEL_NAME_SUPPORT').' - '.$data['assunt']);
        $email->setConfig('emailVars', $emailVars);
        $email->setConfig('recaptcha', false);

        if ($email->send()) {
            unset($email);

            $bodyConfirm = '
                <p>Sua mensagem foi enviada com sucesso. Aguarde que entraremos em contato.</p>
                <hr>'.$bodySupport;

            $email = new \CoreSlim\Email();

            $emailVars['body_title'] = 'Olá '.$this->processString($data['name'], 'first-name').',';
            $emailVars['button_link'] = config('app.PATH_CMS');
            $emailVars['button_label'] = 'Acesse o '.config('app.LABEL_SYSTEM_NAME');
            $emailVars['body_text'] = $bodyConfirm;
            $emailVars['signature_label'] = $email->signature('signature_label');
            $emailVars['signature_link'] = $email->signature('signature_link');

            $email->setConfig('callback', parent::pathLang(null, config('app.PATH_SYSTEM').'system/static&operation=support'));
            $email->setConfig('to', [$data['email'], $data['name']]);
            $email->setConfig('body', $bodyConfirm);
            $email->setConfig('form', 'pageConfigFormDefault');
            $email->setConfig('title', 'Confirmação de envio - '.config('app.LABEL_NAME_SUPPORT').' - '.$data['assunt']);
            $email->setConfig('emailVars', $emailVars);
            $email->send();

            header('Location: '.parent::pathLang(null, config('app.PATH_SYSTEM').'system/static&operation=support&callback=support_001'));
            exit;
        }
        else {
            header('Location: '.parent::pathLang(null, config('app.PATH_SYSTEM').'system/static&operation=support&callback=102'));
            exit;
        }
    }
}
