<?php
require_once(__DIR__.'/class.module.php');
$execute = new ModuleDoop('central');
echo $execute->modules->htmlHeader();
echo $execute->htmlFilterReport();

$stats = $execute->getStatsList();
?>
<hr class="hr hr-dotted">
<?php if (isset($stats['registers'])) { ?>
<div class="table-responsive">
    <table class="table table-striped table-bordered table-hover table-doop table-stats">
        <thead>
            <tr>
                <th>tipo de relatório</th>
                <th width="20%" class="center">período</th>
                <th width="20%" class="center">total</th>
            </tr>
        </thead>

        <tbody>
            <?php foreach ($stats['registers'] as $key => $value) { ?>
            <tr>
                <td><p><?php echo $value['title']; ?></p></td>
                <td class="center"><h4><?php echo $value['label']; ?></h4></td>
                <td class="center"><h4><b><?php echo $value['total']; ?></b></h4></td>
            </tr>
            <?php } ?>
        </tbody>

        <tfoot>
            <tr>
                <td colspan="2" class="center"><h4><?php echo $stats['all-registers']['label']; ?></h4></td>
                <td class="center"><h4><b><?php echo $stats['all-registers']['total']; ?></b></h4></td>
            </tr>
        </tfoot>
    </table>
</div>
    <?php if (isset($stats['graphics'])) { ?>
    <br>

    <div class="container">
        <canvas class="chartjs" id="chartStats" width="547" height="300"></canvas>
    </div>
    <?php } ?>

<?php } else { ?>
<div class="alert alert-warning">NENHUMA ESTATÍSTICA COMPUTADA</div>
<?php } ?>

<?php if (isset($stats['graphics'])) { ?>
<script>
    var grapichsLabels = [<?php echo $stats['graphics']['labels']; ?>];
    var grapichsValues = [<?php echo $stats['graphics']['values']; ?>];
    var grapichsTitle = '<?php echo $stats['graphics']['title']; ?>';
</script>
<?php } ?>
