<?php

class DayFilter extends MasterFilter
{
    public $keyUrl = 'day';

    public $moduleInstance = null;

    public function load()
    {
        if (!parent::load() && !$this->getUrl()) {
            if ($this->month()->get() !== 'all-months') {
                $this->set('all-days');
            }
        }
    }

    public function generateFilter()
    {
        $dataFilter = null;

        $stats = $this->statsFilter();

        if ($stats) {
            foreach ($stats as $key => $value) {
                $dataFilter[$key] = [
                    'key' => $key,
                    'value' => $this->setUrl($key),
                    'title' => $key.'/'.$this->month()->get().'/'.$this->year()->get(),
                    'selected' => $this->check($key),
                    'disabled' => false
                ];
            }

            $dataFilter['all-days'] = [
                'key' => 'all-days',
                'value' => $this->setUrl('all-days'),
                'title' => 'TODOS OS DIAS',
                'selected' => $this->check('all-days'),
                'disabled' => false
            ];

            $dataFirst = [
                'key' => 'none-select',
                'value' => $this->setUrl('none-select'),
                'title' => 'Selecione um dia...',
                'selected' => $this->check('none-select'),
                'disabled' => false
            ];

            array_unshift($dataFilter, $dataFirst);

            return $this->htmlSelect($dataFilter);
        }
    }

    public function statsFilter()
    {
        $stats = $this->year()->stats();
        $statsFilter = null;

        if (isset($stats['months'])) {
            foreach ($stats['months'] as $month => $monthData) {
                foreach ($monthData['days'] as $day => $dayData) {
                    $statsFilter[$day] = $dayData;
                }
            }
        }

        return $statsFilter;
    }

    public function listFilter()
    {
        $listFilter = null;

        $target = $this->target()->get();

        if ($target) {
            $stats = $this->target()->stats();

            if ($stats && $target == 'website' && $this->year()->get() != 'all-years' && $this->month()->get() != 'all-months') {
                foreach ($stats['period'][$this->year()->get()]['months'][$this->month()->get()]['days'] as  $day => $value) {
                    $listFilter[$day]['title'] = 'Acessos Website';
                    $listFilter[$day]['label'] = '<b class="text-uppercase">'.$day.'/'.$this->month()->get().'/'.$this->year()->get().'</b>';
                    $listFilter[$day]['total'] = $this->formatTotal($value);
                }

                ksort($listFilter);

                return $listFilter;
            }
            else if ($stats) {
                foreach ($stats['period'] as $idStats => $years) {
                    if (isset($years[$this->year()->get()]['months'][$this->month()->get()]['days'])) {
                        foreach ($years[$this->year()->get()]['months'][$this->month()->get()]['days'] as $day => $value) {
                            $listFilter[$idStats]['title'] = $this->getDatabase($idStats);
                            $listFilter[$idStats]['label'] = '<b class="text-uppercase">'.$day.'/'.$this->month()->get().'/'.$this->year()->get().'</b>';
                            $listFilter[$idStats]['total'] = $this->formatTotal($value);
                        }
                    }
                }

                if (isset($listFilter)) {
                    ksort($listFilter);

                    return $listFilter;
                }
            }
        }
    }
}
