<?php

class MonthFilter extends MasterFilter
{
    public $keyUrl = 'month';

    public $moduleInstance = null;

    public function load()
    {
        if (!parent::load() && !$this->getUrl()) {
            if ($this->year()->get() !== 'all-years') {
                $this->set(date('m'));
            }
            else {
                $this->set('all-months');
            }
        }
    }

    public function generateFilter()
    {
        $dataFilter = null;

        $stats = $this->statsFilter();

        if ($stats) {
            foreach ($stats as $key => $value) {
                $dataFilter[$key] = [
                    'key' => $key,
                    'value' => $this->setUrl($key),
                    'title' => strtoupper($this->controller()->processDate($key, 'month_name')).'/'.$this->year()->get(),
                    'selected' => $this->check($key),
                    'disabled' => false
                ];
            }

            $dataFilter['all-months'] = [
                'key' => 'all-months',
                'value' => $this->setUrl('all-months'),
                'title' => 'TODOS OS MESES',
                'selected' => $this->check('all-months'),
                'disabled' => false
            ];

            $dataFirst = [
                'key' => 'none-select',
                'value' => $this->setUrl('none-select'),
                'title' => 'Selecione um mês...',
                'selected' => $this->check('none-select'),
                'disabled' => false
            ];

            array_unshift($dataFilter, $dataFirst);

            return $this->htmlSelect($dataFilter);
        }
    }

    public function statsFilter()
    {
        $stats = $this->year()->stats();
        $statsFilter = null;

        if (isset($stats['months']) && !$this->year()->check('all-years')) {
            foreach ($stats['months'] as $month => $monthData) {
                $statsFilter[$month] = $monthData;
            }
        }

        return $statsFilter;
    }

    public function listFilter()
    {
        $listFilter = null;

        $target = $this->target()->get();

        if ($target && !$this->year()->check('all-years')) {
            $stats = $this->target()->stats();

            if ($stats && $target == 'website') {
                if (isset($stats['period'][$this->year()->get()]['months'])) {
                    foreach ($stats['period'][$this->year()->get()]['months'] as  $month => $value) {
                        $listFilter[$month]['title'] = 'Acessos Website';
                        $listFilter[$month]['label'] = '<b class="text-uppercase">'.$month.'/'.$this->year()->get().'</b>';
                        $listFilter[$month]['total'] = $this->formatTotal($value['total']);
                    }

                    ksort($listFilter);
                }

                return $listFilter;
            }
            else if ($stats) {
                if (isset($stats['period'])) {
                    foreach ($stats['period'] as $idStats => $years) {
                       foreach ($years as $year => $value) {
                            $listFilter[$idStats]['title'] = $this->getDatabase($idStats);
                            $listFilter[$idStats]['label'] = '<b class="text-uppercase">'.$year.'</b>';
                            $listFilter[$idStats]['total'] = $this->formatTotal($value['total']);
                        }
                    }

                    ksort($listFilter);
                }

                return $listFilter;
            }
        }
    }

    public function stats()
    {
        $stats = $this->target()->stats();
        $target = $this->get();

        foreach ($stats['period'] as $statsId => $years) {
            foreach ($years['months'] as $month => $monthData) {
                $statsMonth[$month] = $monthData;
            }
        }

        if (isset($statsMonth[$target])) {
            $statsMonth[$target];
        }

        return $statsMonth;
    }
}
