<?php

class TargetFilter extends MasterFilter
{
    public $keyUrl = 'target';

    public $moduleInstance = null;

    public function __construct($moduleInstance)
    {
        parent::__construct($moduleInstance);
    }

    public function generateFilter()
    {
        $dataFilter = [];

        $modulesSystem = $this->modulesSystem();

        if ($stats = $this->statsDatabase()) {
            foreach ($stats as $idStats => $valueStats) {
                if (count($valueStats) != 0 && isset($modulesSystem[$idStats])) {
                    $dataFilter[$modulesSystem[$idStats]['order']] = [
                        'key' => $idStats,
                        'value' => $this->setUrl($idStats).'&year=all-years&month=all-months&day=all-days',
                        'title' => 'Acessos - '.$modulesSystem[$idStats]['title'],
                        'selected' => $this->check($idStats),
                        'disabled' => false
                    ];
                }
            }
        }

        $dataFirst = [
            'key' => 'none-select',
            'value' => $this->setUrl('none-select'),
            'title' => 'Selecione um tipo de relatório...',
            'selected' => $this->check('none-select'),
            'disabled' => false
        ];

        array_unshift($dataFilter, $dataFirst);

        return $this->htmlSelect($dataFilter);
    }

    public function listFilter()
    {
        $listFilter = null;

        $stats = $this->stats();

        if ($stats && $this->has('website')) {
            $listFilter['label'] = '<b class="text-uppercase">TOTAL</b>';
            $listFilter['total'] = $this->formatTotal($stats['global']['total']);

            return $listFilter;
        }
        else if ($stats) {
            $listFilter['label'] = '<b class="text-uppercase">TOTAL</b>';
            $listFilter['total'] = $this->formatTotal($stats['global']['total']);

            return $listFilter;
        }
    }

    public function stats()
    {
        $stats = $this->statsDatabase();

        $target = $this->get();

        if (isset($stats[$target])) {
            return $stats[$target];
        }
    }
}
