<?php

// doopSites v1.9.7 - Última atualização 12/06/2020 17:22

class CallbackSite
{
    public $keyReturn = null;

    public $template = [
        'danger',
        'success',
        'warning',
        'info'
    ];

    public $key = null;
    public $type = null;
    public $title = null;
    public $message = null;

    public $return = null;
    public $locale = null;

    public function __construct($locale)
    {
        $this->keyReturn = $locale;
    }

    public function set($key, $location, $callback = true, $message = null, $type = null, $title = null)
    {
        $this->setSessions($key, $message, $type, $title);

        if ($callback) {
            header('Location: '.$location);
            exit;
        }
    }

    public function setSessions($key, $message = null, $type = null, $title = null)
    {
        $this->setTemplate($key, false);

        $_SESSION['callback']['code'] = $this->return['code'];

        $_SESSION['callback']['typealert'] = $this->return['type'];

        $_SESSION['callback']['type'] = $this->return['type'];
        $_SESSION['callback']['message'] = $this->return['message'];

        if (array_key_exists('title', $this->return)) {
            $_SESSION['callback']['title'] = $this->return['title'];
        }

        if (!is_null($message)) {
            $_SESSION['callback']['message'] = $message;
        }

        if (!is_null($type)) {
            $_SESSION['callback']['type'] = $type;
            $_SESSION['callback']['typealert'] = $type;
        }

        if (!is_null($title)) {
            $_SESSION['callback']['title'] = $title;
        }

        if ($this->return['type'] == 'danger') {
            $_SESSION['callback']['typealert'] = 'error';
        }
    }

    public function injectMessages($locales)
    {
        $this->locale = $locales;
    }

    public function setTemplate($code, $icons = false)
    {
        $this->setInfo($code);

        if ($icons) {
            switch ($this->type)
            {
                case 'danger': $icon = '<i class="fas fa-times"></i> '; break;
                case 'success': $icon = '<i class="fas fa-check"></i>'; break;
                case 'warning': $icon = '<i class="fas fa-exclamation-triangle"></i>'; break;
                case 'info': $icon = '<i class="fas fa-question-circle"></i>'; break;
            }

            $this->message = $icon.' '.$this->message;
        }


        $this->return = [
            'type' => $this->type,
            'title' => $this->title,
            'message' => $this->message,
            'code' => $code
        ];
    }

    public function getReturn()
    {
        if (array_key_exists('callback', $_SESSION)) {
            $callback = $_SESSION['callback'];

            unset($_SESSION['callback']);

            return $callback;
        }
        else {
            return null;
        }
    }

    public function setInfo($code)
    {
        if ($this->locale) {
            if (array_key_exists('type', $this->locale) && array_key_exists('message', $this->locale)) {
                $this->key = $this->locale['key'];

                if (array_key_exists('type', $this->locale)) {
                    $this->type = $this->locale['type'];
                }

                if (array_key_exists('title', $this->locale)) {
                    $this->title = $this->locale['title'];
                }

                if (array_key_exists('message', $this->locale)) {
                    $this->message = $this->locale['message'];
                }
            }
            else {
                foreach ($this->locale as $key => $value) {
                    if ($value == $code || $code == $key) {
                        $keyActive = str_replace('Key', '', $key);

                        $this->key = $key;

                        if (array_key_exists($keyActive.'Type', $this->locale)) {
                            $this->type = $this->locale[$keyActive.'Type'];
                        }

                        if (array_key_exists($keyActive.'Title', $this->locale)) {
                            $this->title = $this->locale[$keyActive.'Title'];
                        }

                        if (array_key_exists($keyActive.'Message', $this->locale)) {
                            $this->message = $this->locale[$keyActive.'Message'];
                        }
                    }
                }
            }
        }

        if (!$this->message) {
            foreach ($this->keyReturn['callback']['key'] as $key => $value) {
                if ($value == $code || $code == $key) {
                    $this->key = $key;

                    if (array_key_exists('status', $this->keyReturn['callback'])) {
                        $this->type = $this->keyReturn['callback']['status'][$key];
                    }

                    if (array_key_exists('title', $this->keyReturn['callback'])) {
                        $this->title = $this->keyReturn['callback']['title'][$key];
                    }

                    if (array_key_exists('message', $this->keyReturn['callback'])) {
                        $this->message = $this->keyReturn['callback']['message'][$key];
                    }
                }
            }
        }
    }
}
