<?php

// doopSites v1.9.7 - Última atualização 02/02/2023 17:16

class ModelSite extends CoreSlim\Database
{
    public $_lang = null;
    public $_table = null;
    public $_sufix = null;
    public $_value = null;
    public $_last = null;
    public $_tuplePrimary = 'id';
    public $_generateUuid = true;

    public function __construct($connection = null)
    {
        parent::__construct($connection);
    }

    public function setLangIso($parameter)
    {
        $this->_lang = $parameter;
    }

    public function getLangIso()
    {
        return $this->_lang;
    }

    public function setTable($parameter)
    {
        $this->_table = $parameter;
    }

    public function getTable()
    {
        return $this->_table;
    }

    public function setSufix($parameter)
    {
        $this->_sufix = $parameter;
    }

    public function getSufix()
    {
        return $this->_sufix;
    }

    public function setValue($parameter)
    {
        $this->_value = $parameter;
    }

    public function getValue()
    {
        return $this->_value;
    }

    public function setLast($parameter)
    {
        $this->_last = $parameter;
    }

    public function getLast()
    {
        return $this->_last;
    }

    public function setTuplePrimary($parameter)
    {
        $this->_tuplePrimary = $parameter;
    }

    public function getTuplePrimary()
    {
        return $this->_tuplePrimary;
    }

    public function setGenerateUuid($value)
    {
        $this->_generateUuid = $value;
    }

    public function getGenerateUuid()
    {
        return $this->_generateUuid;
    }

    public function sufix($parameter)
    {
        return $parameter . '_' . $this->getSufix();
    }

    public function unsufix($parameter)
    {
        $parameter = str_replace('_'.$this->getSufix(), '', $parameter);

        return $parameter;
    }

    public function dbPost($parameter, $type = 'injection')
    {
        return Request::post($this->sufix($parameter), $type);
    }

    public function dataSave($data, $type, $registry = true, $status = 'active')
    {
        foreach ($data as $field => $value) {
            if (!$value && $value != 0) {
                $value = "NULL";
            }
            else {
                $value = "'".$value."'";
            }

            $sql_field[] = "`".$field."`";
            $sql_value[] = $value;
            $sql_rules[] = "`".$field."` = ".$value;
        }

        $registry_field = null;
        $registry_value = null;

        if ($type == 'insert') {
            if ($registry == true) {
                $user = 5000;
                $time = date('Y-m-d H:i:s');

                if ($this->getGenerateUuid()) {
                    $uuid = Tools::generateUuid(uniqid());

                    $registry_field .= ", `".$this->sufix('uuid')."`";
                    $registry_value .= ", '".$uuid."'";

                    $data[$this->sufix('uuid')] = $uuid;
                }

                $registry_field .= ", `".$this->sufix('user')."`, `".$this->sufix('time')."`, `".$this->sufix('status')."`";
                $registry_value .= ", '".$user."', '".$time."', '".$status."'";

                $data[$this->sufix('user')] = $user;
                $data[$this->sufix('time')] = $time;
                $data[$this->sufix('status')] = $status;
            }

            $query = "INSERT INTO `".$this->getTable()."` (".implode(', ', $sql_field).$registry_field.")
                      VALUES (".implode(', ', $sql_value).$registry_value.")";

            if ($this->dbQuery($query, false)) {
                $this->setLast($this->dbLast());

                $data[$this->sufix('id')] = $this->getLast();

                return $data;
            }
        }
        else if ($type == 'update') {
            $query = "UPDATE `".$this->getTable()."` SET ".implode(', ', $sql_rules)."
                      WHERE `".$this->sufix($this->getTuplePrimary())."` = '".$this->getValue()."'";

            if ($this->dbQuery($query)) {
                return $data;
            }
        }
    }

    public function dataDuplicated($field = [], $value = [])
    {
        for ($i = 0; $i < count($field); $i++) {
            if ($i == 0) {
                $condition = "`".$this->sufix($field[$i])."` = '".$value[$i]."'";
            }
            else {
                $condition .= " AND `".$this->sufix($field[$i])."` = '".$value[$i]."'";
            }
        }

        $query = "SELECT `".$this->sufix($this->getTuplePrimary())."`
                  FROM `".$this->getTable()."`
                  WHERE ".$condition;

        if ($this->dbNumRows($query) > 0) {
            return true;
        }
        else {
            return false;
        }
    }

    public function getLabelMod($table, $sufix, $id, $label)
    {
        if (is_array($label)) {
            foreach ($label as $keyLabel => $valueLabel) {
                $newLabel[$key] = `".$valueLabel."_".$sufix."`;
            }

            $label = explode(',', $newLabel);
        }

        $result = $this->dbFetchAssoc("SELECT `".$label."_".$sufix."` FROM `".$table."` WHERE `id_".$sufix."` = '".$id."'");

        if (isset($result[$label.'_'.$sufix])) {
            return $result[$label.'_'.$sufix];
        }
    }

    public function getTupleMod($key, $select, $view = null, $where = 'id', $table = 'mod')
    {
        if (is_array($view)) {
            foreach ($view as $keyView => $valueView) {
                $newView[$keyView] = '`'.$valueView.'_'.$key.'`';
            }

            $view = implode(', ', $newView);

            $return = 'array';
        }
        else {
            $view = $view.'_'.$key;

            $return = 'string';
        }

        $result = $this->dbFetchAssoc("SELECT `".$view."` FROM `".$table."_".$key."` WHERE `".$where."_".$key."` = '".$select."'");

        if ($return == 'string') {
            if (isset($result[$view])) {
                return $result[$view];
            }
        }
        else {
            return $result;
        }
    }

    public function setBaseData($key, $array = null, $type = 'json')
    {
        if (is_null($array)) {
            $result = $this->dbFetchAssoc("SELECT `value_base` as value FROM `sis_base` WHERE `key_base` = '".$key."'");

            $base = null;

            if (@unserialize($result['value'])) {
                $base = unserialize($result['value']);
            }
            else if (@json_decode($result['value'])) {
                $base = json_decode($result['value'], true);
            }

            return $base;
        }
        else if (is_array($array)) {
            if ($type == 'serialize') {
                $base = serialize($array);
            }
            else if ($type == 'json') {
                $base = json_encode($array);
            }

            $check = $this->dbFetchAssoc("SELECT `value_base` FROM `sis_base` WHERE `key_base` = '".$key."'");

            if ($check) {
                $update = "UPDATE `sis_base` SET `value_base` = '".$base."' WHERE `key_base` = '".$key."'";

                $this->dbQuery($update);
            }
            else {
                $insert = "INSERT INTO `sis_base` (`id_base`, `key_base`, `value_base`) VALUES (NULL, '".$key."', '".$base."')";

                $this->dbQuery($insert);
            }
        }
    }

    public function getBaseData($key)
    {
        $result = $this->dbFetchAssoc("SELECT `value_base` as value FROM `sis_base` WHERE `key_base` = '".$key."'");

        $base = null;

        if (@unserialize($result['value'])) {
            $base = unserialize($result['value']);
        }
        else if (@json_decode($result['value'])) {
            $base = json_decode($result['value'], true);
        }

        return $base;
    }

    public function dataDelete($id)
    {
        $query = "DELETE FROM `".$this->getTable()."` WHERE `".$this->sufix($this->getTuplePrimary())."` = '".intval($id)."'";

        $this->dbQuery($query);

        return true;
    }

    public function dbGenerateOrder($field = [], $value = [])
    {
        $condition = null;

        for ($i = 0; $i < count($field); $i++) {
            if ($i == 0) {
                $condition = " AND `".$this->sufix($field[$i])."` = '".$value[$i]."'";
            }
            else {
                $condition .= " AND `".$this->sufix($field[$i])."` = '".$value[$i]."'";
            }
        }

        $query = "SELECT `".$this->sufix('id')."`
                  FROM `".$this->getTable()."` WHERE `".$this->sufix('status')."` = 'active'".$condition;

        $total = $this->dbNumRows($query);

        return $total + 1;
    }

    public function generatorOrder($extra = null)
    {
        return $this->dbNumRows("SELECT `".$this->sufix('id')."` FROM `".$this->getTable()."` WHERE `".$this->sufix('status')."` <> 'deleted' ".$extra) + 1;
    }
}
