<?php

// doopSites v1.9.7 - Última atualização 23/05/2023 12:27

class ModulesSite
{
    protected $core = null;

    public $box = null;
    public $module = null;
    public $dependences = null;
    public $page = [];
    public $prefixTable = 'mod';
    public $table = null;
    public $sufix = null;
    public $key = null;
    public $view = null;
    public $folder = null;
    public $querySearch = null;

    public $query = [
        'select' => '*',
        'limit' => 50,
        'orderby' => null,
        'where' => null,
        'join' => null,
        'groupby' => null,
        'having' => null
    ];

    public $og = null;
    public $defaultView = true;
    public $idSuperView = false;
    public $forceArchive = false;
    public $notOg = false;

    public $notView = [];
    public $selectView = [];

    public $resources = [
        'category' => [
            'active' => false,
            'command' => 'filter',
            'type' => 'list',
            'label' => null,
            'title' => null,
            'internal' => null,
            'key' => null,
            'view' => 'title',
            'positions' => [2, 3, 2],
            'multiple' => false,
            'notitle' => false,
            'manipuleLocale' => false,
            'order' => 'title',
            'total' => false,
            'prefixTable' => 'mod',
            'compare' => 'slug',
            'extraWhere' => null
        ],

        'period' => [
            'active' => false,
            'command' => 'filter',
            'type' => 'list',
            'label' => null,
            'title' => null,
            'internal' => null,
            'key' => null,
            'view' => 'dateinit',
            'positions' => [3, 4, 2],
            'multiple' => false,
            'notitle' => false,
            'manipuleLocale' => false,
            'order' => 'dateinit',
            'monthWhere' => true,
            'total' => false,
            'prefixTable' => 'mod',
            'extraWhere' => null
        ]
    ];

    public $features = [
        'search' => [
            'active' => true,
            'type' => 'aside',
            'label' => null,
            'internal' => null,
            'key' => null
        ],

        'galleryPhoto' => [
            'active' => true,
            'title' => null,
            'key' => 'gallery-photo',
            'cols' => 'flex-content-grid-4 flex-content-grid-xs-2',
            'limit' => null
        ],

        'galleryVideo' => [
            'active' => true,
            'title' => null,
            'key' => 'gallery-video',
            'cols' => 'flex-content-grid-2',
            'limit' => null
        ],

        'galleryAnexx' => [
            'active' => true,
            'title' => null,
            'key' => 'gallery-anexx',
            'cols' => null,
            'limit' => null,
            'prefix' => 'mod'
        ],

        'galleryAudio' => [
            'active' => true,
            'title' => null,
            'key' => 'gallery-audio',
            'cols' => null,
            'limit' => null
        ]
    ];

    public $extra = [
        'charTitle' => null,
        'charText' => null,
        'typeText' => 'string',
        'formatDate' => 'brazil',
        'tupleCover' => 'cover',
        'tuplePosition' => 2,
        'tupleSelected' => 'slug',
        'columns' => null,
        'budget' => false,
        'imagedefault' => false,
        'positionPrimary' => 1,
        'forcePrimary' => null,
        'urlTuplePrimary' => true,
        'grid' => 'col-xs-12 col-sm-6 col-md-4 col-lg-3',
        'fileType' => 'normal',
        'manipuleRouteLink' => true,
        'executeProcess' => true
    ];

    public $forceView = false;

    public $manipule = [
        'tupleSearch' => false,
        'uppertupleSearch' => false,
        'opengraph' => [
            'label',
            'text',
            'thumb',
            'keywords'
        ],
        'queryStatus' => true,
        'query' => false,
        'idRouteLink' => false,
        'urlCommand' => true,
        'secondBreadcrumbPrimary' => false
    ];

    public function __construct($core)
    {
        $this->core = $core;
    }

    public function core()
    {
        return $this->core;
    }

    public function getBox()
    {
        return $this->box;
    }

    public function setForceView($state)
    {
        $this->forceView = $state;
    }

    public function init($backend = null, $frontend = null, $box = null)
    {
        if ($backend && $frontend && $box) {
            $this->module = $backend;

            if ($this->module != 'ibge-state') {
                $this->table = $this->prefixTable.'_'.$backend;
            }
            else {
                $this->table = 'sis_'.$backend;
            }

            $this->sufix = $backend;
            $this->key = $frontend;
            $this->folder = $backend;
            $this->box = $box;
        }
        else if ($backend && $frontend && !$box) {
            if (Request::seo($this->extra['positionPrimary']) == $frontend) {
                $this->module = $backend;

                if ($this->module != 'ibge-state') {
                    $this->table = $this->prefixTable.'_'.$backend;
                }
                else {
                    $this->table = 'sis_'.$backend;
                }

                $this->sufix = $backend;
                $this->key = $frontend;
                $this->folder = $backend;

                if (Request::seo($this->extra['tuplePosition']) != $this->core()->getLocale('key', 'view') && Request::seo($this->extra['tuplePosition'] + 1) != $this->core()->getLocale('key', 'view') && !$this->forceView) {
                    $this->box = 'archive';
                }
                else {
                    $this->box = 'view';
                }
            }
        }
    }

    public function start($dataManipule = null)
    {
        if ($this->core()->database()->checkTable($this->table) && $this->extra['executeProcess']) {
            $this->controllerBox();

            $dataReturn = null;

            if (is_null($dataManipule)) {
                if ($this->box == 'view') {
                    $dataReturn = $this->view();
                }
                else if ($this->box == 'page' || $this->box == 'page-call') {
                    $dataReturn = $this->page();
                }
                else if ($this->box == 'group' || $this->box == 'group-call') {
                    $dataReturn = $this->pagesGroup();
                }
                else if ($this->box == 'archive' || $this->forceArchive) {
                    $dataReturn = $this->archive();
                }
                else {
                    $dataReturn = $this->data();
                }
            }
            else {
                $dataReturn = $dataManipule;
            }

            if (($this->box == 'view' || $this->box == 'archive' || $this->box == 'page' || $this->box == 'page-call'  || $this->box == 'group') && !$this->notOg) {
                $this->setOpenGraph($dataReturn);

                $dataReturn['og'] = $this->openGraph();
            }

            return $dataReturn;
        }
    }

    public function getTuples($result)
    {
        $data = [];

        if ($result) {
            if (!array_key_exists('id', $this->notView) && array_key_exists('id_'.$this->sufix, $result)) {
                $data['id'] = Treatment::string($result['id_'.$this->sufix], 'int');
            }

            if (!array_key_exists('code', $this->notView) && array_key_exists('code_'.$this->sufix, $result)) {
                $data['code'] = Treatment::string($result['code_'.$this->sufix], 'sstring');
            }

            if (!array_key_exists('title', $this->notView) && array_key_exists('title_'.$this->sufix, $result)) {
                $data['title'] = Treatment::string($result['title_'.$this->sufix], 'string', $this->extra['charTitle']);
            }

            if (!array_key_exists('title', $this->notView) && array_key_exists('title_'.$this->sufix, $result)) {
                $data['label'] = Treatment::string($result['title_'.$this->sufix]);
            }

            if (!array_key_exists('subtitle', $this->notView) && array_key_exists('subtitle_'.$this->sufix, $result)) {
                $data['subtitle'] = Treatment::string($result['subtitle_'.$this->sufix]);
            }

            if (!array_key_exists('slug', $this->notView) && array_key_exists('slug_'.$this->sufix, $result)) {
                $data['slug'] = Treatment::string($result['slug_'.$this->sufix], 'string');
            }

            if ($this->dependences) {
                foreach ($this->dependences as $key => $params) {
                    if (array_key_exists($key, $this->resources) && !array_key_exists('repository', $params)) {
                        $resources = $this->resources[$key];

                        if (!array_key_exists($key, $this->notView) && array_key_exists($key.'_'.$this->sufix, $result) && !array_key_exists('multiple', $params)) {
                            $keyData = $result[$key.'_'.$this->sufix];

                            $dependencesData = json_decode($keyData, true);

                            if (is_int($dependencesData)) {
                                $dependencesData = null;
                                $dependencesData[] = $keyData;
                            }

                            if ($dependencesData) {
                                foreach($dependencesData as $keyCategoryData => $value) {
                                    if (!is_array($resources['view']) && array_key_exists($resources['view'].'_'.$params['sufix'], $result)) {
                                        $viewDependences = $result[$resources['view'].'_'.$params['sufix']];

                                        if ($viewDependences) {
                                            $url = null;
                                            $slug = null;

                                            if (array_key_exists('slug_'.$params['sufix'], $result)) {
                                                $slug = Treatment::string($result['slug_'.$params['sufix']]);

                                                if ($this->box != 'archive') {
                                                    if (!array_key_exists('key', $params)) {
                                                        $this->dependences[$key]['key'] = null;

                                                        $params['key'] = $this->dependences[$key]['key'] = $this->core()->getLocale($key, 'key');
                                                    }

                                                    $url = Request::permalink($this->key.'/'.$slug);
                                                }
                                                else {
                                                    $url = Request::manipulationPermalink($resources['positions'], $slug, $this->key);
                                                }
                                            }

                                            $data['dependence'][] = [
                                                'id' => Treatment::string($result['id_'.$params['sufix']]),
                                                'title' => Treatment::string($viewDependences, 'string', 100),
                                                'label' => Treatment::string($viewDependences),
                                                'slug' => $slug,
                                                'url' => $url
                                            ];
                                        }
                                    }
                                }
                            }
                        }
                        else {
                            $queryDependences = "
                                SELECT `id_".$params['sufix']."` as id, `title_".$params['sufix']."` as title, `slug_".$params['sufix']."` as slug
                                FROM `".$params['multiple']['table']."`
                                INNER JOIN `".$this->table."` ON (`id_".$this->sufix."` = `".$params['multiple']['primarykeyforeing']."_".$params['multiple']['sufix']."` AND `status_".$this->sufix."` = 'active')
                                INNER JOIN `".$params['table']."` ON (`id_".$params['sufix']."` = `".$params['multiple']['secondarykeyforeing']."_".$params['multiple']['sufix']."` AND `status_".$params['sufix']."` = 'active')
                                WHERE `".$params['multiple']['primarykeyforeing']."_".$params['multiple']['sufix']."` = '".$data['id']."'
                                GROUP BY `id_".$params['sufix']."`";

                            $resultDependences = $this->core()->database()->dbFetchAll($queryDependences);

                            if ($resultDependences) {
                                foreach ($resultDependences as $key => $valueDependence) {
                                    $url = null;
                                    $slug = null;

                                    if (array_key_exists('slug', $valueDependence)) {
                                        $slug = Treatment::string($valueDependence['slug']);

                                        if ($resources['type'] == 'actionView') {
                                            if (!array_key_exists('key', $params)) {
                                                $this->dependences[$key]['key'] = null;

                                                $params['key'] = $this->dependences[$key]['key'] = $this->core()->getLocale($key, 'key');
                                            }

                                            $url = Request::permalink($params['key'].'/'.$this->core()->getLocale('key', 'view').'/'.$slug);
                                        }
                                        else {
                                            $url = Request::manipulationPermalink($resources['positions'], $slug, $this->key);
                                        }
                                    }

                                    $data['dependence'][] = [
                                        'id' => Treatment::string($valueDependence['id']),
                                        'title' => Treatment::string($valueDependence['title'], 'string', 100),
                                        'label' => Treatment::string($valueDependence['title']),
                                        'slug' => $slug,
                                        'url' => $url
                                    ];
                                }
                            }
                        }
                    }
                }
            }

            if (!array_key_exists('text', $this->notView) && array_key_exists('text_'.$this->sufix, $result)) {
                $data['text'] = Treatment::string($result['text_'.$this->sufix], $this->extra['typeText'], $this->extra['charText']);
            }

            if (!array_key_exists('hour', $this->notView) && array_key_exists('hour_'.$this->sufix, $result)) {
                $data['hour'] = Treatment::string($result['hour_'.$this->sufix], 'hour2digits');
            }

            if (!array_key_exists('date', $this->notView) && array_key_exists('date_'.$this->sufix, $result)) {
                $montDate = $result['date_'.$this->sufix];

                if (array_key_exists('hour_'.$this->sufix, $result)) {
                    $montDate .= ' '.$result['hour_'.$this->sufix];
                }

                if ($montDate != null) {
                    if ($this->extra['formatDate']) {
                        $data['date'] = Treatment::date($montDate, $this->extra['formatDate']);
                    }
                    else {
                        $data['date'] = Treatment::string($montDate);
                    }
                }
            }

            if (!array_key_exists('dateinit', $this->notView) && array_key_exists('dateinit_'.$this->sufix, $result)) {
                $dateInit = $result['dateinit_'.$this->sufix];

                if ($this->extra['formatDate']) {
                    $data['date'] = Treatment::date($dateInit, $this->extra['formatDate']);
                }
                else {
                    $data['date'] = Treatment::string($dateInit);
                }
            }

            if (!array_key_exists('url', $this->notView) && array_key_exists('slug_'.$this->sufix, $result)) {
                if ($this->extra['manipuleRouteLink']) {
                    $key = $this->extra['manipuleRouteLink'];
                }
                else {
                    $key = $this->key;
                }

                if (!$this->extra['urlTuplePrimary']) {
                    if ($this->extra['positionPrimary'] == 2) {
                        $key = Request::seo(1).'/'.Request::seo(2);
                    }

                    if ($this->box != 'page' && $this->box != 'page-call') {
                        $data['url'] = Request::permalink($key.'/'.$this->core()->getLocale('key', 'view').'/'.$result['slug_'.$this->sufix], $this->extra['forcePrimary']);
                    }
                    else {
                        $data['url'] = Request::permalink($key, $this->extra['forcePrimary']);
                    }
                }
                else {
                    if ($this->box != 'page') {
                        $data['url'] = Request::permalink($key.'/'.$result['slug_'.$this->sufix], $this->extra['forcePrimary']);
                    }
                    else {
                        $data['url'] = Request::permalink($result['slug_'.$this->sufix], $this->extra['forcePrimary']);
                    }
                }
            }

            if ($this->manipule['idRouteLink']) {
                if ($result['id_'.$this->sufix]) {
                    if ($this->extra['manipuleRouteLink']) {
                        $key = $this->extra['manipuleRouteLink'];
                    }
                    else {
                        $key = $this->key;
                    }

                    $get = $result['id_'.$this->sufix];

                    $data['url'] = Treatment::string(Request::permalink($key.'/'.$get), 'string');
                }
            }

            if (!array_key_exists('url', $this->notView) && array_key_exists('url_'.$this->sufix, $result)) {
                if ($result['url_'.$this->sufix]) {
                    $data['url'] = Treatment::string($result['url_'.$this->sufix], 'string');
                }
            }

            if (array_key_exists('url_'.$this->sufix, $result) && array_key_exists('internal_'.$this->sufix, $result)) {
                if ($result['url_'.$this->sufix] && $result['internal_'.$this->sufix]) {
                    switch ($result['internal_'.$this->sufix]) {
                        case 1:
                            $data['url'] = Request::permalink($result['url_'.$this->sufix]);
                        break;

                        case 2:
                            $data['url'] = Treatment::string($result['url_'.$this->sufix]);
                        break;

                        case 3:
                            $data['url'] = Request::permalink($this->core()->database()->getTupleMod('page', $result['url_'.$this->sufix], 'slug'));
                        break;
                    }
                }
            }

            if (!array_key_exists('target', $this->notView) && array_key_exists('target_'.$this->sufix, $result)) {
                $data['target'] = Treatment::string($result['target_'.$this->sufix], 'string');
            }

            if (!array_key_exists('thumb', $this->notView) && array_key_exists($this->extra['tupleCover'].'_'.$this->sufix, $result)) {
                if (!array_key_exists('covertype_'.$this->sufix, $result)) {
                    $tupleCover = $result[$this->extra['tupleCover'].'_'.$this->sufix];

                    if (@json_decode($tupleCover)) {
                        $tupleCover = json_decode($tupleCover, true);

                        $tupleCover = $tupleCover['name'];
                    }

                    $data['original'] = \CoreSlim\Assets::loadThumb($tupleCover, $this->folder, 'default', $this->extra['imagedefault']);
                    $data['thumb'] = \CoreSlim\Assets::loadThumb($tupleCover, $this->folder, 'thumb', $this->extra['imagedefault']);
                }
                else {
                    $cover = json_decode($result[$this->extra['tupleCover'].'_'.$this->sufix], true);

                    if ($result['covertype_'.$this->sufix] == 2 && isset($cover['name'])) {
                        $data['original'] = \CoreSlim\Assets::loadThumb($cover['name'], $this->folder, 'default', $this->extra['imagedefault']);
                        $data['thumb'] = \CoreSlim\Assets::loadThumb($cover['name'], $this->folder, 'thumb', $this->extra['imagedefault']);
                    }
                    else if ($result['covertype_'.$this->sufix] == 3) {
                        $data['video']['thumb'] = \CoreSlim\Assets::getVideoThumbnail($result[$this->extra['tupleCover'].'_'.$this->sufix]);
                        $data['video']['src'] = \CoreSlim\Assets::getVideo($result[$this->extra['tupleCover'].'_'.$this->sufix]);
                    }

                    if (!isset($data['original']) && !isset($data['video'])) {
                        $tupleCover = $result[$this->extra['tupleCover'].'_'.$this->sufix];

                        if (@json_decode($tupleCover)) {
                            $tupleCover = json_decode($tupleCover, true);

                            if (isset($tupleCover['name'])) {
                                $tupleCover = $tupleCover['name'];
                            }
                        }

                        $data['original'] = \CoreSlim\Assets::loadThumb($tupleCover, $this->folder, 'default', $this->extra['imagedefault']);
                        $data['thumb'] = \CoreSlim\Assets::loadThumb($tupleCover, $this->folder, 'thumb', $this->extra['imagedefault']);
                    }
                }

                if (!array_key_exists('legend', $this->notView) && array_key_exists('legend_'.$this->sufix, $result)) {
                    $data['legend'] = Treatment::string($result['legend_'.$this->sufix], 'string', 200);
                }

                if (!array_key_exists('credit', $this->notView) && array_key_exists('credit_'.$this->sufix, $result)) {
                    $data['credit'] = Treatment::string($result['credit_'.$this->sufix], 'string', 200);
                }
            }

            if (!array_key_exists('file', $this->notView) && array_key_exists('file_'.$this->sufix, $result)) {
                if ($this->extra['fileType'] == 'normal') {
                    $data['file'] = $result['file_'.$this->sufix];

                    if (@json_encode($data['file'])) {
                        $data['file'] = json_decode($data['file'], true);

                        $data['file'] = $data['file']['name'];
                    }

                    $data['file'] = \CoreSlim\Assets::loadThumb($data['file'], $this->folder, 'default', $this->extra['imagedefault']);

                    if (array_key_exists('mimetype_'.$this->sufix, $result)) {
                        $data['mimetype'] = Treatment::string($result['mimetype_'.$this->sufix], 'string');
                    }
                }
                else if ($this->extra['fileType'] == 'images-responsive') {
                    if (@json_encode($result['file_'.$this->sufix])) {
                        $file = json_decode($result['file_'.$this->sufix], true);

                        if (array_key_exists('desktop', $file)) {
                            $data['file']['desktop'] = \CoreSlim\Assets::loadThumb($file['desktop']['name'], $this->folder, 'default');
                        }

                        if (array_key_exists('mobile', $file)) {
                            $data['file']['mobile'] = \CoreSlim\Assets::loadThumb($file['mobile']['name'], $this->folder, 'default');
                        }

                        if (!array_key_exists('file', $data)) {
                            $data['file'] = \CoreSlim\Assets::loadThumb($file['name'], $this->folder, 'default');
                        }
                    }
                }
                else if ($this->extra['fileType'] == 'anexx') {
                    if (!@json_encode($result['file_'.$this->sufix])) {
                        $data['file'] = config('app.PATH_UPLOAD').'/'.$this->folder.'/'.$result['file_'.$this->sufix];
                    }
                    else {
                        $downloadJson = json_decode($result['file_'.$this->sufix], true);

                        $downloadJson['root'] = config('app.ROOT_UPLOAD').'/'.$this->folder.'/'.$downloadJson['name'];
                        $downloadJson['download'] = config('app.PATH_UPLOAD').'/'.$this->folder.'/'.$downloadJson['name'];

                        $data['file'] = config('app.PATH_API').'/getDownload.php?parameter='.base64_encode(json_encode($downloadJson));
                    }
                }
            }

            if (!array_key_exists('video', $this->notView) && array_key_exists('video_'.$this->sufix, $result)) {
                $data['video']['thumb'] = \CoreSlim\Assets::getVideoThumbnail($result['video_'.$this->sufix]);
                $data['video']['src'] = \CoreSlim\Assets::getVideo($result['video_'.$this->sufix]);
            }

            if ($this->box == 'archive' || $this->box == 'view' || $this->box == 'extra' || $this->box == 'group' || $this->box == 'page' || $this->box == 'page-call' || $this->box == 'group-call' || $this->box == 'index') {
                foreach($this->features as $key => $params) {
                    if ($this->features[$key]['active'] && array_key_exists('id_'.$this->sufix, $result)) {
                        $box = $this->extraBox($this->features[$key]['key'], $result['id_'.$this->sufix], $params);

                        if ($box) {
                            $data[$key] = $box;
                        }
                    }
                }
            }

            if ($this->extra['budget']) {
                if (array_key_exists('id_'.$this->sufix, $result)) {
                    $data['button']['url'] = Request::permalink($this->core()->getLocale('key', 'budget').'/'.$this->core()->getLocale('key', 'view').'/'.$result['id_'.$this->sufix]);
                    $data['button']['title'] = $this->core()->getLocale('extra', 'buttonbugdet');
                }
            }

            if ($this->selectView) {
                foreach($this->selectView as $key => $value) {
                    $tupleSufix = null;

                    if (array_key_exists($value['tuple'].'_'.$this->sufix, $result)) {
                        $tupleSufix = $result[$value['tuple'].'_'.$this->sufix];
                    }

                    if (array_key_exists('view', $value)) {
                        $valueTuple = $value['view'];
                    }
                    else {
                        $valueTuple = $value['tuple'];
                    }

                    if (!array_key_exists($value['tuple'], $this->notView)) {
                        if (array_key_exists('format', $value)) {
                            if ($value['format'] == 'date') {
                                if (array_key_exists('formatType', $value)) {
                                    $data[$valueTuple] = Treatment::date($tupleSufix, $value['formatType']);
                                }
                                else {
                                    $data[$valueTuple] = Treatment::date($tupleSufix, 'brazil');
                                }
                            }
                            else if ($value['format'] == 'unserialize') {
                                $data[$valueTuple] = unserialize($tupleSufix);
                            }
                            else if ($value['format'] == 'json') {
                                $data[$valueTuple] = json_decode($tupleSufix, true);
                            }
                            else if ($value['format'] == 'download') {
                                if (!@json_encode($tupleSufix)) {
                                    $data[$valueTuple] = config('app.PATH_UPLOAD').'/'.$this->folder.'/'.$tupleSufix;
                                }
                                else {
                                    $downloadJson = json_decode($tupleSufix, true);

                                    $downloadJson['root'] = config('app.ROOT_UPLOAD').'/'.$this->folder.'/'.$downloadJson['name'];
                                    $downloadJson['download'] = config('app.PATH_UPLOAD').'/'.$this->folder.'/'.$downloadJson['name'];

                                    $data[$valueTuple] = config('app.PATH_API').'/getDownload.php?parameter='.base64_encode(json_encode($downloadJson));
                                }
                            }
                            else if ($value['format'] == 'external') {
                                if ($value['formatType'] == 'string') {
                                    $data[$valueTuple] = null;

                                    if (array_key_exists('prefer', $value)) {
                                        if (array_key_exists($value['prefer'], $result)) {
                                            $data[$valueTuple] = Treatment::string($result[$value['prefer']], $value['formatType']);
                                        }
                                    }

                                    if (!$data[$valueTuple] && array_key_exists($value['tuple'], $result)) {
                                        $data[$valueTuple] = Treatment::string($result[$value['tuple']], $value['formatType']);
                                    }
                                }
                                else if ($value['formatType'] == 'image') {
                                    $data[$valueTuple] = [];

                                    $formatExtra = null;

                                    if (array_key_exists('formatExtra', $value)) {
                                        $formatExtra = $value['formatExtra'];
                                    }

                                    $formatFolder = $this->folder;

                                    if (array_key_exists('formatFolder', $value)) {
                                        $formatFolder = $value['formatFolder'];
                                    }

                                    $data[$valueTuple]['original'] = \CoreSlim\Assets::loadThumb($result[$value['tuple']], $formatFolder, 'default', $formatExtra);
                                    $data[$valueTuple]['thumb'] = \CoreSlim\Assets::loadThumb($result[$value['tuple']], $formatFolder, 'thumb', $formatExtra);
                                }
                                else if ($value['formatType'] == 'int') {
                                    $data[$valueTuple] = Treatment::handle($result[$value['tuple']], 'int');
                                }
                            }
                            else if ($value['format'] == 'str_pad') {
                                $data[$valueTuple] = str_pad($tupleSufix, 5, $value['formatType'], STR_PAD_LEFT);
                            }
                            else if ($value['format'] == 'str_pad_code') {
                                $data[$valueTuple] = "#".str_pad($tupleSufix, 5, $value['formatType'], STR_PAD_LEFT);
                            }
                            else if ($value['format'] == 'text') {
                                $data[$valueTuple] = Treatment::string($tupleSufix, 'text');
                            }
                           else if ($value['format'] == 'amount') {
                                $data[$valueTuple] = Treatment::string($tupleSufix, 'amount');
                            }
                            else if ($value['format'] == 'int') {
                                $data[$valueTuple] = Treatment::string($tupleSufix, 'int');
                            }
                            else if ($value['format'] == 'image') {
                                $data[$valueTuple]['original'] = \CoreSlim\Assets::loadThumb($tupleSufix, $this->folder, 'default', $this->extra['imagedefault']);
                                $data[$valueTuple]['thumb'] = \CoreSlim\Assets::loadThumb($tupleSufix, $this->folder, 'thumb', $this->extra['imagedefault']);
                            }
                            else if ($value['format'] == 'phones') {
                                if (@json_decode($tupleSufix)) {
                                    $tupleSufix = json_decode($tupleSufix, true);
                                }

                                $data[$valueTuple] = Tools::preparePhones($tupleSufix);
                            }
                            else if ($tupleSufix) {
                                $data[$valueTuple] = Treatment::string($tupleSufix, $value['format']);
                            }
                        }
                        else {
                            if ($tupleSufix) {
                                $data[$valueTuple] = Treatment::string($tupleSufix);
                            }
                        }
                    }
                }
            }
        }

        return $data;
    }

    public function controllerBox()
    {
        switch($this->box) {
            case 'page':
            case 'page-call':
            case 'group':
            case 'group-call':
            case 'view':
                if (!$this->view) {
                    if ($this->box == 'page' && Request::seo(1) && Request::seo(1) != $this->core()->getLocale('key', 'page')) {
                        if (!$this->key) {
                            $this->view = Request::seo(1);
                        }
                        else {
                            $this->view = $this->key;
                        }
                    }
                    else if ($this->box == 'page-call') {
                        $this->view = $this->key;
                    }
                    else if (Request::seo(1) == $this->core()->getLocale('key', 'page')) {
                        $this->view = Request::seo($this->extra['tuplePosition']);
                    }

                    if ($this->box == 'group-call' || $this->box == 'group') {
                        $this->view = $this->key;
                    }

                    if ($this->box == 'view' && Request::seo($this->extra['tuplePosition'] + 1) == $this->core()->getLocale('key', 'view')) {
                        $this->view = Request::seo($this->extra['tuplePosition'] + 2);
                    }
                    else if ($this->box == 'view' && Request::seo($this->extra['tuplePosition']) == $this->core()->getLocale('key', 'view')) {
                        $this->view = Request::seo($this->extra['tuplePosition'] + 1);
                    }
                    else if ($this->box == 'view' && Request::seo($this->extra['tuplePosition']) != $this->core()->getLocale('key', 'view')) {
                        $this->view = Request::seo($this->extra['tuplePosition']);
                    }

                    $this->extra['typeText'] = 'text';
                    $this->extra['charTitle'] = 'all';

                    if ($this->box != 'group' && $this->box != 'group-call') {
                        if (is_int($this->view)) {
                            $this->extra['tupleSelected'] = 'id';
                        }

                        $this->query['where'][] = "AND `".$this->extra['tupleSelected']."_".$this->sufix."` = '".$this->view."'";
                    }
                }
            break;

            case 'archive':
                $this->view = $this->key;

                if (is_null($this->query['limit'])) {
                    $this->query['limit'] = 6;
                }

                if (is_null($this->query['orderby'])) {
                    $this->query['orderby'] = "`time_".$this->sufix."` DESC";
                }

                if (is_null($this->extra['charTitle'])) {
                    $this->extra['charTitle'] = 150;
                }

                if (is_null($this->extra['charText'])) {
                    $this->extra['charText'] = 200;
                }
            break;

            case 'popular':
            case 'last':
            case 'index':
            case 'data':
            case 'all':
                $this->view = $this->key;

                if (is_null($this->query['orderby'])) {
                    if ($this->box != 'popular') {
                        $this->query['orderby'] = "`time_".$this->sufix."` DESC";
                    }
                    else {
                        $this->query['orderby'] = "`view_".$this->sufix."` DESC";
                    }
                }

                if (is_null($this->query['limit'])) {
                    $this->query['limit'] = 4;
                }

                if (is_null($this->extra['charTitle'])) {
                    $this->extra['charTitle'] = 200;
                }

                if (is_null($this->extra['charText'])) {
                    $this->extra['charText'] = 250;
                }

                if ($this->box == 'data') {
                    if (is_null($this->query['limit'])) {
                        $this->query['limit'] = 500;
                    }
                }
            break;

            case 'rotative-order':
            case 'rotative-rand':
            case 'rotative-time':
                if (is_null($this->query['orderby'])) {
                    if ($this->box == 'rotative-rand') {
                        $this->query['orderby'] = "RAND()";
                    }
                    else if ($this->box == 'rotative-order') {
                        $this->query['orderby'] = "`order_".$this->sufix."`";
                    }
                    else if ($this->box == 'rotative-time') {
                        $this->query['orderby'] = "`time_".$this->sufix."`";
                    }
                }

                if (is_null($this->query['limit'])) {
                    $this->query['limit'] = 15;
                }
            break;
        }
    }

    public function controllerReturn($module)
    {
        switch($this->box) {
            case 'rotative-order':
            case 'rotative-rand':
                unset($module['actions']);
                unset($module['pagination']);
            break;

            case 'popular':
            case 'last':
            case 'data':
                unset($module['page']);
                unset($module['actions']);
                unset($module['pagination']);
                unset($module['og']);
            break;
        }

        return $module;
    }

    public function controllerDefault()
    {
        if ($this->dependences && $this->resources) {
            foreach ($this->dependences as $key => $params) {
                if (array_key_exists($key, $this->resources)) {
                    if (!array_key_exists('repository', $params)) {
                        $foreignkey = $params['foreignkey']."_".$this->sufix;

                        if (strpos($params['foreignkey'], '-')) {
                            $foreignkey = $params['foreignkey'];
                        }

                        if (!$this->resources[$key]['multiple']) {
                            $this->query['join'][] = $params['join']." `".$params['table']."` ON (`".$params['primarykey']."` = `".$foreignkey."` AND `status_".$params['sufix']."` <> 'disabled')";
                        }
                        else {
                            $queryDependence = $params['join']." `".$params['table']."` ON (`status_".$params['sufix']."` <> 'disabled')";

                            $this->query['join'][] = $queryDependence;
                            $this->query['join'][] = $params['multiple']['join']." `".$params['multiple']['table']."` ON (`".$params['multiple']['primarykeyforeing']."_".$params['multiple']['sufix']."` = `id_".$this->sufix."` AND `".$params['multiple']['secondarykeyforeing']."_".$params['multiple']['sufix']."` = `".$params['primarykey']."`)";
                        }
                    }
                }
            }
        }

        $dataReturn = ['select' => null, 'join' => null, 'where' => null, 'groupby' => null, 'having' => null];

        if ($this->query['select']) {
            $dataReturn['select'] = $this->query['select'];
        }

        if ($this->query['join']) {
            $dataReturn['join'] = implode(' ', $this->query['join']);
        }

        if ($this->query['where']) {
            $dataReturn['where'] = implode(' ', $this->query['where']);
        }

        if ($this->query['groupby']) {
            $dataReturn['groupby'] = $this->query['groupby'];
        }

        if ($this->query['having']) {
            $dataReturn['having'] = implode(' ', $this->query['having']);
        }

        return $dataReturn;
    }

    public function manipulePage()
    {
        if ($this->page) {
            $dataReturn['header'] = $this->page[0];
            $dataReturn['header']['key'] = $this->key;
            $dataReturn['header']['module'] = $this->module;

            $dataReturn['breadcrumb'][] = ['title' => '<i class="fas fa-home" title="'.$this->core()->getLocale('extra', 'start').'"></i>', 'key' => 'index', 'url' => Request::permalink()];

            foreach($this->page as $key => $params) {
                $dataReturn['breadcrumb'][] = $params;
            }

            $infoModules = $this->core()->infoModules;

            if ($this->box == 'index') {
                if ($infoModules) {
                    if (array_key_exists($this->module, $infoModules)) {
                        if (isset($infoModules[$this->module]['scope']['index_hat']) && $infoModules[$this->module]['scope']['status_indexHat'] == 1) {
                            $dataReturn['header']['hat'] = Treatment::string($infoModules[$this->module]['scope']['index_hat']);
                        }

                        if (isset($infoModules[$this->module]['scope']['index_title'])) {
                            $dataReturn['header']['title'] = Treatment::string($infoModules[$this->module]['scope']['index_title']);
                            $dataReturn['header']['key'] = $this->module;
                        }

                        if (isset($infoModules[$this->module]['scope']['index_subtitle']) && $infoModules[$this->module]['scope']['status_indexSubtitle'] == 1) {
                            $dataReturn['header']['subtitle'] = Treatment::string($infoModules[$this->module]['scope']['index_subtitle']);
                        }

                        if (isset($infoModules[$this->module]['scope']['index_text']) && $infoModules[$this->module]['scope']['status_indexText'] == 1) {
                            $dataReturn['header']['text'] = Treatment::string(base64_decode($infoModules[$this->module]['scope']['index_text']));
                        }

                        if (isset($infoModules[$this->module]['scope']['index_readmore']) && $infoModules[$this->module]['scope']['status_indexReadmore'] == 1) {
                            $dataReturn['header']['index_readmore'] = Treatment::string($infoModules[$this->module]['scope']['index_readmore']);
                        }
                    }
                }
            }
            else {
                if ($infoModules) {
                    if (array_key_exists($this->module, $infoModules)) {
                        if ($infoModules[$this->module]['scope']['noneitens']) {
                            $dataReturn['header']['noneitens'] = Treatment::string($infoModules[$this->module]['scope']['noneitens']);
                        }
                    }
                }
            }

            if ($this->manipule['secondBreadcrumbPrimary']) {
                $dataReturn['header']['title'] = $dataReturn['breadcrumb'][2]['title'];
                $dataReturn['header']['url'] = $dataReturn['breadcrumb'][2]['url'];

                $dataReturn['breadcrumb'][1] = $dataReturn['breadcrumb'][2];

                unset($dataReturn['breadcrumb'][2]);
            }

            return $dataReturn;
        }
    }

    public function loadResources()
    {
        if ($this->resources) {
            $dataReturn = [];

            foreach($this->resources as $key => $params) {
                if ($params['active'] == true) {
                    if ($key !== 'period') {
                        if (array_key_exists($key, $this->dependences)) {
                            $dependences = $this->dependences[$key];

                            if (!$params['label'] && !$params['manipuleLocale']) {
                                $params['label'] = $this->resources[$key]['label'] = $this->core()->getLocale($key, 'label');
                            }
                            else if (!$params['label']) {
                                $params['label'] = $this->resources[$key]['label'] = $this->core()->getLocale($params['manipuleLocale'], 'label');
                            }

                            if (!$params['title'] && !$params['manipuleLocale']) {
                                $params['title'] = $this->resources[$key]['title'] = $this->core()->getLocale($key, 'title');
                            }
                            else if (!$params['title']) {
                                $params['title'] = $this->resources[$key]['title'] = $this->core()->getLocale($params['manipuleLocale'], 'title');
                            }

                            if (!$params['internal'] && !$params['manipuleLocale']) {
                                $params['internal'] = $this->resources[$key]['internal'] = $this->core()->getLocale($key, 'internal');
                            }
                            else if (!$params['internal']) {
                                $params['internal'] = $this->resources[$key]['internal'] = $this->core()->getLocale($params['manipuleLocale'], 'internal');
                            }

                            if (!$params['key']) {
                                $params['key'] = $this->resources[$key]['key'] = $this->core()->getLocale($key, 'key');
                            }

                            if (!array_key_exists('repository', $dependences)) {
                                $listRepo = $this->filterController('list', $this->sufix, $dependences, $params);

                                if (isset($listRepo[0])) {
                                    $dataReturn[$key] = [
                                        'info' => [
                                            'type' => $params['type'],
                                            'title' => $params['title'],
                                            'label' => $params['label'],
                                            'url' => $this->page[0]['url'],
                                            'internal' => $params['internal'],
                                            'notitle' => $params['notitle']
                                        ],
                                        'list' => $listRepo[0],
                                        'active' => false
                                    ];
                                }
                            }
                            else {
                                $dataReturn[$key] = [
                                    'info' => [
                                        'type' => $params['type'],
                                        'title' => $params['title'],
                                        'label' => $params['label'],
                                        'url' => $this->page[0]['url'],
                                        'internal' => $params['internal'],
                                        'notitle' => $params['notitle']
                                    ],
                                    'list' => $this->filterControllerRepository('list', $this->sufix, $dependences, $params),
                                    'active' => false
                                ];
                            }

                            if ($params['key'] != Request::seo($params['positions'][0]) && Request::seo(2) != $this->core()->getLocale('search', 'key')) {
                                $dataReturn[$key]['active'] = true;
                            }

                            if (!array_key_exists('repository', $dependences)) {
                                $breadcrumb = $this->filterController('breadcrumb', $this->sufix, $dependences, $params);
                            }
                            else {
                                $breadcrumb = $this->filterControllerRepository('breadcrumb', $this->sufix, $dependences, $params);
                            }

                            if ($breadcrumb) {
                                $this->page[] = $breadcrumb;
                            }

                            if ($params['command'] != 'none') {
                                if (!array_key_exists('repository', $dependences)) {
                                    $filter = $this->filterController('filter', $this->sufix, $dependences, $params);
                                }
                                else {
                                    $filter = $this->filterControllerRepository('filter', $this->sufix, $dependences, $params);
                                }

                                if ($filter && $this->box == 'archive') {
                                    $this->query['where'][] = $filter;
                                }
                            }
                        }
                    }
                    else if ($this->resources['period']['active']) {
                        if (!$params['label']) {
                            $params['label'] = $this->resources['period']['label'] = $this->core()->getLocale('period', 'label');
                        }

                        if (!isset($params['title'])) {
                            $params['title'] = $this->resources['period']['title'] = $this->core()->getLocale('period', 'title');
                        }

                        if (!$params['internal']) {
                            $params['internal'] = $this->resources['period']['internal'] = $this->core()->getLocale('period', 'internal');
                        }

                        if (!$params['key']) {
                            $params['key'] = $this->resources['period']['key'] = $this->core()->getLocale('period', 'key');
                        }

                        if (isset($listRepo[1])) {
                            $params['extraInner'] = $listRepo[1];
                        }

                        $dataReturn[$key] = [
                            'info' => [
                                'type' => $params['type'],
                                'title' => $params['title'],
                                'label' => $params['label'],
                                'url' => $this->page[0]['url'],
                                'internal' => $params['internal'],
                                'notitle' => $params['notitle']
                            ],
                            'list' => $this->filterPeriod('list', $this->module, $params)
                        ];

                        $breadcrumb = $this->filterPeriod('breadcrumb', $this->module, $params);

                        if ($breadcrumb) {
                            $this->page[] = $breadcrumb;
                        }

                        $filter = $this->filterPeriod('filter', $this->module, $params);

                        if ($filter) {
                            $this->query['where'][] = $filter;
                        }
                    }
                }
            }

            return $dataReturn;
        }
    }

    public function actionLoadSearch()
    {
        $dataReturn = null;

        if ($this->features['search']['active'] == true) {
            $keySearch = [];

            if ($this->dependences) {
                $keySearch = $this->dependences;
            }

            if (!$this->features['search']['label']) {
                $this->features['search']['label'] = $this->core()->getLocale('search', 'label');
            }

            if (!$this->features['search']['internal']) {
                $this->features['search']['internal'] = $this->core()->getLocale('search', 'placeholder');
            }

            if (!$this->features['search']['key']) {
                $this->features['search']['key'] = $this->core()->getLocale('search', 'key');
            }

            $params = [
                'dependences' => $keySearch,
                'type' => 'search'
            ];

            $dataReturn = [
                'title' => $this->features['search']['label'],
                'placeholder' => $this->features['search']['internal'],
                'action' => Request::permalink($this->key.'/'.$this->features['search']['key'])
            ];

            $dataReturn['filter'] = $this->filterSearch('filter');

            if ($dataReturn['filter']) {
                $this->query['where'][] = $dataReturn['filter'];

                $dataReturn['placeholder'] = 'Pesquisa: '.$_SESSION['string_search'];
            }

            $breadcrumb = $this->filterSearch('breadcrumb');

            if ($breadcrumb) {
                $this->page[] = $breadcrumb;
            }
        }

        return $dataReturn;
    }

    public function archive()
    {
        $module = [];

        if ($this->resources) {
            $module['actions'] = $this->loadResources();
            $module['actions']['search'] = $this->actionLoadSearch();
        }

        $controller = $this->controllerDefault();

        $paginationItem = $this->query['limit'];

        if ($this->manipule['queryStatus']) {
            $queryStatus = "`status_".$this->sufix."` <> 'disabled'";
        }
        else {
            $queryStatus = "`id_".$this->sufix."` <> '0'";
        }

        if (!$this->manipule['query']) {
            $paginationQuery = "SELECT ".$controller['select']." FROM `".$this->table."`
                                ".$controller['join']."
                                WHERE ".$queryStatus." ".$controller['where']."
                                GROUP BY `id_".$this->sufix."` ".$controller['groupby']."
                                ".$controller['having']."
                                ORDER BY ".$this->query['orderby'];
        }
        else {
            $paginationQuery = $this->manipule['query'];
        }

        $columns = $this->extra['columns'];
        $group = 0;
        $index = 0;

        $pagination = new \CoreSlim\Pagination([
            'locale' => $this->core()->locale['pagination'],
            'item' => $paginationItem,
            'query' => $paginationQuery
        ]);

        if ($queryData = $this->core()->database()->dbFetchAll($pagination->execute())) {
            foreach ($queryData as $keyQuery => $result) {
                if ($index == $columns) {
                    $group++;
                    $index = 0;
                }

                if ($columns) {
                    $data[$group][$index] = $this->getTuples($result);
                }
                else {
                    $data[$index] = $this->getTuples($result);
                }

                $index++;
            }

            if (!array_key_exists(1, $this->page)) {
                $module['pagination'] = $pagination->navigation($this->page[0]['url']);
            }
            else if (array_key_exists(1, $this->page)) {
                $module['pagination'] = $pagination->navigation($this->page[1]['url']);
            }

            $module['data'] = $data;
        }

        $module['page'] = $this->manipulePage();
        $module['extra'] = $this->extra;

        return $this->controllerReturn($module);
    }

    public function data()
    {
        $module = [];

        $controller = $this->controllerDefault();

        if ($this->manipule['queryStatus']) {
            $queryStatus = "`status_".$this->sufix."` = 'active'";
        }
        else {
            $queryStatus = "`id_".$this->sufix."` <> '0'";
        }

        if (!$this->manipule['query']) {
            $query = "SELECT ".$controller['select']." FROM `".$this->table."`
                     ".$controller['join']."
                     WHERE ".$queryStatus." ".$controller['where']."
                     GROUP BY `id_".$this->sufix."` ".$controller['groupby']."
                     ".$controller['having']."
                     ORDER BY ".$this->query['orderby']."
                     LIMIT ".$this->query['limit'];
        }
        else {
            $query = $this->manipule['query'];
        }

        $queryData = $this->core()->database()->dbFetchAll($query);

        $data = null;

        $columns = $this->extra['columns'];
        $group = 0;
        $index = 0;

        if ($queryData) {
            foreach($queryData as $key => $value) {
                if ($index == $columns) {
                  $group++;
                  $index = 0;
                }

                if ($columns) {
                    $data[$group][$index] = $this->getTuples($value);
                }
                else {
                  $data[$index] = $this->getTuples($value);
                }

                $index++;
            }
        }

        $module['page'] = $this->manipulePage();
        $module['data'] = $data;
        $module['extra'] = $this->extra;

        return $this->controllerReturn($module);
    }

    public function view()
    {
        $module = [];

        if ($this->resources) {
            $module['actions'] = $this->loadResources();
            $module['actions']['search'] = $this->actionLoadSearch();
        }

        $controller = $this->controllerDefault();

        $result = null;

        if ($this->view) {
            if ($this->manipule['queryStatus']) {
                $queryStatus = "`status_".$this->sufix."` <> 'disabled'";
            }
            else {
                $queryStatus = "`id_".$this->sufix."` <> '0'";
            }

            if (!$this->manipule['query']) {
                $query = "SELECT ".$controller['select']." FROM `".$this->table."`
                        ".$controller['join']."
                        WHERE ".$queryStatus." ".$controller['where'];
            }
            else {
                $query = $this->manipule['query'];
            }

            $result = $this->core()->database()->dbFetch($query);
        }

        if ($result) {
            if (isset($result['view_'.$this->sufix])) {
                $this->setStats($this->sufix, $result['id_'.$this->sufix], $this->table);

                $this->idSuperView = $result['id_'.$this->sufix];
            }

            $module['data'] = $this->getTuples($result);
        }

        if (is_null($result)) {
            $this->core()->executerErrorUrl();
        }

        $module['page'] = $this->manipulePage();

        if (array_key_exists('data', $module)) {
            if (array_key_exists('title', $module['data']) && array_key_exists('url', $module['data'])) {
                $module['page']['breadcrumb'][] = [
                    'title' => $module['data']['title'],
                    'url' => $module['data']['url']
                ];
            }
            else if (array_key_exists('name', $module['data']) && array_key_exists('url', $module['data'])) {
                $module['page']['breadcrumb'][] = [
                    'title' => $module['data']['name'],
                    'url' => $module['data']['url']
                ];
            }
        }

        return $module;
    }

    public function page()
    {
        $module = [];

        $controller = $this->controllerDefault();

        $result = null;

        if ($this->view) {
            $query = "SELECT * FROM `".$this->table."`
                     ".$controller['join']."
                     WHERE `status_".$this->sufix."` <> 'disabled' ".$controller['where'];

            $result = $this->core()->database()->dbFetch($query);
        }

        if ($result) {
            $url = $this->core()->getLocale('key', 'page').'/'.$result['slug_'.$this->sufix];

            if (Request::seo(1) != $this->core()->getLocale('key', 'page')) {
                $url = $result['slug_'.$this->sufix];
            }

            $this->page[] = [
                'title' => Treatment::string($result['title_'.$this->sufix]),
                'key' => $url,
                'url' => Request::permalink($url)
            ];

            $this->setStats($this->sufix, $result['id_'.$this->sufix], $this->table);

            $this->idSuperView = $result['id_'.$this->sufix];

            $module['data'] = $this->getTuples($result);
        }

        $module['page'] = $this->manipulePage();

        return $module;
    }

    public function pagesGroup()
    {
        $module = [];

        $controller = $this->controllerDefault();

        $dataGroup = null;

        if ($this->view) {
            $dataGroup = $this->core()->database()->dbFetch("SELECT `id_page-type`, `title_page-type` FROM `".$this->prefixTable."_page-type` WHERE `status_page-type` = 'active' AND `slug_page-type` = '".$this->view."'");
        }

        if ($dataGroup) {
            $this->page[] = ['title' => Treatment::string($dataGroup[1]),
                             'url' => Request::permalink($this->view)];

            $queryData = "SELECT * FROM `".$this->table."`
                          WHERE `status_".$this->sufix."` <> 'disabled' AND `type_".$this->sufix."` = '".$dataGroup[0]."'
                          GROUP BY `id_".$this->sufix."`
                          ORDER BY `order_".$this->sufix."`";

            if ($queryData = $this->core()->database()->dbFetchAll($queryData)) {
                $data = null;
                $index = 0;

                $active = null;

                if (Request::seo($this->extra['tuplePosition'])) {
                    $active = Request::seo($this->extra['tuplePosition']);
                }

                foreach ($queryData as $key => $result) {
                    $module['data'][$index] = $this->getTuples($result);

                    if (is_null($active)) {
                        $module['data'][0]['active'] = 'active';
                    }
                    else {
                        if ($module['data'][$index]['slug'] == $active) {
                            $module['data'][$index]['active'] = 'active';
                        }
                    }

                    $index++;
                }

                if ($module['data']) {
                    foreach($module['data'] as $key => $data) {
                        if (array_key_exists('slug', $data)) {
                            $module['data'][$key]['url'] = Request::permalink($this->view.'/'.$data['slug']);
                        }
                    }
                }
            }
        }

        $module['page'] = $this->manipulePage();

        return $module;
    }

    public function extraBox($type, $id, $params)
    {
        if ($this->features) {
            if ($type == 'gallery-photo') {
                $galleryPhoto = null;

                $galleryPhoto = $this->core()->extraPhoto($this->sufix, $id, $params);

                return $galleryPhoto;
            }

            if ($type == 'gallery-video') {
                $galleryVideo = null;

                $galleryVideo = $this->core()->extraVideo($this->sufix, $id, $params);

                return $galleryVideo;
            }

            if ($type == 'gallery-anexx') {
                $galleryAnexx = null;

                $galleryAnexx = $this->core()->extraAnexx($this->sufix, $id, $params);

                return $galleryAnexx;
            }

            if ($type == 'gallery-audio') {
                $galleryAudio = null;

                if (array_key_exists('galleryAudio', $this->features)) {
                    $galleryAudio = $this->core()->extraAudio($this->sufix, $id, $params);
                }

                return $galleryAudio;
            }
        }
    }

    public function filterController($type, $module, $dependences, $resources)
    {
        $command = Request::seo($resources['positions'][0]);

        if (!$command) {
            $command = null;
        }

        if (!array_key_exists('compare', $resources)) {
            $resources['compare'] = 'slug';
        }

        if ($type == 'list') {
            $status = "`id_".$dependences['sufix']."` <> '0'";
            $statusModule = null;

            if ($this->manipule['queryStatus']) {
                $status = "(`status_".$dependences['sufix']."` = 'active' OR `status_".$dependences['sufix']."` = 'old')";

                $statusModule = "AND (`status_".$module."` = 'active' OR `status_".$module."` = 'old')";

                if (array_key_exists('foreignsufix', $dependences)) {
                    $statusModule = "AND (`status_".$dependences['foreignsufix']."` = 'active' OR `status_".$dependences['foreignsufix']."` = 'old')";
                }
            }

            $foreignkey = $dependences['foreignkey']."_".$module;

            if (strpos($dependences['foreignkey'], '-')) {
                $foreignkey = $dependences['foreignkey'];
            }

            if (!array_key_exists('prefixTable', $resources)) {
                $tableInner = $this->prefixTable.'_'.$module;
            }
            else {
                $tableInner = $resources['prefixTable'].'_'.$module;
            }

            $countInner = 'id_'.$module;

            if (array_key_exists('foreigntable', $dependences)) {
                $tableInner = $dependences['foreigntable'];
            }

            if (array_key_exists('foreignsufix', $dependences)) {
                $countInner = 'id_'.$dependences['foreignsufix'];
            }

            $insertSelect = null;

            if (is_array($resources['order'])) {
                $manipuleOrder = null;

                foreach ($resources['order'] as $key => $value) {
                   $resources['order'][$key] = $value;
                }

                $manipuleOrder = implode(', ', $resources['order']);
            }
            else {
                $manipuleOrder = "`".$resources['order']."_".$dependences['sufix']."`";
            }

            if (is_array($resources['view'])) {
                $manipuleView = null;

                foreach ($resources['view'] as $key => $value) {
                   $resources['view'][$key] = "`".$value."_".$dependences['sufix']."`";
                }

                $manipuleView = implode(', ', $resources['view']);
            }
            else {
                $manipuleView = "`".$resources['view']."_".$dependences['sufix']."`";
            }

            if (!$resources['multiple']) {
                $innerSentence = "INNER JOIN `".$tableInner."` ON (`id_".$dependences['sufix']."` LIKE `".$foreignkey."` ".$statusModule.")";
                $innerSentenceTransfer = "INNER JOIN `".$dependences['table']."` ON (`id_".$dependences['sufix']."` = `".$foreignkey."`)";

                if ($resources['compare'] == 'slug') {
                    $querySql = "SELECT ".$manipuleView.", `slug_".$dependences['sufix']."`, `id_".$dependences['sufix']."`, COUNT(`".$countInner."`) as total FROM `".$dependences['table']."`
                                 ".$innerSentence."
                                 WHERE ".$status.$resources['extraWhere']."
                                 GROUP BY `id_".$dependences['sufix']."`
                                 ORDER BY ".$manipuleOrder;
                }
                else if ($resources['compare'] == 'id') {
                    $innerSentence = "INNER JOIN `".$tableInner."` ON (`id_".$dependences['sufix']."` = `".$foreignkey."` ".$statusModule.")";
                    $innerSentenceTransfer = "INNER JOIN `".$dependences['table']."` ON (`id_".$dependences['sufix']."` = `".$foreignkey."`)";

                    $querySql = "SELECT ".$manipuleView.", `id_".$dependences['sufix']."`, COUNT(`".$countInner."`) as total FROM `".$dependences['table']."`
                                 ".$innerSentence."
                                 WHERE ".$status.$resources['extraWhere']."
                                 GROUP BY `id_".$dependences['sufix']."`
                                 ORDER BY ".$manipuleOrder;
                }
                else if ($resources['compare']) {
                    $innerSentence = "INNER JOIN `".$tableInner."` ON (`id_".$dependences['sufix']."` = `".$foreignkey."` ".$statusModule.")";
                    $innerSentenceTransfer = "INNER JOIN `".$dependences['table']."` ON (`id_".$dependences['sufix']."` = `".$foreignkey."`)";

                    $querySql = "SELECT ".$manipuleView.", `".$resources['compare']."_".$dependences['sufix']."`, `id_".$dependences['sufix']."`, COUNT(`".$countInner."`) as total FROM `".$dependences['table']."`
                                 ".$innerSentence."
                                 WHERE ".$status.$resources['extraWhere']."
                                 GROUP BY `id_".$dependences['sufix']."`
                                 ORDER BY ".$manipuleOrder;
                }
            }
            else {
                $innerSentence = "".$dependences['multiple']['join']." `".$dependences['multiple']['table']."` ON (`".$dependences['multiple']['secondarykeyforeing']."_".$dependences['multiple']['sufix']."` = `".$dependences['primarykey']."`)
                                 INNER JOIN `".$tableInner."` ON (`".$dependences['multiple']['primarykeyforeing']."_".$dependences['multiple']['sufix']."` = `id_".$this->sufix."`)";

                $innerSentenceTransfer = "INNER JOIN `".$dependences['table']."` ON (`id_".$dependences['sufix']."` = `".$foreignkey."`)";

                $querySql = "SELECT ".$manipuleView.", `".$resources['compare']."_".$dependences['sufix']."`, `id_".$dependences['sufix']."`, COUNT(`".$countInner."`) as total FROM `".$dependences['table']."`
                             ".$innerSentence."
                             WHERE ".$status.$resources['extraWhere']."
                             GROUP BY `id_".$dependences['sufix']."`
                             ORDER BY ".$manipuleOrder;
            }

            $query = $this->core()->database()->dbQuery($querySql);

            if ($query) {
                if ($query->num_rows > 0) {
                    $dataReturn = null;

                    $index = 1;

                    while ($result = $query->fetch_array()) {
                        if (array_key_exists($resources['compare'].'_'.$dependences['sufix'], $result)) {
                            $slug = $result[$resources['compare'].'_'.$dependences['sufix']];
                        }

                        $dataReturn[$index]['url'] = Request::manipulationPermalink($resources['positions'], $slug);
                        $dataReturn[$index]['title'] = Treatment::string($result[0]);
                        $dataReturn[$index]['slug'] = $slug;
                        $dataReturn[$index]['key'] = $slug;

                        if ($resources['total']) {
                            $dataReturn[$index]['total'] = $result['total'];
                        }

                        $dataReturn[$index]['id'] = intval($result['id_'.$dependences['sufix']]);

                        if ($command == $slug) {
                            $dataReturn[$index]['active'] = true;
                        }
                        else {
                            $dataReturn[$index]['active'] = false;
                        }

                        $dataReturn[$index]['manipule'] = $result;

                        $index++;
                    }

                    return [$dataReturn, $innerSentenceTransfer];
                }
            }
        }
        else if ($type == 'filter' && Request::seo($resources['positions'][2]) !== $this->core()->getLocale('search', 'key') && Request::seo($resources['positions'][2]) !== $this->core()->getLocale('key', 'view')) {
            if ($command !== $resources['key'] && $command && (substr($command, 0, 7) != $this->core()->getLocale('pagination', 1) && substr($command, 0, 5) != $this->core()->getLocale('pagination', 1))) {
                $slug = $resources['compare']."_".$dependences['sufix'];

                if (!$resources['multiple']) {
                    return "AND `".$slug."` = '".$command."'";
                }
                else {
                    $status = null;

                    if ($this->manipule['queryStatus']) {
                        $status = "AND `status_".$dependences['sufix']."` <> 'disabled'";
                    }

                    $idSelectMultiple = $this->core()->database()->dbFetch("SELECT `id_".$dependences['sufix']."` FROM `".$dependences['table']."` WHERE `".$slug."` = '".$command."' ".$status);

                    $queryCondition = " AND `".$dependences['multiple']['secondarykeyforeing']."_".$dependences['multiple']['sufix']."` = '".$idSelectMultiple[0]."'";

                    return $queryCondition;
                }
            }
        }
        else if ($type == 'breadcrumb' && Request::seo($resources['positions'][2]) !== $this->core()->getLocale('search', 'key') && Request::seo($resources['positions'][2]) !== $this->core()->getLocale('key', 'view')) {
            if ($command !== $resources['key'] && $command) {
                $slug = $resources['compare'].'_'.$dependences['sufix'];

                if (is_array($resources['view'])) {
                    $manipuleView = null;

                    foreach ($resources['view'] as $key => $value) {
                       $resources['view'][$key] = "`".$value."_".$dependences['sufix']."`";
                    }

                    $manipuleView = implode(', ', $resources['view']);
                    $insertSelect = $manipuleView;
                }
                else {
                    $manipuleView = "`".$resources['view']."_".$dependences['sufix']."`";
                    $insertSelect = null;
                }

                $query = "SELECT ".$manipuleView.", `".$slug."`
                          FROM `".$dependences['table']."` WHERE `".$slug."` = '".$command."' LIMIT 1";

                $dataResult = $this->core()->database()->dbFetch($query);

                $end = null;

                if ($dataResult) {
                    $end = [
                        'key' => $command,
                        'title' => Treatment::string($dataResult[0]),
                        'url' => Request::manipulationPermalink($resources['positions'], $dataResult[1])
                    ];
                }

                return $end;
            }
        }
    }

    public function filterControllerRepository($type, $module, $dependences, $resources)
    {
        $command = Request::seo($resources['positions'][0]);

        $dataReturn = null;

        if ($type == 'list') {
            $repository = $this->core()->getRepository(0, $dependences['repository']);

            if ($repository) {
                foreach ($repository as $key => $value) {
                    $dataReturn[$key]['url'] = Request::manipulationPermalink($resources['positions'], $value['value']);
                    $dataReturn[$key]['title'] = Treatment::string($value['title']);
                    $dataReturn[$key]['slug'] = $value['value'];
                    $dataReturn[$key]['id'] = intval($value['value']);

                    if ($command == $value['value']) {
                        $dataReturn[$key]['active'] = true;
                    }
                    else {
                        $dataReturn[$key]['active'] = false;
                    }

                    $dataReturn[$key]['manipule'] = $value;
                }
            }
        }
        else if ($type == 'breadcrumb') {
            $repository = $this->core()->getRepository($command, $dependences['repository']);

            $end = null;

            foreach ($repository as $key => $value) {
                if ($value['selected']) {
                    $end = ['title' => Treatment::string($value['title']),
                            'url' => Request::manipulationPermalink($resources['positions'], $value['value'])];
                }
            }

            return $end;
        }
        else if ($type == 'filter') {
            $repository = $this->core()->getRepository($command, $dependences['repository']);

            $end = null;

            foreach ($repository as $key => $value) {
                if ($value['selected']) {
                    return "AND `".$resources['view']."_".$module."` = '".$value['value']."'";
                }
            }

            return $end;
        }

        return $dataReturn;
    }

    public function filterPeriod($type, $module, $resources)
    {
        $command = Request::seo($resources['positions'][0]);

        if ($type == 'list' && $command !== $this->core()->getLocale('key', 'view')) {
            $dataReturn = null;

            $monthWhere = null;

            if ($resources['monthWhere']) {
                $monthWhere = ", MONTH(`".$resources['view']."_".$module."`)";
            }

            if (!array_key_exists('prefixTable', $resources)) {
                $tableModule = $this->prefixTable.'_'.$module;
            }
            else {
                $tableModule = $resources['prefixTable'].'_'.$module;
            }

            if (isset($this->query['where']) && is_array($this->query['where'])) {
                if (is_null($resources['extraWhere'])) {
                    $resources['extraWhere'] = implode(' ', $this->query['where']);
                }
                else {
                    $resources['extraWhere'] = array_merge_recursive($resources['extraWhere'], $this->query['where']);

                    $resources['extraWhere'] = implode(' ', $resources['extraWhere']);
                }
            }

            $extraInner = null;

            if (isset($resources['extraInner'])) {
                $extraInner = $resources['extraInner'];
            }

            if (isset($resources['extraInnerInject'])) {
                if (isset($extraInner)) {
                    $extraInner = $extraInner." ".$resources['extraInnerInject'];
                }
                else {
                    $extraInner = $resources['extraInnerInject'];
                }
            }

            $querySql = "SELECT `".$resources['view']."_".$module."`, COUNT(`id_".$module."`) FROM `".$tableModule."`
                         ".$extraInner."
                         WHERE `status_".$module."` = 'active' ".$resources['extraWhere']."
                         GROUP BY YEAR(`".$resources['view']."_".$module."`)".$monthWhere."
                         ORDER BY `".$resources['view']."_".$module."` DESC";

            $query = $this->core()->database()->dbQuery($querySql);

            if ($query) {
                if ($query->num_rows !== 0) {
                    $dataReturn = null;

                    $index = 1;

                    while ($result = $query->fetch_array()) {
                        if ($result[0] != '0000-00-00') {
                            if ($resources['monthWhere']) {
                                 $filter = substr($result[0], 5, 2).'-'.substr($result[0], 0, 4);
                            }
                            else {
                                $filter = substr($result[0], 0, 4);
                            }

                            $dataReturn[$index]['url'] = Request::manipulationPermalink($resources['positions'], $filter);

                            if ($resources['total']) {
                                $dataReturn[$index]['total'] = $result[1];
                            }

                            $monthWhere = null;

                            if ($resources['monthWhere']) {
                                $monthWhere = Treatment::date(Treatment::date($result[0], 'month'), 'month_name').'/';
                            }

                            $dataReturn[$index]['title'] = $monthWhere.Treatment::date($result[0], 'year');

                            if (Request::seo($resources['positions'][0]) == $filter) {
                                $dataReturn[$index]['active'] = true;
                            }
                            else {
                                $dataReturn[$index]['active'] = false;
                            }

                            $index++;
                        }
                    }

                    return $dataReturn;
                }
            }
        }
        else if ($type == 'breadcrumb' && Request::seo($resources['positions'][2]) !== $this->core()->getLocale('search', 'key') && Request::seo($resources['positions'][2]) !== $this->core()->getLocale('key', 'view')) {
            if ($command !== $resources['key'] && $command) {

                if ($resources['monthWhere']) {
                    $year = intval(Treatment::date(substr($command, 3, 4), 'year'));

                    $url = Treatment::date(substr($command, 0, 2), 'month_name').'/'.$year;
                }
                else {
                    $year = intval($command);

                    $url = $year;
                }

                if ($year != 0) {
                    $end = [
                        'title' => $url,
                        'key' => $command,
                        'url' => Request::manipulationPermalink($resources['positions'], $command)
                    ];

                    return $end;
                }
            }
        }
        else if ($type === 'filter' && Request::seo($resources['positions'][2]) !== $this->core()->getLocale('search', 'key') && Request::seo($resources['positions'][2]) !== $this->core()->getLocale('key', 'view')) {
            if ($command !== $resources['key'] && $command) {
                if ($resources['monthWhere']) {
                    $month = substr(Request::seo($resources['positions'][0]), 0, 2);
                    $year = intval(substr(Request::seo($resources['positions'][0]), 3, 4));
                }
                else {
                    $month = null;
                    $year = intval(Request::seo($resources['positions'][0]));
                }

                $monthWhere = null;

                if ($resources['monthWhere']) {
                    $monthWhere = " AND MONTH(`".$resources['view']."_".$module."`) = '".$month."'";
                }

                if ($year != 0) {
                    return "AND YEAR(`".$resources['view']."_".$module."`) = '".$year."'".$monthWhere;
                }
            }
        }
    }

    public function filterSearch($type, $searchPosition = 3)
    {
        if ($type == 'filter') {
            if (Request::post('submitSearch_internal') == 'submitSearch_internal') {
                if (!$this->manipule['tupleSearch']) {
                    $queryPrimary = "SELECT * FROM `".$this->table."`";
                }
                else if (is_array($this->manipule['tupleSearch'])) {
                    foreach ($this->manipule['tupleSearch'] as $keyTuple) {
                        $tuples[] = '`'.$keyTuple.'`';
                    }

                    $queryPrimary = "SELECT ".implode(', ', $tuples)." FROM `".$this->table."`";
                }

                if ($primary = $this->core()->database()->dbFields($queryPrimary)) {
                    if (!$this->manipule['uppertupleSearch']) {
                        $_SESSION['string_search'] = Request::post('stringSearch_internal');
                    }
                    else {
                        $_SESSION['string_search'] = strtoupper(Request::post('stringSearch_internal'));
                    }

                    $this->querySearch = null;

                    if (!$this->manipule['tupleSearch']) {
                        if (is_array($this->dependences) && count($this->dependences) > 0) {
                            foreach($this->dependences as $dependence) {
                                $queryRelative = "SELECT * FROM `".$dependence['table']."`";

                                if ($relative = $this->core()->database()->dbFieldsSearch($queryRelative, $table)) {
                                    foreach ($relative as $key => $fieldRelative) {
                                        if (isset($fieldRelative['native_type']) && ($fieldRelative['native_type'] == 'DATE' || $fieldRelative['native_type'] == 'DATETIME') && \DateTime::createFromFormat('Y-m-d H:i:s', Treatment::date($_SESSION['string_search'], 'mysql').' 00:00:00') !== false) {
                                            $this->querySearch[] = "(`".$fieldRelative['name']."` = '".Treatment::date($_SESSION['string_search'], 'mysql')."')";
                                        }
                                        else if (isset($fieldRelative['native_type']) && $fieldRelative['native_type'] == 'VAR_STRING') {
                                            $this->querySearch[] = "(`".$fieldRelative['name']."` LIKE '%".Treatment::string($_SESSION['string_search'])."%')";
                                        }
                                        else {
                                            $this->querySearch[] = "(`".$fieldRelative['name']."` LIKE '%".Treatment::string($_SESSION['string_search'], 'text')."%')";
                                        }
                                    }
                                }
                            }
                        }
                    }

                    foreach ($primary as $key => $fieldPrimary) {
                        if (isset($fieldPrimary['native_type']) && ($fieldPrimary['native_type'] == 'DATE' || $fieldPrimary['native_type'] == 'DATETIME') && \DateTime::createFromFormat('Y-m-d H:i:s', Treatment::date($_SESSION['string_search'], 'mysql').' 00:00:00') !== false) {
                            $this->querySearch[] = "(`".$fieldPrimary['name']."` = '".Treatment::date($_SESSION['string_search'], 'mysql')."')";
                        }
                        else if (isset($fieldPrimary['native_type']) && $fieldPrimary['native_type'] == 'VAR_STRING') {
                            $this->querySearch[] = "(`".$fieldPrimary['name']."` LIKE '%".Treatment::string($_SESSION['string_search'])."%')";
                        }
                        else {
                            $this->querySearch[] = "(`".$fieldPrimary['name']."` LIKE '%".Treatment::string($_SESSION['string_search'], 'text')."%')";
                        }
                    }

                    if (is_array($this->querySearch)) {
                        $_SESSION['string_query'] = "AND (".implode(' OR ', $this->querySearch).")";

                        return $_SESSION['string_query'];
                    }
                }
            }
            else if (Request::seo($searchPosition) === $this->core()->getLocale('search', 'key')) {
                return $_SESSION['string_query'];
            }
            else {
                $_SESSION['string_search'] = null;
                $_SESSION['string_query'] = null;
            }
        }
        else if ($type == 'breadcrumb' && Request::seo($searchPosition) == $this->core()->getLocale('search', 'key')) {
            if ($_SESSION['string_search']) {
                $end = [
                    'title' => 'Pesquisa: '.Treatment::string($_SESSION['string_search']),
                    'key' => 'pesquisa',
                    'url' => null
                ];

                return $end;
            }
        }
    }

    public function urlOnlyParams($url)
    {
        $base = explode('/', BASE_PATH);

        foreach ($base as $value) {
            $url = str_replace($value, '/', $url);
        }

        $url = str_replace('///', '/', $url);
        $url = str_replace('//', '/', $url);

        return $url;
    }

    public function openGraph()
    {
        if (!$this->og) {
            $site = $this->core()->database()->getBaseData('pageSite');
            $assets = $this->core()->database()->getBaseData('pageAssets');

            $filePath = null;

            if (isset($assets['logoopengraph']['file'])) {
                $filePath = \CoreSlim\Assets::loadThumb($assets['logoopengraph']['file'], 'configuration', 'default');
            }

            if (isset($site['title'])) {
                $this->og = [
                    'site_name' => $site['title'],
                    'url' => Request::permalink(),
                    'title' => $site['metatitle'],
                    'description' => $site['metadescription'],
                    'type' => 'website',
                    'image' => $filePath
                ];
            }
        }

        return $this->og;
    }

    public function setOpenGraph($data, $forceData = false)
    {
        $assets = $this->core()->database()->getBaseData('pageAssets');

        $core = $this->core()->render()->getVars('core');

        $resultSeo = [
            'seo' => null,
            'auths' => null,
            'scripts' => null
        ];

        if ($this->extra['executeProcess'] && array_key_exists('data', $data) && ($this->box == 'view' || $this->box == 'page' || $this->box == 'page-call')) {
            if ($this->idSuperView) {
                $querySeo = "SELECT `seo_config`, `auths_config`, `scripts_config` FROM `sub_config` WHERE `table_config` = '".$this->prefixTable."_".$this->module."' AND `tuple_config` = '".$this->idSuperView."'";

                $dataSeo = $this->core()->database()->dbFetch($querySeo);

                if (!$dataSeo) {
                    $resultSeo = [];
                }
                else {
                    if (@json_decode($dataSeo['seo_config'])) {
                        $resultSeo['seo'] = json_decode($dataSeo['seo_config'], true);
                    }

                    if (@json_decode($dataSeo['auths_config'])) {
                        $resultSeo['auths'] = json_decode($dataSeo['auths_config'], true);
                    }

                    if (@json_decode($dataSeo['scripts_config'])) {
                        $resultSeo['scripts'] = json_decode($dataSeo['scripts_config'], true);

                        foreach ($resultSeo['scripts'] as $key => $value) {
                            $resultSeo['scripts'][$key] = Treatment::string($value, 'code');
                        }

                        $this->core()->render()->setVars('scripts_internal', $resultSeo['scripts']);
                    }
                }
            }

            $label = $this->og['site_name'] = null;

            if (array_key_exists($this->manipule['opengraph'][0], $data['data'])) {
                $label = Treatment::string($data['data'][$this->manipule['opengraph'][0]], 'unserializestring');
            }

            if ($label) {
                $this->og['site_name'] = Treatment::string($label.' - '.$core['title'], 'unserializestring');

                $this->og['title'] = $this->og['title'] = $core['title'] = $core['metatitle'] = $this->og['site_name'];
            }

            if (isset($resultSeo['seo']['title']) && $resultSeo['seo']['title']) {
                $this->og['site_name'] = $this->og['title'] = $core['metatitle'] = Treatment::string($resultSeo['seo']['title'], 'unserializestring');
            }

            if (array_key_exists($this->manipule['opengraph'][1], $data['data'])) {
                $this->og['description'] = $core['metadescription'] = Treatment::string($data['data'][$this->manipule['opengraph'][1]], 'string', 250);
            }

            if (isset($resultSeo['seo']['description']) && $resultSeo['seo']['description']) {
                 $this->og['description'] = $core['metadescription'] = Treatment::string($resultSeo['seo']['description'], 'unserializestring');
            }

            if (array_key_exists($this->manipule['opengraph'][3], $data['data'])) {
                $core['metakeywords'] = Treatment::string($data['data'][$this->manipule['opengraph'][3]], 'string', 200);
            }

            if (isset($resultSeo['seo']['keywords']) && $resultSeo['seo']['keywords']) {
                $core['metakeywords'] = Treatment::string($resultSeo['seo']['keywords'], 'unserializestring');
            }

            $this->core()->render()->setVars('core', $core);

            if (array_key_exists('url', $data['data'])) {
                $this->og['url'] = $data['data']['url'];
            }

            $this->og['type'] = 'article';

            if (array_key_exists($this->manipule['opengraph'][2], $data['data'])) {
                if ($data['data'][$this->manipule['opengraph'][2]]) {
                    $this->og['image'] = $data['data'][$this->manipule['opengraph'][2]];
                }
                else if (isset($assets['logoopengraph']['file'])) {
                    $filePath = \CoreSlim\Assets::loadThumb($assets['logoopengraph']['file'], 'configuration', 'default');

                    $this->og['image'] = $filePath;
                }
            }
            else {
                $filePath = \CoreSlim\Assets::loadThumb($assets['logoopengraph']['file'], 'configuration', 'default');

                $this->og['image'] = $filePath;
            }

        }
        else if ($this->extra['executeProcess'] && array_key_exists('data', $data) && $this->box == 'archive') {
            if (array_key_exists($this->module, $this->core->infoModules)) {
                $infoModule = $this->core->infoModules[$this->module]['scope'];
            }
            else {
                $infoModule = [];
            }

            $core = $this->core()->render()->getVars('core');

            if (array_key_exists('title_seo', $infoModule)) {
                if ($infoModule['title_seo']) {
                    $this->og['site_name'] = $this->og['title'] = $core['title'] = $core['metatitle'] = Treatment::string($infoModule['title_seo'].' - '.$core['title'], 'unserializestring');
                }
            }

            if (array_key_exists('description_seo', $infoModule)) {
                if ($infoModule['description_seo']) {
                    $this->og['description'] = $core['metadescription'] = Treatment::string($infoModule['description_seo'], 'unserializestring');
                }
            }

            if (array_key_exists('keywords_seo', $infoModule)) {
                if ($infoModule['keywords_seo']) {
                    $core['metakeywords'] = Treatment::string($infoModule['keywords_seo'], 'unserializestring');
                }
            }

            if (array_key_exists('url', $data['page']['header'])) {
                $this->og['url'] = $data['page']['header']['url'];
            }

            $assets = $this->core()->database()->getBaseData('pageAssets');

            $filePath = \CoreSlim\Assets::loadThumb($assets['logoopengraph']['file'], 'configuration', 'default');

            $this->og['image'] = $filePath;

            $this->og['type'] = 'website';

            $count = count($this->page);

            if ($count == 2) {
                $this->og['site_name'] = $this->og['title'] = $core['title'] = $core['metatitle'] = $this->page[1]['title'] . ' - ' . $this->page[0]['title'] . ' - ' . $core['title'];
            } else if ($count == 3) {
                $this->og['site_name'] = $this->og['title'] = $core['title'] = $core['metatitle'] = $this->page[1]['title'] . ' - ' . $this->page[2]['title'] . ' - ' . $this->page[0]['title'] . ' - ' . $core['title'];
            }

            if ($forceData) {
                $label = $this->og['site_name'] = null;

                $label = $data['page']['header']['title'];

                if ($label) {
                    $this->og['site_name'] = Treatment::string($label.' - '.$core['title'], 'unserializestring');

                    $this->og['title'] = $this->og['title'] = $core['title'] = $core['metatitle'] = $this->og['site_name'];
                }
            }

            $this->core()->render()->setVars('core', $core);
        }
    }

    public function setStats($type, $id = null, $table = null)
    {
        $stats = new \CoreSlim\Stats\StatsCentral($type, $id, $table);
        $stats->add();
    }

    public function urlResoucesFull($notperiod = true, $notpagination = true, $notCategory = true)
    {
        $link = $this->key;

        $category = $this->core()->getLocale('category', 'key');
        $period = $this->core()->getLocale('period', 'key');
        $pagination = $this->core()->getLocale('pagination', 7);

        if ($notCategory) {
            $link .= '/'.$category;
        }

        if ($notperiod) {
            $link .= '/'.$period;
        }

        if ($notpagination) {
            $link .= '/'.$pagination;
        }

        return Request::permalink($link);
    }

    public function setDependencesCategory()
    {
        return [
            'table' => $this->prefixTable.'_'.$this->module.'-category',
            'sufix' => $this->module.'-category',
            'primarykey' => 'id_'.$this->module.'-category',
            'foreignkey' => 'category',
            'join' => 'INNER JOIN',
            'key' => $this->core->getLocale('category', 'key')
        ];
    }
}
