<?php

// doopSites v1.9.7 - Última atualização 12/02/2020 16:57

class RenderSite
{
    private $instance = null;
    private $loader = null;

    public $vars = [];

    public $template = null;

    public $dirs = null;

    public function __construct()
    {

    }

    public function setVars($type, $key, $params = null)
    {
        if (!empty($params)) {
            $this->vars[$type][$key] = $params;
        }
        else {
            $this->vars[$type] = $key;
        }
    }

    public function setDirs($type, $key)
    {
        $this->dirs[$type] = $key;
    }

    public function getVars($key = null)
    {
        if (!$key) {
            return $this->vars;
        }
        else {
            if (array_key_exists($key, $this->vars)) {
                return $this->vars[$key];
            }
        }
    }

    public function setTemplate($template)
    {
        $this->template = $template;
    }

    public function init($view = null, $callback = false)
    {
        $pathModule[] = config('app.ROOT_SITE').'/template';

        if (is_array($this->dirs)) {
            foreach ($this->dirs as $key => $value) {
                $pathModule[] = $value;
            }
        }

        $this->loader = new \Twig\Loader\FilesystemLoader($pathModule);

        if (config('app.ENV') == 'development') {
            $this->instance = new \Twig\Environment($this->loader);
        }
        else {
            $this->instance = new \Twig\Environment($this->loader);
        }

        $this->instance->addFunction(
            new \Twig\TwigFunction('form_token',
                function ($lock_to = null) {
                    if (empty($_SESSION['token'])) {
                        $_SESSION['token'] = bin2hex(random_bytes(32));
                    }

                    if (empty($_SESSION['token2'])) {
                        $_SESSION['token2'] = random_bytes(32);
                    }

                    if (empty($lock_to)) {
                        return $_SESSION['token'];
                    }

                    return hash_hmac('sha256', $lock_to, $_SESSION['token2']);
                }
            )
        );

        $this->instance->addFunction(
            new \Twig\TwigFunction('assets_css',
                function ($filename, $privateProvider = 'site', $min = true, $version = true) {
                    return \CoreSlim\Filesystem::css($filename, $privateProvider, $min, $version);
                }
            )
        );

        $this->instance->addFunction(
            new \Twig\TwigFunction('assets_js',
                function ($filename, $privateProvider = 'site', $min = true, $version = true) {
                    return \CoreSlim\Filesystem::js($filename, $privateProvider, $min, $version);
                }
            )
        );

        $this->instance->addFunction(
            new \Twig\TwigFunction('assets_img',
                function ($filename, $privateProvider = 'site') {
                    return \CoreSlim\Filesystem::img($filename, $privateProvider);
                }
            )
        );

        if (!$view) {
            $view = $this->template;
        }

        $template = $view.'.twig';

        $vars = $this->getVars();

        if ($callback) {
            dd($vars);
            exit;
        }

        echo $this->instance->render($template, $this->getVars());
        exit;
    }
}
