<?php

class Contact extends ModulesInstanceSite
{
    public $key = 'contact';
    public $keyForm = 'configFormContact';
    public $config = null;

    public $template = [
        'module' => 'modules/forms/contact'
    ];

    public function __construct($controller, $config = null)
    {
        parent::__construct($controller);

        $this->setConfig($config);

        unset($controler, $config);
    }

    public function setConfig($config)
    {
        if (is_null($config)) {
            $config = $this->getExtra($this->key);
        }

        $this->config = $config;
    }

    public function route()
    {
        $controller = parent::controller();
        $database = parent::database();

        $database->setTable('ex_contact');
        $database->setSufix('contact');

        $controller->callback()->injectMessages($this->config['callback']);

        $this->monitorActions();

        if ($this->config['scope']['key'] == Request::seo(1)) {
            return $this->view(true);
        }
    }

    public function monitorActions()
    {
        $submitKey = parent::database()->sufix('submit');

        if (Request::post($submitKey) == $submitKey){
            $this->storeContact();
        }
    }

    public function view()
    {
        $controller = parent::controller();

        $info = [
            'title' => $this->config['scope']['title'],
            'text' => $this->config['scope']['text'],
            'key' => $this->config['scope']['key']
        ];

        $dataReturn['module'] = parent::generatePageStatic($info);

        $dataReturn['form']['state'] = Tools::getStateModule(0);
        $dataReturn['form']['city'] = Tools::getCityModule(0, 0);
        $dataReturn['form']['action'] = Request::permalink($this->config['scope']['key']);

        $controller->render()->setTemplate(parent::getTemplate('module'));

        return $dataReturn;
    }

    public function index()
    {
        $controller = parent::controller();

        $info = [
            'title' => $this->config['scope']['title'],
            'text' => null,
            'key' => $this->config['scope']['key']
        ];

        $dataReturn = parent::generatePageStatic($info, null, false);

        $dataReturn['form']['action'] = Request::permalink($this->config['scope']['key']);

        return $dataReturn;
    }

    public function storeContact()
    {
        $controller = parent::controller();
        $database = $controller->database();

        $params = [
            'name' => ['label' => $this->config['label']['name'], 'format' => 'string'],
            'email' => ['label' => $this->config['label']['email'], 'format' => 'email'],
            'phone' => ['label' => $this->config['label']['phone'], 'format' => 'phone'],
            'state' => ['label' => $this->config['label']['state'], 'format' => 'int'],
            'city' => ['label' => $this->config['label']['city'], 'format' => 'int'],
            'subject' => ['label' => $this->config['label']['subject'], 'format' => 'string'],
            'message' => ['label' => $this->config['label']['message'], 'format' => 'text']
        ];

        $urlCallback = Request::permalink($this->config['scope']['key']);

        if ($controller->checkFormIntegrity($database->sufix('key'), $urlCallback, true)) {
            $data = $this->loadDataPost($params, $urlCallback);

            $bodyData = $this->setEmailBody($data, $params);

            $emailCapture = $data[$database->sufix('email')];
            $nameCapture = $data[$database->sufix('name')];

            $email = new \CoreSlim\Email();

            $body = '<p>'.$this->config['callback']['sendMessage'].'</p><hr>';
            $body .= $bodyData;

            $emailsVars['body_title'] = 'Olá '.Treatment::string($nameCapture, 'first-name').',';
            $emailsVars['button_link'] = Request::permalink();
            $emailsVars['button_label'] = 'ACESSAR SITE';
            $emailsVars['body_text'] = $body;
            $emailsVars['signature_label'] = $email->signature('signature_label');
            $emailsVars['signature_link'] = $email->signature('signature_link');

            $email->setConfig('template', 'basic.html');
            $email->setConfig('callback', $urlCallback);
            $email->setConfig('to', [$emailCapture, $nameCapture]);
            $email->setConfig('emailVars', $emailsVars);
            $email->setConfig('form', $this->keyForm);
            $email->setConfig('recaptcha', true);

            if ($email->send()) {
                $dataExecute = $this->execute($data);

                $email = new \CoreSlim\Email();

                $body = '<p>Você tem um novo e-mail de contato.</p><hr>';
                $body .= $bodyData;

                if (isset($dataExecute[$database->sufix('ip')])) {
                    $body .= '<hr><p><b>IP:</b> '.$dataExecute[$database->sufix('ip')].'</p>';
                }

                if (isset($dataExecute[$database->sufix('agent')])) {
                    $body .= '<p><b>AGENTE:</b> '.$dataExecute[$database->sufix('agent')].'</p>';
                }

                $emailsVars['body_title'] = 'Olá '.$email->signature('company').',';
                $emailsVars['button_link'] = config('app.PATH_CMS');
                $emailsVars['button_label'] = 'ACESSAR PAINEL';
                $emailsVars['body_text'] = $body;
                $emailsVars['signature_label'] = $email->signature('signature_label');
                $emailsVars['signature_link'] = $email->signature('signature_link');

                $email->setConfig('template', 'basic.html');
                $email->setConfig('callback', $urlCallback);
                $email->setConfig('reply', [$emailCapture, $nameCapture]);
                $email->setConfig('emailVars', $emailsVars);
                $email->setConfig('form', $this->keyForm);
                $email->setConfig('recaptcha', false);
                $email->send();

                $controller->callback()->injectMessages($this->config['callback']);
                $controller->callback()->set('sendKey', $urlCallback);
            }
        }
    }

    public function execute($data)
    {
        $controller = parent::controller();
        $database = parent::database();

        $controller->monitorNewsletter($data);

        $database->setTable('ex_contact');
        $database->setSufix('contact');

        $data[$database->sufix('ip')] = $_SERVER['REMOTE_ADDR'];

        $ua = parse_user_agent($_SERVER['HTTP_USER_AGENT']);

        $data[$database->sufix('agent')] = $ua['platform'].' / '.$ua['browser'].' / '.$ua['version'];

        return $database->dataSave($data, 'insert');
    }

    public function loadDataPost($params, $urlCallback)
    {
        $controller = parent::controller();
        $database = parent::database();

        $data = null;

        foreach ($params as $key => $value) {
            $data[$database->sufix($key)] = Request::post($database->sufix($key), $value['format']);
        }

        if ($data) {
            return $data;
        }
    }

    public function setEmailBody($data, $params)
    {
        $database = parent::database();

        $body = null;

        if ($params && $data) {
            foreach ($params as $key => $value) {
                if ($key == 'state' || $key == 'city' || $key == 'country') {
                    $body .= '<p><b>'.$value['label'].':</b> '.\Treatment::string($database->getTupleMod('ibge-'.$key, $data[$database->sufix($key)], 'name', 'id', 'sis')).'</p>';
                }
                else {
                    $body .= '<p><b>'.$value['label'].':</b> '.\Treatment::string($data[$database->sufix($key)]).'</p>';
                }
            }
        }

        if ($body) {
            return $body;
        }
    }
}
