<?php

class Localization extends ModulesInstanceSite
{
    public $key = 'localization';
    public $config = null;

    public $template = [
        'module' => 'modules/pages/localization'
    ];

    public function __construct($controller, $config = null)
    {
        parent::__construct($controller);

        $this->setConfig($config);

        unset($controler, $config);
    }

    public function setConfig($config)
    {
        if (is_null($config)) {
            $config = $this->getExtra($this->key);
        }

        $this->config = $config;
    }

    public function route()
    {
        $controller = parent::controller();
        $database = parent::database();

        if ($this->config['scope']['key'] == Request::seo(1)) {
            return $this->view(true);
        }
    }

    public function view()
    {
        $controller = parent::controller();

        $info = [
            'title' => $this->config['scope']['title'],
            'text' => $this->config['scope']['text'],
            'key' => $this->config['scope']['key']
        ];

        $dataReturn['module'] = parent::generatePageStatic($info);

        $controller->render()->setTemplate(parent::getTemplate('module'));

        return $dataReturn;
    }
}
