<?php

class Menu extends ModulesInstanceSite
{
    public function __construct($controller)
    {
        parent::__construct($controller);
    }

    public function manipule()
    {
        $this->loadPages();
        $this->loadProductsCategories();
    }

    public function loadPages()
    {
        if (!class_exists('Pages')) {
            require_once(config('app.ROOT_MODULES').'/pages.php');
        }

        $pages = new Pages($this->controller());

        if ($newMenu = $pages->manipuleMenu()) {
            $this->setMenu($newMenu, 1);
        }
    }

    public function loadProductsCategories()
    {
        if (!class_exists('Products')) {
            require_once(config('app.ROOT_MODULES').'/products.php');
        }

        $products = new Products($this->controller());

        if ($newMenu = $products->manipuleMenu()) {
            $this->setMenu($newMenu, 3);
        }
    }

    public function setMenu($newMenu, $position)
    {
        $header = $this->controller()->render()->getVars('header');

        if (isset($header['menu']['itens'][$position]['subitem'])) {
            $subItemDatabase = $header['menu']['itens'][$position]['subitem'];

            if (!is_array($newMenu)) {
                $newMenu = [];
            }

            if (is_array($newMenu)) {
                foreach ($newMenu as $key => $value) {
                    $newMenuReturn[$key] = $value;
                }
            }

            if (!is_array($subItemDatabase)) {
                $subItemDatabase = [];
            }

            if (is_array($subItemDatabase)) {
                foreach ($subItemDatabase as $key => $value) {
                    $newMenuReturn[$key] = $value;
                }
            }

            $header['menu']['itens'][$position]['subitem'] = $newMenuReturn;

            $this->controller()->render()->setVars('header', $header);
        }
    }
}
