<?php

class Products extends ModulesInstanceSite
{
    public $key = 'products';

    public function __construct($controller)
    {
        parent::__construct($controller);

        $instanceModule = $this->getInfoAllModule($this->key);

        if (isset($instanceModule['scope'])) {
            $this->keyLang = [
                'archive' => $instanceModule['scope']['key'],
                'view' => $instanceModule['scope']['key_view']
            ];
        }
    }

    public function archive()
    {
        $dataReturn = null;

        $this->type = 'archive';

        $module = clone $this->modules();

        $module->init($this->key, $this->locale['key'], $this->type);

        $module->page[] = ['key' => $this->locale['key'], 'title' => $this->locale['title'], 'url' => Request::permalink($module->key)];

        $this->render()->setTemplate($this->getTemplate('archive'));

        $searchAction = false;

        if ($querySearch = $this->search()) {
            if (is_array($querySearch)) {
                $dataReturn = $querySearch;

                $searchAction = true;
            }
            else if ($querySearch == 'execute-search') {
                $searchAction = true;
            }
        }

        if (!$searchAction) {
            $dataReturn = $this->loadData(null, [['time_products', 'DESC']], 16);
        }

        $dataReturn['page'] = $module->manipulePage();
        $dataReturn['actions'] = $this->generateActions();

        if (Request::get('categoria') && isset($_SESSION['category'])) {
            $dataReturn['page']['breadcrumb'][] = $_SESSION['category'];
            $dataReturn['page']['header']['title'] = $dataReturn['page']['header']['title']. ' / '.$_SESSION['category']['title'];
        }

        $module->setOpenGraph($dataReturn);

        if (!$searchAction) {
            $dataReturn['actions']['search']['placeholder'] = 'Pesquise em produtos...';
        }
        else {
            $dataReturn['actions']['search']['placeholder'] = 'Sua pesquisa: '.$_SESSION['string_search'];
        }

        $dataReturn['actions']['search']['active'] = $searchAction;
        $dataReturn['actions']['search']['title'] = 'Clique para pesquisar em produtos';
        $dataReturn['actions']['search']['action'] = Request::injectVars($this->locale['key'], [['pesquisa' => 'sim']]);

        unset($module);

        return $dataReturn;
    }

    public function view()
    {
        $dataReturn = null;

        $this->type = 'view';

        $module = clone $this->modules();

        $module->init($this->key, $this->locale['key'], $this->type);

        $module->page[] = ['key' => $this->locale['key'], 'title' => $this->locale['title'], 'url' => Request::permalink($module->key)];

        $this->render()->setTemplate($this->getTemplate('view'));

        $dataReturn = $this->loadData("AND `slug_".$module->sufix."` = '".Request::seo(2)."'", "`time_".$module->sufix."` DESC", 1, true, $module);

        $dataReturn['page'] = $module->manipulePage();

        $dataReturn['page']['breadcrumb'][] = [
            'key' => $this->locale['key'].'-'.$dataReturn['data']['slug'],
            'title' => $dataReturn['data']['title'],
            'url' => $dataReturn['data']['url']
        ];

        //$dataReturn['page']['header']['title'] = $dataReturn['data']['title'];
        $dataReturn['page']['header']['url'] = $dataReturn['data']['url'];

        $module->setOpenGraph($dataReturn);

        $dataReturn['og'] = $module->og;

        $core = $this->controller()->render()->getVars('core');

        $dataReturn['othersData'] = $this->others($dataReturn['data']['id']);

        unset($module);

        return $dataReturn;
    }

    public function index()
    {
        $dataReturn = null;

        $this->type = 'index';

        $module = clone $this->modules();

        $module->init($this->key, $this->locale['key'], $this->type);

        $module->page[] = ['key' => $this->locale['key'], 'title' => $this->locale['title'], 'url' => Request::permalink($module->key)];

        $dataReturn = $this->loadData(null, [['RAND()']]);

        unset($dataReturn['pagination']);

        $dataReturn['page'] = $module->manipulePage();

        unset($module);

        return $dataReturn;
    }

    public function others($idNot)
    {
        $dataReturn = null;

        $this->type = 'index';

        $module = clone $this->modules();

        $module->init($this->key, $this->locale['key'], $this->type);

        $module->page[] = ['key' => $this->locale['key'], 'title' => $this->locale['title'], 'url' => Request::permalink($module->key)];

        $dataReturn = $this->loadData("AND `id_".$module->sufix."` <> '".$idNot."'", "`id_".$module->sufix."`", 10);
        $dataReturn['page'] = $module->manipulePage();

        unset($dataReturn['page']['breadcrumb']);
        unset($dataReturn['pagination']);

        unset($module);

        $dataReturn['page']['header']['title'] = '+ '.$dataReturn['page']['header']['title'];

        return $dataReturn;
    }

    public function loadData($where, $orderby = [['order', 'ASC']], $limit = 12, $view = false, $module = null)
    {
        $controller = $this->controller();
        $database = $this->database();

        $repository = new \Repository('products');

        $repository->select('id_products', 'id');
        $repository->select('title_products', 'title');
        $repository->select('slug_products', 'slug');
        $repository->select('subtitle_products', 'subtitle');
        $repository->select('text_products', 'text');
        $repository->select('cover_products', 'cover');
        $repository->select('user_products', 'user');
        $repository->select('title_products-category', 'category_title');
        $repository->select('slug_products-category', 'category_slug');

        $repository->innerJoin('products-category', 'id', 'category');

        $repository->where('status_products', 'active');

        if (is_array($orderby)) {
            foreach ($orderby as $keyOB => $valueOB) {
                if ($valueOB[0] != 'RAND()') {
                    $repository->orderBy($valueOB[0], $valueOB[1]);
                }
                else {
                    $repository->orderByRand();
                }
            }
        }

        if (Request::get('categoria')) {
            $repository->whereAnd('slug_products-category', Request::get('categoria'));
        }

        if (!is_null($where)) {
            $repository->setQuery('where', $where);
        }

        if ($result = $repository->paginateGet($controller->locale['pagination'], $limit)) {
            $dataReturn = $result;

            if (isset($result['data'])) {
                foreach ($result['data'] as $key => $value) {
                    if ($module) {
                        foreach($module->features as $keyFeatures => $params) {
                            if ($module->features[$keyFeatures]['active'] && array_key_exists('id', $value)) {
                                $box = $module->extraBox($module->features[$keyFeatures]['key'], $value['id'], $params);

                                if ($box) {
                                    $dataReturn['data'][$key][$keyFeatures] = $box;
                                }
                            }
                        }
                    }

                    if (isset($dataReturn['data'][$key]['galleryVideo'])) {
                        $dataReturn['data'][$key]['galleryVideo']['info']['title'] = null;
                        $dataReturn['data'][$key]['galleryVideo']['info']['cols'] = 'flex-content-grid-12';
                    }

                    if (isset($dataReturn['data'][$key]['galleryAnexx'])) {
                        $dataReturn['data'][$key]['galleryAnexx']['info']['title'] = null;
                    }

                    $dataReturn['data'][$key]['id'] = $dataReturn['data'][$key]['value'] = intval($value['id']);
                    $dataReturn['data'][$key]['slug'] = $value['slug'];

                    $dataReturn['data'][$key]['title'] = Treatment::string($value['title']);
                    $dataReturn['data'][$key]['label'] = Treatment::string($value['title']);
                    $dataReturn['data'][$key]['subtitle'] = Treatment::string($value['subtitle'], 'text');

                    $dataReturn['data'][$key]['text'] = Treatment::string($value['text'], 'text');
                    $dataReturn['data'][$key]['url'] = Request::permalink($this->keyLang['view'].'/'.$value['slug']);

                    $dataReturn['data'][$key]['thumb'] = Assets::loadThumb($value['cover'], 'products', 'thumb');
                    $dataReturn['data'][$key]['original'] = Assets::loadThumb($value['cover'], 'products', 'default');

                    $dataReturn['data'][$key]['category']['title'] = Treatment::string($value['category_title']);
                    $dataReturn['data'][$key]['category']['url'] = Request::injectVars($this->keyLang['archive'], [['categoria' => $value['category_slug']]]);

                    $dataReturn['data'][$key]['jsonin'] = Tools::jsonEncode($dataReturn['data'][$key]);
                }
            }

            if ($view) {
                $dataReturn['data'] = $dataReturn['data'][0];

                unset($dataReturn['pagination']);

                $this->modules()->setStats('products', $dataReturn['data']['id'], 'mod_products');
            }

            return $dataReturn;
        }
    }

    public function generateActions()
    {
        $controller = $this->controller();
        $database = $this->database();

        $actions['category']['info'] = [
            'type' => 'select',
            'title' => 'categoria',
            'label' => 'Selecione um categoria...',
            'url' => Request::injectVars($this->keyLang['archive'], [['categoria' => 'empty']]),
            'internal' => 'categoria',
            'notitle' => true,
            'cols' => 'col-sm-4 col-md-4'
        ];

        if (Request::get('categoria')) {
            $actions['options']['open'] = true;

            $actions['category']['info']['label'] = 'Resetar filtro de categorias...';
        }

        $repository = new \Repository('products-category');

        $repository->select('id', 'id');
        $repository->select('title', 'title');
        $repository->select('slug', 'slug');
        $repository->where('status', 'active');
        $repository->orderBy('order');

        if ($result = $repository->all()) {
            foreach ($result as $key => $value) {
                $active = false;

                if ($value['slug'] == Request::get('categoria')) {
                    $active = true;
                }

                $actions['category']['list'][$key]['id'] = intval($value['id']);
                $actions['category']['list'][$key]['title'] = Treatment::string($value['title']);
                $actions['category']['list'][$key]['url'] = Request::injectVars($this->keyLang['archive'], [['categoria' => $value['slug']]]);
                $actions['category']['list'][$key]['active'] = $active;

                if (Request::get('categoria') && $active) {
                    $_SESSION['category'] = $actions['category']['list'][$key];
                }
            }
        }

        return $actions;
    }

    public function search($action = 'submitSearch_internal', $string = 'stringSearch_internal', $limit = 12)
    {
        $controller = $this->controller();

        if (Request::post($action) == $action) {
            $_SESSION['string_search'] = Request::post($string, 'string');

            $searchTables = ['mod_products', 'mod_products-category'];

            $where = $whereRepo = null;

            foreach ($searchTables as $table) {
                $queryRelative = "SELECT * FROM `".$table."`";

                if ($relative = $controller->database()->dbFieldsSearch($queryRelative, $table)) {
                    foreach ($relative as $key => $fieldRelative) {
                        if (isset($fieldRelative['native_type']) && ($fieldRelative['native_type'] == 'DATE' || $fieldRelative['native_type'] == 'DATETIME') && \DateTime::createFromFormat('Y-m-d H:i:s', Treatment::date($_SESSION['string_search'], 'mysql').' 00:00:00') !== false) {
                            $where[] = "(`".$fieldRelative['name']."` = '".Treatment::date($_SESSION['string_search'], 'mysql')."')";
                            $whereRepo[] = [$fieldRelative['name'], Treatment::date($_SESSION['string_search'], 'mysql')];
                        }
                        else if (isset($fieldRelative['native_type']) && $fieldRelative['native_type'] == 'VAR_STRING') {
                            $where[] = "(`".$fieldRelative['name']."` LIKE '%".Treatment::string($_SESSION['string_search'])."%')";
                        }
                        else {
                            $where[] = "(`".$fieldRelative['name']."` LIKE '%".Treatment::string($_SESSION['string_search'], 'text')."%')";
                        }
                    }
                }
            }

            $_SESSION['string_query'] = "AND (".implode(' OR ', $where).")";

            $module = $this->loadData($_SESSION['string_query'], [['title_products', 'ASC']], $limit);

            if ($module) {
                return $module;
            }
            else {
                return 'execute-search';
            }
        }
        else if (Request::get('pesquisa') == 'sim') {
            $module = $this->loadData($_SESSION['string_query'], [['title_products', 'ASC']], $limit);

            if ($module) {
                return $module;
            }
        }
        else if (Request::get('pesquisa') != 'sim') {
            $_SESSION['string_search'] = null;
            $_SESSION['string_query'] = null;
        }
    }

    public function manipuleMenu()
    {
        $repository = new \Repository('products-category');

        $repository->select('id', 'id');
        $repository->select('title', 'title');
        $repository->select('slug', 'slug');
        $repository->where('status', 'active');
        $repository->orderBy('order');

        if ($result = $repository->all()) {
            foreach ($result as $key => $value) {
                $menuReturn[$value['id']]['key'] = $this->locale['key'].'-'.$value['slug'];
                $menuReturn[$value['id']]['title'] = Treatment::string($value['title']);
                $menuReturn[$value['id']]['url'] = Request::injectVars($this->keyLang['archive'], [['categoria' => $value['slug']]]);
                $menuReturn[$value['id']]['target'] = '_parent';
                $menuReturn[$value['id']]['image'] = null;
                $menuReturn[$value['id']]['active'] = null;
                $menuReturn[$value['id']]['thumb'] = null;
                $menuReturn[$value['id']]['original'] = null;
            }

            return $menuReturn;
        }
    }
}
