<?php

class representatives extends ModulesInstanceSite
{
	public $key = 'representatives';

    public $keyLang = [
        'archive' => 'representantes'
    ];

    public $template = [
        'archive' => 'modules/pages/representatives'
    ];

	public function __construct($controller)
	{
		parent::__construct($controller, false);
	}

    public function instanceModules()
    {
        $module = parent::instanceCore();

        return $module;
    }

    public function archive()
    {
        $dataReturn = null;

        $this->type = 'archive';

        $module = clone $this->modules();

        $module->init($this->key, $this->locale['key'], $this->type);

        $module->page[] = ['key' => $this->locale['key'], 'title' => $this->locale['title'], 'url' => Request::permalink($module->key)];

        $this->render()->setTemplate($this->getTemplate('archive'));

        $searchAction = false;

        $dataReturn = $this->loadData(11);

        $dataReturn['page'] = $module->manipulePage();
        $dataReturn['filters'] = $this->filters(11);

        $module->setOpenGraph($dataReturn);

        unset($module);

        return $dataReturn;
    }

    public function loadData($stateDefault = null)
    {
        $controller = $this->controller();
        $database = $this->database();

        $database->setTable('mod_representatives');
        $database->setSufix('representatives');

        $whereState = '';

        if (Request::get('estado')) {
            $whereState = " AND `slug_ibge-state` = '".Request::get('estado')."'";
        }
        else if (isset($stateDefault)) {
            $whereState = " AND `id_ibge-state` = '".$stateDefault."'";
        }

        $whereCity = '';

        if (Request::get('cidade')) {
            $whereCity = " AND `slug_ibge-city` = '".Request::get('cidade')."'";
        }

        $query = "SELECT `id_representatives` as id,
                         `title_representatives` as title,
                         `state_representatives` as state,
                         `city_representatives` as city,
                         `address_representatives` as address,
                         `phone_representatives` as phone,
                         `celular_representatives` as celular,
                         `email_representatives` as email,
                         `name_ibge-state` as state_name,
                         `slug_ibge-state` as state_slug,
                         `iso_ibge-state` as state_iso,
                         `name_ibge-city` as city_name,
                         `slug_ibge-city` as city_slug
                  FROM `mod_representatives`
                  INNER JOIN `sis_ibge-state` ON (`id_ibge-state` = `state_representatives`".$whereState.")
                  INNER JOIN `sis_ibge-city` ON (`id_ibge-city` = `city_representatives`".$whereCity.")
                  WHERE `status_representatives` = 'active'
                  ORDER BY `title_representatives`";

        $result = $database->dbFetchAll($query);

        if ($result) {
            foreach ($result as $key => $value) {
                $dataReturn['data'][$key]['id'] = $dataReturn['data'][$key]['value'] = intval($value['id']);

                $dataReturn['data'][$key]['title'] = Treatment::string($value['title']);
                $dataReturn['data'][$key]['location'] = Treatment::string($value['city_name'].'/'.$value['state_iso']);
                $dataReturn['data'][$key]['address'] = Treatment::string($value['address']);
                $dataReturn['data'][$key]['phone'] = Treatment::string($value['phone']);
                $dataReturn['data'][$key]['phonecallto'] = Treatment::string($value['phone'], 'callto');
                $dataReturn['data'][$key]['celular'] = Treatment::string($value['celular']);
                $dataReturn['data'][$key]['celularcallto'] = Treatment::string($value['celular'], 'callto');
                $dataReturn['data'][$key]['email'] = Treatment::string($value['email']);
                $dataReturn['data'][$key]['title'] = Treatment::string($value['title']);
                $dataReturn['data'][$key]['url'] = Request::injectVars($this->keyLang['archive'], [['estado' => $value['state_slug'], 'cidade' => $value['city_slug']]]);
            }

            return $dataReturn;
        }
    }

	public function filters($stateDefault = null, $cityDefault = null)
	{
        $controller = $this->controller();
        $database = $this->database();

        $query = "SELECT `id_ibge-state` as id, `slug_ibge-state` as slug, `name_ibge-state` as name, `iso_ibge-state` as iso
                  FROM `sis_ibge-state`
                  INNER JOIN `mod_representatives` ON (`state_representatives` = `id_ibge-state`)
                  WHERE `status_representatives` = 'active'
                  GROUP BY `id_ibge-state`
                  ORDER BY `name_ibge-state`";

        if ($states = $database->dbFetchAll($query)) {
            foreach ($states as $key => $value) {
                $selectedState = false;

                if (Request::get('estado') == $value['slug']) {
                    $selectedState = true;
                }
                else if ($stateDefault && $value['id'] == $stateDefault) {
                    $selectedState = true;
                }

                if ($selectedState) {
                    $stateId = intval($value['id']);
                }

                $dataReturn['states'][$value['id']]['id'] = Request::injectVars($this->keyLang['archive'], [['estado' => $value['slug']]], ['cidade']);
                $dataReturn['states'][$value['id']]['value'] = $dataReturn['states'][$value['id']]['id'];
                $dataReturn['states'][$value['id']]['slug'] = Treatment::string($value['slug']);
                $dataReturn['states'][$value['id']]['name'] = Treatment::string($value['name']);
                $dataReturn['states'][$value['id']]['iso'] = Treatment::string($value['iso']);
                $dataReturn['states'][$value['id']]['title'] = $dataReturn['states'][$value['id']]['name'];
                $dataReturn['states'][$value['id']]['selected'] = $selectedState;

                if ($selectedState) {
                    $dataReturn['state'] = $dataReturn['states'][$value['id']];
                }
            }

            if (isset($stateId)) {
                $query = "SELECT `id_ibge-state` as state_id,
                                 `name_ibge-state` as state_name,
                                 `slug_ibge-state` as state_slug,
                                 `iso_ibge-state` as state_iso,
                                 `id_ibge-city` as city_id,
                                 `name_ibge-city` as city_name,
                                 `slug_ibge-city` as city_slug
                          FROM `sis_ibge-state`
                          INNER JOIN `sis_ibge-city` ON (`state_ibge-city` = `id_ibge-state`)
                          INNER JOIN `mod_representatives` ON (`city_representatives` = `id_ibge-city`)
                          WHERE `state_representatives` = '".$stateId."'
                          GROUP BY `id_ibge-city`
                          ORDER BY `name_ibge-city`";

                if ($citys = parent::database()->dbFetchAll($query)) {
                    foreach ($citys as $key => $value) {
                        $selectedCity = false;

                        if (Request::get('cidade') == $value['city_slug']) {
                            $selectedCity = true;
                        }
                        else if ($cityDefault && $value['id'] == $cityDefault) {
                            $selectedCity = true;
                        }

                        $dataReturn['cities'][$value['city_id']]['id'] = Request::injectVars($this->keyLang['archive'], [['estado' => $value['state_slug'], 'cidade' => $value['city_slug']]]);
                        $dataReturn['cities'][$value['city_id']]['value'] = $dataReturn['cities'][$value['city_id']]['id'];
                        $dataReturn['cities'][$value['city_id']]['slug'] = Treatment::string($value['city_slug']);
                        $dataReturn['cities'][$value['city_id']]['name'] = Treatment::string($value['city_name']);
                        $dataReturn['cities'][$value['city_id']]['title'] = $dataReturn['cities'][$value['city_id']]['name'];
                        $dataReturn['cities'][$value['city_id']]['selected'] = $selectedCity;

                        if ($selectedCity) {
                            $dataReturn['city'] = $dataReturn['cities'][$value['city_id']];
                        }
                    }
                }
            }

            return $dataReturn;
        }
	}
}
