<?php

class Search extends ModulesInstanceSite
{
    public function __construct($controller)
    {
        parent::__construct($controller);
    }

    public function init()
    {
        $params['page'] = [
            'title' => 'Páginas',
            'url' => parent::getLocale('key', 'page'),
            'select' => ['title', 'text'],
            'active' => false,
            'prefixTable' => 'mod',
        ];

        $params['products'] = [
            'title' => 'Produtos',
            'url' => 'produto',
            'select' => ['title', 'text'],
            'active' => false,
            'prefixTable' => 'mod'
        ];

        $params['services'] = [
            'title' => 'Serviços',
            'url' => 'servico',
            'select' => ['title',  'text'],
            'active' => false,
            'prefixTable' => 'mod'
        ];

        $params['news'] = [
            'title' => 'Notícias',
            'url' => 'noticia',
            'select' => ['title', 'date', 'text'],
            'active' => false,
            'prefixTable' => 'mod'
        ];

        return [
            'module' => $this->searchProcess($params)
        ];
    }

    public function searchProcess($params)
    {
        $this->getSession();

        $dataQuery = $this->getData($params);

        $dataReturn = null;

        $info = ['key' => parent::getLocale('search', 'key'), 'title' => parent::getLocale('search', 'label')];

        $search = $this->generatePageStatic($info);

        $first = 1;

        foreach ($params as $key => $value) {
            if (array_key_exists($key, $dataQuery)) {
                $data = $dataQuery[$key];

                if ($data) {
                    $select = false;

                    if ($first == 1) {
                        $params[$key]['active'] = true;
                        $select = true;
                    }

                    foreach ($data as $dataKey => $dataValue) {
                        foreach ($value['select'] as $keySelect => $valueSelect) {
                            $check = $valueSelect.'_'.$key;

                            $dataReturn[$key]['active'] = $select;

                            if (array_key_exists($check, $dataValue)) {
                                if ($valueSelect == 'cover') {
                                    $valueSelect = 'thumb';
                                }

                                $string = null;

                                if ($valueSelect == 'date' || $valueSelect == 'dateinit') {
                                    $string = Treatment::date($dataValue[$check], 'brazil');
                                }
                                else if ($valueSelect == 'text') {
                                    $string = Treatment::string($dataValue[$check], 'string', 300);
                                }
                                else if ($valueSelect == 'thumb') {
                                    $string = Assets::loadThumb($dataValue[$check], $key, 'thumb', false);
                                }
                                else {
                                    $string =  Treatment::string($dataValue[$check]);
                                }

                                if ($valueSelect != 'dependence') {
                                    $dataReturn[$key]['data'][$dataKey][$valueSelect] = $string;
                                }
                                else {
                                    $dataReturn[$key]['data'][$dataKey][$valueSelect][$indexSelect]['title'] = $string;
                                }
                            }
                            else {
                                if ($valueSelect == 'coverGallery') {
                                    $photo = parent::database()->dbFetch("SELECT `file_photo` FROM `sub_photo` WHERE `table_photo` = 'mod_animals' AND `tuple_photo` = '".$dataValue['id_animals']."' AND `status_photo` = 'active' ORDER BY `order_photo` LIMIT 1");

                                    if (@json_decode($photo[0])) {
                                        $photo = json_decode($photo[0], true);

                                        $dataReturn[$key]['data'][$dataKey]['galleryPhoto']['gallery'][0]['thumb'] = Assets::loadThumb($photo['name'], $key, 'smaller', false);
                                    }
                                }
                            }

                            $viewTuple = 'slug';

                            if (array_key_exists('slug', $value)) {
                                $viewTuple = $value['slug'];
                            }

                            if ($value['url'] == parent::getLocale('key', 'page')) {
                                $dataReturn[$key]['data'][$dataKey]['url'] = parent::permalink($dataValue[$viewTuple.'_'.$key]);
                            }
                            else {
                                $urlFinal = $value['url'];

                                if (array_key_exists('provider', $value)) {
                                    $urlFinal = $value['provider'].'/'.$value['url'];
                                }

                                $dataReturn[$key]['data'][$dataKey]['url'] = parent::permalink($urlFinal.'/'.$dataValue[$viewTuple.'_'.$key]);
                            }
                        }
                    }

                    $first++;
                }
                else {
                    unset($params[$key]);
                }
            }
        }

        $search['tabs'] = $params;
        $search['data'] = $dataReturn;

        if (array_key_exists('string_search', $_SESSION)) {
            $search['searchstring'] = $_SESSION['string_search'];
        }

        parent::render()->setTemplate('modules/pages/search');

        return $search;
    }

    public function getSession()
    {
        if (Request::post('submitSearch_all') == 'submitSearch_all') {
            $_SESSION['string_search'] = null;
            $_SESSION['string_query'] = null;

            $_SESSION['string_search'] = Request::post('stringSearch_all');
        }
        else if (parent::seo(1) == 'pesquisar') {
            return $_SESSION['string_query'];
        }
        else {
            $_SESSION['string_search'] = null;
            $_SESSION['string_query'] = null;
        }
    }

    public function getData($params)
    {
        $dataQuery = null;

        foreach ($params as $key => $value) {
            $query = "SELECT * FROM `".$value['prefixTable']."_".$key."`";

            $dataSearch = null;

            if ($fields = parent::database()->dbFields($query)) {
                for ($i = 0; $i < count($fields) - 4; $i++) {
                    $dataSearch[] = "`".$fields[$i]."` LIKE '%".$_SESSION['string_search']."%'";
                }
            }

            if ($dataSearch) {
                $query .= " WHERE (".implode(' OR ', $dataSearch).") AND `status_".$key."` = 'active'";

                if (in_array('date', $value['select'])) {
                    $query .= "AND `date_".$key."` <= CURDATE()";
                }

                if (in_array('dateinit', $value['select'])) {
                    $query .= "AND `dateinit_".$key."` <= CURDATE()";
                }

                if (in_array('date', $value['select']) || in_array('dateinit', $value['select'])) {
                    if (in_array('date', $value['select'])) {
                        $query .= " ORDER BY `date_".$key."` DESC, `time_".$key."` DESC";
                    }

                    if (in_array('dateinit', $value['select'])) {
                        $query .= " ORDER BY `dateinit_".$key."` DESC, `time_".$key."` DESC";
                    }
                }
                else {
                    $query .= " ORDER BY `time_".$key."` DESC";
                }

                $query .= " LIMIT 100";

                $dataQuery[$key] = parent::database()->dbFetchAll($query);
            }
        }

        return $dataQuery;
    }

    public function treatData($check, $dataKey, $dataValue, $valueSelect, $value, $key, $keySelect)
    {

    }
}
