<?php

// CoreSlim - Última atualização 18/04/2023 09:07

namespace CoreSlim;

class Database
{
    private $driver = null;

    public $dataLang = 'pt_BR';

    protected $connection = [
        'driver' => null,
        'host' => null,
        'user' => null,
        'password' => null,
        'database' => null,
        'port' => null
    ];

    public function __construct($connection = null, $lang = null)
    {
        if (!is_null($lang)) {
            $this->dataLang = $lang;
        }

        ini_set('default_charset','UTF-8');
        mb_internal_encoding('UTF-8');
        mb_http_output('UTF-8');
        mb_language('uni');
        mb_regex_encoding('UTF-8');
        ob_start('mb_output_handler');

        if ($connection) {
            $this->connection = $connection;
        }
        else {
            $default = config('database.default');
            $connections = config('database.connections');

            $connection = $connections[$this->dataLang][$default];

            $this->setConnection('driver', $connection['driver']);
            $this->setConnection('host', $connection['host']);
            $this->setConnection('user', $connection['username']);
            $this->setConnection('password', $connection['password']);
            $this->setConnection('database', $connection['database']);
            $this->setConnection('port', $connection['port']);
        }
    }

    public function setConnection($type, $value)
    {
        $this->connection[$type] = $value;
    }

    public function getConnection($type)
    {
        return $this->connection[$type];
    }

    protected function connectionOpen()
    {
        if (!isset($this->driver)) {
            $this->driver = new \PDO($this->getConnection('driver').':host='.$this->getConnection('host').'; dbname='.$this->getConnection('database').'; port='.$this->getConnection('port'), $this->getConnection('user'), $this->getConnection('password'), [
                \PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8"
            ]);

            //$this->driver->setAttribute(\PDO::ATTR_ERRMODE, \PDO::ERRMODE_EXCEPTION);
            //$this->driver->setAttribute(\PDO::ATTR_ORACLE_NULLS, \PDO::NULL_EMPTY_STRING);

            $this->driver->setAttribute(\PDO::ATTR_ERRMODE, \PDO::ERRMODE_EXCEPTION);
            $this->driver->setAttribute(\PDO::ATTR_EMULATE_PREPARES, false);
        }
    }

    public function connectionClose()
    {
        unset($this->driver);
    }

    public function checkTable($table = null)
    {
        if ($table) {
            $query = "SELECT * FROM `".$table."`";

            if ($this->dbQuery($query)) {
                return true;
            }
        }
    }

    public function dbQuery($query, $closeConnection = false)
    {
        $this->connectionOpen();

        try {
            $dataReturn = $this->driver->query($query);

            if ($closeConnection) {
                $this->connectionClose();
            }

            if ($dataReturn) {
                return $dataReturn;
            }
        } catch (\PDOException $e) {
            return false;
        }
    }

    public function dbPrepare($query, $closeConnection = true)
    {
        $this->connectionOpen();

        try {
            $dataReturn = $this->driver->prepare($query);

            if ($closeConnection) {
                $this->connectionClose();
            }

            if ($dataReturn) {
                return $dataReturn;
            }
        } catch (\PDOException $e) {
            return false;
        }
    }

    public function dbFields($query, $closeConnection = false)
    {
        $queryExec = $this->dbQuery($query, $closeConnection);

        if ($queryExec) {
            $total_column = $queryExec->columnCount();

            if ($total_column) {
                for ($counter = 0; $counter < $total_column; $counter ++) {
                    $meta = $queryExec->getColumnMeta($counter);

                    $column[] = $meta;
                }

                return $column;
            }
        }
    }

    public function dbFieldsSearch($query, $tableActive, $closeConnection = false)
    {
        $notFields = ['uuid', 'token', 'created', 'updated', 'time', 'user', 'status'];
        $notFieldsJoin = ['id', 'instance'];

        $queryExec = $this->dbQuery($query, $closeConnection);

        $total_column = $queryExec->columnCount();

        if ($total_column) {
            for ($counter = 0; $counter < $total_column; $counter ++) {
                $meta = $queryExec->getColumnMeta($counter);

                if (!in_array('multiple_key', $meta['flags'])) {
                    if (!in_array($meta['name'], $notFields) && $meta['table'] == $tableActive) {
                        $column[] = $meta;
                    }

                    if (!in_array($meta['name'], $notFields) && !in_array($meta['name'], $notFieldsJoin) && $meta['table'] != $tableActive) {
                        $column[] = $meta;
                    }
                }
            }

            return $column;
        }
    }

    public function dbFetch($query, $closeConnection = false)
    {
        if ($queryExec = $this->dbQuery($query, $closeConnection)) {
            return $queryExec->fetch(\PDO::FETCH_BOTH);
        }
    }

    public function dbFetchAssoc($query, $closeConnection = false)
    {
        if ($queryExec = $this->dbQuery($query, $closeConnection)) {
            return $queryExec->fetch(\PDO::FETCH_ASSOC);
        }
    }

    public function dbFetchAll($query, $closeConnection = false)
    {
        if ($queryExec = $this->dbQuery($query, $closeConnection)) {
            return $queryExec->fetchAll(\PDO::FETCH_BOTH);
        }
    }

    public function dbNumRows($query, $closeConnection = false)
    {
        if ($queryExec = $this->dbQuery($query, $closeConnection)) {
            return $queryExec->rowCount();
        }
    }

    public function dbLast()
    {
        return $this->driver->lastInsertId();
    }
}
