<?php

// CoreSlim - Última atualização 18/04/2023 09:49

namespace CoreSlim;

class Repository
{
    private $request = null;

    private $database = null;

    private $table = null;
    private $sufix = null;

    private $idLast = null;
    private $createUUID = true;
    private $defaultInstance = 'uuid';
    private $provider = null;

    private $commands = [
        'tablePrefix' => false,
        'tupleSufix' => false
    ];

    private $query = [
        'select' => null,
        'set' => [],
        'join' => [],
        'having' => null,
        'where' => [],
        'whereLike' => [],
        'groupby' => null,
        'orderby' => null,
        'limit' => null
    ];

    public $forceOldDatabase = true;

    public function __construct($key, $commands = [], $credencials = null)
    {
        $this->processCommands($commands);

        if ($key) {
            $this->setBehavior($key);
        }

        $this->database = new Database($credencials);
    }

    public function processCommands($commands)
    {
        if ($this->forceOldDatabase && !isset($commands['old'])) {
            $commands['old'] = true;
        }

        if (isset($commands['old'])) {
            if ($commands['old'] === true) {
                $this->commands['tablePrefix'] = true;
                $this->commands['tupleSufix'] = true;

                $this->commands['prefixKey'] = 'mod';
            }

            if (isset($commands['prefixKey'])) {
                $this->commands['prefixKey'] = $commands['prefixKey'];
            }
        }
    }

    public function setBehavior($key)
    {
        $this->setCleanQuery();

        if ($this->commands['tablePrefix']) {
            $table = $this->commands['prefixKey'].'_'.$key;
            $sufix = $key;
        }
        else {
            $table = $key;
            $sufix = null;
        }

        $this->setTable($table);
        $this->setSufix($sufix);
    }

    public function setCleanQuery()
    {
        $this->query = [
            'select' => null,
            'set' => [],
            'join' => [],
            'having' => null,
            'where' => [],
            'whereLike' => [],
            'groupby' => null,
            'orderby' => null,
            'limit' => null
        ];
    }

    public function database()
    {
        return $this->database;
    }

    public function setIdLast($id)
    {
        $this->idLast = $id;
    }

    public function getIdLast()
    {
        return $this->idLast;
    }

    public function setCreateUUID($status)
    {
        $this->createUUID = $status;
    }

    public function setDefaultInstance($instance)
    {
        $this->defaultInstance = $instance;
    }

    public function setProvider($provider)
    {
        $this->provider = $provider;
    }

    public function setTable($table)
    {
        $this->table = $table;
    }

    public function getTable()
    {
        return $this->table;
    }

    public function setTablePrefix($tablePrefix)
    {
        $this->commands['tablePrefix'] = $tablePrefix;
    }

    public function setSufix($sufix)
    {
        $this->sufix = $sufix;
    }

    public function getSufix()
    {
        return $this->sufix;
    }

    public function setTupleSufix($tupleSufix)
    {
        $this->commands['tupleSufix'] = $tupleSufix;
    }

    public function getKey()
    {
        return $this->table;
    }

    public function setQuery($type, $value)
    {
        if ($type == 'limit') {
            $this->query[$type] = $value;
        }
        else if ($type == 'groupby') {
            if (is_array($this->query[$type])) {
                foreach ($this->query[$type] as $keyQuery => $valueQuery) {
                    if ($valueQuery != $value) {
                        $this->query[$type][] = $value;
                    }
                }
            }
            else {
                $this->query[$type][] = $value;
            }
        }
        else {
            $this->query[$type][] = $value;
        }
    }

    public function getQuery($type)
    {
        return $this->query[$type];
    }

    public function in($parameter, $data, $treat = 'string')
    {
        if (array_key_exists($this->sufix($parameter), $data)) {
            return Treatment::string($data[$this->sufix($parameter)], $treat);
        }
    }

    public function sufix($parameter, $key = null)
    {
        if (is_null($key)) {
            $key = $this->getKey();
        }

        if ($this->commands['tupleSufix']) {
            $checkParameter = explode('_', $parameter);

            if (count($checkParameter) > 1) {
                $parameter = '`'.$parameter.'`';
            }
            else {
                $parameter = '`'.$parameter.'_'.$this->getSufix().'`';
            }
        }
        else {
            $checkParameter = explode('::', $parameter);
            $checkParameterUnderline = explode('_', $parameter);

            if (count($checkParameter) == 2) {
                $parameter = '`'.$checkParameter[0].'`.`'.$checkParameter[1].'`';
            }
            else if (count($checkParameterUnderline) > 1) {
                $parameter = '`'.$parameter.'`';
            }
            else {
                $parameter = '`'.$key.'`.`'.$parameter.'`';
            }
        }
        return $parameter;
    }

    public function sufixin($parameter, $key = null)
    {
        $sufix = self::sufix($parameter, $key);

        $sufix = str_replace('`', '', $sufix);
        $sufix = str_replace('´', '', $sufix);

        return $sufix;
    }

    public function unsufix($value)
    {
        $parameter = str_replace('_'.$this->getSufix(), '', $parameter);

        return $parameter;
    }

    public function select($key, $name = null, $prefix = null)
    {
        if (is_null($name)) {
            $name = $key;
        }

        $select = $this->sufix($key)." as '".$name."'";

        if ($prefix) {
            $select = $this->sufix($key, $prefix)." as '".$name."'";
        }

        $this->setQuery('select', $select);
    }

    public function selectCount($key, $name = null)
    {
        if (is_null($name)) {
            $name = $key;
        }

        $select = "COUNT(".$this->sufix($key).") as '".$name."'";

        $this->setQuery('select', $select);
    }

    public function selectSum($key, $name = null)
    {
        if (is_null($name)) {
            $name = $key;
        }

        $select = "SUM(".$this->sufix($key).") as '".$name."'";

        $this->setQuery('select', $select);
    }

    public function selectMax($key, $name = null)
    {
        if (is_null($name)) {
            $name = $key;
        }

        $select = "MAX(".$this->sufix($key).") as '".$name."'";

        $this->setQuery('select', $select);
    }


    public function selectJSON($key, $target, $name = null)
    {
        if (is_null($name)) {
            $name = $key;
        }

        if (!strstr($key, '-') && !strstr($key, '_')) {
            $key = $this->sufix($key);
        }

        $select = "SUM(".$key.") as '".$name."'";

        $this->setQuery('select', $select);
    }

    public function selectArray($array)
    {
        if (is_array($array)) {
            foreach ($array as $key => $value) {
                $this->select($value);
            }
        }
    }

    public function set($key, $value)
    {
        $set[$this->sufix($key)] = $value;

        $this->setQuery('set', $set);
    }

    public function setArray($array)
    {
        if (is_array($array)) {
            foreach ($array as $key => $value) {
                $set = null;
                $set[$this->sufix($key)] = $value;

                $this->setQuery('set', $set);
            }
        }
    }

    public function setSum($key, $value)
    {
        $set[$this->sufix($key)] = $this->sufix($key).' + '.$value;

        $this->setQuery('set', $set);
    }

    public function setOrder($keySet, $valuesCompare = null)
    {
        $query = null;

        if (is_array($valuesCompare)) {
            foreach ($valuesCompare as $key => $value) {
                if ($tuple = $this->getSetTuple($value)) {
                    $query .= " AND `".$this->sufix($value)."` = '".$tuple."'";
                }
            }
        }

        if ($query){
            $this->set($keySet, $this->database()->generatorOrder($query));
        }
    }

    public function getSetTuple($tuple)
    {
        $sets = $this->getQuery('set');

        foreach ($sets as $key => $value) {
            if (array_key_exists($this->sufix($tuple), $value)) {
                return $value[$this->sufix($tuple)];
            }
        }
    }

    public function inTablePrefix($tablePrefix, $key)
    {
        $table = $key;

        if ($this->commands['tablePrefix']) {
            $table = "`".$tablePrefix."_".$table."`";
        }
        else {
            $table = "`".$table."`";
        }

        return $table;
    }

    public function inTupleSufix($key, $tupleSufix)
    {
        $tuple = $tupleSufix;

        if ($this->commands['tupleSufix']) {
            $tuple = $this->sufix($key."_".$tuple);
        }
        else {
            $tuple = $this->sufix($key, $tupleSufix);
        }

        return $tuple;
    }

    public function innerJoin($dependence, $keyDependence, $keydatabase = 'id', $tablePrefix = 'mod', $operation = '=')
    {
        $join = "INNER JOIN ".$this->inTablePrefix($tablePrefix, $dependence)." ON (".$this->inTupleSufix($keyDependence, $dependence)." ".$operation." ".$this->sufix($keydatabase).")";

        $this->setQuery('join', $join);
    }

    public function innerJoinOnly($dependence, $tablePrefix = 'mod')
    {
        $join = "INNER JOIN ".$this->inTablePrefix($tablePrefix, $dependence);

        $this->setQuery('join', $join);
    }

    public function leftJoin($dependence, $keyDependence, $keydatabase = 'id', $tablePrefix = 'mod', $extraConditition = null, $operation = '=')
    {
        $join = "LEFT JOIN ".$this->inTablePrefix($tablePrefix, $dependence)." ON (".$this->inTupleSufix($keyDependence, $dependence)." ".$operation." ".$this->sufix($keydatabase).$extraConditition.")";

        $this->setQuery('join', $join);
    }

    public function rightJoin($dependence, $keyDependence, $keydatabase = 'id', $extraConditition = null, $operation = '=', $tablePrefix = 'mod')
    {
        $join = "RIGHT JOIN ".$this->inTablePrefix($tablePrefix, $dependence)." ON (".$this->inTupleSufix($keyDependence, $dependence)." ".$operation." ".$this->sufix($keydatabase).$extraConditition.")";

        $this->setQuery('join', $join);
    }

    public function leftJoinJSON($dependence, $keyDependence, $keySelected, $keydatabase = 'id', $tablePrefix = 'mod', $extraConditition = null, $operation = '=')
    {
        $join = 'INNER JOIN '.$this->inTablePrefix($tablePrefix, $dependence).' ON (JSON_EXTRACT('.$this->inTupleSufix($keyDependence, $dependence).', "$.'.$keySelected.'") '.$operation.' '.$this->sufix($keydatabase).$extraConditition.')';

        $this->setQuery('join', $join);
    }

    public function where($key, $value, $operation = '=', $valueType = 'value', $in = true)
    {
        $where = $this->manipuleWhere($key, $value, $operation, $valueType);

        if ($in) {
            $this->setQuery('where', $where);

            return $this;
        }
        else {
            return $where;
        }
    }

    public function whereAnd($key, $value, $operation = '=', $valueType = 'value', $globTuple = null)
    {
        $whereAnd = " AND ".$this->manipuleWhere($key, $value, $operation, $valueType, $globTuple);

        $this->setQuery('where', $whereAnd);

        return $this;
    }

    public function whereAndNot($key, $value, $operation = '=', $valueType = 'value', $globTuple = null)
    {
        $whereAnd = " AND NOT ".$this->manipuleWhere($key, $value, $operation, $valueType, $globTuple);

        $this->setQuery('where', $whereAnd);

        return $this;
    }

    public function whereOr($key, $value, $operation = '=', $valueType = 'value')
    {
        $whereOr = " OR ".$this->manipuleWhere($key, $value, $operation, $valueType);

        $this->setQuery('where', $whereOr);

        return $this;
    }

    public function whereIsNull($key, $whereGroup = 'AND', $not = 'NOT')
    {
        $key = $this->sufix($key);

        $whereIsNull = " ".$whereGroup." ".$not." ".$key." IS NULL";

        $this->setQuery('where', $whereIsNull);

        return $this;
    }

    public function whereIsNullGroup($group, $whereGroup = 'AND', $whereItem = 'OR')
    {
        foreach ($group as $key => $value) {
            $values[$key] = $this->sufix($value)." IS NULL";
        }

        $whereIsNullGroup = ' '.$whereGroup.' ('.implode(' '.$whereItem.' ', $values).')';

        $this->setQuery('where', $whereIsNullGroup);

        return $this;
    }

    public function whereGroup($key, $values = [], $whereGroup = 'AND')
    {
        foreach ($values as $keyValue => $valueValue) {
            $valuesString[$keyValue] = $this->manipuleWhere($key, $valueValue, '=', 'value');
        }

        $valuesString = implode(' OR ', $valuesString);

        $whereAnd = " ".$whereGroup." (".$valuesString.")";

        $this->setQuery('where', $whereAnd);

        return $this;
    }

    public function whereSearch($value, $params = null, $whereGroup = 'AND', $whereItem = 'OR', $operation = 'LIKE', $valueType = 'value')
    {
        if (is_null($params)) {
            $params = $this->loadFieldsSearch();
        }

        $whereSearch = " ".$whereGroup." (";

        $totalParams = count($params);

        for ($param = 0; $param < $totalParams; $param++) {
            $whereSearch .= $this->sufix($params[$param])." ".$operation." '%".\Treatment::string($value)."%'";

            if ($param + 1 != $totalParams) {
                $whereSearch .= " ".$whereItem." ";
            }
        }

        $whereSearch .= ")";

        $this->setQuery('where', $whereSearch);
    }

    public function whereLike($key, $value, $operation = 'OR', $prefix = '%', $sufix = '%')
    {
        if (!strstr($key, '-') && !strstr($key, '_')) {
            $key = $this->sufix($key);
        }

        $whereLike = $this->getQuery('whereLike');

        if (is_array($whereLike) && count($whereLike) > 0) {
            $whereLike = $operation." ".$key." LIKE '".$prefix.$value.$sufix."'";
        }
        else {
            $whereLike = $key." LIKE '".$prefix.$value.$sufix."'";
        }

        $this->setQuery('whereLike', $whereLike);
    }

    public function whereJSON($key, $selected, $value, $whereGroup = 'AND', $operation = '=', $valueType = 'value', $in = true)
    {
        $key = $this->sufix($key);

        if (!is_int($value)) {
            $value = "'".$value."'";
        }

        if ($whereGroup) {
            $whereJSON = ' '.$whereGroup.' JSON_EXTRACT('.$key.', "$.'.$selected.'") '.$operation.' '.$value;
        }
        else {
            $whereJSON = ' JSON_EXTRACT('.$key.', "$.'.$selected.'") '.$operation.' '.$value;
        }

        if ($in) {
            $this->setQuery('where', $whereJSON);
        }

        return $whereJSON;
    }

    public function betweenDate($key, $value1, $value2, $whereGroup = 'AND', $addOneDay = false)
    {
        $key = $this->sufix($key);

        $value1 = rtrim(trim($value1));
        $value2 = rtrim(trim($value2));

        if ($addOneDay) {
            $value1 = date('Y-m-d', strtotime($value1.'+1 days'));
        }

        $whereBetween = " ".$whereGroup." ".$key." BETWEEN CAST('".$value2."' AS DATE) AND CAST('".$value1."' AS DATE)";

        $this->setQuery('where', $whereBetween);
    }

    public function groupBy($key)
    {
        $groupBy = $this->sufix($key);

        $this->setQuery('groupby', $groupBy);
    }

    public function orderBy($key, $order = 'ASC', $sufix = true)
    {
        if ($sufix) {
            $orderBy = $this->sufix($key)." ".$order;
        }
        else {
            $orderBy = '`'.$key."` ".$order;
        }

        $this->setQuery('orderby', $orderBy);
    }

    public function orderByRand()
    {
        $this->setQuery('orderby', 'RAND()');
    }

    public function limit($limit)
    {
        $this->setQuery('limit', $limit);
    }

    public function manipuleWhere($label, $value = null, $operation = '=', $valueType = 'value', $globTuple = null)
    {
        $where = null;

        if ($value || $value == 0) {
            $label = $this->sufix($label);

            if ($globTuple) {
                $label = $globTuple.'('.$label.')';
            }

            if ($valueType == 'value') {
                $where = $label." ".$operation." '".$value."'";
            }
            else if ($valueType == 'dependence') {
                $where = $label." ".$operation." `".$value."`";
            }
        }

        return $where;
    }

    public function getSetQuery()
    {
       $sets = $this->getQuery('set');

       $params = null;

        foreach ($sets as $set) {
            foreach ($set as $key => $value) {
                if (!strstr($value, '`')) {
                    $params[] = $key." = '".$value."'";
                }
                else {
                    $params[] = $key." = ".$value;
                }
            }
        }

        if ($params) {
            return implode(', ', $params);
        }
    }

    public function getSetParams()
    {
        $sets = $this->getQuery('set');

        foreach ($sets as $set) {
            foreach ($set as $key => $value) {
                $params[] = $key;
            }
        }

        return implode(', ', $params);
    }

    public function getSetValues()
    {
        $sets = $this->getQuery('set');

        foreach ($sets as $set) {
            foreach ($set as $key => $value) {
                if (!is_null($value) && !strstr($value, '`')) {
                    $params[] = "'".$value."'";
                }
                else {
                    if (is_null($value)) {
                        $params[] = '';
                    }
                    else {
                        $params[] = $value;
                    }
                }
            }
        }

        return implode(', ', $params);
    }

    public function getQuerySelect()
    {
        $select = $this->getQuery('select');
        $selectReturn = '*';

        if (is_array($select)) {
            $selectReturn = implode(', ',$select);
        }

        return $selectReturn;
    }

    public function getQueryWhere()
    {
        $where = $this->getQuery('where');
        $whereReturn = null;

        if (is_array($where) && count($where) > 0) {
            $whereReturn = "WHERE ".implode(' ', $where);
        }

        $whereLike = $this->getQuery('whereLike');

        if (is_array($whereLike) && count($whereLike) > 0) {
            if ($whereReturn) {
                $whereReturn = $whereReturn ." AND (".implode(' ', $whereLike).")";
            }
            else  {
                 $whereReturn = "(".implode(' ', $whereLike).")";
            }
        }

        return $whereReturn;
    }

    public function getQueryGroupBy()
    {
        $groupBy = $this->getQuery('groupby');

        if (is_array($groupBy)) {
            $groupBy = "GROUP BY ".implode(', ', $groupBy);
        }

        return $groupBy;
    }

    public function getQueryOrderBy()
    {
        $orderBy = $this->getQuery('orderby');

        if (is_array($orderBy)) {
            $orderBy = "ORDER BY ".implode(', ', $orderBy);
        }

        return $orderBy;
    }

    public function getQueryLimit()
    {
        $limit = $this->getQuery('limit');

        if ($limit) {
            $limit = "LIMIT ".$limit;
        }

        return $limit;
    }

    public function getQueryHaving()
    {
        $having = $this->getQuery('having');

        if (is_array($having)) {
            $having = "HAVING ".implode(', ', $having);
        }

        return $having;
    }

    public function getQueryPagination()
    {
        $query = "SELECT ".$this->getQuerySelect()."
                  FROM `".$this->getTable()."`
                  ".implode(' ', $this->getQuery('join'))."
                  ".$this->getQueryWhere()."
                  ".$this->getQueryGroupBy()."
                  ".$this->getQueryHaving()."
                  ".$this->getQueryOrderBy();

        return $query;
    }

    public function getQuerySimple()
    {
        $query = "SELECT * FROM `".$this->getTable()."`";

        return $query;
    }

    public function getQueryManage()
    {
        $query = "SELECT ".$this->getQuerySelect()."
                  FROM `".$this->getTable()."`
                  ".implode(' ', $this->getQuery('join'))."
                  ".$this->getQueryWhere()."
                  ".$this->getQueryGroupBy()."
                  ".$this->getQueryHaving()."
                  ".$this->getQueryOrderBy()."
                  ".$this->getQueryLimit();

        return [
            'query' => $query
        ];
    }

    public function getQueryCheck()
    {
        $query = "SELECT ".$this->sufix('id')." as 'id' FROM `".$this->getTable()."` ".$this->getQueryWhere();

        return $query;
    }

    public function getQueryDelete()
    {
        $query = "DELETE FROM `".$this->getTable()."`
                  ".$this->getQueryWhere();

        return $query;
    }

    public function getQueryCreate()
    {
        $query = "INSERT INTO `".$this->getTable()."`
                  (".$this->getSetParams().")
                  VALUES (".$this->getSetValues().")";

        return $query;
    }

    public function getQueryUpdate()
    {
        $query = "UPDATE `".$this->getTable()."`
                  SET ".$this->getSetQuery()."
                  ".$this->getQueryWhere();

        return $query;
    }

    public function getQueryView()
    {
        $query = "SELECT ".$this->getQuerySelect()."
                  FROM `".$this->getTable()."`
                  ".implode(' ', $this->getQuery('join'))."
                  ".$this->getQueryWhere()."
                  ".$this->getQueryGroupBy()."
                  ".$this->getQueryHaving()."
                  ".$this->getQueryOrderBy();

        return $query;
    }

    public function getQueryCreateView($nameView)
    {
        $query = "CREATE VIEW `".$nameView."` AS
                  SELECT ".$this->getQuerySelect()."
                  FROM `".$this->getTable()."`
                  ".implode(' ', $this->getQuery('join'))."
                  ".$this->getQueryWhere();

        return $query;
    }

    public function getQueryField()
    {
        $query = "SELECT *
                  FROM `".$this->getTable()."`
                  ".implode(' ', $this->getQuery('join'));

        return [
            'query' => $query
        ];
    }

    public function getQuerySelectView($nameView)
    {
        $query = "SELECT VIEW `".$nameView."`";

        return $query;
    }

    public function find($dumpQuery = false)
    {
        $query = $this->getQueryView();

        if ($dumpQuery) {
            print_r($query);
            dd('EXIT');
        }

        if ($result = $this->database()->dbFetchAssoc($query)) {
            $this->setCleanQuery();

            return $result;
        }
    }

    public function all($dumpQuery = false)
    {
        $query = $this->getQueryManage();

        if ($dumpQuery) {
            print_r($query['query']);
            dd('EXIT');
        }

        if ($result = $this->database()->dbFetchAll($query['query'])) {
            $this->setCleanQuery();

            return $result;
        }
    }

    public function paginateGet($params, $limit = 10, $dumpQuery = null, $keyUrl = null, $keyTab = null)
    {
        $query = $this->getQueryPagination();

        $pagination = new PaginationGet([
            'locale' => $params,
            'item' => $limit,
            'query' => $query
        ]);

        if (!is_null($keyUrl)) {
            $pagination->keyPage = $keyUrl;
        }

        $pagination->execute();

        if ($dumpQuery) {
            print_r($pagination->query);
            dd('EXIT');
        }

        $total = $this->total(false, $query, false);

        $this->limit($pagination->queryLimit);

        if ($dumpQuery) {
            print_r($pagination->query);
            dd('EXIT');
        }

        $dataReturn['total'] = $total;
        $dataReturn['data'] = $this->all();
        $dataReturn['pagination'] = $pagination->navigation($this->provider);
        $dataReturn['limit'] = $pagination->item;
        $dataReturn['page'] = $pagination->page;

        $this->setCleanQuery();

        return $dataReturn;
    }

    public function paginate($dumpQuery = false, $keyUrl = null, $keyTab = null)
    {
        $query = $this->getQueryPagination();

        $pagination = new PaginationComponent($this->request);

        if (!is_null($keyUrl)) {
            $pagination->keyPage = $keyUrl;
        }

        $pagination->keyTab = $keyTab;

        $pagination->item = $this->getQuery('limit');
        $pagination->query = $query;

        if ($dumpQuery) {
            print_r($pagination->query);
            dd('EXIT');
        }

        $total = $this->total(false, $query, false);

        if ($result = $pagination->find($total)) {
            $this->limit($pagination->queryLimit);

            if ($dumpQuery) {
                print_r($pagination->query);
                dd('EXIT');
            }

            $dataReturn['total'] = $total;
            $dataReturn['data'] = $this->all();
            $dataReturn['pagination'] = $pagination->navigation($this->provider);
            $dataReturn['limit'] = $pagination->item;
            $dataReturn['page'] = $pagination->page;

            $this->setCleanQuery();

            return $dataReturn;
        }
    }

    public function total($dumpQuery = false, $query = null, $clean = true)
    {
        if (is_null($query)) {
            $query = $this->getQueryPagination();
        }

        if ($dumpQuery) {
            print_r($query);
            dd('EXIT');
        }

        if ($result = $this->database()->dbNumRows($query)) {
            if ($clean) {
                $this->setCleanQuery();
            }

            return $result;
        }
    }

    public function check($dumpQuery = false, $query = null, $clean = true)
    {
        if (is_null($query)) {
            $query = $this->getQueryCheck();
        }

        if ($dumpQuery) {
            print_r($query);
            dd('EXIT');
        }

        if ($result = $this->database()->dbNumRows($query)) {
            if ($clean) {
                $this->setCleanQuery();
            }

            return $result;
        }
    }

    public function create($dumpQuery = false)
    {
        if ($this->createUUID && $this->checkField('uuid') && !$this->getSetTuple('uuid')) {
            $this->set('uuid', $this->createUUID());
        }

        if ($this->checkField('createduser') && !$this->getSetTuple('createduser')) {
            $this->set('createduser', 5000);
        }

        if ($this->checkField('status') && !$this->getSetTuple('status')) {
            $this->set('status', 1);
        }

        if ($this->checkField('ip') && !$this->getSetTuple('ip')) {
            $this->set('ip', $_SERVER['REMOTE_ADDR']);
        }

        $query = $this->getQueryCreate();

        if ($dumpQuery) {
            print_r($query);
            dd('EXIT');
        }

        if ($execute = $this->database()->dbQuery($query, false)) {
            $idNew = $this->database()->dbLast();

            $this->setIdLast($idNew);

            $this->setCleanQuery();

            return true;
        }
    }

    public function update($value = null, $dumpQuery = false)
    {
        if ($value) {
            $queryWhere = $this->getQuery('where');

            if (count($queryWhere) == 0) {
                $this->where($this->defaultInstance, $value);
            }
            else {
                $this->whereAnd($this->defaultInstance, $value);
            }
        }

        $query = $this->getQueryUpdate();

        if ($dumpQuery) {
            print_r($query);
            dd('EXIT');
        }

        if ($execute = $this->database()->dbQuery($query)) {
            $this->setCleanQuery();

            return true;
        }
    }

    public function createView($nameView, $dumpQuery = false)
    {
        $query = $this->getQueryCreateView($nameView);

        if ($dumpQuery) {
            print_r($query);
            dd('EXIT');
        }

        if ($execute = $this->database()->dbQuery($query)) {
            $this->setCleanQuery();

            return true;
        }
    }

    public function delete($value = null, $dumpQuery = false)
    {
        if ($value) {
            $this->where($this->defaultInstance, $value);
        }

        $query = $this->getQueryDelete();

        if ($dumpQuery) {
            print_r($query);
            dd('EXIT');
        }

        if ($execute = $this->database()->dbQuery($query)) {
            $this->setCleanQuery();

            return true;
        }
    }

    public function compare($fields = [], $values = [])
    {
        $this->select($this->defaultInstance);

        $this->where('id', 0, '<>');

        for ($i = 0; $i < count($fields); $i++) {
            $this->whereLike($fields[$i], $values[$i], 'OR', null, null);
        }

        if ($this->check() > 0) {
            $this->setCleanQuery();

            return true;
        }
        else {
            $this->setCleanQuery();

            return false;
        }
    }

    public function checkField($fieldCheck, $table = null)
    {
        if (is_null($table)) {
            $table = $this->getTable();
        }

        $query = $this->getQuerySimple();

        $execute = $this->database()->dbFields($query);

        if (is_array($execute)) {
            foreach ($execute as $key => $value) {
                if ($this->sufix($value['name']) == $this->sufix($fieldCheck)) {
                    return true;
                }
            }
        }

        return false;
    }

    public function loadFieldsSearch()
    {
        $query = $this->getQueryField();

        $execute = $this->database()->dbFieldsSearch($query['query'], $this->getTable());

        return $execute;
    }

    public function createUUID()
    {
        return \Tools::generateUUID(uniqid().md5($this->getTable()));
    }

    public function base($key)
    {
        $this->select('value');
        $this->where('key', $key);

        if ($data = $this->find()) {
            if (@unserialize($data['value'])) {
                $data = unserialize($data['value']);
            }
            else if (@json_decode($data['value'])) {
                $data = json_decode($data['value'], true);
            }

            return $data;
        }
    }

    public static function getStatic($selectedData = 1, $file = null, $output = 'array', $order = false)
    {
        $dataReturn = null;

        $filePath = config('integration.ROOT_SITE').'/app/repository'.'/'.$file.'.json';

        $repository = null;

        if (file_exists($filePath)) {
            $repository = file_get_contents($filePath);

            $repository = json_decode($repository, true);
        }

        if ($repository) {
            if ($order) {
                asort($repository);
            }

            foreach ($repository as $key => $value) {
                $selected = false;

                if ($key == $selectedData) {
                    $selected = true;

                    if ($output == 'view') {
                        return Treatment::string($value);
                    }
                }

                $dataReturn[] = [
                    'title' => Treatment::string($value),
                    'value' => intval($key),
                    'selected' => $selected
                ];
            }

            if ($output != 'view') {
                return $dataReturn;
            }
        }
    }

    public static function getTuple($key, $select, $view = 'title', $where = 'id', $prefix = 'mod')
    {
        $repository = new \Repository($key, $prefix);

        if (is_array($view)) {
            foreach ($view as $keyView => $valueView) {
                $repository->select($valueView);
            }

            $return = 'array';
        }
        else {
            $repository->select($view);

            $return = 'string';
        }

        $repository->where($where, $select);

        if ($result = $repository->find()) {
            if ($return == 'string') {
                return $result[$view];
            }
            else {
                return $result;
            }
        }
    }

    public function checkTable($table)
    {
        $this->setTable($table);

        $query = $this->getQuerySimple();

        if ($result = $this->find()){
            return true;
        }
    }

    public function truncate($table = null)
    {
        if (is_null($table)) {
            $table = $this->getTable();
        }

        $query = "TRUNCATE TABLE `".$this->getTable()."`";

        if ($execute = $this->database()->dbQuery($query, false)) {
            return true;
        }
    }
}
