<?php

// CoreSlim - Última atualização 23/05/2023 16:03

namespace CoreSlim;

use CoreSlim\Treatment;

class Request
{
    public static function post($key, $type = 'injection')
    {
        $post = isset($_POST[$key]) ? $$key = $_POST[$key] : $$key = null;

        if ($post == null) {
            return null;
        }
        else if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            return Treatment::handle($$key, $type);
        }
    }

    public static function get($key, $type = 'sanitize')
    {
        if (isset($_GET[$key])) {
            return Treatment::handle($_GET[$key], $type);
        }
        else {
            return null;
        }
    }

    public static function seo($position, $primary = true)
    {
        $base = explode('/', config('app.BASE_PATH'));
        $url = explode('/', $_SERVER['REQUEST_URI']);

        $base_key = count($base) - intval(config('app.URL'));
        $base_default = null;

        if (array_key_exists($base_key, $base)) {
            $base_default = $base[$base_key];
        }

        if ($position < count($url)) {
            foreach ($url as $key => $value) {
                if ($value == $base_default) {
                    if (array_key_exists(($key + $position), $url)) {
                        return $url[$key + $position];
                    }
                }
            }
        }
    }

    public static function permalink($path = null, $primary = null)
    {
        if (is_null($path) && is_null($primary)) {
            return self::preventBarsUrl(config('app.BASE_PATH'));
        }
        else if (!is_null($path) && !is_null($primary)) {
            return self::preventBarsUrl(config('app.BASE_PATH').'/'.$primary.'/'.$path);
        }
        else if (!is_null($path) && is_null($primary)) {
            return self::preventBarsUrl(config('app.BASE_PATH').'/'.$path);
        }
        else if (is_null($path) && !is_null($primary)) {
            return self::preventBarsUrl(config('app.BASE_PATH').'/'.$primary);
        }
    }

    public static function unpermalink($path = null, $primary = null)
    {
        if (is_null($path)) {
            return $path;
        }
        else if (is_null($primary)) {
            return str_replace(config('app.BASE_PATH').'/', '', $path);
        }
        else if (is_null($path) && is_string($primary)) {
            return str_replace(config('app.BASE_PATH').'/'.$primary.'/', $path);
        }
        else if (is_string($path) && is_string($primary)) {
            return str_replace(config('app.BASE_PATH').'/'.$primary.'/'.$path.'/', $path);
        }
    }

    public static function injectVars($keyPrimary = null, $vars = [], $notVars = null)
    {
        $varsSaveActive = $_GET;

        if (!is_null($keyPrimary)) {
            $path = self::permalink($keyPrimary);
        }
        else {
            $path = $_SERVER['REQUEST_URI'];
            $path = explode('/?', $path);

            $base = explode('/', config('app.BASE_PATH'));
            $baseEnd = end($base);
            $baseRemove = '/'.$baseEnd;


            $path = str_replace($baseRemove, '', $path);

            $path = self::permalink(substr($path[0], 1));
        }

        if (is_array($vars)) {
            foreach ($vars as $arrayVars) {
                foreach ($arrayVars as $key => $value) {
                    $varsSaveActive[$key] = $value;

                    if ($value == 'empty') {
                        unset($varsSaveActive[$key]);
                    }
                }
            }
        }

        if (is_array($varsSaveActive)) {
            if ($notVars) {
                if ($key != 'pesquisa') {
                    array_push($notVars, 'pesquisa');
                }

                foreach ($varsSaveActive as $key => $value) {
                    foreach ($notVars as $varNot) {
                        if ($varNot == $key) {
                            unset($varsSaveActive[$key]);
                        }
                    }
                }
            }

            $i = 0;

            foreach ($varsSaveActive as $key => $value) {
                if ($i == 0) {
                    $operator = '/?';
                }
                else {
                    $operator = '&';
                }

                $path .= $operator.Treatment::handle($key).'='.Treatment::handle($value);

                $i++;
            }
        }

        return self::preventBarsUrl($path);
    }

    public static function preventBarsUrl($url)
    {
        $explodeUrl = explode(config('app.BASE_PATH'), $url);

        $urlString = str_replace('////', '/', $explodeUrl[1]);
        $urlString = str_replace('///', '/', $urlString);
        $urlString = str_replace('//', '/', $urlString);

        $newUrl = config('app.BASE_PATH').$urlString;

        return $newUrl;
    }

    public static function urlComplet()
    {
        return config('app.BASE_URL').$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];
    }

    public static function pathPreservLink($path = null, $vars = [], $not = [])
    {
        $pathActive = self::urlComplet();

        $varsPathActive = explode('&operation=', $pathActive);

        $pathPrimary = $varsPathActive[0];

        $varsPathActive = explode('&', $varsPathActive[1]);

        $operation = $varsPathActive[0];

        unset($varsPathActive[0]);

        $varsPathActive = array_values($varsPathActive);

        $varsSend = null;

        if (is_array($vars)) {
            foreach ($vars as $arrayVars) {
                foreach ($arrayVars as $key => $value) {
                    $varsSend .= '&'.$key.'='.$value;
                }
            }
        }

        $pathSend = $path.$varsSend;

        $varsPathSend = explode('&', $pathSend);

        $pathNew = $pathPrimary.'&operation='.$operation;

        $varsSaveActive = [];

        foreach ($varsPathActive as $value) {
            $vars = explode('=', $value);

            if (!isset($not[$vars[0]])) {
                $varsSaveActive[$vars[0]] = $vars[1];
            }
        }

        foreach ($varsPathSend as $value) {
            if ($value) {
                $vars = explode('=', $value);

                $varsSaveSend[$vars[0]] = $vars[1];

                if (is_array($varsSaveActive)) {
                    $varsSaveActive[$vars[0]] = $vars[1];
                }
                else {
                    $varsSaveActive[$vars[0]] = $vars[1];
                }

                if ($vars[1] == 'empty') {
                    unset($varsSaveActive[$vars[0]]);
                }
            }
        }

        foreach ($varsSaveActive as $key => $value) {
            $pathNew .= '&'.$key.'='.$value;
        }

        return $pathNew;
    }

    public static function linkDoop($module, $operation, $id = null, $folder = 'module')
    {
        $link = config('app.PATH_SYSTEM').$folder.'/'.$module.'&operation='.$operation;

        if ($id) {
            $link .= '&id='.$id;
        }

        return self::preventBarsUrl($link);
    }

    public static function manipulationPermalink($positions, $parameter = null, $clear = null)
    {
        $primaryUri = Request::seo(1);

        $url = $this->urlOnlyParams($_SERVER['REQUEST_URI']);

        $urlParams = explode('/', $url);

        if (!$urlParams[0]) {
            unset($urlParams[0]);
        }

        $urlCount = count($urlParams);

        if ($urlCount < $positions[1]) {
            $url = '/'.Request::unpermalink($this->page[0]['url']);

            $urlParams = explode('/', $url);

            if (!$urlParams[0]) {
                unset($urlParams[0]);
            }

            $urlCount = count($urlParams);
        }

        $urlParams[$positions[0]] = $parameter;

        $uriNew = implode('/', $urlParams);

        return Request::permalink($uriNew);
    }

    public static function monitorFragmentSocial()
    {
        $url = Request::urlComplet();

        $vars = explode('/', $url);
        $endVar = end($vars);

        $fragments = ['?fbclid=', '?gclid='];

        foreach ($fragments as $fragment) {
            $fragmentUrl = strpos($endVar, $fragment);

            if ($fragmentUrl > 0) {
                $fragmentUrl = strstr($url, $fragment);

                $newUrl = str_replace($fragmentUrl, '', $url).'/'.$fragmentUrl;

                header('Location: '.$newUrl);
                exit;
            }
        }
    }

    public static function getPositionUrl($label)
    {
        $uri = explode('/', $_SERVER['REQUEST_URI']);

        for ($i = array_search(Request::seo(1), $uri) - 1; $i < count($uri); $i++) {
            if (array_key_exists($i, $uri)) {
                $uriActive[] = $uri[$i];
            }
        }

        foreach ($uriActive as $key => $parameter) {
            if ($parameter == $label) {
                return $key;
            }
        }
    }
}
