<?php

// CoreSlim - Última atualização 15/04/2024 17:17

namespace CoreSlim;

use Ramsey\Uuid\Uuid;

class Tools
{
    public static function generateUUID($key)
    {
        $uuid = Uuid::uuid5(Uuid::NAMESPACE_DNS, config('app.SECRET_KEY').$key);

        return $uuid->toString();
    }

    public static function checkUUID($key, $uuidCompare)
    {
        $uuidGenerate = Uuid::uuid5(Uuid::NAMESPACE_DNS, config('app.SECRET_KEY').$key);

        if ($uuidCompare == $uuidGenerate) {
            return true;
        }
    }

    public static function setArray($array = [], $content = null, $values = null)
    {
        if (is_string($content)) {
            if (is_array($array) && is_array($values)) {
                $newValues[$content] = $values;

                $array = array_merge_recursive($newValues, $array);
            }
            else {
                $array[$content] = $values;
            }
        }

        return $array;
    }

    public static function getArray($array, $search = null, $force = false)
    {
        if (is_array($array) && is_array($search) && count($search) >= 1) {
            foreach ($search as $key => $value) {
                if ((is_int($value) || is_string($value) || is_bool($value)) && array_key_exists($value, $array)) {
                    if (is_array($array[$value])) {
                        unset($search[$key]);

                        return self::getArray($array[$value], array_values($search), $force);
                    }
                    else if (!is_array($array[$value])) {
                        return $array[$value];
                    }
                }
                else if ($force) {
                    return self::getArray($search[0], $value, $force);
                }
            }
        }
        else if ($force && is_array($search) && count($search) == 0 && is_array($array)) {
            return $array;
        }
    }

    public static function getInArray($array, $search = null)
    {
        if (is_array($array) && !is_array($search) && array_key_exists($search, $array)) {
            return $array[$search];
        }
        else if (is_array($array) && is_array($search)) {
            return self::getArray($array, $search, true);
        }
        else if (is_array($array) && is_null($search)){
            return $search;
        }
    }

    public static function hasArray($array, $search)
    {
        if (is_array($array) && is_array($search) && count($search) >= 1) {
            foreach ($search as $key => $value) {
                if ((is_int($value) || is_string($value) || is_bool($value)) && array_key_exists($value, $array)) {
                    if (is_array($array[$value])) {
                        unset($search[$key]);

                        return self::hasArray($array[$value], array_values($search));
                    }
                    else if (!is_array($array[$value])) {
                        return true;
                    }
                }
            }
        }
        else if (is_array($search) && count($search) == 0 && is_array($array)) {
            return true;
        }
        else if (!is_array($search) && is_array($array) && array_key_exists($search, $array)) {
            return true;
        }

        return false;
    }

    public static function timeDiff($date, $dateCompare = null, $disable = ['h', 'i', 's'])
    {
        $period = [
            'y' => ['singular' => 'ano', 'plural' => 'anos'],
            'm' => ['singular' => 'mês', 'plural' => 'meses'],
            'w' => ['singular' => 'semana', 'plural' => 'semanas'],
            'd' => ['singular' => 'dia', 'plural' => 'dias'],
            'h' => ['singular' => 'hora', 'plural' => 'horas'],
            'i' => ['singular' => 'minuto', 'plural' => 'minutos'],
            's' => ['singular' => 'segundo', 'plural' => 'segundos']
        ];

        $date = new \DateTime($date);

        if (is_null($dateCompare)) {
            $dateCompare = new \DateTime(date('Y-m-d H:i:s'));
        }

        $diff = $date->diff($dateCompare);

        $output = null;

        if ($diff) {
            if ($diff->y > 0 && !in_array('y', $disable)) {
                $output .= ' '.$diff->y;

                if ($diff->y == 1) {
                    $output .= ' '.$period['y']['singular'];
                }
                else {
                    $output .= ' '.$period['y']['plural'];
                }
            }

            if ($diff->m > 0 && !in_array('m', $disable)) {
                $output .= ' '.$diff->m;

                if ($diff->m == 1) {
                    $output .= ' '.$period['m']['singular'];
                }
                else {
                    $output .= ' '.$period['m']['plural'];
                }
            }

            if ($diff->d > 0 && !in_array('d', $disable)) {
                if ($diff->m > 0) {
                    $output .= ' e ';
                }

                $output .= ' '.$diff->d;

                if ($diff->d == 1 && !in_array('d', $disable)) {
                    $output .= ' '.$period['d']['singular'];
                }
                else {
                    $output .= ' '.$period['d']['plural'];
                }
            }

            if ($diff->h > 0 && !in_array('h', $disable)) {
                $output .= ' '.$diff->h;

                if ($diff->h == 1) {
                    $output .= ' '.$period['h']['singular'];
                }
                else {
                    $output .= ' '.$period['h']['plural'];
                }
            }

            if ($diff->i > 0 && !in_array('i', $disable)) {
                $output .= ' '.$diff->i;

                if ($diff->i == 1) {
                    $output .= ' '.$period['i']['singular'];
                }
                else {
                    $output .= ' '.$period['i']['plural'];
                }
            }

            if ($diff->s > 0 && !in_array('s', $disable)) {
                $output .= ' '.$diff->s;

                if ($diff->s == 1) {
                    $output .= ' '.$period['s']['singular'];
                }
                else {
                    $output .= ' '.$period['s']['plural'];
                }
            }
        }

        return $output;
    }

    public static function jsonOpen($path, $array = true)
    {
        if (file_exists($path)) {
            $read = file_get_contents($path);

            return json_decode($read, $array);
        }
    }

    public static function jsonSave($path, $data)
    {
        $file = fopen($path, 'w+');

        fwrite($file, json_encode($data));
        fclose($file);
    }

    public static function prepareAddress($info)
    {
        if ($info) {
            $infoAddress = null;

            $repository = new Repository('ibge-city', ['prefixKey' => 'sis']);
            $repository->select('name_ibge-city', 'city');
            $repository->select('iso_ibge-state', 'state');
            $repository->innerJoin('ibge-state', 'id', 'state', 'sis');
            $repository->where('id', $info['city']);
            $repository->whereAnd('state', $info['state']);

            if ($data = $repository->find()) {
                $city = Treatment::string($data['city']);
                $state = Treatment::string($data['state']);

                if ($info['address'] || $info['district'] || $city || $state || $info['cep']) {
                    $infoAddress = [
                        'address' => Treatment::string($info['address'], 'text'),
                        'district' => Treatment::string($info['district'], 'text'),
                        'cep' => Treatment::string($info['cep'], 'text'),
                        'city' => $city,
                        'state' => $state
                    ];
                }

                if (array_key_exists('postal', $info)) {
                    if ($info['postal']) {
                        $infoAddress['postal'] = Treatment::string($info['postal'], 'text');
                    }
                }
            }

            return $infoAddress;
        }
    }

    public static function preparePhones($phones)
    {
        $infoPhones = null;

        if ($phones) {
            $phonesArray = $phones['number'];

            $detailsArray = $operatorArray = null;

            if ($phones['details']) {
                $detailsArray = $phones['details'];
            }

            if ($phones['operator']) {
                $operatorArray = $phones['operator'];
            }

            if (is_array($phonesArray)) {
                $totalArray = count($phonesArray);

                for ($i = 0; $i < $totalArray; $i++) {
                    $infoPhones[$i]['number'] = Treatment::string($phonesArray[$i], 'text');
                    $infoPhones[$i]['callto'] = Treatment::string($phonesArray[$i], 'callto');

                    if ($detailsArray) {
                        $infoPhones[$i]['details'] = Treatment::string($detailsArray[$i], 'text');
                    }
                    else {
                        $infoPhones[$i]['details'] = null;
                    }

                    if ($operatorArray) {
                        $infoPhones[$i]['operator'] = Treatment::string($operatorArray[$i], 'text');
                    }
                    else {
                        $infoPhones[$i]['operator'] = null;
                    }
                }

                if ($infoPhones) {
                    return $infoPhones;
                }
            }
        }
    }

    public static function prepareEmails($emails)
    {
        $infoEmails = null;

        if ($emails) {
            $emailsArray = $emails['emails'];

            $labelsArray = null;

            if ($emails['labels']) {
                $labelsArray = $emails['labels'];
            }

            if (is_array($emailsArray)) {
                $totalArray = count($emailsArray);

                for ($i = 0; $i < $totalArray; $i++) {
                    $infoEmails[$i]['emails'] = Treatment::string($emailsArray[$i], 'text');

                    if ($labelsArray) {
                        $infoEmails[$i]['labels'] = Treatment::string($labelsArray[$i], 'text');
                    }
                    else {
                        $infoEmails[$i]['labels'] = null;
                    }
                }

                if ($infoEmails) {
                    return $infoEmails;
                }
            }
        }
    }

    public static function prepareSocialNetworks($socialBase)
    {
        if (isset($socialBase['type'])) {
            $social = null;
            $socialUrl = $socialBase['url'];
            $socialType = $socialBase['type'];

            if ($socialUrl) {
                for ($i = 0; $i < count($socialUrl); $i++) {
                    if ($socialType[$i]['key'] != 'whatsapp') {
                        $social[$socialType[$i]['key']] = [
                            'url' => $socialUrl[$i],
                            'type' => $socialType[$i]
                        ];
                    }
                    else {
                        $social[$socialType[$i]['key']] = [
                            'url' => $socialUrl[$i],
                            'callto' => '+55'.preg_replace("/[^0-9]/", "", $socialUrl[$i]),
                            'type' => $socialType[$i]
                        ];
                    }
                }
            }

            return $social;
        }
    }

    public static function prepareWhatsapp($number, $message)
    {
        $whatsapp['number'] = Treatment::string($number, 'calltonot+');
        $whatsapp['numbercallto'] = Treatment::string($number, 'callto');
        $whatsapp['numberview'] = Treatment::string($number);
        $whatsapp['message'] = rawurlencode(Treatment::string($message, 'unserializestring'));
        $whatsapp['link'] = 'https://api.whatsapp.com/send?phone='.$whatsapp['number'].'&text='.$whatsapp['message'];

        return $whatsapp;
    }

    public static function getCountryModule($country = 76, $output = 'name')
    {
        $dataReturn = [];

        $repository = new Repository('ibge-country', ['prefixKey' => 'sis']);
        $repository->select('id_ibge-country', 'id');
        $repository->select($output.'_ibge-country', $output);
        $repository->where('status', 'active');
        $repository->orderBy($output);

        if ($query = $repository->all()) {
            foreach ($query as $key => $value) {
                $selected = false;

                if ($value['id'] == $country) {
                    $selected = true;
                }

                $dataReturn[] = [
                    'title' => Treatment::string($value[$output]),
                    'value' => Treatment::string($value['id']),
                    'selected' => $selected
                ];
            }
        }

        return $dataReturn;
    }

    public static function getStateModule($state = 11, $country = 76, $output = 'name')
    {
        $dataReturn = [];

        $repository = new Repository('ibge-state', ['prefixKey' => 'sis']);
        $repository->select('id_ibge-state', 'id');
        $repository->select($output.'_ibge-state', $output);
        $repository->where('status', 'active');
        $repository->whereAnd('country', $country);
        $repository->orderBy($output);

        if ($query = $repository->all()) {
            foreach ($query as $key => $value) {
                $selected = false;

                if ($value['id'] == $state) {
                    $selected = true;
                }

                $dataReturn[] = [
                    'title' => Treatment::string($value[$output]),
                    'value' => Treatment::string($value['id']),
                    'selected' => $selected
                ];
            }
        }

        return $dataReturn;
    }

    public static function getCityModule($city = 2000, $state = 11, $country = 76)
    {
        $dataReturn = [];

        $repository = new Repository('ibge-city', ['prefixKey' => 'sis']);
        $repository->select('id_ibge-city', 'id');
        $repository->select('name_ibge-city', 'name');
        $repository->where('status', 'active');
        $repository->whereAnd('country', $country);
        $repository->whereAnd('state', $state);
        $repository->orderBy('name');

        if ($query = $repository->all()) {
            foreach ($query as $key => $value) {
                $selected = false;

                if ($value['id'] == $city) {
                    $selected = true;
                }

                $dataReturn[] = [
                    'title' => Treatment::string($value['name']),
                    'value' => Treatment::string($value['id']),
                    'selected' => $selected
                ];
            }
        }

        return $dataReturn;
    }

    public static function getRepository($selectedData = 1, $file = null, $output = 'array', $order = true)
    {
        $dataReturn = null;

        $filePath = config('app.ROOT_SITE').'/repository/'.$file.'.json';

        $repository = null;

        if (file_exists($filePath)) {
            $repository = file_get_contents(config('app.ROOT_SITE').'/repository/'.$file.'.json');

            $repository = json_decode($repository, true);
        }
        else {
            $dirProviders = config('app.ROOT_SITE').'/providers';

            if (is_dir($dirProviders)) {
                $iterator = new DirectoryIterator($dirProviders);

                while ($iterator->valid()) {
                    $entry = $iterator->getFilename();

                    $path = $dirProviders.'/'.$entry;

                    $iterator->next();

                    if (is_dir($path)) {
                        $repositoryDir = $path.'/repository';

                        if (is_dir($repositoryDir)) {
                            if (file_exists($repositoryDir.'/'.$file.'.json')) {
                                $repository = file_get_contents($repositoryDir.'/'.$file.'.json');

                                $repository = json_decode($repository, true);
                            }
                        }
                    }
                 }
            }
        }

        if ($repository) {
            if ($order) {
                asort($repository);
            }

            if ($output == 'full') {
                $dataReturn = $repository;
            }
            else {
                foreach ($repository as $key => $value) {
                    $selected = false;

                    if ($key == $selectedData) {
                        $selected = true;

                        if ($output == 'view') {
                            return Treatment::string($value);
                        }
                    }

                    $dataReturn[] = [
                        'title' => Treatment::string($value),
                        'value' => intval($key),
                        'selected' => $selected
                    ];
                }
            }

            if ($output != 'view') {
                return $dataReturn;
            }
        }
    }

    public static function setCsfrToken()
    {
        if (empty($_SESSION['token'])) {
            if (function_exists('random_bytes')) {
                $_SESSION['token'] = bin2hex(random_bytes(32));
            } else {
                $_SESSION['token'] = bin2hex(openssl_random_pseudo_bytes(32));
            }
        }
    }

    public static function checkCsfrToken($key, $link, $callback)
    {
        $public_key = Request::post($key);

        if (!empty($public_key)) {
            if (hash_equals($_SESSION['token'], $public_key)) {
                return true;
            }
        }

        $callback->set('invalid-publickey', $link);
    }

    public static function jsonEncode($array)
    {
        return json_encode($array, JSON_HEX_APOS | JSON_HEX_QUOT | JSON_HEX_AMP | JSON_UNESCAPED_UNICODE);
    }
}
