<?php

class_alias('\CoreSlim\Assets', 'Assets');
class_alias('\CoreSlim\Repository', 'Repository');
class_alias('\CoreSlim\Request', 'Request');
class_alias('\CoreSlim\Treatment', 'Treatment');
class_alias('\CoreSlim\Tools', 'Tools');

if (!function_exists('config')) {
    function config($sentence) {
        return \CoreSlim\Filesystem::getGlobalConfig($sentence);
    }
}

if (!function_exists('lang')) {
    function lang($sentence, $acceptRoute = null) {
        return \CoreSlim\Filesystem::getGlobalLang($sentence, $acceptRoute);
    }
}

if (!function_exists('assets_css')) {
    function assets_css($filename, $privateProvider = 'site', $min = true, $version = true) {
        return \CoreSlim\Filesystem::css($filename, $privateProvider, $min, $version);
    }
}

if (!function_exists('assets_js')) {
    function assets_js($filename, $privateProvider = 'site', $min = true, $version = true) {
        return \CoreSlim\Filesystem::js($filename, $privateProvider, $min, $version);
    }
}

if (!function_exists('assets_img')) {
    function assets_img($filename, $privateProvider = 'site', $min = true, $version = true) {
        return \CoreSlim\Filesystem::img($filename, $privateProvider);
    }
}

if (!function_exists('hash_equals')) {
    function hash_equals($str1, $str2) {
        if (strlen($str1) != strlen($str2)) {
            return false;
        }
        else {
            $res = $str1 ^ $str2;
            $ret = 0;

            for ($i = strlen($res) - 1; $i >= 0; $i--) {
                $ret |= ord($res[$i]);
            }

            return !$ret;
        }
    }
}
